/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.db.impl;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.ListIterator;
import nl.ibs.fac.db.AssetManagerFactory;
import nl.ibs.fac.db.IncomingFinancialTransactionManagerFactory;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.TransactionDataBean;
import nl.ibs.fac.db.TransactionManager;
import nl.ibs.fac.db.TransactionPK;
import nl.ibs.fac.db.impl.PersistenceMetaDataTransaction;
import nl.ibs.fac.db.impl.Transaction_Impl;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.AtomicDBTransaction;
import nl.ibs.jsql.BusinessObject_Impl;
import nl.ibs.jsql.Cache;
import nl.ibs.jsql.DBConfig;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.Query;
import nl.ibs.jsql.QueryFactory;
import nl.ibs.jsql.exception.FinderException;
import nl.ibs.jsql.exception.JSQLException;
import nl.ibs.jsql.exception.RemoveException;
import nl.ibs.jsql.impl.ArrayListImpl;
import nl.ibs.jsql.impl.ListIteratorImpl;
import nl.ibs.jsql.impl.QueryImplementation;
import nl.ibs.jsql.sql.AttributeAccessor;
import nl.ibs.jsql.sql.BusinessObjectManager;
import nl.ibs.jsql.sql.ConnectionProvider;
import nl.ibs.jsql.sql.DBConnection;
import nl.ibs.jsql.sql.DBMapping;
import nl.ibs.jsql.sql.PersistenceMetaData;
import nl.ibs.jsql.sql.QueryTranslator;
import nl.ibs.vegas.ExecutableQuery;
import nl.ibs.vegas.meta.AttributeMeta;
import nl.ibs.vegas.meta.impl.FieldMetaImpl;
import nl.ibs.vegas.meta.impl.ObjectRelationMetaImpl;
import nl.ibs.vegas.persistence.Manager;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TransactionManager_Impl
extends BusinessObjectManager
implements TransactionManager {
    private static final String APPLICATION = "fac";
    private static DOMImplementation domImplementation = DBConfig.getDOMImplementation();
    private static AttributeAccessor generalAccessor = new AttributeAccessor();
    private static boolean verbose = Log.debug();
    private static PersistenceMetaData pmd = PersistenceMetaDataTransaction.getInstance();
    private static Hashtable instances = new Hashtable();
    private DBData dbd;
    static final String[] keys = new String[]{"companyId", "documentNr", "seqNr"};
    static final AttributeMeta[] attributes = new AttributeMeta[]{new FieldMetaImpl("companyId", "txt-company-id", "txt-company-id-short", "txt-company-id-description", "text", String.class, 7, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("documentNr", "txt-document-nr", "txt-document-nr-short", "txt-document-nr-description", "number", Integer.TYPE, 9, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("seqNr", "txt-seq-nr", "txt-seq-nr-short", "txt-seq-nr-description", "number", Integer.TYPE, 3, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("description", "txt-description", "txt-description-short", "txt-description-description", "text", String.class, 30, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("gLDescription", "txt-g-l-description", "txt-g-l-description-short", "txt-g-l-description-description", "text", String.class, 20, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("cora", "txt-cora", "txt-cora-short", "txt-cora-description", "text", String.class, 1, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("assetId", "txt-asset-id", "txt-asset-id-short", "txt-asset-id-description", "text", String.class, 10, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("bookYear", "txt-book-year", "txt-book-year-short", "txt-book-year-description", "number", Integer.TYPE, 4, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("period", "txt-period", "txt-period-short", "txt-period-description", "number", Integer.TYPE, 2, 0, "0", "false", "false", "false", "", false, false, null, null), new FieldMetaImpl("bookYearForJournalization", "txt-book-year-for-journalization", "txt-book-year-for-journalization-short", "txt-book-year-for-journalization-description", "number", Integer.TYPE, 4, 0, "0", "false", "false", "false", "", false, false, null, null), new FieldMetaImpl("periodForJournalization", "txt-period-for-journalization", "txt-period-for-journalization-short", "txt-period-for-journalization-description", "number", Integer.TYPE, 2, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("accountingPrinciple", "txt-accounting-principle", "txt-accounting-principle-short", "txt-accounting-principle-description", "number", Integer.TYPE, 1, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("mainTransactionType", "txt-main-transaction-type", "txt-main-transaction-type-short", "txt-main-transaction-type-description", "number", Integer.TYPE, 1, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("transactionType", "txt-transaction-type", "txt-transaction-type-short", "txt-transaction-type-description", "number", Integer.TYPE, 3, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("batchId", "txt-batch-id", "txt-batch-id-short", "txt-batch-id-description", "number", Integer.TYPE, 9, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("incomingFinancialTransactionId", "txt-incoming-financial-transaction-id", "txt-incoming-financial-transaction-id-short", "txt-incoming-financial-transaction-id-description", "text", String.class, 10, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("daybookId", "txt-daybook-id", "txt-daybook-id-short", "txt-daybook-id-description", "text", String.class, 9, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("voucherId", "txt-voucher-id", "txt-voucher-id-short", "txt-voucher-id-description", "text", String.class, 9, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("voucherDate", "txt-voucher-date", "txt-voucher-date-short", "txt-voucher-date-description", "date", Date.class, 0, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("proFormaTypeId", "txt-pro-forma-type-id", "txt-pro-forma-type-id-short", "txt-pro-forma-type-id-description", "text", String.class, 10, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("reasonCode", "txt-reason-code", "txt-reason-code-short", "txt-reason-code-description", "number", Integer.TYPE, 2, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("finDimId1", "txt-fin-dim-id1", "txt-fin-dim-id1-short", "txt-fin-dim-id1-description", "text", String.class, 9, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("finDimId2", "txt-fin-dim-id2", "txt-fin-dim-id2-short", "txt-fin-dim-id2-description", "text", String.class, 9, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("finDimId3", "txt-fin-dim-id3", "txt-fin-dim-id3-short", "txt-fin-dim-id3-description", "text", String.class, 9, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("finDimId4", "txt-fin-dim-id4", "txt-fin-dim-id4-short", "txt-fin-dim-id4-description", "text", String.class, 9, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("finDimId5", "txt-fin-dim-id5", "txt-fin-dim-id5-short", "txt-fin-dim-id5-description", "text", String.class, 9, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("state", "txt-state", "txt-state-short", "txt-state-description", "number", Integer.TYPE, 1, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("amount1", "txt-amount1", "txt-amount1-short", "txt-amount1-description", "decimal", BigDecimal.class, 11, 2, "0.00", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("amount2", "txt-amount2", "txt-amount2-short", "txt-amount2-description", "decimal", BigDecimal.class, 11, 2, "0.00", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("amount3", "txt-amount3", "txt-amount3-short", "txt-amount3-description", "decimal", BigDecimal.class, 11, 2, "0.00", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("correctionCodeDC", "txt-correction-code-dc", "txt-correction-code-dc-short", "txt-correction-code-dc-description", "text", String.class, 1, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("infoLevel", "txt-info-level", "txt-info-level-short", "txt-info-level-description", "number", Integer.TYPE, 1, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("revCode", "txt-rev-code", "txt-rev-code-short", "txt-rev-code-description", "number", Integer.TYPE, 1, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("revDocumentNr", "txt-rev-document-nr", "txt-rev-document-nr-short", "txt-rev-document-nr-description", "number", Integer.TYPE, 9, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("revSeqNr", "txt-rev-seq-nr", "txt-rev-seq-nr-short", "txt-rev-seq-nr-description", "number", Integer.TYPE, 3, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("journalingState", "txt-journaling-state", "txt-journaling-state-short", "txt-journaling-state-description", "number", Integer.TYPE, 1, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("mainAccount1", "txt-main-account1", "txt-main-account1-short", "txt-main-account1-description", "text", String.class, 9, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("mainAccount2", "txt-main-account2", "txt-main-account2-short", "txt-main-account2-description", "text", String.class, 9, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("mainAccount3", "txt-main-account3", "txt-main-account3-short", "txt-main-account3-description", "text", String.class, 9, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("mainAccount4", "txt-main-account4", "txt-main-account4-short", "txt-main-account4-description", "text", String.class, 9, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("isBudget", "txt-is-budget", "txt-is-budget-short", "txt-is-budget-description", "boolean", Boolean.TYPE, 0, 0, "false", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("bookingIndicator", "txt-booking-indicator", "txt-booking-indicator-short", "txt-booking-indicator-description", "number", Integer.TYPE, 1, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("originalInterestPercentage", "txt-original-interest-percentage", "txt-original-interest-percentage-short", "txt-original-interest-percentage-description", "decimal", BigDecimal.class, 6, 3, "0.000", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("creationDate", "txt-creation-date", "txt-creation-date-short", "txt-creation-date-description", "date", Date.class, 0, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("createdByUser", "txt-created-by-user", "txt-created-by-user-short", "txt-created-by-user-description", "text", String.class, 10, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("aggregationDocumentNr", "txt-aggregation-document-nr", "txt-aggregation-document-nr-short", "txt-aggregation-document-nr-description", "number", Integer.TYPE, 9, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("aggregationSeqNr", "txt-aggregation-seq-nr", "txt-aggregation-seq-nr-short", "txt-aggregation-seq-nr-description", "number", Integer.TYPE, 3, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("alternativeCompanyId", "txt-alternative-company-id", "txt-alternative-company-id-short", "txt-alternative-company-id-description", "text", String.class, 7, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("disinvestmentReasonCode", "txt-disinvestment-reason-code", "txt-disinvestment-reason-code-short", "txt-disinvestment-reason-code-description", "number", Integer.TYPE, 1, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("journalingTerm1", "txt-journaling-term1", "txt-journaling-term1-short", "txt-journaling-term1-description", "number", Integer.TYPE, 3, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("journalingTerm2", "txt-journaling-term2", "txt-journaling-term2-short", "txt-journaling-term2-description", "number", Integer.TYPE, 3, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("journalingTerm3", "txt-journaling-term3", "txt-journaling-term3-short", "txt-journaling-term3-description", "number", Integer.TYPE, 3, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("journalingTerm4", "txt-journaling-term4", "txt-journaling-term4-short", "txt-journaling-term4-description", "number", Integer.TYPE, 3, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("journalingTerm5", "txt-journaling-term5", "txt-journaling-term5-short", "txt-journaling-term5-description", "number", Integer.TYPE, 3, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("creditId", "txt-credit-id", "txt-credit-id-short", "txt-credit-id-description", "text", String.class, 10, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("suppressContraBooking", "txt-suppress-contra-booking", "txt-suppress-contra-booking-short", "txt-suppress-contra-booking-description", "number", Integer.TYPE, 1, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("correctionAmount445", "txt-correction-amount445", "txt-correction-amount445-short", "txt-correction-amount445-description", "decimal", BigDecimal.class, 15, 2, "0.00", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("mainAccountsSet", "txt-main-accounts-set", "txt-main-accounts-set-short", "txt-main-accounts-set-description", "boolean", Boolean.TYPE, 0, 0, "false", "false", "false", "", "", false, false, null, null), new ObjectRelationMetaImpl("asset", "txt-asset", "txt-asset-short", "txt-asset-description", (Manager)AssetManagerFactory.getInstance(), false, "companyId = ?companyId"), new ObjectRelationMetaImpl("incomingFinancialTransaction", "txt-incoming-financial-transaction", "txt-incoming-financial-transaction-short", "txt-incoming-financial-transaction-description", (Manager)IncomingFinancialTransactionManagerFactory.getInstance(), false, "companyId = ?companyId")};

    private TransactionManager_Impl(DBData dbData) {
        this.dbd = dbData;
    }

    public static TransactionManager getInstance() {
        return TransactionManager_Impl.getInstance(DBData.getDefaultDBData(APPLICATION));
    }

    public static TransactionManager getInstance(DBData dbd) {
        if (dbd == null) {
            throw new IllegalArgumentException("Tried to instantiate a Manager it DBData = null!");
        }
        TransactionManager_Impl inst = (TransactionManager_Impl)instances.get(dbd);
        if (inst == null) {
            inst = new TransactionManager_Impl(dbd);
            instances.put(dbd, inst);
        }
        return inst;
    }

    public DBData getDBData() {
        return this.dbd;
    }

    @Override
    public Transaction create(TransactionDataBean bean) throws Exception {
        Transaction_Impl impl = new Transaction_Impl(this.dbd, bean);
        impl.assureStorage();
        return impl;
    }

    @Override
    public Transaction create(String _companyId, int _documentNr, int _seqNr) throws Exception {
        Transaction_Impl obj = new Transaction_Impl(this.dbd, _companyId, _documentNr, _seqNr);
        obj.assureStorage();
        return obj;
    }

    private TransactionPK getPK(ResultSet rs) throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        TransactionPK inst = new TransactionPK();
        inst.setCompanyId(rs.getString(pmd.getFieldName("CompanyId", provider)));
        inst.setDocumentNr(rs.getInt(pmd.getFieldName("DocumentNr", provider)));
        inst.setSeqNr(rs.getInt(pmd.getFieldName("SeqNr", provider)));
        return inst;
    }

    @Override
    public Transaction findOrCreate(TransactionPK key) throws Exception {
        Transaction obj;
        try {
            obj = this.findByPrimaryKey(key);
        }
        catch (FinderException e) {
            obj = this.create(key.getCompanyId(), key.getDocumentNr(), key.getSeqNr());
        }
        return obj;
    }

    @Override
    public void add(TransactionDataBean inst) throws Exception {
        Transaction_Impl impl = new Transaction_Impl(this.dbd, inst);
        impl.assureStorage();
    }

    @Override
    public void removeByPrimaryKey(TransactionPK key) throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        Transaction cachedObject = this.getCachedObjectByPrimaryKey(key);
        DBConnection dbc = provider instanceof AtomicDBTransaction ? ((AtomicDBTransaction)provider).getConnectionForUpdate((BusinessObject_Impl)((Object)cachedObject)) : provider.getConnection();
        String pskey = "nl.ibs.fac.db.Transaction.removeByPrimaryKey";
        try {
            PreparedStatement prep = dbc.getPreparedStatement(pskey);
            if (prep == null) {
                prep = dbc.getPreparedStatement(pskey, " DELETE FROM " + provider.getPrefix() + pmd.getTableName(provider) + " WHERE " + pmd.getFieldName("CompanyId", provider) + "=? AND " + pmd.getFieldName("DocumentNr", provider) + "=? AND " + pmd.getFieldName("SeqNr", provider) + "=?");
            }
            prep.setString(1, key.getCompanyId());
            prep.setInt(2, key.getDocumentNr());
            prep.setInt(3, key.getSeqNr());
            int x = prep.executeUpdate();
            if (x == 0) {
                throw new RemoveException("Key not found");
            }
            if (cachedObject != null) {
                DBPersistenceManager.removeFromCache(cachedObject);
            }
        }
        catch (SQLException e) {
            if (!(e instanceof JSQLException)) {
                Log.error((String)e.getMessage());
            }
            throw e;
        }
        finally {
            provider.returnConnection(dbc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Transaction findByPrimaryKey(TransactionPK key) throws Exception {
        Transaction transaction = this.getCachedObjectByPrimaryKey(key);
        if (transaction != null) {
            return transaction;
        }
        ResultSet rs = null;
        try {
            rs = this.getResultSet(key);
            Transaction transaction2 = (Transaction)this.getBusinessObject(rs);
            return transaction2;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    Log.error((String)e.getMessage());
                }
            }
        }
    }

    public ResultSet getResultSet(TransactionPK key) throws Exception {
        ResultSet rs = null;
        String pskey = "nl.ibs.fac.db.Transaction.findByPrimaryKey1";
        Object inst = null;
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        DBConnection dbc = provider.getConnection();
        try {
            PreparedStatement prep = dbc.getPreparedStatement(pskey);
            if (prep == null) {
                prep = dbc.getPreparedStatement(pskey, " SELECT *  FROM " + provider.getPrefix() + pmd.getTableName(provider) + " WHERE " + pmd.getFieldName("CompanyId", provider) + "=? AND " + pmd.getFieldName("DocumentNr", provider) + "=? AND " + pmd.getFieldName("SeqNr", provider) + "=?");
            }
            prep.setString(1, key.getCompanyId());
            prep.setInt(2, key.getDocumentNr());
            prep.setInt(3, key.getSeqNr());
            prep.executeQuery();
            rs = prep.getResultSet();
            if (!rs.next()) {
                throw new FinderException("Key not found");
            }
        }
        catch (SQLException e) {
            if (!(e instanceof JSQLException)) {
                Log.error((String)e.getMessage());
            }
            throw e;
        }
        finally {
            provider.returnConnection(dbc);
        }
        return rs;
    }

    public Transaction getCachedObjectByPrimaryKey(TransactionPK key) throws Exception {
        Cache cache = DBPersistenceManager.getCache();
        if (cache == null) {
            return null;
        }
        Object o = cache.get(new String("-2061510888_" + this.dbd.getDBId() + key.getCompanyId() + key.getDocumentNr() + key.getSeqNr()));
        return (Transaction)o;
    }

    @Override
    public ConnectionProvider getConnectionProvider() throws Exception {
        return DBPersistenceManager.getConnectionProvider(this.dbd);
    }

    @Override
    public PersistenceMetaData getPersistenceMetaData() {
        return pmd;
    }

    @Override
    public int getDocumentNrMax(String _companyId) throws Exception {
        ResultSet rs = null;
        int result = 0;
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        DBConnection dbc = provider.getConnection();
        try {
            String pskey = "nl.ibs.fac.db.Transaction.getDocumentNrMax_1737665094";
            PreparedStatement prep = dbc.getPreparedStatement(pskey);
            if (prep == null) {
                prep = dbc.getPreparedStatement(pskey, " SELECT   MAX(" + pmd.getFieldName("DocumentNr", provider) + ") FROM " + provider.getPrefix() + pmd.getTableName(provider) + " WHERE " + pmd.getFieldName("CompanyId", provider) + "=? ", 0);
            }
            prep.setObject(1, (Object)_companyId, mapping.getJDBCTypeFor("String"));
            rs = prep.executeQuery();
            if (rs.next()) {
                result = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            Log.error((String)e.getMessage());
            throw e;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            provider.returnConnection(dbc);
        }
        return result;
    }

    @Override
    public int generalUpdate(String setClause, String whereClause) throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        DBConnection dbc = provider.getConnection();
        try {
            String update = "UPDATE " + provider.getPrefix() + pmd.getTableName(provider) + " SET " + QueryTranslator.translateObjectQuery(setClause + " WHERE " + whereClause, pmd, provider);
            int n = dbc.executeUpdate(update);
            return n;
        }
        catch (SQLException e) {
            Log.error((String)e.getMessage());
            throw e;
        }
        finally {
            provider.returnConnection(dbc);
        }
    }

    @Override
    public int generalDelete(String whereClause) throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        DBConnection dbc = provider.getConnection();
        try {
            String delete = "DELETE FROM " + provider.getPrefix() + pmd.getTableName(provider) + " WHERE " + QueryTranslator.translateObjectQuery(whereClause, pmd, provider);
            int n = dbc.executeUpdate(delete);
            return n;
        }
        catch (SQLException e) {
            Log.error((String)e.getMessage());
            throw e;
        }
        finally {
            provider.returnConnection(dbc);
        }
    }

    @Override
    public Transaction getFirstObject(Query query) throws Exception {
        if (query == null) {
            query = QueryFactory.create();
        }
        int prevMax = query.getMaxObjects();
        query.setMaxObjects(1);
        try {
            Transaction transaction = (Transaction)((QueryImplementation)query).execute(this, (short)0);
            return transaction;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            query.setMaxObjects(prevMax);
        }
    }

    @Override
    public Collection getCollection(Query query) throws Exception {
        if (query == null) {
            query = QueryFactory.create(this, null, null, 1000);
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        return (Collection)queryImpl.execute(this, (short)-1);
    }

    public ListIterator getListIterator(Query query) throws Exception {
        if (query == null) {
            query = QueryFactory.create(this, null, null, 1000);
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        return (ListIterator)queryImpl.execute(this, (short)-2);
    }

    @Override
    public Document getDocument(Query query) throws Exception {
        if (query == null) {
            query = QueryFactory.create(this, null, null, 1000);
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        return (Document)queryImpl.execute(this, (short)-3);
    }

    @Override
    public DocumentFragment getDocumentFragment(Query query) throws Exception {
        if (query == null) {
            query = QueryFactory.create(this, null, null, 1000);
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        return (DocumentFragment)queryImpl.execute(this, (short)-4);
    }

    @Override
    public ArrayList getDocumentFragmentArrayList(Query query) throws Exception {
        if (query == null) {
            query = QueryFactory.create(this, null, null, 1000);
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        return (ArrayList)queryImpl.execute(this, (short)-5);
    }

    @Override
    protected Collection getCollection(ResultSet rs) throws Exception {
        ArrayListImpl result = new ArrayListImpl();
        while (rs.next()) {
            ((ArrayList)result).add(this.getBusinessObject(rs));
        }
        return result;
    }

    @Override
    protected Document getDocument(ResultSet resultSet) throws Exception {
        Document document = domImplementation.createDocument("", "data", null);
        Element root = document.getDocumentElement();
        this.collectResultElements(resultSet, root, this.getConnectionProvider());
        return document;
    }

    @Override
    protected DocumentFragment getDocumentFragment(ResultSet resultSet) throws Exception {
        Document document = domImplementation.createDocument("", "data", null);
        DocumentFragment documentFragment = document.createDocumentFragment();
        this.collectResultElements(resultSet, documentFragment, this.getConnectionProvider());
        return documentFragment;
    }

    @Override
    protected ArrayList getDocumentFragmentArrayList(ResultSet resultSet) throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        Document document = domImplementation.createDocument("", "data", null);
        ArrayListImpl arrayList = new ArrayListImpl();
        while (resultSet.next()) {
            DocumentFragment documentFragment = document.createDocumentFragment();
            Node rec = documentFragment.appendChild(document.createElement("transaction"));
            TransactionManager_Impl.addBOFieldsToElement(resultSet, rec, provider);
            ((ArrayList)arrayList).add(documentFragment);
        }
        return arrayList;
    }

    @Override
    protected ListIterator getListIterator(ResultSet rs) throws Exception {
        ListIteratorImpl result = new ListIteratorImpl();
        while (rs.next()) {
            result.add(this.getBusinessObject(rs));
        }
        result.pointer = 0;
        return result;
    }

    @Override
    protected Object getBusinessObject(ResultSet rs) throws Exception {
        Cache cache = DBPersistenceManager.getCache();
        if (cache != null) {
            ConnectionProvider provider = this.getConnectionProvider();
            Object o = cache.get(new String("-2061510888_" + this.dbd.getDBId() + rs.getObject(pmd.getFieldName("CompanyId", provider)) + rs.getObject(pmd.getFieldName("DocumentNr", provider)) + rs.getObject(pmd.getFieldName("SeqNr", provider))));
            if (o != null) {
                return o;
            }
        }
        return DBPersistenceManager.cache(this.createBusinessObject(rs));
    }

    private Object createBusinessObject(ResultSet rs) throws Exception {
        return new Transaction_Impl(this.dbd, rs);
    }

    private void collectResultElements(ResultSet rs, Node root, ConnectionProvider provider) throws Exception {
        Document doc = root.getOwnerDocument();
        while (rs.next()) {
            Node rec = root.appendChild(doc.createElement("transaction"));
            TransactionManager_Impl.addBOFieldsToElement(rs, rec, provider);
        }
    }

    public static void addBOFieldsToElement(ResultSet rs, Node rec, ConnectionProvider provider) throws Exception {
        DBMapping mapping = provider.getDBMapping();
        Document doc = rec.getOwnerDocument();
        Object o = null;
        String s = null;
        s = rs.getString(pmd.getFieldName("CompanyId", provider));
        if (s != null && (s = s.trim()).length() > 0) {
            rec.appendChild(doc.createElement("companyid")).appendChild(doc.createCDATASection(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("DocumentNr", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("documentnr")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("SeqNr", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("seqnr")).appendChild(doc.createTextNode(s));
        }
        if ((s = rs.getString(pmd.getFieldName("Description", provider))) != null && (s = s.trim()).length() > 0) {
            rec.appendChild(doc.createElement("description")).appendChild(doc.createCDATASection(s));
        }
        if ((s = rs.getString(pmd.getFieldName("GLDescription", provider))) != null && (s = s.trim()).length() > 0) {
            rec.appendChild(doc.createElement("gldescription")).appendChild(doc.createCDATASection(s));
        }
        if ((s = rs.getString(pmd.getFieldName("Cora", provider))) != null && (s = s.trim()).length() > 0) {
            rec.appendChild(doc.createElement("cora")).appendChild(doc.createCDATASection(s));
        }
        if ((s = rs.getString(pmd.getFieldName("AssetId", provider))) != null && (s = s.trim()).length() > 0) {
            rec.appendChild(doc.createElement("assetid")).appendChild(doc.createCDATASection(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("BookYear", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("bookyear")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("Period", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("period")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("BookYearForJournalization", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("bookyearforjournalization")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("PeriodForJournalization", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("periodforjournalization")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("AccountingPrinciple", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("accountingprinciple")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("MainTransactionType", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("maintransactiontype")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("TransactionType", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("transactiontype")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("BatchId", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("batchid")).appendChild(doc.createTextNode(s));
        }
        if ((s = rs.getString(pmd.getFieldName("IncomingFinancialTransactionId", provider))) != null && (s = s.trim()).length() > 0) {
            rec.appendChild(doc.createElement("incomingfinancialtransactionid")).appendChild(doc.createCDATASection(s));
        }
        if ((s = rs.getString(pmd.getFieldName("DaybookId", provider))) != null && (s = s.trim()).length() > 0) {
            rec.appendChild(doc.createElement("daybookid")).appendChild(doc.createCDATASection(s));
        }
        if ((s = rs.getString(pmd.getFieldName("VoucherId", provider))) != null && (s = s.trim()).length() > 0) {
            rec.appendChild(doc.createElement("voucherid")).appendChild(doc.createCDATASection(s));
        }
        if ((o = rs.getDate(pmd.getFieldName("VoucherDate", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("voucherdate")).appendChild(doc.createTextNode(s));
        }
        if ((s = rs.getString(pmd.getFieldName("ProFormaTypeId", provider))) != null && (s = s.trim()).length() > 0) {
            rec.appendChild(doc.createElement("proformatypeid")).appendChild(doc.createCDATASection(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("ReasonCode", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("reasoncode")).appendChild(doc.createTextNode(s));
        }
        if ((s = rs.getString(pmd.getFieldName("FinDimId1", provider))) != null && (s = s.trim()).length() > 0) {
            rec.appendChild(doc.createElement("findimid1")).appendChild(doc.createCDATASection(s));
        }
        if ((s = rs.getString(pmd.getFieldName("FinDimId2", provider))) != null && (s = s.trim()).length() > 0) {
            rec.appendChild(doc.createElement("findimid2")).appendChild(doc.createCDATASection(s));
        }
        if ((s = rs.getString(pmd.getFieldName("FinDimId3", provider))) != null && (s = s.trim()).length() > 0) {
            rec.appendChild(doc.createElement("findimid3")).appendChild(doc.createCDATASection(s));
        }
        if ((s = rs.getString(pmd.getFieldName("FinDimId4", provider))) != null && (s = s.trim()).length() > 0) {
            rec.appendChild(doc.createElement("findimid4")).appendChild(doc.createCDATASection(s));
        }
        if ((s = rs.getString(pmd.getFieldName("FinDimId5", provider))) != null && (s = s.trim()).length() > 0) {
            rec.appendChild(doc.createElement("findimid5")).appendChild(doc.createCDATASection(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("State", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("state")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getBigDecimal(pmd.getFieldName("Amount1", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("amount1")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getBigDecimal(pmd.getFieldName("Amount2", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("amount2")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getBigDecimal(pmd.getFieldName("Amount3", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("amount3")).appendChild(doc.createTextNode(s));
        }
        if ((s = rs.getString(pmd.getFieldName("CorrectionCodeDC", provider))) != null && (s = s.trim()).length() > 0) {
            rec.appendChild(doc.createElement("correctioncodedc")).appendChild(doc.createCDATASection(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("InfoLevel", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("infolevel")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("RevCode", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("revcode")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("RevDocumentNr", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("revdocumentnr")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("RevSeqNr", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("revseqnr")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("JournalingState", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("journalingstate")).appendChild(doc.createTextNode(s));
        }
        if ((s = rs.getString(pmd.getFieldName("MainAccount1", provider))) != null && (s = s.trim()).length() > 0) {
            rec.appendChild(doc.createElement("mainaccount1")).appendChild(doc.createCDATASection(s));
        }
        if ((s = rs.getString(pmd.getFieldName("MainAccount2", provider))) != null && (s = s.trim()).length() > 0) {
            rec.appendChild(doc.createElement("mainaccount2")).appendChild(doc.createCDATASection(s));
        }
        if ((s = rs.getString(pmd.getFieldName("MainAccount3", provider))) != null && (s = s.trim()).length() > 0) {
            rec.appendChild(doc.createElement("mainaccount3")).appendChild(doc.createCDATASection(s));
        }
        if ((s = rs.getString(pmd.getFieldName("MainAccount4", provider))) != null && (s = s.trim()).length() > 0) {
            rec.appendChild(doc.createElement("mainaccount4")).appendChild(doc.createCDATASection(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("IsBudget", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("isbudget")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("BookingIndicator", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("bookingindicator")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getBigDecimal(pmd.getFieldName("OriginalInterestPercentage", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("originalinterestpercentage")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getDate(pmd.getFieldName("CreationDate", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("creationdate")).appendChild(doc.createTextNode(s));
        }
        if ((s = rs.getString(pmd.getFieldName("createdByUser", provider))) != null && (s = s.trim()).length() > 0) {
            rec.appendChild(doc.createElement("createdbyuser")).appendChild(doc.createCDATASection(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("AggregationDocumentNr", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("aggregationdocumentnr")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("AggregationSeqNr", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("aggregationseqnr")).appendChild(doc.createTextNode(s));
        }
        if ((s = rs.getString(pmd.getFieldName("AlternativeCompanyId", provider))) != null && (s = s.trim()).length() > 0) {
            rec.appendChild(doc.createElement("alternativecompanyid")).appendChild(doc.createCDATASection(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("DisinvestmentReasonCode", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("disinvestmentreasoncode")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("JournalingTerm1", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("journalingterm1")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("JournalingTerm2", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("journalingterm2")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("JournalingTerm3", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("journalingterm3")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("JournalingTerm4", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("journalingterm4")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("JournalingTerm5", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("journalingterm5")).appendChild(doc.createTextNode(s));
        }
        if ((s = rs.getString(pmd.getFieldName("CreditId", provider))) != null && (s = s.trim()).length() > 0) {
            rec.appendChild(doc.createElement("creditid")).appendChild(doc.createCDATASection(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("SuppressContraBooking", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("suppresscontrabooking")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getBigDecimal(pmd.getFieldName("CorrectionAmount445", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("correctionamount445")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("MainAccountsSet", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("mainaccountsset")).appendChild(doc.createTextNode(s));
        }
    }

    public ExecutableQuery getExecutableQuery() {
        return QueryFactory.create(this);
    }

    public String[] getKeyNames() {
        return keys;
    }

    public AttributeMeta[] getAttributes() {
        return attributes;
    }

    public Class getClassType() {
        return Transaction.class;
    }

    public String getNameField() {
        return "seqNr";
    }

    public String getDescriptionField() {
        return "seqNr";
    }

    public String getTextKey() {
        return "txt-transaction";
    }

    public String getTextKeyShort() {
        return "txt-transaction-short";
    }

    public String getTextKeyDescription() {
        return "txt-transaction-description";
    }

    public AttributeMeta getAttribute(String name) {
        if (attributes == null || name == null) {
            return null;
        }
        for (int i = 0; i < attributes.length; ++i) {
            if (!name.equals(attributes[i].getName())) continue;
            return attributes[i];
        }
        return null;
    }
}

