/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.db.impl;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import nl.ibs.fac.db.User;
import nl.ibs.fac.db.UserDataBean;
import nl.ibs.fac.db.UserGroup;
import nl.ibs.fac.db.impl.PersistenceMetaDataUser;
import nl.ibs.fac.db.impl.UserGroupManager_Impl;
import nl.ibs.fac.db.impl.UserManager_Impl;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.AtomicDBTransaction;
import nl.ibs.jsql.BusinessObject_Impl;
import nl.ibs.jsql.DBConfig;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransactionListener;
import nl.ibs.jsql.exception.CreateException;
import nl.ibs.jsql.exception.DeletedException;
import nl.ibs.jsql.exception.FinderException;
import nl.ibs.jsql.exception.InvalidStateException;
import nl.ibs.jsql.exception.JSQLException;
import nl.ibs.jsql.exception.UpdateException;
import nl.ibs.jsql.impl.ArrayListImpl;
import nl.ibs.jsql.sql.AttributeAccessor;
import nl.ibs.jsql.sql.ConnectionProvider;
import nl.ibs.jsql.sql.DBConnection;
import nl.ibs.jsql.sql.DBMapping;
import nl.ibs.jsql.sql.PersistenceMetaData;
import org.w3c.dom.DOMImplementation;

public class User_Impl
implements User,
BusinessObject_Impl,
DBTransactionListener {
    private static final String APPLICATION = "fac";
    private static final PersistenceMetaData pmd = PersistenceMetaDataUser.getInstance();
    private static final AttributeAccessor generalAccessor = new AttributeAccessor();
    protected static final boolean verbose = Log.debug();
    protected static final DOMImplementation domImplementation = DBConfig.getDOMImplementation();
    protected static final boolean autoUpdate = true;
    protected static final boolean cacheRelations = DBConfig.getCacheObjectRelations();
    protected static final boolean deferUpdates = DBConfig.getDeferUpdates();
    protected boolean updateDefered;
    protected boolean holdUpdate;
    protected boolean dirty;
    protected boolean stored;
    protected boolean deleted;
    protected boolean underConstruction;
    protected boolean participatingInTransaction;
    protected int hashCode;
    protected transient HashMap relationalCache;
    private TransactionImage transactionImage;
    private DBImage currentDBImage;
    protected DBData dbd;
    protected String id;
    protected String description;
    protected String userGroupId;
    protected boolean admin;
    protected boolean oneEnvironment;
    protected String facLib;
    protected boolean selectCompany;
    protected String companyId;
    protected boolean checkCurrentTransactionBatchHasTransactions;
    protected transient UserGroup transientUserGroup;

    protected User_Impl() throws Exception {
        this(DBData.getDefaultDBData(APPLICATION));
    }

    protected User_Impl(DBData _dbd) throws Exception {
        this.dbd = _dbd;
        this.initializeTheImplementationClass();
    }

    protected User_Impl(DBData _dbd, String _id) throws Exception {
        this.dbd = _dbd;
        this.initializeTheImplementationClass();
        try {
            this.underConstruction = true;
            this.setId(_id);
        }
        finally {
            this.underConstruction = false;
        }
    }

    protected User_Impl(DBData _dbd, UserDataBean bean) throws Exception {
        this.dbd = _dbd;
        if (!bean.getClass().getName().equals("nl.ibs.fac.db.UserDataBean")) {
            throw new IllegalArgumentException("JSQL: Tried to instantiate User with " + bean.getClass().getName() + "!! Use nl.ibs.fac.db.UserDataBean instead !");
        }
        this.initializeTheImplementationClass();
        try {
            this.underConstruction = true;
            this.setId(bean.getId());
            this.setDescription(bean.getDescription());
            this.setUserGroupId(bean.getUserGroupId());
            this.setAdmin(bean.getAdmin());
            this.setOneEnvironment(bean.getOneEnvironment());
            this.setFacLib(bean.getFacLib());
            this.setSelectCompany(bean.getSelectCompany());
            this.setCompanyId(bean.getCompanyId());
            this.setCheckCurrentTransactionBatchHasTransactions(bean.getCheckCurrentTransactionBatchHasTransactions());
        }
        finally {
            this.underConstruction = false;
        }
    }

    public User_Impl(DBData _dbd, ResultSet rs) throws Exception {
        this.dbd = _dbd;
        this.loadData(rs);
        this.stored = true;
    }

    public void loadData(ResultSet rs) throws Exception {
        this.initializeTheImplementationClass();
        ConnectionProvider provider = this.getConnectionProvider();
        this.id = rs.getString(pmd.getFieldName("Id", provider));
        this.description = rs.getString(pmd.getFieldName("Description", provider));
        this.userGroupId = rs.getString(pmd.getFieldName("UserGroupId", provider));
        this.admin = rs.getBoolean(pmd.getFieldName("Admin", provider));
        this.oneEnvironment = rs.getBoolean(pmd.getFieldName("OneEnvironment", provider));
        this.facLib = rs.getString(pmd.getFieldName("FacLib", provider));
        this.selectCompany = rs.getBoolean(pmd.getFieldName("selectCompany", provider));
        this.companyId = rs.getString(pmd.getFieldName("CompanyId", provider));
        this.checkCurrentTransactionBatchHasTransactions = rs.getBoolean(pmd.getFieldName("CheckCurrentTransactionBatchHasTransactions", provider));
        this.currentDBImage = null;
    }

    protected ConnectionProvider getConnectionProvider() throws Exception {
        return DBPersistenceManager.getConnectionProvider(this.dbd);
    }

    @Override
    public Object getPrimaryKey() throws Exception {
        return this.getId();
    }

    @Override
    public String getId() throws Exception {
        this.assureStorage();
        return this.id;
    }

    @Override
    public String getDescription() throws Exception {
        return this.description;
    }

    @Override
    public String getUserGroupId() throws Exception {
        return this.userGroupId;
    }

    @Override
    public boolean getAdmin() throws Exception {
        return this.admin;
    }

    @Override
    public boolean getOneEnvironment() throws Exception {
        return this.oneEnvironment;
    }

    @Override
    public String getFacLib() throws Exception {
        return this.facLib;
    }

    @Override
    public boolean getSelectCompany() throws Exception {
        return this.selectCompany;
    }

    @Override
    public String getCompanyId() throws Exception {
        return this.companyId;
    }

    @Override
    public boolean getCheckCurrentTransactionBatchHasTransactions() throws Exception {
        return this.checkCurrentTransactionBatchHasTransactions;
    }

    @Override
    public UserGroup getUserGroup() throws Exception {
        if (this.isCachedRelation("UserGroup")) {
            return (UserGroup)this.getCachedRelationObject("UserGroup");
        }
        if (this.getUserGroupId() == null) {
            return (UserGroup)this.addCachedRelationObject("UserGroup", null);
        }
        try {
            return (UserGroup)this.addCachedRelationObject("UserGroup", ((UserGroupManager_Impl)UserGroupManager_Impl.getInstance(this.dbd)).findByPrimaryKey(this.getUserGroupId()));
        }
        catch (FinderException fe) {
            return null;
        }
    }

    public void setId(String _id) throws Exception {
        if (_id == null) {
            _id = "";
        }
        if (_id.equals(this.getId())) {
            return;
        }
        this.preSet();
        this.id = _id;
        this.autoUpdate();
    }

    @Override
    public void setDescription(String _description) throws Exception {
        if (_description == null) {
            _description = "";
        }
        if (_description.equals(this.getDescription())) {
            return;
        }
        this.preSet();
        this.description = _description;
        this.autoUpdate();
    }

    public void setUserGroupId(String _userGroupId) throws Exception {
        if (_userGroupId == null) {
            _userGroupId = "";
        }
        if (_userGroupId.equals(this.getUserGroupId())) {
            return;
        }
        this.preSet();
        this.userGroupId = _userGroupId;
        this.autoUpdate();
    }

    @Override
    public void setAdmin(boolean _admin) throws Exception {
        if (_admin == this.getAdmin()) {
            return;
        }
        this.preSet();
        this.admin = _admin;
        this.autoUpdate();
    }

    @Override
    public void setOneEnvironment(boolean _oneEnvironment) throws Exception {
        if (_oneEnvironment == this.getOneEnvironment()) {
            return;
        }
        this.preSet();
        this.oneEnvironment = _oneEnvironment;
        this.autoUpdate();
    }

    @Override
    public void setFacLib(String _facLib) throws Exception {
        if (_facLib == null) {
            _facLib = "";
        }
        if (_facLib.equals(this.getFacLib())) {
            return;
        }
        this.preSet();
        this.facLib = _facLib;
        this.autoUpdate();
    }

    @Override
    public void setSelectCompany(boolean _selectCompany) throws Exception {
        if (_selectCompany == this.getSelectCompany()) {
            return;
        }
        this.preSet();
        this.selectCompany = _selectCompany;
        this.autoUpdate();
    }

    @Override
    public void setCompanyId(String _companyId) throws Exception {
        if (_companyId == null) {
            _companyId = "";
        }
        if (_companyId.equals(this.getCompanyId())) {
            return;
        }
        this.preSet();
        this.companyId = _companyId;
        this.autoUpdate();
    }

    @Override
    public void setCheckCurrentTransactionBatchHasTransactions(boolean _checkCurrentTransactionBatchHasTransactions) throws Exception {
        if (_checkCurrentTransactionBatchHasTransactions == this.getCheckCurrentTransactionBatchHasTransactions()) {
            return;
        }
        this.preSet();
        this.checkCurrentTransactionBatchHasTransactions = _checkCurrentTransactionBatchHasTransactions;
        this.autoUpdate();
    }

    @Override
    public void setUserGroup(UserGroup object) throws Exception {
        this.transientUserGroup = object;
        this.preSet();
        if (object == null) {
            generalAccessor.setAttribute((Object)this, "userGroupId", null);
        } else {
            object.assureStorage();
            generalAccessor.setAttribute((Object)this, "userGroupId", generalAccessor.getObjectAttribute(object, "id"));
        }
        this.autoUpdate();
        this.addCachedRelationObject("UserGroup", object);
    }

    private void initializeTheImplementationClass() throws Exception {
        this.id = "";
        this.description = "";
        this.userGroupId = "";
        this.admin = false;
        this.oneEnvironment = false;
        this.facLib = "";
        this.selectCompany = false;
        this.companyId = "";
        this.checkCurrentTransactionBatchHasTransactions = false;
    }

    protected void updateDBImage() throws Exception {
        if (this.currentDBImage == null) {
            this.currentDBImage = new DBImage();
        }
        this.currentDBImage.id = this.id;
        this.currentDBImage.description = this.description;
        this.currentDBImage.userGroupId = this.userGroupId;
        this.currentDBImage.admin = this.admin;
        this.currentDBImage.oneEnvironment = this.oneEnvironment;
        this.currentDBImage.facLib = this.facLib;
        this.currentDBImage.selectCompany = this.selectCompany;
        this.currentDBImage.companyId = this.companyId;
        this.currentDBImage.checkCurrentTransactionBatchHasTransactions = this.checkCurrentTransactionBatchHasTransactions;
        this.updateTransactionImage();
    }

    private void autoUpdate() throws Exception {
        if (this.underConstruction) {
            return;
        }
        if (this.deleted) {
            throw new InvalidStateException("User is deleted!");
        }
        this.dirty = true;
        if (!this.deferUpdate() && !this.holdUpdate) {
            this.save();
        }
    }

    @Override
    public void assureStorage() throws Exception {
        if (this.stored || this.updateDefered) {
            return;
        }
        boolean pre = this.holdUpdate;
        this.holdUpdate = false;
        this.autoUpdate();
        this.holdUpdate = pre;
    }

    @Override
    public void delete() throws Exception {
        if (this.deleted) {
            return;
        }
        if (this.stored) {
            ConnectionProvider provider = this.getConnectionProvider();
            if (!this.participatingInTransaction && provider instanceof AtomicDBTransaction) {
                ((AtomicDBTransaction)provider).addListener(this);
                this.participatingInTransaction = true;
                this.updateDefered = false;
            }
            ((UserManager_Impl)UserManager_Impl.getInstance(this.dbd)).removeByPrimaryKey(this.getId());
        }
        this.deleted = true;
    }

    @Override
    public void refreshData() throws Exception {
        this.save();
        this.relationalCache = null;
        ResultSet rs = null;
        try {
            rs = ((UserManager_Impl)UserManager_Impl.getInstance(this.dbd)).getResultSet((String)this.getPrimaryKey());
            this.loadData(rs);
        }
        catch (FinderException e) {
            throw new DeletedException("Deleted by other user");
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    Log.error((String)e.getMessage());
                }
            }
        }
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            try {
                this.hashCode = new String("385275089_" + this.dbd.getDBId() + this.id).hashCode();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        return this.hashCode;
    }

    @Override
    public UserDataBean getDataBean() throws Exception {
        return this.getDataBean(null);
    }

    @Override
    public UserDataBean getUserDataBean() throws Exception {
        return this.getDataBean(null);
    }

    private UserDataBean getDataBean(UserDataBean bean) throws Exception {
        if (bean == null) {
            bean = new UserDataBean();
        }
        bean.setId(this.getId());
        bean.setDescription(this.getDescription());
        bean.setUserGroupId(this.getUserGroupId());
        bean.setAdmin(this.getAdmin());
        bean.setOneEnvironment(this.getOneEnvironment());
        bean.setFacLib(this.getFacLib());
        bean.setSelectCompany(this.getSelectCompany());
        bean.setCompanyId(this.getCompanyId());
        bean.setCheckCurrentTransactionBatchHasTransactions(this.getCheckCurrentTransactionBatchHasTransactions());
        return bean;
    }

    public boolean equals(Object object) {
        try {
            if (object == null || !(object instanceof User_Impl)) {
                return false;
            }
            User_Impl bo = (User_Impl)object;
            if (bo.getId() == null ? this.getId() != null : !bo.getId().equals(this.getId())) {
                return false;
            }
            if (bo.getClass() != this.getClass()) {
                return false;
            }
            return bo.getDBId() == this.getDBId();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public void update(UserDataBean bean) throws Exception {
        this.set(bean);
    }

    public void set(UserDataBean bean) throws Exception {
        this.preSet();
        boolean pre = this.holdUpdate;
        try {
            this.holdUpdate = true;
            this.setId(bean.getId());
            this.setDescription(bean.getDescription());
            this.setUserGroupId(bean.getUserGroupId());
            this.setAdmin(bean.getAdmin());
            this.setOneEnvironment(bean.getOneEnvironment());
            this.setFacLib(bean.getFacLib());
            this.setSelectCompany(bean.getSelectCompany());
            this.setCompanyId(bean.getCompanyId());
            this.setCheckCurrentTransactionBatchHasTransactions(bean.getCheckCurrentTransactionBatchHasTransactions());
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.holdUpdate = pre;
        }
        this.autoUpdate();
    }

    @Override
    public void save() throws Exception {
        if (this.deleted) {
            throw new InvalidStateException(-1, "User is deleted!");
        }
        if (!this.stored) {
            this.insert();
        } else if (this.dirty) {
            this.update();
        }
        this.updateDefered = false;
    }

    private void update() throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        DBConnection dbc = provider instanceof AtomicDBTransaction ? ((AtomicDBTransaction)provider).getConnectionForUpdate(this) : provider.getConnection();
        DBImage image = this.currentDBImage;
        StringBuffer key = new StringBuffer("nl.ibs.fac.db.User.save");
        try {
            PreparedStatement prep = dbc.getPreparedStatement(key.toString());
            if (prep == null) {
                prep = dbc.getPreparedStatement(key.toString(), " UPDATE " + provider.getPrefix() + pmd.getTableName(provider) + " SET " + pmd.getFieldName("Id", provider) + " = ? , " + pmd.getFieldName("Description", provider) + " = ? , " + pmd.getFieldName("UserGroupId", provider) + " = ? , " + pmd.getFieldName("Admin", provider) + " = ? , " + pmd.getFieldName("OneEnvironment", provider) + " = ? , " + pmd.getFieldName("FacLib", provider) + " = ? , " + pmd.getFieldName("selectCompany", provider) + " = ? , " + pmd.getFieldName("CompanyId", provider) + " = ? , " + pmd.getFieldName("CheckCurrentTransactionBatchHasTransactions", provider) + " = ?  WHERE " + pmd.getFieldName("Id", provider) + " = ?  AND  " + pmd.getFieldName("Description", provider) + " = ?  AND  " + pmd.getFieldName("UserGroupId", provider) + " = ?  AND  " + pmd.getFieldName("Admin", provider) + " = ?  AND  " + pmd.getFieldName("OneEnvironment", provider) + " = ?  AND  " + pmd.getFieldName("FacLib", provider) + " = ?  AND  " + pmd.getFieldName("selectCompany", provider) + " = ?  AND  " + pmd.getFieldName("CompanyId", provider) + " = ?  AND  " + pmd.getFieldName("CheckCurrentTransactionBatchHasTransactions", provider) + " = ? ");
            }
            int parmIndex = 1;
            prep.setObject(parmIndex++, (Object)this.id, mapping.getJDBCTypeFor("String"));
            prep.setObject(parmIndex++, (Object)this.description, mapping.getJDBCTypeFor("String"));
            prep.setObject(parmIndex++, (Object)this.userGroupId, mapping.getJDBCTypeFor("String"));
            prep.setObject(parmIndex++, (Object)new Boolean(this.admin), mapping.getJDBCTypeFor("boolean"));
            prep.setObject(parmIndex++, (Object)new Boolean(this.oneEnvironment), mapping.getJDBCTypeFor("boolean"));
            prep.setObject(parmIndex++, (Object)this.facLib, mapping.getJDBCTypeFor("String"));
            prep.setObject(parmIndex++, (Object)new Boolean(this.selectCompany), mapping.getJDBCTypeFor("boolean"));
            prep.setObject(parmIndex++, (Object)this.companyId, mapping.getJDBCTypeFor("String"));
            prep.setObject(parmIndex++, (Object)new Boolean(this.checkCurrentTransactionBatchHasTransactions), mapping.getJDBCTypeFor("boolean"));
            prep.setObject(parmIndex++, (Object)image.id, mapping.getJDBCTypeFor("String"));
            prep.setObject(parmIndex++, (Object)image.description, mapping.getJDBCTypeFor("String"));
            prep.setObject(parmIndex++, (Object)image.userGroupId, mapping.getJDBCTypeFor("String"));
            prep.setObject(parmIndex++, (Object)new Boolean(image.admin), mapping.getJDBCTypeFor("boolean"));
            prep.setObject(parmIndex++, (Object)new Boolean(image.oneEnvironment), mapping.getJDBCTypeFor("boolean"));
            prep.setObject(parmIndex++, (Object)image.facLib, mapping.getJDBCTypeFor("String"));
            prep.setObject(parmIndex++, (Object)new Boolean(image.selectCompany), mapping.getJDBCTypeFor("boolean"));
            prep.setObject(parmIndex++, (Object)image.companyId, mapping.getJDBCTypeFor("String"));
            prep.setObject(parmIndex++, (Object)new Boolean(image.checkCurrentTransactionBatchHasTransactions), mapping.getJDBCTypeFor("boolean"));
            int n = prep.executeUpdate();
            if (n == 0) {
                this.rollback(true);
                throw new UpdateException("User modified by other user!", this);
            }
            this.updateDBImage();
            this.dirty = false;
            this.stored = true;
            if (provider instanceof AtomicDBTransaction && !this.participatingInTransaction) {
                ((AtomicDBTransaction)provider).addListener(this);
                this.participatingInTransaction = true;
            }
        }
        catch (Exception e) {
            if (!(e instanceof JSQLException)) {
                Log.error((String)e.getMessage());
            }
            throw e;
        }
        finally {
            provider.returnConnection(dbc);
        }
    }

    private void insert() throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        this.stored = true;
        DBConnection dbc = provider instanceof AtomicDBTransaction ? ((AtomicDBTransaction)provider).getConnectionForUpdate(this) : provider.getConnection();
        try {
            PreparedStatement prep = dbc.getPreparedStatement("nl.ibs.fac.db.User.insert");
            if (prep == null) {
                prep = dbc.getPreparedStatement("nl.ibs.fac.db.User.insert", "INSERT INTO " + provider.getPrefix() + pmd.getTableName(provider) + " ( " + pmd.getFieldName("Id", provider) + ", " + pmd.getFieldName("Description", provider) + ", " + pmd.getFieldName("UserGroupId", provider) + ", " + pmd.getFieldName("Admin", provider) + ", " + pmd.getFieldName("OneEnvironment", provider) + ", " + pmd.getFieldName("FacLib", provider) + ", " + pmd.getFieldName("selectCompany", provider) + ", " + pmd.getFieldName("CompanyId", provider) + ", " + pmd.getFieldName("CheckCurrentTransactionBatchHasTransactions", provider) + ") VALUES (?,?,?,?,?,?,?,?,?)");
            }
            prep.setObject(1, (Object)this.id, mapping.getJDBCTypeFor("String"));
            prep.setObject(2, (Object)this.description, mapping.getJDBCTypeFor("String"));
            prep.setObject(3, (Object)this.userGroupId, mapping.getJDBCTypeFor("String"));
            prep.setObject(4, (Object)new Boolean(this.admin), mapping.getJDBCTypeFor("boolean"));
            prep.setObject(5, (Object)new Boolean(this.oneEnvironment), mapping.getJDBCTypeFor("boolean"));
            prep.setObject(6, (Object)this.facLib, mapping.getJDBCTypeFor("String"));
            prep.setObject(7, (Object)new Boolean(this.selectCompany), mapping.getJDBCTypeFor("boolean"));
            prep.setObject(8, (Object)this.companyId, mapping.getJDBCTypeFor("String"));
            prep.setObject(9, (Object)new Boolean(this.checkCurrentTransactionBatchHasTransactions), mapping.getJDBCTypeFor("boolean"));
            prep.executeUpdate();
            this.updateDBImage();
            this.dirty = false;
            DBPersistenceManager.cache(this);
            if (provider instanceof AtomicDBTransaction && !this.participatingInTransaction) {
                ((AtomicDBTransaction)provider).addListener(this);
                this.participatingInTransaction = true;
            }
        }
        catch (CreateException e) {
            this.stored = false;
            throw e;
        }
        catch (Exception e) {
            this.stored = false;
            Log.error((String)e.getMessage());
            throw e;
        }
        finally {
            provider.returnConnection(dbc);
        }
    }

    @Override
    public void preSet() throws Exception {
        if (this.underConstruction) {
            return;
        }
        this.validateProvider();
        if (this.currentDBImage == null && this.stored) {
            this.updateDBImage();
        }
        this.dirty = true;
    }

    private void validateProvider() throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        if (provider instanceof AtomicDBTransaction && !((AtomicDBTransaction)provider).isActive()) {
            throw new Exception("Current transaction set but not active! Start transaction before modifying BusinessObjects!");
        }
    }

    protected void updateTransactionImage() throws Exception {
        this.updateTransactionImage(false);
    }

    protected void updateTransactionImage(boolean forse) throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        if ((this.transactionImage == null || forse) && provider instanceof AtomicDBTransaction) {
            if (this.transactionImage == null) {
                this.transactionImage = new TransactionImage();
            }
            if (this.transactionImage.dbImage == null) {
                this.transactionImage.dbImage = new DBImage();
            }
            this.transactionImage.dbImage.id = this.currentDBImage.id;
            this.transactionImage.dbImage.description = this.currentDBImage.description;
            this.transactionImage.dbImage.userGroupId = this.currentDBImage.userGroupId;
            this.transactionImage.dbImage.admin = this.currentDBImage.admin;
            this.transactionImage.dbImage.oneEnvironment = this.currentDBImage.oneEnvironment;
            this.transactionImage.dbImage.facLib = this.currentDBImage.facLib;
            this.transactionImage.dbImage.selectCompany = this.currentDBImage.selectCompany;
            this.transactionImage.dbImage.companyId = this.currentDBImage.companyId;
            this.transactionImage.dbImage.checkCurrentTransactionBatchHasTransactions = this.currentDBImage.checkCurrentTransactionBatchHasTransactions;
            this.transactionImage.stored = this.stored;
            this.transactionImage.deleted = this.deleted;
        }
    }

    @Override
    public void rollback(boolean includeBOFields) throws Exception {
        if (this.relationalCache != null) {
            this.relationalCache.clear();
        }
        this.updateDefered = false;
        if (this.transactionImage == null) {
            return;
        }
        this.currentDBImage.id = this.transactionImage.dbImage.id;
        this.currentDBImage.description = this.transactionImage.dbImage.description;
        this.currentDBImage.userGroupId = this.transactionImage.dbImage.userGroupId;
        this.currentDBImage.admin = this.transactionImage.dbImage.admin;
        this.currentDBImage.oneEnvironment = this.transactionImage.dbImage.oneEnvironment;
        this.currentDBImage.facLib = this.transactionImage.dbImage.facLib;
        this.currentDBImage.selectCompany = this.transactionImage.dbImage.selectCompany;
        this.currentDBImage.companyId = this.transactionImage.dbImage.companyId;
        this.currentDBImage.checkCurrentTransactionBatchHasTransactions = this.transactionImage.dbImage.checkCurrentTransactionBatchHasTransactions;
        if (includeBOFields) {
            this.id = this.transactionImage.dbImage.id;
            this.description = this.transactionImage.dbImage.description;
            this.userGroupId = this.transactionImage.dbImage.userGroupId;
            this.admin = this.transactionImage.dbImage.admin;
            this.oneEnvironment = this.transactionImage.dbImage.oneEnvironment;
            this.facLib = this.transactionImage.dbImage.facLib;
            this.selectCompany = this.transactionImage.dbImage.selectCompany;
            this.companyId = this.transactionImage.dbImage.companyId;
            this.checkCurrentTransactionBatchHasTransactions = this.transactionImage.dbImage.checkCurrentTransactionBatchHasTransactions;
        }
        this.stored = this.transactionImage.stored;
        this.deleted = this.transactionImage.deleted;
        this.participatingInTransaction = false;
        if (!this.stored) {
            DBPersistenceManager.removeFromCache(this);
        }
    }

    @Override
    public void commit() throws Exception {
        if (this.deleted) {
            DBPersistenceManager.removeFromCache(this);
        } else {
            this.updateTransactionImage(true);
        }
        this.participatingInTransaction = false;
        this.updateDefered = false;
    }

    @Override
    public PersistenceMetaData getPersistenceMetaData() {
        return pmd;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public int getDBId() {
        return this.dbd.getDBId();
    }

    @Override
    public DBData getDBData() {
        return this.dbd;
    }

    protected boolean deferUpdate() throws Exception {
        ConnectionProvider provider;
        if (!deferUpdates) {
            return false;
        }
        if (!this.updateDefered && (provider = this.getConnectionProvider()) instanceof AtomicDBTransaction) {
            ((AtomicDBTransaction)provider).setDeferedForUpdate(this);
            this.updateDefered = true;
        }
        return this.updateDefered;
    }

    protected boolean isCachedRelation(String relation) {
        return this.relationalCache == null ? false : this.relationalCache.containsKey(relation);
    }

    @Override
    public Object addCachedRelationObject(String relation, Object object) {
        if (!cacheRelations) {
            return object;
        }
        if (this.relationalCache == null) {
            this.relationalCache = new HashMap();
        }
        if (object instanceof ArrayListImpl) {
            ((ArrayListImpl)object).fixate();
        }
        this.relationalCache.put(relation, object);
        return object;
    }

    protected Object getCachedRelationObject(String relation) {
        if (this.relationalCache == null) {
            return null;
        }
        Object o = this.relationalCache.get(relation);
        if (o instanceof BusinessObject_Impl) {
            return ((BusinessObject_Impl)o).isDeleted() ? null : o;
        }
        if (o instanceof ArrayListImpl) {
            ArrayList list = ((ArrayListImpl)o).getBaseCopy();
            for (int x = 0; x < list.size(); ++x) {
                if (!((BusinessObject_Impl)list.get(x)).isDeleted()) continue;
                list.remove(x--);
            }
            return list;
        }
        return o;
    }

    @Override
    public void clearCachedRelation(String relation) {
        if (this.relationalCache != null) {
            this.relationalCache.remove(relation);
        }
    }

    private static final class TransactionImage
    implements Serializable {
        private DBImage dbImage;
        boolean stored;
        boolean deleted;

        private TransactionImage() {
        }
    }

    private static final class DBImage
    implements Serializable {
        private String id;
        private String description;
        private String userGroupId;
        private boolean admin;
        private boolean oneEnvironment;
        private String facLib;
        private boolean selectCompany;
        private String companyId;
        private boolean checkCurrentTransactionBatchHasTransactions;

        private DBImage() {
        }
    }
}

