/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.db.impl;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.ListIterator;
import nl.ibs.fac.db.WozValue;
import nl.ibs.fac.db.WozValueDataBean;
import nl.ibs.fac.db.WozValueManager;
import nl.ibs.fac.db.WozValuePK;
import nl.ibs.fac.db.impl.PersistenceMetaDataWozValue;
import nl.ibs.fac.db.impl.WozValue_Impl;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.AtomicDBTransaction;
import nl.ibs.jsql.BusinessObject_Impl;
import nl.ibs.jsql.Cache;
import nl.ibs.jsql.DBConfig;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.Query;
import nl.ibs.jsql.QueryFactory;
import nl.ibs.jsql.exception.FinderException;
import nl.ibs.jsql.exception.JSQLException;
import nl.ibs.jsql.exception.RemoveException;
import nl.ibs.jsql.impl.ArrayListImpl;
import nl.ibs.jsql.impl.ListIteratorImpl;
import nl.ibs.jsql.impl.QueryImplementation;
import nl.ibs.jsql.sql.AttributeAccessor;
import nl.ibs.jsql.sql.BusinessObjectManager;
import nl.ibs.jsql.sql.ConnectionProvider;
import nl.ibs.jsql.sql.DBConnection;
import nl.ibs.jsql.sql.DBMapping;
import nl.ibs.jsql.sql.PersistenceMetaData;
import nl.ibs.jsql.sql.QueryTranslator;
import nl.ibs.vegas.ExecutableQuery;
import nl.ibs.vegas.meta.AttributeMeta;
import nl.ibs.vegas.meta.impl.FieldMetaImpl;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WozValueManager_Impl
extends BusinessObjectManager
implements WozValueManager {
    private static final String APPLICATION = "fac";
    private static DOMImplementation domImplementation = DBConfig.getDOMImplementation();
    private static AttributeAccessor generalAccessor = new AttributeAccessor();
    private static boolean verbose = Log.debug();
    private static PersistenceMetaData pmd = PersistenceMetaDataWozValue.getInstance();
    private static Hashtable instances = new Hashtable();
    private DBData dbd;
    static final String[] keys = new String[]{"companyId", "cora", "assetId", "wOZValueYear", "wOZValuePeriod"};
    static final AttributeMeta[] attributes = new AttributeMeta[]{new FieldMetaImpl("companyId", "txt-company-id", "txt-company-id-short", "txt-company-id-description", "text", String.class, 7, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("cora", "txt-cora", "txt-cora-short", "txt-cora-description", "text", String.class, 1, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("assetId", "txt-asset-id", "txt-asset-id-short", "txt-asset-id-description", "text", String.class, 10, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("wOZValueYear", "txt-w-o-z-value-year", "txt-w-o-z-value-year-short", "txt-w-o-z-value-year-description", "number", Integer.TYPE, 4, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("wOZValuePeriod", "txt-w-o-z-value-period", "txt-w-o-z-value-period-short", "txt-w-o-z-value-period-description", "number", Integer.TYPE, 2, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("wOZAmount", "txt-w-o-z-amount", "txt-w-o-z-amount-short", "txt-w-o-z-amount-description", "decimal", BigDecimal.class, 15, 2, "0.00", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("limitValuePercentage", "txt-limit-value-percentage", "txt-limit-value-percentage-short", "txt-limit-value-percentage-description", "decimal", BigDecimal.class, 5, 2, "0.00", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("limitValueYear1", "txt-limit-value-year1", "txt-limit-value-year1-short", "txt-limit-value-year1-description", "number", Integer.TYPE, 4, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("limitValuePeriod1", "txt-limit-value-period1", "txt-limit-value-period1-short", "txt-limit-value-period1-description", "number", Integer.TYPE, 2, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("limitAmount1", "txt-limit-amount1", "txt-limit-amount1-short", "txt-limit-amount1-description", "decimal", BigDecimal.class, 15, 2, "0.00", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("limitValueYear2", "txt-limit-value-year2", "txt-limit-value-year2-short", "txt-limit-value-year2-description", "number", Integer.TYPE, 4, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("limitValuePeriod2", "txt-limit-value-period2", "txt-limit-value-period2-short", "txt-limit-value-period2-description", "number", Integer.TYPE, 2, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("limitAmount2", "txt-limit-amount2", "txt-limit-amount2-short", "txt-limit-amount2-description", "decimal", BigDecimal.class, 15, 2, "0.00", "false", "false", "", "", false, false, null, null)};

    private WozValueManager_Impl(DBData dbData) {
        this.dbd = dbData;
    }

    public static WozValueManager getInstance() {
        return WozValueManager_Impl.getInstance(DBData.getDefaultDBData(APPLICATION));
    }

    public static WozValueManager getInstance(DBData dbd) {
        if (dbd == null) {
            throw new IllegalArgumentException("Tried to instantiate a Manager it DBData = null!");
        }
        WozValueManager_Impl inst = (WozValueManager_Impl)instances.get(dbd);
        if (inst == null) {
            inst = new WozValueManager_Impl(dbd);
            instances.put(dbd, inst);
        }
        return inst;
    }

    public DBData getDBData() {
        return this.dbd;
    }

    @Override
    public WozValue create(WozValueDataBean bean) throws Exception {
        WozValue_Impl impl = new WozValue_Impl(this.dbd, bean);
        impl.assureStorage();
        return impl;
    }

    @Override
    public WozValue create(String _companyId, String _cora, String _assetId, int _wOZValueYear, int _wOZValuePeriod) throws Exception {
        WozValue_Impl obj = new WozValue_Impl(this.dbd, _companyId, _cora, _assetId, _wOZValueYear, _wOZValuePeriod);
        obj.assureStorage();
        return obj;
    }

    private WozValuePK getPK(ResultSet rs) throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        WozValuePK inst = new WozValuePK();
        inst.setCompanyId(rs.getString(pmd.getFieldName("CompanyId", provider)));
        inst.setCora(rs.getString(pmd.getFieldName("Cora", provider)));
        inst.setAssetId(rs.getString(pmd.getFieldName("AssetId", provider)));
        inst.setWOZValueYear(rs.getInt(pmd.getFieldName("WOZValueYear", provider)));
        inst.setWOZValuePeriod(rs.getInt(pmd.getFieldName("WOZValuePeriod", provider)));
        return inst;
    }

    @Override
    public WozValue findOrCreate(WozValuePK key) throws Exception {
        WozValue obj;
        try {
            obj = this.findByPrimaryKey(key);
        }
        catch (FinderException e) {
            obj = this.create(key.getCompanyId(), key.getCora(), key.getAssetId(), key.getWOZValueYear(), key.getWOZValuePeriod());
        }
        return obj;
    }

    @Override
    public void add(WozValueDataBean inst) throws Exception {
        WozValue_Impl impl = new WozValue_Impl(this.dbd, inst);
        impl.assureStorage();
    }

    @Override
    public void removeByPrimaryKey(WozValuePK key) throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        WozValue cachedObject = this.getCachedObjectByPrimaryKey(key);
        DBConnection dbc = provider instanceof AtomicDBTransaction ? ((AtomicDBTransaction)provider).getConnectionForUpdate((BusinessObject_Impl)((Object)cachedObject)) : provider.getConnection();
        String pskey = "nl.ibs.fac.db.WozValue.removeByPrimaryKey";
        try {
            PreparedStatement prep = dbc.getPreparedStatement(pskey);
            if (prep == null) {
                prep = dbc.getPreparedStatement(pskey, " DELETE FROM " + provider.getPrefix() + pmd.getTableName(provider) + " WHERE " + pmd.getFieldName("CompanyId", provider) + "=? AND " + pmd.getFieldName("Cora", provider) + "=? AND " + pmd.getFieldName("AssetId", provider) + "=? AND " + pmd.getFieldName("WOZValueYear", provider) + "=? AND " + pmd.getFieldName("WOZValuePeriod", provider) + "=?");
            }
            prep.setString(1, key.getCompanyId());
            prep.setString(2, key.getCora());
            prep.setString(3, key.getAssetId());
            prep.setInt(4, key.getWOZValueYear());
            prep.setInt(5, key.getWOZValuePeriod());
            int x = prep.executeUpdate();
            if (x == 0) {
                throw new RemoveException("Key not found");
            }
            if (cachedObject != null) {
                DBPersistenceManager.removeFromCache(cachedObject);
            }
        }
        catch (SQLException e) {
            if (!(e instanceof JSQLException)) {
                Log.error((String)e.getMessage());
            }
            throw e;
        }
        finally {
            provider.returnConnection(dbc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WozValue findByPrimaryKey(WozValuePK key) throws Exception {
        WozValue wozValue = this.getCachedObjectByPrimaryKey(key);
        if (wozValue != null) {
            return wozValue;
        }
        ResultSet rs = null;
        try {
            rs = this.getResultSet(key);
            WozValue wozValue2 = (WozValue)this.getBusinessObject(rs);
            return wozValue2;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    Log.error((String)e.getMessage());
                }
            }
        }
    }

    public ResultSet getResultSet(WozValuePK key) throws Exception {
        ResultSet rs = null;
        String pskey = "nl.ibs.fac.db.WozValue.findByPrimaryKey1";
        Object inst = null;
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        DBConnection dbc = provider.getConnection();
        try {
            PreparedStatement prep = dbc.getPreparedStatement(pskey);
            if (prep == null) {
                prep = dbc.getPreparedStatement(pskey, " SELECT *  FROM " + provider.getPrefix() + pmd.getTableName(provider) + " WHERE " + pmd.getFieldName("CompanyId", provider) + "=? AND " + pmd.getFieldName("Cora", provider) + "=? AND " + pmd.getFieldName("AssetId", provider) + "=? AND " + pmd.getFieldName("WOZValueYear", provider) + "=? AND " + pmd.getFieldName("WOZValuePeriod", provider) + "=?");
            }
            prep.setString(1, key.getCompanyId());
            prep.setString(2, key.getCora());
            prep.setString(3, key.getAssetId());
            prep.setInt(4, key.getWOZValueYear());
            prep.setInt(5, key.getWOZValuePeriod());
            prep.executeQuery();
            rs = prep.getResultSet();
            if (!rs.next()) {
                throw new FinderException("Key not found");
            }
        }
        catch (SQLException e) {
            if (!(e instanceof JSQLException)) {
                Log.error((String)e.getMessage());
            }
            throw e;
        }
        finally {
            provider.returnConnection(dbc);
        }
        return rs;
    }

    public WozValue getCachedObjectByPrimaryKey(WozValuePK key) throws Exception {
        Cache cache = DBPersistenceManager.getCache();
        if (cache == null) {
            return null;
        }
        Object o = cache.get(new String("-2121244683_" + this.dbd.getDBId() + key.getCompanyId() + key.getCora() + key.getAssetId() + key.getWOZValueYear() + key.getWOZValuePeriod()));
        return (WozValue)o;
    }

    @Override
    public ConnectionProvider getConnectionProvider() throws Exception {
        return DBPersistenceManager.getConnectionProvider(this.dbd);
    }

    @Override
    public PersistenceMetaData getPersistenceMetaData() {
        return pmd;
    }

    @Override
    public int generalUpdate(String setClause, String whereClause) throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        DBConnection dbc = provider.getConnection();
        try {
            String update = "UPDATE " + provider.getPrefix() + pmd.getTableName(provider) + " SET " + QueryTranslator.translateObjectQuery(setClause + " WHERE " + whereClause, pmd, provider);
            int n = dbc.executeUpdate(update);
            return n;
        }
        catch (SQLException e) {
            Log.error((String)e.getMessage());
            throw e;
        }
        finally {
            provider.returnConnection(dbc);
        }
    }

    @Override
    public int generalDelete(String whereClause) throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        DBConnection dbc = provider.getConnection();
        try {
            String delete = "DELETE FROM " + provider.getPrefix() + pmd.getTableName(provider) + " WHERE " + QueryTranslator.translateObjectQuery(whereClause, pmd, provider);
            int n = dbc.executeUpdate(delete);
            return n;
        }
        catch (SQLException e) {
            Log.error((String)e.getMessage());
            throw e;
        }
        finally {
            provider.returnConnection(dbc);
        }
    }

    @Override
    public WozValue getFirstObject(Query query) throws Exception {
        if (query == null) {
            query = QueryFactory.create();
        }
        int prevMax = query.getMaxObjects();
        query.setMaxObjects(1);
        try {
            WozValue wozValue = (WozValue)((QueryImplementation)query).execute(this, (short)0);
            return wozValue;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            query.setMaxObjects(prevMax);
        }
    }

    @Override
    public Collection getCollection(Query query) throws Exception {
        if (query == null) {
            query = QueryFactory.create(this, null, null, 1000);
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        return (Collection)queryImpl.execute(this, (short)-1);
    }

    public ListIterator getListIterator(Query query) throws Exception {
        if (query == null) {
            query = QueryFactory.create(this, null, null, 1000);
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        return (ListIterator)queryImpl.execute(this, (short)-2);
    }

    @Override
    public Document getDocument(Query query) throws Exception {
        if (query == null) {
            query = QueryFactory.create(this, null, null, 1000);
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        return (Document)queryImpl.execute(this, (short)-3);
    }

    @Override
    public DocumentFragment getDocumentFragment(Query query) throws Exception {
        if (query == null) {
            query = QueryFactory.create(this, null, null, 1000);
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        return (DocumentFragment)queryImpl.execute(this, (short)-4);
    }

    @Override
    public ArrayList getDocumentFragmentArrayList(Query query) throws Exception {
        if (query == null) {
            query = QueryFactory.create(this, null, null, 1000);
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        return (ArrayList)queryImpl.execute(this, (short)-5);
    }

    @Override
    protected Collection getCollection(ResultSet rs) throws Exception {
        ArrayListImpl result = new ArrayListImpl();
        while (rs.next()) {
            ((ArrayList)result).add(this.getBusinessObject(rs));
        }
        return result;
    }

    @Override
    protected Document getDocument(ResultSet resultSet) throws Exception {
        Document document = domImplementation.createDocument("", "data", null);
        Element root = document.getDocumentElement();
        this.collectResultElements(resultSet, root, this.getConnectionProvider());
        return document;
    }

    @Override
    protected DocumentFragment getDocumentFragment(ResultSet resultSet) throws Exception {
        Document document = domImplementation.createDocument("", "data", null);
        DocumentFragment documentFragment = document.createDocumentFragment();
        this.collectResultElements(resultSet, documentFragment, this.getConnectionProvider());
        return documentFragment;
    }

    @Override
    protected ArrayList getDocumentFragmentArrayList(ResultSet resultSet) throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        Document document = domImplementation.createDocument("", "data", null);
        ArrayListImpl arrayList = new ArrayListImpl();
        while (resultSet.next()) {
            DocumentFragment documentFragment = document.createDocumentFragment();
            Node rec = documentFragment.appendChild(document.createElement("wozvalue"));
            WozValueManager_Impl.addBOFieldsToElement(resultSet, rec, provider);
            ((ArrayList)arrayList).add(documentFragment);
        }
        return arrayList;
    }

    @Override
    protected ListIterator getListIterator(ResultSet rs) throws Exception {
        ListIteratorImpl result = new ListIteratorImpl();
        while (rs.next()) {
            result.add(this.getBusinessObject(rs));
        }
        result.pointer = 0;
        return result;
    }

    @Override
    protected Object getBusinessObject(ResultSet rs) throws Exception {
        Cache cache = DBPersistenceManager.getCache();
        if (cache != null) {
            ConnectionProvider provider = this.getConnectionProvider();
            Object o = cache.get(new String("-2121244683_" + this.dbd.getDBId() + rs.getObject(pmd.getFieldName("CompanyId", provider)) + rs.getObject(pmd.getFieldName("Cora", provider)) + rs.getObject(pmd.getFieldName("AssetId", provider)) + rs.getObject(pmd.getFieldName("WOZValueYear", provider)) + rs.getObject(pmd.getFieldName("WOZValuePeriod", provider))));
            if (o != null) {
                return o;
            }
        }
        return DBPersistenceManager.cache(this.createBusinessObject(rs));
    }

    private Object createBusinessObject(ResultSet rs) throws Exception {
        return new WozValue_Impl(this.dbd, rs);
    }

    private void collectResultElements(ResultSet rs, Node root, ConnectionProvider provider) throws Exception {
        Document doc = root.getOwnerDocument();
        while (rs.next()) {
            Node rec = root.appendChild(doc.createElement("wozvalue"));
            WozValueManager_Impl.addBOFieldsToElement(rs, rec, provider);
        }
    }

    public static void addBOFieldsToElement(ResultSet rs, Node rec, ConnectionProvider provider) throws Exception {
        DBMapping mapping = provider.getDBMapping();
        Document doc = rec.getOwnerDocument();
        Object o = null;
        String s = null;
        s = rs.getString(pmd.getFieldName("CompanyId", provider));
        if (s != null && (s = s.trim()).length() > 0) {
            rec.appendChild(doc.createElement("companyid")).appendChild(doc.createCDATASection(s));
        }
        if ((s = rs.getString(pmd.getFieldName("Cora", provider))) != null && (s = s.trim()).length() > 0) {
            rec.appendChild(doc.createElement("cora")).appendChild(doc.createCDATASection(s));
        }
        if ((s = rs.getString(pmd.getFieldName("AssetId", provider))) != null && (s = s.trim()).length() > 0) {
            rec.appendChild(doc.createElement("assetid")).appendChild(doc.createCDATASection(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("WOZValueYear", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("wozvalueyear")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("WOZValuePeriod", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("wozvalueperiod")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getBigDecimal(pmd.getFieldName("WOZAmount", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("wozamount")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getBigDecimal(pmd.getFieldName("LimitValuePercentage", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("limitvaluepercentage")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("LimitValueYear1", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("limitvalueyear1")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("LimitValuePeriod1", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("limitvalueperiod1")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getBigDecimal(pmd.getFieldName("LimitAmount1", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("limitamount1")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("LimitValueYear2", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("limitvalueyear2")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("LimitValuePeriod2", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("limitvalueperiod2")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getBigDecimal(pmd.getFieldName("LimitAmount2", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("limitamount2")).appendChild(doc.createTextNode(s));
        }
    }

    public ExecutableQuery getExecutableQuery() {
        return QueryFactory.create(this);
    }

    public String[] getKeyNames() {
        return keys;
    }

    public AttributeMeta[] getAttributes() {
        return attributes;
    }

    public Class getClassType() {
        return WozValue.class;
    }

    public String getNameField() {
        return "wOZValuePeriod";
    }

    public String getDescriptionField() {
        return "wOZValuePeriod";
    }

    public String getTextKey() {
        return "txt-woz-value";
    }

    public String getTextKeyShort() {
        return "txt-woz-value-short";
    }

    public String getTextKeyDescription() {
        return "txt-woz-value-description";
    }

    public AttributeMeta getAttribute(String name) {
        if (attributes == null || name == null) {
            return null;
        }
        for (int i = 0; i < attributes.length; ++i) {
            if (!name.equals(attributes[i].getName())) continue;
            return attributes[i];
        }
        return null;
    }
}

