/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.gov.adapters;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.helpers.TableHelper;
import nl.ibs.esp.language.TranslationHelperImpl;
import nl.ibs.esp.layout.ESPGridLayout;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.ComboBox;
import nl.ibs.esp.uiobjects.CommonTable;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.HeaderPanel;
import nl.ibs.esp.uiobjects.Image;
import nl.ibs.esp.uiobjects.Label;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.ODBQuery;
import nl.ibs.esp.uiobjects.ODBTable;
import nl.ibs.esp.uiobjects.Panel;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.Table;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.UserMessageCollection;
import nl.ibs.esp.util.ODBCounter;
import nl.ibs.esp.util.Transformer;
import nl.ibs.fac.CalculationValue;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.adapters.AssetPanels;
import nl.ibs.fac.adapters.AssetReferenceField;
import nl.ibs.fac.adapters.BookYearPeriodGrid;
import nl.ibs.fac.adapters.DecimalTransformer;
import nl.ibs.fac.adapters.FACDecimalField;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.FMSReferenceField;
import nl.ibs.fac.adapters.FinancialReferenceField;
import nl.ibs.fac.adapters.MemoAdapter;
import nl.ibs.fac.adapters.MemoImageTransformer;
import nl.ibs.fac.adapters.NumericIdTransformer;
import nl.ibs.fac.adapters.ParentAssetAdapter;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.boadapters.BookYearBO;
import nl.ibs.fac.boadapters.CompanyAccountingPrincipleDefaultBO;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.bp.AssetBP;
import nl.ibs.fac.bp.InvestmentBP;
import nl.ibs.fac.bp.LedgerCorrectionBP;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.CompanyAccountingPrincipleDefault;
import nl.ibs.fac.db.Credit;
import nl.ibs.fac.db.CreditBalance;
import nl.ibs.fac.gov.adapters.CloseCreditTransactionAdapter;
import nl.ibs.fac.gov.adapters.CreditReferenceField;
import nl.ibs.fac.gov.boadapters.CreditBO;
import nl.ibs.fac.gov.boadapters.CreditBalanceBO;
import nl.ibs.fac.gov.boadapters.TotalEstimationTransactionBO;
import nl.ibs.fac.gov.bp.CreditBP;
import nl.ibs.fac.gov.bp.CreditBalanceBP;
import nl.ibs.fac.gov.bp.CreditDepreciationBP;
import nl.ibs.fac.gov.bp.GenericGovernmentBP;
import nl.ibs.fac.gov.queries.CreditQuery;

public class CloseCreditAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = 9040484021052750804L;
    private static final DecimalTransformer DECIMALTRANSFORMER = new DecimalTransformer();
    public static final String PAGE = CloseCreditAdapter.class.getName();
    private Company company;
    private ODBTable table = null;
    private CommonTable.SearchPanel searchPanel;
    private static final String[] TOOLTIPS = new String[]{"Label.AlreadyAllocated", "Label.Memo"};
    private static final String[] NAMES = new String[]{"id", "totalEstimationAmount", "totalCostAmount", "allocatedValue", "description", "proFormaTypeId", "startYear", "endYear", "preferedGLAccountId", "hasMemo"};
    private static final String[] LABELS = new String[]{"Label.Id", "Label.CreditAmount", "Label.BalanceAmount", "Label.AlreadyAllocated", "Label.Description", "Label.Type", "Label.From", "Label.To", "Label.GLAccount", "Label.Memo"};
    private static final short[] SIZES = new short[]{80, 125, 125, 20, 250, 80, 40, 40, 80, 20};
    private static final String[] TYPES = new String[]{null, null, null, null, null, null, null, null, null, null};
    private static Transformer[] TRANSFORMERS = new Transformer[]{null, new DecimalTransformer(), new DecimalTransformer(), null, null, null, null, null, null, new MemoImageTransformer()};
    private static final boolean[] COLUMNNOWRAPS = new boolean[]{true, true, true, true, true, true, true, true, true, true};
    private static final boolean[] SORTABLE = new boolean[]{true, false, false, true, true, true, true, true, true, true};
    private NumericIdTransformer numericIdTransformer = new NumericIdTransformer();
    private static final String REFRESH = "refresh";
    public static final String ALLOCATE_ENTRY = "allocateEntry";
    private static final String ALLOCATE = "allocate";
    public static final String CONFIRM_ENTRY = "confirmEntry";
    public static final String UPDATE_TABLE = "updateTable";
    private static final String CREATEASSET = "createAsset";
    private FloatBar fbShow = new FloatBar();
    private FloatBar fbAllocate = new FloatBar();
    private Action[] rowActions;
    private Action[] headerActions;
    private Credit credit;
    private Panel header;
    private CreditReferenceField crf;
    private Label spaceLabel;
    private Label interestMessageLabel;
    private String spaces = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
    private CreditDepreciationBP businessProcess;
    private FACDecimalField creditAmount = new FACDecimalField("", 15, 2);
    private FACDecimalField balanceAmount = new FACDecimalField("", 15, 2);
    private FACDecimalField deprAmount = new FACDecimalField("", 15, 2);
    private FieldGroup fgAllocateTo;
    private FACDecimalField unAllocatedValue = new FACDecimalField("Label.Amount", 15, 2);
    private FACDecimalField unAllocatedDeprValue = new FACDecimalField("Label.DepreciationAmount", 15, 2);
    private ComboBox allocateTo = new ComboBox("Label.TransactionType");
    private static final String NEW_ASSET = "NEW_ASSET";
    private static final String INVESTMENT = "INVESTMENT";
    private static final String LEDGERCORRECTION = "LEDGERCORRECTION";
    private BookYearPeriodGrid facYearPeriod;
    private BookYearPeriodGrid finYearPeriod;
    private BookYearPeriodGrid closingPeriod;
    private AssetPanels panels;
    private LedgerCorrectionBP ledgerCorrectionBP;
    private FieldGroup correctionPanel = new FieldGroup("Label.GeneralLedgerCorrection");
    private FACDecimalField transactionValue = new FACDecimalField("Label.Amount", 15, 2);
    private Field description = new Field("Label.Description");
    private FinancialReferenceField daybook;
    private FinancialReferenceField[] financialDimension = new FinancialReferenceField[9];
    private String[] finTexts = new String[5];
    private AssetReferenceField assetField;
    private FieldGroup investmentPanel = new FieldGroup("Label.AdditionalInvestment.short");
    private InvestmentBP investmentBP;
    protected static final String CREDIT = "Credit";
    private GenericGovernmentBP genericGovernmentBP;
    private CreditBalanceBP creditBalanceBP;
    private FieldGroup maFieldGroup = null;
    protected ODBTable table0 = null;
    private static final String[] NAMES0 = new String[]{"totalEstimationAmount", "totalCostAmount", "expenditureLeftAmount", "totalInterestAmount", "manualInterestAmount", "manualDepreciationAmount", "initialProjectCostAmount"};
    private String[] LABELS0 = new String[]{"Label.Estimation", "Label.Costs", "Label.ExpenditureLeftAmount", "Label.InterestCalculatedAmount", "Label.ManualInterestAmount", "Label.ManualDepreciationAmount", "Label.InitialProjectCostAmount"};
    private static final short[] SIZES0 = new short[]{96, 96, 96, 93, 93, 93, 93};
    private static final Transformer[] TRANSFORMERS0 = new Transformer[]{DECIMALTRANSFORMER, DECIMALTRANSFORMER, DECIMALTRANSFORMER, DECIMALTRANSFORMER, DECIMALTRANSFORMER, DECIMALTRANSFORMER, DECIMALTRANSFORMER};

    public CloseCreditAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.initialize(object);
    }

    private void initialize(DataObject object) throws Exception {
        this.company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        this.creditBalanceBP = new CreditBalanceBP(this.company);
        if (this.company.getUseValuationMainAccount()) {
            this.genericGovernmentBP = new GenericGovernmentBP(this.company);
        }
        CloseCreditAdapter.TRANSFORMERS[3] = new CreditAllocatedValueImageTransformer();
        Action refresh = new Action("Button.Refresh").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(REFRESH);
        this.fbShow.addAction(refresh);
        this.fbShow.addAction(this.finish);
        Action close = new Action("Button.Close").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(ALLOCATE_ENTRY);
        Action transactions = new Action("Button.Transactions").setAdapter(this.getProcessAdapterPageName(CloseCreditTransactionAdapter.PAGE)).setMethod("show");
        Action memo = new Action("Label.Memo").setAdapter(this.getProcessAdapterPageName(MemoAdapter.PAGE)).setMethod("show");
        this.getProcess().setAttribute("MemoAdapterReturnPage", (Object)this.getProcessAdapterPageName(PAGE));
        this.rowActions = new Action[]{close, transactions, memo};
        this.headerActions = new Action[]{refresh};
        this.header = new HeaderPanel();
        this.crf = new CreditReferenceField(this.company, false);
        this.crf.setLabel("Label.Credit");
        this.crf.setReadonly(true);
        this.header.addUIObject((UIObject)this.crf);
        this.spaceLabel = new Label(this.spaces);
        this.header.addUIObject((UIObject)this.spaceLabel);
        this.interestMessageLabel = new Label("");
        this.interestMessageLabel.setColor("red");
        this.header.addUIObject((UIObject)this.interestMessageLabel);
        this.fgAllocateTo = new FieldGroup("Label.ValueToBook");
        this.unAllocatedValue.setReadonly(true);
        this.unAllocatedValue.setNullable(false);
        this.fgAllocateTo.add((Field)this.unAllocatedValue);
        this.unAllocatedDeprValue.setReadonly(true);
        this.unAllocatedDeprValue.setNullable(false);
        this.fgAllocateTo.add((Field)this.unAllocatedDeprValue);
        this.allocateTo.addOption("Label.NewAsset", NEW_ASSET);
        this.allocateTo.addOption("Label.AdditionalInvestment.short", INVESTMENT);
        this.allocateTo.addOption("Label.GeneralLedgerCorrection", LEDGERCORRECTION);
        this.allocateTo.add((Action)new AllocateToChangeAction(this.getProcessAdapterPageName(PAGE)));
        this.fgAllocateTo.add(this.allocateTo);
        this.facYearPeriod = new BookYearPeriodGrid("Label.ActivationPeriod", "" + this.company.getCurrentBookYear(), this.bookYearMin, this.bookYearMax, this.numberOfPeriods);
        this.fgAllocateTo.add((ESPGridLayout)this.facYearPeriod);
        this.finYearPeriod = new BookYearPeriodGrid("Label.BookPeriod", false);
        this.fgAllocateTo.add((ESPGridLayout)this.finYearPeriod);
        this.investmentBP = new InvestmentBP(this.company, this.numberOfPeriods, "FIN");
        this.transactionValue.setMandatory(true);
        this.transactionValue.requestFocus(true);
        this.investmentPanel.add((Field)this.transactionValue);
        this.description.setLength(30);
        this.description.setMaxLength(30);
        this.investmentPanel.add(this.description);
        this.assetField = new AssetReferenceField(this.company, null, new Boolean(true), true, false);
        this.assetField.setLabel("Label.Asset");
        this.assetField.setDescriptionLength(35);
        this.assetField.setMandatory(true);
        this.investmentPanel.add((Field)this.assetField);
        this.ledgerCorrectionBP = new LedgerCorrectionBP(this.company, this.numberOfPeriods);
        this.correctionPanel.add((Field)this.transactionValue);
        this.transactionValue.requestFocus(true);
        this.correctionPanel.add(this.description);
        this.daybook = new FMSReferenceField(this.loginHelper, "Label.Daybook", -1, true);
        this.financialDimension[0] = new FMSReferenceField(this.loginHelper, "Label.MainAccount", 0, true);
        this.daybook.setMandatory(true);
        this.correctionPanel.add((Field)this.daybook);
        this.financialDimension[0].setMandatory(true);
        this.correctionPanel.add((Field)this.financialDimension[0]);
        this.finTexts[0] = this.env.getName1();
        this.finTexts[1] = this.env.getName2();
        this.finTexts[2] = this.env.getName3();
        this.finTexts[3] = this.env.getName4();
        this.finTexts[4] = this.env.getName5();
        for (int i = 0; i < this.finTexts.length; ++i) {
            if (this.finTexts[i].length() == 0) continue;
            this.financialDimension[i + 1] = new FMSReferenceField(this.loginHelper, this.finTexts[i], i + 1, this.company);
            this.correctionPanel.add((Field)this.financialDimension[i + 1]);
        }
        BookYearBO.synchronizeWithFinancials(this.loginHelper, this.env, this.company);
    }

    public DataObject show(DataObject object) throws Exception {
        if (this.companyId == null) {
            object.addUIObject((UIObject)new Message("NoActiveCompany", "error"));
            return this.finish(object);
        }
        this.getProcess().removeAttribute(CREDIT);
        this.credit = null;
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.CloseCredits", "screen_name"));
        if (this.table == null) {
            this.createTable();
        }
        object.addUIObject((UIObject)this.searchPanel);
        object.addUIObject((UIObject)this.table);
        object.addUIObject((UIObject)this.fbShow);
        this.getProcess().setAttribute("Table", (Object)this.table);
        return object;
    }

    private void createTable() throws Exception {
        CreditQuery query = new CreditQuery(this.dbData, this.companyId, true, true);
        this.table = new ODBTable(Credit.class, (ODBQuery)query, new String[]{"id"}, 12);
        this.table.setName(PAGE);
        this.table.setCounter((ODBCounter)query);
        this.table.setColumnNames(NAMES);
        this.table.setColumnLabels(LABELS);
        this.table.setColumnSizes(SIZES);
        if (CreditBO.isIdNumeric(this.company)) {
            CloseCreditAdapter.TYPES[0] = "number";
            CloseCreditAdapter.TRANSFORMERS[0] = this.numericIdTransformer;
        }
        this.table.setColumnTypes(TYPES);
        this.table.setDisplayTransformers(TRANSFORMERS);
        this.table.setColumnNoWraps(COLUMNNOWRAPS);
        this.table.setColumnSortable(SORTABLE);
        this.table.setSortable(true);
        this.table.orderByColumn("id");
        this.searchPanel = this.table.createSearch(NAMES, LABELS);
        Action filterAction = this.table.createFilterAction(NAMES, LABELS, 3);
        this.searchPanel.addAction(filterAction);
        this.searchPanel.setCSSClass("headerPanel");
        TableHelper.createMenu((Table)this.table, (Action[])this.headerActions, (Action[])this.rowActions);
        this.table.reload();
        TableHelper.setHeaderTooltips((CommonTable)this.table, (String[])TOOLTIPS);
    }

    public DataObject updateTable(DataObject object) throws Exception {
        if (this.credit != null) {
            this.table.setPointer("id", (Object)this.credit.getId(), true);
            this.table.reload();
        }
        return this.show(object);
    }

    public DataObject refresh(DataObject object) throws Exception {
        this.table = null;
        return this.show(object);
    }

    public DataObject allocateEntry(DataObject object) throws Exception {
        this.credit = (Credit)this.getProcess().getAttribute(CREDIT);
        if (this.credit == null) {
            this.credit = (Credit)TableHelper.getSelectedItem((DataObject)object);
            if (this.credit.getInitialProjectCostsReferenceCounter() != 0 && this.credit.getInitialProjectCostAmount().doubleValue() != 0.0) {
                object.addUIObject((UIObject)new Message("credit_has_initial_project_costs", "error"));
                return object;
            }
            Collection balances = CreditBalanceBO.retrieveCreditBalances(this.credit);
            if (balances != null && !balances.isEmpty()) {
                for (CreditBalance balance : balances) {
                    this.creditBalanceBP.handleBalanceIsDirty(balance);
                }
            }
            this.getProcess().setAttribute(CREDIT, (Object)this.credit);
            this.spaceLabel.setHidden(true);
            this.interestMessageLabel.setHidden(true);
            this.refreshAmountsTable();
            this.crf.setValue(this.credit.getId());
            this.crf.setDescription(this.credit.getDescription());
            this.creditAmount.setValue(TotalEstimationTransactionBO.getTotalCreditAmount(this.credit));
            this.balanceAmount.setValue(CreditBalanceBO.getBalanceAmounts(this.credit)[0]);
            this.deprAmount.setValue(this.credit.getManualDepreciationAmount());
            if (this.deprAmount.getBigDecimal().doubleValue() == 0.0) {
                this.deprAmount.setHidden(true);
                this.unAllocatedDeprValue.setHidden(true);
            }
        }
        if (this.balanceAmount.getBigDecimal().doubleValue() == 0.0) {
            this.clearScreen(true, false, true);
            object.addUIObject((UIObject)new Header("Title.CloseCredit", "screen_name"));
            object.addUIObject((UIObject)this.header);
            this.unAllocatedValue.setValue(this.balanceAmount.getBigDecimal());
            this.closingPeriod = new BookYearPeriodGrid("Label.Period", false);
            this.closingPeriod.setValues("" + this.credit.getEndYear(), "" + this.numberOfPeriods);
            FieldGroup fg = new FieldGroup();
            fg.forceBorder(true);
            fg.add((Field)this.unAllocatedValue);
            fg.add((ESPGridLayout)this.closingPeriod);
            object.addUIObject((UIObject)fg);
            FloatBar fb = new FloatBar();
            fb.addAction(new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("closeZeroBalanceCredit"));
            fb.addAction(this.cancel);
            object.addUIObject((UIObject)fb);
            return object;
        }
        this.finYearPeriod.setValues("" + this.credit.getEndYear(), "" + this.numberOfPeriods);
        this.finYearPeriod.getBookYear().setMinValue((long)this.credit.getStartYear(), true);
        this.facYearPeriod.setValues("" + (this.credit.getEndYear() + 1), "1");
        this.validateForInterestNotBookedYet();
        if (this.credit.getIsResultAccountItem()) {
            this.allocateTo.setSelectedOptionValue(LEDGERCORRECTION);
        } else {
            this.allocateTo.setSelectedOptionValue(NEW_ASSET);
        }
        return this.allocate(object);
    }

    private void validateForInterestNotBookedYet() throws Exception {
        String message;
        this.businessProcess = new CreditDepreciationBP(this.company, this.numberOfPeriods);
        int yearTo = this.credit.getClosingYear();
        int periodTo = this.credit.getClosingPeriod();
        if (yearTo == 0) {
            if (this.credit.getIsResultAccountItem()) {
                yearTo = this.finYearPeriod.getBookYear().getIntValue();
                periodTo = this.finYearPeriod.getPeriod().getIntValue();
            } else {
                int[] yearPeriod = PeriodHelper.getPreviousPeriod(this.numberOfPeriods, this.facYearPeriod.getBookYear().getIntValue(), this.facYearPeriod.getPeriod().getIntValue());
                yearTo = yearPeriod[0];
                periodTo = yearPeriod[1];
            }
        }
        if (yearTo > this.credit.getEndYear()) {
            yearTo = this.credit.getEndYear();
            periodTo = this.numberOfPeriods;
        }
        if ((message = this.businessProcess.depreciate(this.credit, yearTo, periodTo)) == null) {
            Collection values = this.businessProcess.getAllCalculationValues();
            if (values == null || values.isEmpty()) {
                return;
            }
            Iterator vi = values.iterator();
            BigDecimal totalInterestAmount = new BigDecimal("0.00");
            while (vi.hasNext()) {
                CalculationValue value = (CalculationValue)vi.next();
                totalInterestAmount = totalInterestAmount.add(value.getInterestAmount());
            }
            if (totalInterestAmount.doubleValue() != 0.0) {
                this.spaceLabel.setHidden(false);
                this.interestMessageLabel.setLabel(this.spaces + this.spaces + this.spaces + "Let op : nog niet geboekte periodieke rente ad " + totalInterestAmount + " !!!");
                this.interestMessageLabel.setHidden(false);
            }
        }
    }

    public DataObject allocate(DataObject object) throws Exception {
        this.unAllocatedValue.setValue(this.balanceAmount.getBigDecimal().subtract(this.credit.getAllocatedValue()));
        this.unAllocatedDeprValue.setValue(this.deprAmount.getBigDecimal().subtract(this.credit.getAllocatedDepreciationValue()));
        if (this.balanceAmount.getBigDecimal().doubleValue() != 0.0 && this.unAllocatedValue.getBigDecimal().doubleValue() == 0.0 && this.unAllocatedDeprValue.getBigDecimal().doubleValue() == 0.0) {
            object.addUIObject((UIObject)new RedirectAction(this.getProcessAdapterPageName(CloseCreditTransactionAdapter.PAGE), "show", this.getProcess().getProcessId()));
            return object;
        }
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.CloseCredit", "screen_name"));
        object.addUIObject((UIObject)this.header);
        object.addUIObject((UIObject)this.fgAllocateTo);
        this.facYearPeriod.setHidden(false);
        this.facYearPeriod.setReadonly(false);
        this.facYearPeriod.setMandatory(true);
        this.finYearPeriod.setReadonly(false);
        this.finYearPeriod.setMandatory(true);
        this.fbAllocate = new FloatBar();
        String selected = this.allocateTo.getSelectedOptionValue();
        if (selected.equals(NEW_ASSET)) {
            this.createNewAssetPanel(object);
        } else if (selected.equals(INVESTMENT)) {
            this.createInvestmentPanel(object);
        } else if (selected.equals(LEDGERCORRECTION)) {
            this.facYearPeriod.setHidden(true);
            this.facYearPeriod.setMandatory(false);
            this.finYearPeriod.setMandatory(true);
            this.createCorrectionPanel(object);
        }
        if (this.credit.getClosingYear() != 0) {
            this.facYearPeriod.setValues("" + this.credit.getClosingYear(), "" + this.credit.getClosingPeriod());
            this.finYearPeriod.setValues("" + this.credit.getFinClosingYear(), "" + this.credit.getFinClosingPeriod());
            this.facYearPeriod.setReadonly(true);
            this.finYearPeriod.setReadonly(true);
        }
        this.fbAllocate.addAction(this.cancel);
        object.addUIObject((UIObject)this.fbAllocate);
        return object;
    }

    protected void refreshAmountsTable() throws Exception {
        ODBTable oldTable = this.table0;
        this.createAmountsTable();
        if (oldTable == null) {
            this.header.addUIObject((UIObject)this.table0);
        } else {
            this.header.replaceUIObject((UIObject)oldTable, (UIObject)this.table0);
        }
    }

    protected void createAmountsTable() throws Exception {
        CreditQuery query = new CreditQuery(this.dbData, this.company.getId(), this.credit.getId());
        this.table0 = new ODBTable(Credit.class, (ODBQuery)query, new String[]{"id"}, 12);
        this.table0.setName("CreditPanels.CreditHeader");
        this.table0.setCounter((ODBCounter)query);
        this.table0.setColumnNames(NAMES0);
        this.table0.setColumnLabels(this.LABELS0);
        this.table0.setColumnSizes(SIZES0);
        this.table0.setDisplayTransformers(TRANSFORMERS0);
        this.table0.reload();
    }

    public DataObject closeZeroBalanceCredit(DataObject object) throws Exception {
        this.credit = (Credit)this.getProcess().getAttribute(CREDIT);
        String message = CreditBP.closeZeroBalanceCredit(this.credit, this.closingPeriod.getBookYear().getIntValue(), this.closingPeriod.getPeriod().getIntValue());
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        return this.refresh(object);
    }

    public void createInvestmentPanel(DataObject object) throws Exception {
        this.assetField.setValue();
        this.assetField.setDescription("");
        this.description.setValue();
        BigDecimal unAllocValue = this.unAllocatedValue.getBigDecimal();
        this.transactionValue.setValue(unAllocValue);
        if (unAllocValue.doubleValue() < 0.0) {
            this.transactionValue.setMaxValue(0.0, false);
            this.transactionValue.setMinValue(unAllocValue, true);
        } else {
            this.transactionValue.setMinValue(0.0, false);
            this.transactionValue.setMaxValue(unAllocValue, true);
        }
        object.addUIObject((UIObject)this.investmentPanel);
        Action action = new Action("Button.OK", null, null, this.getProcessAdapterPageName(PAGE), "createInvestment");
        action.setDefault(true);
        action.setValidationEnabled(true);
        this.fbAllocate.addAction(action);
    }

    public DataObject createInvestment(DataObject object) throws Exception {
        this.investmentPanel.removeInvalidTags();
        boolean error = false;
        String[] messages = null;
        Asset asset = this.assetField.getAsset();
        String message = this.investmentBP.hasNotPostedTransactions(asset);
        if (message != null) {
            error = true;
            object.addUIObject((UIObject)new Message(message, "error"));
        }
        if (asset.getStartUseYear() != this.facYearPeriod.getBookYear().getIntValue() || asset.getStartUsePeriod() != this.facYearPeriod.getPeriod().getIntValue()) {
            error = true;
            String s = " (" + asset.getStartUseYear() + "-" + asset.getStartUsePeriod() + ") ";
            object.addUIObject((UIObject)new Message("Activeringsperiode van krediet en activum " + s + "moeten overeenkomen", "error"));
        }
        if ((messages = this.investmentBP.validateFACYearAndPeriod(asset, this.facYearPeriod.getBookYear().getIntValue(), this.facYearPeriod.getPeriod().getIntValue())) != null) {
            error = true;
            this.addErrors(object, messages);
            this.facYearPeriod.setInvalidTag();
        }
        if ((messages = this.investmentBP.validateFINYearAndPeriod(this.finYearPeriod.getBookYear().getIntValue(), this.finYearPeriod.getPeriod().getIntValue(), Integer.parseInt(this.bookYearMin), Integer.parseInt(this.bookYearMax))) != null) {
            error = true;
            this.addErrors(object, messages);
            this.finYearPeriod.setInvalidTag();
        }
        if ((messages = this.investmentBP.validateInvestmentValue(this.transactionValue.getBigDecimal())) != null) {
            error = true;
            this.addErrors(object, messages);
            this.transactionValue.setInvalidTag();
        }
        if (error) {
            return object;
        }
        message = this.investmentBP.createInvestment(asset, false, this.facYearPeriod.getBookYear().getIntValue(), this.facYearPeriod.getPeriod().getIntValue(), this.finYearPeriod.getBookYear().getIntValue(), this.finYearPeriod.getPeriod().getIntValue(), this.description.getValue(), this.transactionValue.getBigDecimal(), null, false, this.loginHelper.getUser(), false, this.credit, 0, -1);
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        this.setCreditClosingYearPeriodData();
        this.table.setPointer("id", (Object)this.credit.getId(), true);
        this.table.reload();
        return this.allocate(object);
    }

    public void createCorrectionPanel(DataObject object) throws Exception {
        this.description.setValue();
        BigDecimal unAllocated = this.unAllocatedValue.getBigDecimal();
        this.transactionValue.setValue(unAllocated);
        if (unAllocated.doubleValue() < 0.0) {
            this.transactionValue.setMaxValue(0.0, false);
            this.transactionValue.setMinValue(unAllocated, true);
        } else {
            this.transactionValue.setMinValue(0.0, false);
            this.transactionValue.setMaxValue(unAllocated, true);
        }
        this.daybook.setValue(((CompanyAccountingPrincipleDefault)CompanyAccountingPrincipleDefaultBO.get(this.dbData, this.companyId, 1)[0]).getDaybookId1());
        this.daybook.setReadonly(false);
        for (int i = 0; i < this.financialDimension.length; ++i) {
            if (this.financialDimension[i] == null) continue;
            this.financialDimension[i].setReadonly(false);
        }
        object.addUIObject((UIObject)this.correctionPanel);
        Action action = new Action("Button.OK", null, null, this.getProcessAdapterPageName(PAGE), "createCorrection");
        action.setDefault(true);
        action.setValidationEnabled(true);
        this.fbAllocate.addAction(action);
    }

    public DataObject createCorrection(DataObject object) throws Exception {
        String message;
        this.correctionPanel.removeInvalidTags();
        boolean error = false;
        String[] messages = null;
        messages = this.ledgerCorrectionBP.validateFINYearAndPeriod(this.finYearPeriod.getBookYear().getIntValue(), this.finYearPeriod.getPeriod().getIntValue(), Integer.parseInt(this.bookYearMin), Integer.parseInt(this.bookYearMax));
        if (messages != null) {
            error = true;
            this.addErrors(object, messages);
            this.finYearPeriod.setInvalidTag();
        }
        String mainAccount = this.financialDimension[0].getFormattedId();
        boolean isFMS = this.env.getOperationArea().trim().length() != 0;
        messages = this.ledgerCorrectionBP.validateFACMainAccount(this.loginHelper, isFMS, this.finYearPeriod.getBookYear().getIntValue(), mainAccount);
        if (messages != null) {
            error = true;
            this.addErrors(object, messages);
            this.financialDimension[0].setInvalidTag();
        }
        if (error) {
            return object;
        }
        String sDaybook = this.daybook.getFormattedId();
        String finDimId1 = "";
        if (this.financialDimension[1] != null) {
            finDimId1 = this.financialDimension[1].getFormattedId();
        }
        String finDimId2 = "";
        if (this.financialDimension[2] != null) {
            finDimId2 = this.financialDimension[2].getFormattedId();
        }
        String finDimId3 = "";
        if (this.financialDimension[3] != null) {
            finDimId3 = this.financialDimension[3].getFormattedId();
        }
        String finDimId4 = "";
        if (this.financialDimension[4] != null) {
            finDimId4 = this.financialDimension[4].getFormattedId();
        }
        String finDimId5 = "";
        if (this.financialDimension[5] != null) {
            finDimId5 = this.financialDimension[5].getFormattedId();
        }
        if ((message = this.ledgerCorrectionBP.createCorrection(this.finYearPeriod.getBookYear().getIntValue(), this.finYearPeriod.getPeriod().getIntValue(), this.description.getValue(), this.transactionValue.getBigDecimal(), sDaybook, mainAccount, finDimId1, finDimId2, finDimId3, finDimId4, finDimId5, null, this.credit, this.loginHelper.getUser())) != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        this.setCreditClosingYearPeriodData();
        return this.allocate(object);
    }

    public DataObject createNewAssetPanel(DataObject object) throws Exception {
        this.maFieldGroup = null;
        this.panels = new AssetPanels(this.loginHelper, this.dbData, this.env, this.company, this.bookYearMin, this.bookYearMax, this.numberOfPeriods, this.governmentActivated, null, false, false, true, null, true, this.credit, null);
        this.getProcess().setAttribute("ParentAssetAdapterReturnPage", (Object)this.getProcessAdapterPageName(PAGE));
        this.getProcess().setAttribute("ParentAssetAdapterReturnMethod", (Object)"handleNewParentAsset");
        this.panels.fbParent.addAction(this.panels.getCreateParentAssetAction().setAdapter(this.getProcessAdapterPageName(ParentAssetAdapter.PAGE)).setMethod("initCreateForm"));
        this.panels.firstPanel.setLabel("Label.Asset");
        this.panels.addAcquisitionDataToFirstPanel("Label.AcquisitionValue", "Label.AcquisitionDate", "Label.NegativeInvestment", null);
        this.panels.acquisitionValue.setValue(this.unAllocatedValue.getBigDecimal());
        this.panels.acquisitionDate.setValue(Calendar.getInstance().getTime());
        this.panels.description.setValue(this.credit.getDescription());
        if (this.credit.getProFormaTypeId() != null && this.credit.getProFormaTypeId().trim().length() > 0) {
            this.panels.type.setValue(this.credit.getProFormaTypeId());
            this.panels.asrf.setValue(this.credit.getProFormaTypeId());
            this.panels.activationSchemeTransaction = TotalEstimationTransactionBO.getBaseActivationSchemeTransaction(this.credit);
            this.panels.asrf.setDescription(this.panels.activationSchemeTransaction.getDescription());
        }
        this.panels.id.setReadonly(this.panels.idReadOnly);
        this.panels.id.setLabel("");
        this.panels.description.setReadonly(false);
        this.panels.description.setLabel("");
        if (!this.panels.id.getReadonly()) {
            this.panels.id.requestFocus(true);
        } else {
            this.panels.description.requestFocus(true);
        }
        object.addUIObject((UIObject)this.panels.firstPanel);
        Action action = new Action("Button.Next", null, null, this.getProcessAdapterPageName(PAGE), "createDimensionsForm");
        action.setDefault(true);
        action.setValidationEnabled(true);
        this.fbAllocate.addAction(action);
        return object;
    }

    public DataObject createNewAssetPanelContinued(DataObject object) throws Exception {
        this.panels.id.setReadonly(this.panels.idReadOnly);
        this.panels.id.setLabel("");
        this.panels.description.setReadonly(false);
        this.panels.description.setLabel("");
        if (!this.panels.id.getReadonly()) {
            this.panels.id.requestFocus(true);
        } else {
            this.panels.description.requestFocus(true);
        }
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.CloseCredit", "screen_name"));
        object.addUIObject((UIObject)this.header);
        object.addUIObject((UIObject)this.fgAllocateTo);
        object.addUIObject((UIObject)this.panels.firstPanel);
        object.addUIObject((UIObject)this.fbAllocate);
        return object;
    }

    public DataObject handleNewParentAsset(DataObject object) throws Exception {
        Object newParentAssetId = this.getProcess().getAttribute("NewParentId");
        if (newParentAssetId != null) {
            this.panels.setNewParent(newParentAssetId.toString(), this.getProcess().getAttribute("NewParentDescription").toString());
            this.getProcess().removeAttribute("NewParentId");
            this.getProcess().removeAttribute("NewParentDescription");
        }
        return object;
    }

    public DataObject createDimensionsForm(DataObject object) throws Exception {
        if (!this.panels.id.isHidden()) {
            Object[] result;
            if ("number".equals(this.panels.id.getType())) {
                try {
                    if (Integer.parseInt(this.panels.id.getValue()) <= 0) {
                        this.panels.id.setInvalidTag();
                        object.addUIObject((UIObject)new Message("value_must_be_positive", "error"));
                        return object;
                    }
                }
                catch (NumberFormatException nfe) {
                    this.panels.id.setInvalidTag();
                    object.addUIObject((UIObject)new Message("not_a_number", "error"));
                    return object;
                }
            }
            if ((result = AssetBO.get(this.company, this.panels.id.getValue().trim(), false))[0] != null) {
                this.panels.id.setInvalidTag();
                object.addUIObject((UIObject)new Message("duplicate_key", "error"));
                return object;
            }
        }
        this.panels.investmentYP.setValues(this.facYearPeriod.getBookYear().getValue(), this.facYearPeriod.getPeriod().getValue());
        this.panels.bookYP.setValues(this.finYearPeriod.getBookYear().getValue(), this.finYearPeriod.getPeriod().getValue());
        String message = this.panels.validateCommonForm();
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        this.panels.id.setReadonly(true);
        this.panels.id.setLabel("Label.Id");
        this.panels.id.setHelpId("Label.AssetId");
        this.panels.description.setReadonly(true);
        this.panels.description.setLabel("Label.Description");
        this.panels.initializeType();
        this.panels.copyStartUsePeriod();
        return this.createDimensionsFormContinued(object);
    }

    public DataObject createDimensionsFormContinued(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.CloseCredit", "screen_name"));
        object.addUIObject((UIObject)this.header);
        object.addUIObject((UIObject)this.panels.headerPanel);
        object.addUIObject((UIObject)this.panels.finDimensionPanel);
        object.addUIObject((UIObject)this.panels.facDimensionPanel);
        FloatBar fb = new FloatBar();
        Action action = new Action("Button.Previous").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createNewAssetPanelContinued");
        fb.addAction(action);
        action = new Action("Button.Next").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createAccountingPrincipleForm");
        action.setDefault(true);
        action.setValidationEnabled(true);
        fb.addAction(action);
        fb.addAction(this.cancel);
        object.addUIObject((UIObject)fb);
        return object;
    }

    public DataObject createAsset(DataObject object) throws Exception {
        Object[] result;
        String message = null;
        this.panels.apTabCount = 0;
        while (this.panels.apTabCount <= this.panels.apTabCountMax) {
            try {
                message = this.panels.validateAccountingPrincipleForm(this.panels.apTabCount);
            }
            catch (UserMessageCollection umc) {
                Throwable[] throwables = umc.getThrowables();
                for (int i = 0; i < throwables.length; ++i) {
                    object.addUIObject((UIObject)new Message(throwables[i].getMessage(), "error"));
                }
                return object;
            }
            if (message != null) {
                object.addUIObject((UIObject)new Message(message, "error"));
                return object;
            }
            ++this.panels.apTabCount;
        }
        if (this.company.getUseValuationMainAccount()) {
            this.panels.mainAccountIds = this.genericGovernmentBP.getFormattedMainAccountIds();
        }
        if ((message = (String)(result = new AssetBP(this.panels).create(null, this.credit, false, this.finYearPeriod.getBookYear().getIntValue()))[1]) != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        this.setCreditClosingYearPeriodData();
        return this.allocate(object);
    }

    public DataObject createAccountingPrincipleFormNext(DataObject object) throws Exception {
        String message = this.panels.validateAccountingPrincipleForm(this.panels.apTabCount);
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        ++this.panels.apTabCount;
        return this.createAccountingPrincipleForm(object);
    }

    public DataObject createAccountingPrincipleFormPrevious(DataObject object) throws Exception {
        --this.panels.apTabCount;
        return this.createAccountingPrincipleForm(object);
    }

    public DataObject createAccountingPrincipleForm(DataObject object) throws Exception {
        this.panels.id.setReadonly(true);
        this.panels.description.setReadonly(true);
        this.panels.copyValuesForCreditClosing(this.unAllocatedDeprValue.getBigDecimal());
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.CloseCredit", "screen_name"));
        object.addUIObject((UIObject)this.header);
        object.addUIObject((UIObject)this.panels.headerPanel);
        object.addUIObject((UIObject)this.panels.apPanels[this.panels.apTabCount]);
        FloatBar fbCreateAP = new FloatBar();
        Action action = this.panels.apTabCount == 0 ? new Action("Button.Previous").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createDimensionsFormContinued") : new Action("Button.Previous").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createAccountingPrincipleFormPrevious");
        fbCreateAP.addAction(action);
        action = this.panels.apTabCount == this.panels.apTabCountMax ? (this.company.getUseValuationMainAccount() ? new Action("Button.Next").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createMainAccountForm") : new Action("Button.Complete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(CREATEASSET)) : new Action("Button.Next").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createAccountingPrincipleFormNext");
        action.setDefault(true);
        action.setValidationEnabled(true);
        fbCreateAP.addAction(action);
        fbCreateAP.addAction(this.cancel);
        object.addUIObject((UIObject)fbCreateAP);
        return object;
    }

    public DataObject createMainAccountForm(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.CloseCredit", "screen_name"));
        object.addUIObject((UIObject)this.header);
        object.addUIObject((UIObject)this.panels.headerPanel);
        if (this.maFieldGroup == null) {
            this.maFieldGroup = this.genericGovernmentBP.getMainAccountFieldGroupForCreditClosing(this.loginHelper, this.panels.assetType, this.finYearPeriod.getBookYear().getIntValue(), this.finYearPeriod.getPeriod().getIntValue(), this.credit);
        }
        object.addUIObject((UIObject)this.maFieldGroup);
        FloatBar fb = new FloatBar();
        fb.addAction(new Action("Button.Previous").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createAccountingPrincipleForm"));
        Action action = new Action("Button.Complete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(CREATEASSET);
        action.setDefault(true);
        action.setValidationEnabled(true);
        fb.addAction(action);
        fb.addAction(this.cancel);
        object.addUIObject((UIObject)fb);
        return object;
    }

    public DataObject confirmEntry(DataObject object) throws Exception {
        this.credit = (Credit)this.getProcess().getAttribute(CREDIT);
        String message = CreditBP.confirm(this.credit, this.numberOfPeriods);
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        return this.refresh(object);
    }

    private void addErrors(DataObject object, String[] errors) throws Exception {
        for (int i = 0; i < errors.length; ++i) {
            if (errors[i] == null || errors[i].trim().length() <= 0) continue;
            object.addUIObject((UIObject)new Message(errors[i], "error"));
        }
    }

    private void setCreditClosingYearPeriodData() throws Exception {
        if (this.credit.getClosingYear() == 0) {
            this.credit.setClosingYear(this.facYearPeriod.getBookYear().getIntValue());
            this.credit.setClosingPeriod(this.facYearPeriod.getPeriod().getIntValue());
            this.credit.setFinClosingYear(this.finYearPeriod.getBookYear().getIntValue());
            this.credit.setFinClosingPeriod(this.finYearPeriod.getPeriod().getIntValue());
        }
    }

    private class CreditAllocatedValueImageTransformer
    implements Transformer {
        private static final long serialVersionUID = -5208191284722424865L;

        private CreditAllocatedValueImageTransformer() {
        }

        public Object transform(Object object) {
            BigDecimal allocatedValue = (BigDecimal)object;
            if (allocatedValue.doubleValue() == 0.0) {
                return "";
            }
            return new Image(TranslationHelperImpl.getInstance().translate("Label.AlreadyAllocated") + " : " + allocatedValue, "shape_square_error.png").setHeight("16").setAlignment("center");
        }
    }

    private class AllocateToChangeAction
    extends Action {
        private static final long serialVersionUID = 1L;

        AllocateToChangeAction(String page) {
            super(null, null, null, page, CloseCreditAdapter.ALLOCATE);
        }

        public boolean execute(DataObject dataObject) throws Exception {
            return false;
        }
    }
}

