/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.gov.adapters;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.helpers.TableHelper;
import nl.ibs.esp.uiobjects.AbstractTable;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CollectionTable;
import nl.ibs.esp.uiobjects.ComboBox;
import nl.ibs.esp.uiobjects.CommonTable;
import nl.ibs.esp.uiobjects.ContextAction;
import nl.ibs.esp.uiobjects.ContextMenu;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.HeaderPanel;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.ODBQuery;
import nl.ibs.esp.uiobjects.ODBTable;
import nl.ibs.esp.uiobjects.OutputField;
import nl.ibs.esp.uiobjects.Panel;
import nl.ibs.esp.uiobjects.TableRow;
import nl.ibs.esp.uiobjects.TableRowMethod;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.util.ODBCounter;
import nl.ibs.esp.util.Transformer;
import nl.ibs.fac.EnumHelper;
import nl.ibs.fac.MainTransactionTypeEnum;
import nl.ibs.fac.adapters.AssetOriginatedImageTransformer;
import nl.ibs.fac.adapters.DecimalTransformer;
import nl.ibs.fac.adapters.ExtendedTransactionAdapter;
import nl.ibs.fac.adapters.FACDecimalField;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.MainTransactionTypeTransformer;
import nl.ibs.fac.adapters.NumericIdTransformer;
import nl.ibs.fac.adapters.ZeroBigDecimalToBlankTransformer;
import nl.ibs.fac.adapters.ZeroIntegerToBlankTransformer;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Credit;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.gov.adapters.BBVCategoryImageTransformer;
import nl.ibs.fac.gov.adapters.CloseCreditAdapter;
import nl.ibs.fac.gov.adapters.CreditReferenceField;
import nl.ibs.fac.gov.boadapters.CreditBalanceBO;
import nl.ibs.fac.gov.boadapters.TotalEstimationTransactionBO;
import nl.ibs.fac.queries.TransactionQuery;

public class CloseCreditTransactionAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = 1314187117307114300L;
    public static final String PAGE = CloseCreditTransactionAdapter.class.getName();
    public static final String TABLENAME = "CCTAdapter";
    public static final String SHOWINTERNAL = "showInternal";
    private Company company;
    private NumericIdTransformer numericIdTransformer = new NumericIdTransformer();
    private Credit credit;
    private Panel header;
    private CreditReferenceField crf;
    private FACDecimalField creditAmount = new FACDecimalField("Label.CreditAmount", 15, 2);
    private FACDecimalField balanceAmount = new FACDecimalField("Label.BalanceAmount", 15, 2);
    private Field unAllocatedValue = new Field("Label.ValueToAssign", "decimal", null, "", 15);
    private ODBTable table = null;
    private static final String[] NAMES = new String[]{"mainTransactionType", "originalIFTAmount", "bookYear", "period", "assetId", "transactionOrAssetDescriptionForCreditClosing", "assetOriginatedByCredit", "bookingIndicator", "valueForAmount1", "amount2"};
    private static final String[] LABELS = new String[]{"Label.TransactionType.short", "Label.Amount", "Label.Year", "Label.Period.short", "Label.Asset", "Label.Description", "Label.NewAsset", "Label.BookingIndicator", "Label.Acquisition", "Label.Depreciation"};
    private static final String[] TOOLTIPS = new String[]{"Label.NewAsset", "Label.BookingIndicator"};
    private static final short[] SIZES = new short[]{120, 100, 50, 30, 80, 175, 20, 20, 100, 100};
    private static final String[] TYPES = new String[]{"text", null, null, null, null, null, null, null, null};
    private static final DecimalTransformer DECIMALTRANSFORMER = new DecimalTransformer();
    private static final ZeroIntegerToBlankTransformer BLANKTRANSFORMER = new ZeroIntegerToBlankTransformer();
    private static final ZeroBigDecimalToBlankTransformer BD_BLANKTRANSFORMER = new ZeroBigDecimalToBlankTransformer();
    private static final Transformer[] TRANSFORMERS = new Transformer[]{new MainTransactionTypeTransformer(), DECIMALTRANSFORMER, BLANKTRANSFORMER, BLANKTRANSFORMER, null, null, new AssetOriginatedImageTransformer(), new BBVCategoryImageTransformer(), BD_BLANKTRANSFORMER, BD_BLANKTRANSFORMER};
    private static final boolean[] COLUMNNOWRAPS = new boolean[]{true, true, true, true, true, true, true, true, true, true};
    private Map<String, ComboBox> inputComponents = new HashMap<String, ComboBox>();
    private TransactionTableRowMethod transactionTableRowMethod = new TransactionTableRowMethod();
    private static final String REFRESH = "refresh";
    private FloatBar fbShow1 = new FloatBar();
    private FloatBar fbShow2 = new FloatBar();
    private Action allocate;
    private Action confirm;
    private Action[] rowActions;
    private Action[] headerActions;
    private FloatBar fbDelete = new FloatBar();
    private ArrayList<Object> deleteList;

    public CloseCreditTransactionAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.initialize(object);
    }

    private void initialize(DataObject object) throws Exception {
        this.company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        Action back = new Action("Button.Back").setAdapter(this.getProcessAdapterPageName(CloseCreditAdapter.PAGE)).setMethod("updateTable");
        Action refresh = new Action("Button.Refresh").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(REFRESH);
        this.fbShow2.addAction(back);
        this.fbShow2.addAction(refresh);
        Action confirmDelete = null;
        this.allocate = new Action("Button.Assign").setAdapter(this.getProcessAdapterPageName(CloseCreditAdapter.PAGE)).setMethod("allocateEntry");
        this.confirm = new Action("Button.Confirm").setAdapter(this.getProcessAdapterPageName(CloseCreditAdapter.PAGE)).setMethod("confirmEntry");
        confirmDelete = new Action("Button.Delete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("confirmDelete");
        this.fbShow1.addAction(this.allocate);
        this.fbShow1.addAction(this.confirm);
        this.fbShow2.addAction(confirmDelete);
        this.fbShow2.addAction(this.finish);
        this.headerActions = new Action[]{refresh, this.allocate, this.confirm};
        Action details = new Action("Button.Details").setAdapter(this.getProcessAdapterPageName(ExtendedTransactionAdapter.PAGE)).setMethod("show");
        this.rowActions = new Action[]{details, confirmDelete};
        ComboBox mtt = EnumHelper.createComboBox("Label.MainTransactionType", MainTransactionTypeEnum.getCollection(), true);
        mtt.setWidth("150");
        this.inputComponents.put("mainTransactionType", mtt);
        this.fbDelete.addAction(new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("delete"));
        this.fbDelete.addAction(new Action("Button.Back").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(SHOWINTERNAL));
        this.fbDelete.addAction(this.finish);
        this.header = new HeaderPanel();
        this.crf = new CreditReferenceField(this.company, false);
        this.crf.setLabel("Label.Credit");
        this.crf.setReadonly(true);
        this.header.addUIObject((UIObject)this.crf);
        this.creditAmount.setReadonly(true);
        this.header.addUIObject((UIObject)this.creditAmount);
        this.balanceAmount.setReadonly(true);
        this.header.addUIObject((UIObject)this.balanceAmount);
        this.unAllocatedValue.setReadonly(true);
        this.header.addUIObject((UIObject)this.unAllocatedValue);
    }

    public DataObject show(DataObject object) throws Exception {
        this.credit = (Credit)this.getProcess().getAttribute("Credit");
        if (this.credit == null) {
            this.credit = (Credit)TableHelper.getSelectedItem((DataObject)object);
            this.getProcess().setAttribute("Credit", (Object)this.credit);
        }
        return this.refresh(object);
    }

    public DataObject showInternal(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.CloseCredit_Transactions", "screen_name"));
        object.addUIObject((UIObject)this.header);
        object.addUIObject((UIObject)this.fbShow1);
        if (this.table == null) {
            this.createTable();
        } else if (this.table.isSelectable()) {
            this.table.undoSelections();
        }
        object.addUIObject((UIObject)this.table);
        object.addUIObject((UIObject)this.fbShow2);
        return object;
    }

    private void createTable() throws Exception {
        TransactionQuery query = new TransactionQuery(this.dbData, this.credit, true);
        this.table = new ODBTable(Transaction.class, (ODBQuery)query, new String[]{"documentNr"}, 12);
        this.table.setName(TABLENAME);
        this.table.setCounter((ODBCounter)query);
        this.table.setColumnNames(NAMES);
        this.table.setColumnLabels(LABELS);
        this.table.setColumnSizes(SIZES);
        this.table.setColumnTypes(TYPES);
        this.table.setDisplayTransformers(TRANSFORMERS);
        this.table.setColumnNoWraps(COLUMNNOWRAPS);
        this.table.setInputComponents(this.inputComponents);
        this.table.setSortable(true);
        this.table.setMultipleSelectable();
        TableHelper.createMenu((CommonTable)this.table, (Action[])this.headerActions, (Action[])this.rowActions, (TableRowMethod)this.transactionTableRowMethod);
        this.table.reload();
        TableHelper.setHeaderTooltips((CommonTable)this.table, (String[])TOOLTIPS);
    }

    public DataObject refresh(DataObject object) throws Exception {
        this.crf.setValue(this.credit.getId());
        this.crf.setDescription(this.credit.getDescription());
        this.creditAmount.setValue(TotalEstimationTransactionBO.getTotalCreditAmount(this.credit));
        this.balanceAmount.setValue(CreditBalanceBO.getBalanceAmounts(this.credit)[0]);
        this.unAllocatedValue.setValue((String)DECIMALTRANSFORMER.transform(this.balanceAmount.getBigDecimal().subtract(this.credit.getAllocatedValue())));
        if (this.balanceAmount.getBigDecimal().subtract(this.credit.getAllocatedValue()).doubleValue() != 0.0) {
            this.allocate.setDefault(true);
            this.allocate.setEnabled(true);
            this.confirm.setDefault(false);
            this.confirm.setEnabled(false);
        } else {
            this.allocate.setDefault(false);
            this.allocate.setEnabled(false);
            this.confirm.setDefault(true);
            this.confirm.setEnabled(true);
        }
        this.table = null;
        return this.showInternal(object);
    }

    public DataObject confirmDelete(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.DeleteTransactions", "screen_name"));
        object.addUIObject((UIObject)this.header);
        object.addUIObject((UIObject)this.createConfirmationTable(object));
        object.addUIObject((UIObject)this.fbDelete);
        return object;
    }

    private CollectionTable createConfirmationTable(DataObject object) throws Exception {
        Object[] transactions = TableHelper.getSelectedItems((AbstractTable)this.table, (DataObject)object);
        this.deleteList = new ArrayList(transactions.length);
        for (int i = 0; i < transactions.length; ++i) {
            this.deleteList.add(transactions[i]);
        }
        CollectionTable table = new CollectionTable(Transaction.class, this.deleteList, 12);
        table.setName(PAGE);
        table.setColumnNames(NAMES);
        table.setColumnLabels(LABELS);
        table.orderByColumn(NAMES[0]);
        table.setColumnSizes(SIZES);
        table.setColumnTypes(TYPES);
        table.setDisplayTransformers(TRANSFORMERS);
        table.setSortable(true);
        table.reload();
        TableHelper.setHeaderTooltips((CommonTable)table, (String[])TOOLTIPS);
        return table;
    }

    public DataObject delete(DataObject object) throws Exception {
        String message = null;
        Object[] transactions = this.deleteList.toArray();
        for (int i = 0; i < transactions.length; ++i) {
            Transaction transaction = (Transaction)transactions[i];
            message = TransactionBO.delete(transaction, null, this.credit);
            if (message == null) continue;
            object.addUIObject((UIObject)new Message(message, "error"));
        }
        if (message != null) {
            return object;
        }
        if (this.credit.getAllocatedValue().doubleValue() == 0.0) {
            this.credit.setClosingYear(0);
            this.credit.setClosingPeriod(0);
            this.credit.setFinClosingYear(0);
            this.credit.setFinClosingPeriod(0);
        }
        return this.refresh(object);
    }

    private class TransactionTableRowMethod
    implements TableRowMethod,
    Serializable {
        private static final long serialVersionUID = 8351780433747830979L;

        private TransactionTableRowMethod() {
        }

        public void postprocesCreatedRow(TableRow row, ContextAction[] rowActions) throws Exception {
            Transaction transaction = (Transaction)row.getObject();
            if (AssetBO.isIdNumeric(CloseCreditTransactionAdapter.this.company, "C".equals(transaction.getCora()))) {
                OutputField field = (OutputField)row.getUIOBjectByName(OutputField.class, "assetId");
                field.setValue((String)CloseCreditTransactionAdapter.this.numericIdTransformer.transform(transaction.getAssetId()));
                field.setType("number");
            }
            ContextMenu menu = new ContextMenu();
            for (int i = 0; i < rowActions.length; ++i) {
                if (rowActions[i] == null) continue;
                ContextAction rowAction = new ContextAction(rowActions[i].getName());
                rowAction.setAdapter(rowActions[i].getPageid());
                rowAction.setMethod(rowActions[i].getMethod());
                menu.addContextMenuItem(rowAction);
            }
            row.setContextMenu(menu);
        }
    }
}

