/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.gov.adapters;

import java.io.Serializable;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.helpers.TableHelper;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CommonTable;
import nl.ibs.esp.uiobjects.ContextAction;
import nl.ibs.esp.uiobjects.ContextMenu;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.ODBQuery;
import nl.ibs.esp.uiobjects.ODBTable;
import nl.ibs.esp.uiobjects.OutputField;
import nl.ibs.esp.uiobjects.Table;
import nl.ibs.esp.uiobjects.TableRow;
import nl.ibs.esp.uiobjects.TableRowMethod;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.Window;
import nl.ibs.esp.util.ODBCounter;
import nl.ibs.esp.util.Transformer;
import nl.ibs.fac.adapters.AssetOriginatedImageTransformer;
import nl.ibs.fac.adapters.DecimalTransformer;
import nl.ibs.fac.adapters.ExtendedTransactionAdapter;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.MainTransactionTypeTransformer;
import nl.ibs.fac.adapters.NumericIdTransformer;
import nl.ibs.fac.adapters.ZeroBigDecimalToBlankTransformer;
import nl.ibs.fac.adapters.ZeroIntegerToBlankTransformer;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Credit;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.gov.adapters.BBVCategoryImageTransformer;
import nl.ibs.fac.queries.TransactionQuery;

public class ClosedCreditTransactionInfoAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = 1314187117307114300L;
    public static final String PAGE = ClosedCreditTransactionInfoAdapter.class.getName();
    public static final String TABLENAME = "CCTInfoAdapter";
    private Company company;
    private NumericIdTransformer numericIdTransformer = new NumericIdTransformer();
    private Credit credit;
    private ODBTable table = null;
    private static final String[] NAMES = new String[]{"mainTransactionType", "originalIFTAmount", "bookYear", "period", "assetId", "transactionOrAssetDescriptionForCreditClosing", "assetOriginatedByCredit", "bookingIndicator", "valueForAmount1", "amount2"};
    private static final String[] LABELS = new String[]{"Label.TransactionType.short", "Label.Amount", "Label.Year", "Label.Period.short", "Label.Asset", "Label.Description", "Label.NewAsset", "Label.BookingIndicator", "Label.Acquisition", "Label.Depreciation"};
    private static final String[] TOOLTIPS = new String[]{"Label.NewAsset", "Label.BookingIndicator"};
    private static final short[] SIZES = new short[]{120, 100, 50, 30, 80, 175, 20, 20, 100, 100};
    private static final String[] TYPES = new String[]{"text", null, null, null, null, null, null, null, null};
    private static final DecimalTransformer DECIMALTRANSFORMER = new DecimalTransformer();
    private static final ZeroIntegerToBlankTransformer BLANKTRANSFORMER = new ZeroIntegerToBlankTransformer();
    private static final ZeroBigDecimalToBlankTransformer BD_BLANKTRANSFORMER = new ZeroBigDecimalToBlankTransformer();
    private static final Transformer[] TRANSFORMERS = new Transformer[]{new MainTransactionTypeTransformer(), DECIMALTRANSFORMER, BLANKTRANSFORMER, BLANKTRANSFORMER, null, null, new AssetOriginatedImageTransformer(), new BBVCategoryImageTransformer(), BD_BLANKTRANSFORMER, BD_BLANKTRANSFORMER};
    private static final boolean[] COLUMNNOWRAPS = new boolean[]{true, true, true, true, true, true, true, true, true, true};
    private TransactionTableRowMethod transactionTableRowMethod = new TransactionTableRowMethod();
    private Action[] rowActions;

    public ClosedCreditTransactionInfoAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.initialize(object);
    }

    private void initialize(DataObject object) throws Exception {
        this.company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        Action details = new Action("Button.Details").setAdapter(this.getProcessAdapterPageName(ExtendedTransactionAdapter.PAGE)).setMethod("show");
        this.rowActions = new Action[]{details};
    }

    public DataObject show(DataObject object) throws Exception {
        this.credit = (Credit)TableHelper.getSelectedItem((DataObject)object);
        if (this.credit.getState() != 4) {
            object.addUIObject((UIObject)new Message("Investeringskrediet is (nog) niet afgesloten.", "error"));
            return object;
        }
        Window window = new Window();
        window.setLabel("Investeringskrediet " + this.credit.getId() + " : Afsluitingsinfo");
        this.createTable();
        window.add((Table)this.table);
        object.addUIObject((UIObject)window);
        return object;
    }

    private void createTable() throws Exception {
        TransactionQuery query = new TransactionQuery(this.dbData, this.credit);
        this.table = new ODBTable(Transaction.class, (ODBQuery)query, new String[]{"documentNr"}, 12);
        this.table.setName(TABLENAME);
        this.table.setCounter((ODBCounter)query);
        this.table.setColumnNames(NAMES);
        this.table.setColumnLabels(LABELS);
        this.table.setColumnSizes(SIZES);
        this.table.setColumnTypes(TYPES);
        this.table.setDisplayTransformers(TRANSFORMERS);
        this.table.setColumnNoWraps(COLUMNNOWRAPS);
        this.table.setSortable(true);
        this.table.setSelectable(false);
        TableHelper.createMenu((CommonTable)this.table, null, (Action[])this.rowActions, (TableRowMethod)this.transactionTableRowMethod);
        this.table.reload();
        TableHelper.setHeaderTooltips((CommonTable)this.table, (String[])TOOLTIPS);
    }

    private class TransactionTableRowMethod
    implements TableRowMethod,
    Serializable {
        private static final long serialVersionUID = 8351780433747830979L;

        private TransactionTableRowMethod() {
        }

        public void postprocesCreatedRow(TableRow row, ContextAction[] rowActions) throws Exception {
            Transaction transaction = (Transaction)row.getObject();
            if (AssetBO.isIdNumeric(ClosedCreditTransactionInfoAdapter.this.company, "C".equals(transaction.getCora()))) {
                OutputField field = (OutputField)row.getUIOBjectByName(OutputField.class, "assetId");
                field.setValue((String)ClosedCreditTransactionInfoAdapter.this.numericIdTransformer.transform(transaction.getAssetId()));
                field.setType("number");
            }
            ContextMenu menu = new ContextMenu();
            for (int i = 0; i < rowActions.length; ++i) {
                if (rowActions[i] == null) continue;
                ContextAction rowAction = new ContextAction(rowActions[i].getName());
                rowAction.setAdapter(rowActions[i].getPageid());
                rowAction.setMethod(rowActions[i].getMethod());
                menu.addContextMenuItem(rowAction);
            }
            row.setContextMenu(menu);
        }
    }
}

