/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.gov.adapters;

import java.util.ArrayList;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.helpers.TableHelper;
import nl.ibs.esp.layout.ESPGridLayout;
import nl.ibs.esp.layout.ESPGridLayoutConstraints;
import nl.ibs.esp.uiobjects.AbstractTable;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CollectionTable;
import nl.ibs.esp.uiobjects.ComboBox;
import nl.ibs.esp.uiobjects.CommonTable;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.HeaderPanel;
import nl.ibs.esp.uiobjects.Image;
import nl.ibs.esp.uiobjects.Label;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.ODBQuery;
import nl.ibs.esp.uiobjects.ODBTable;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.ReferenceField;
import nl.ibs.esp.uiobjects.Table;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.UserMessageException;
import nl.ibs.esp.uiobjects.Window;
import nl.ibs.esp.util.ODBCounter;
import nl.ibs.esp.util.Transformer;
import nl.ibs.fac.EnumHelper;
import nl.ibs.fac.adapters.BookYearPeriodGrid;
import nl.ibs.fac.adapters.DecimalTransformer;
import nl.ibs.fac.adapters.FACDecimalField;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.IncomingFinancialTransactionDetailAdapter;
import nl.ibs.fac.adapters.ZeroLongToBlankTransformer;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.bp.IncomingFinancialTransactionBP;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Credit;
import nl.ibs.fac.db.CreditBalance;
import nl.ibs.fac.db.IncomingFinancialTransaction;
import nl.ibs.fac.db.TotalEstimationTransaction;
import nl.ibs.fac.gov.GovernmentEnumHelper;
import nl.ibs.fac.gov.adapters.BBVCategoryImageTransformer;
import nl.ibs.fac.gov.adapters.CreditPanels;
import nl.ibs.fac.gov.adapters.CreditReferenceField;
import nl.ibs.fac.gov.adapters.IFTGovernmentCodeImageTransformer;
import nl.ibs.fac.gov.boadapters.CreditBalanceBO;
import nl.ibs.fac.gov.boadapters.TotalEstimationTransactionBO;
import nl.ibs.fac.gov.bp.CreditBP;
import nl.ibs.fac.gov.bp.CreditBalanceBP;
import nl.ibs.fac.gov.bp.GenericGovernmentBP;
import nl.ibs.fac.gov.queries.CreditBalanceQuery;
import nl.ibs.fac.gov.queries.IncomingFinancialTransactionForGLAccountQuery;

public class CostAccountAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = 8602096312280509644L;
    public static final String PAGE = CostAccountAdapter.class.getName();
    private ODBTable table1 = null;
    private CommonTable.SearchPanel searchPanel;
    private static final String[] NAMES1 = new String[]{"gLAccountId", "description", "totalBalanceAmount", "isDeletable"};
    private static final String[] LABELS1 = new String[]{"Label.GLAccount", "Label.Description", "Label.TotalAmount", "Label.Remark"};
    private static final String[] TOOLTIPS1 = new String[]{"Label.Remark"};
    private static final short[] SIZES1 = new short[]{100, 300, 125, 20};
    private static Transformer[] TRANSFORMERS1 = new Transformer[]{null, null, new DecimalTransformer(), null};
    protected ODBTable table2;
    private CommonTable.SearchPanel searchPanel2;
    private static final DecimalTransformer DECIMALTRANSFORMER = new DecimalTransformer();
    private static final ZeroLongToBlankTransformer ZLTBTRANSFORMER = new ZeroLongToBlankTransformer();
    private static final BBVCategoryImageTransformer BBVTRANSFORMER = new BBVCategoryImageTransformer();
    private static final IFTGovernmentCodeImageTransformer GOVCDETRANSFORMER = new IFTGovernmentCodeImageTransformer();
    private static final String[] TOOLTIPS2 = new String[]{"Label.BBVCategory", "Label.Remark"};
    private static final String[] NAMES2 = new String[]{"bookYear", "period", "transactionValue", "bBVCategory", "governmentCode", "description", "systemItemNumber", "voucherId", "internalInvoiceId"};
    private static final String[] LABELS2 = new String[]{"Label.Year", "Label.Period.short", "Label.Amount", "Label.BBVCategory", "Label.Remark", "Label.Description", "Label.SystemItemNbr.Xshort", "Label.VoucherId.short", "Label.InvoiceNbr.Xshort"};
    private static final short[] SIZES2 = new short[]{50, 30, 125, 20, 20, 210, 100, 80, 120};
    private static final Transformer[] TRANSFORMERS2 = new Transformer[]{null, null, DECIMALTRANSFORMER, BBVTRANSFORMER, GOVCDETRANSFORMER, null, null, null, ZLTBTRANSFORMER};
    private static final String[] SEARCHNAMES2 = new String[]{"bookYear", "period", "transactionValue", "description", "systemItemNumber", "voucherId", "internalInvoiceId"};
    private static final String[] SEARCHLABELS2 = new String[]{"Label.Year", "Label.Period", "Label.Amount", "Label.Description", "Label.SystemItemNbr.short", "Label.VoucherId", "Label.InvoiceNbr.short"};
    private static final String GRID_FILL_NONE = ESPGridLayoutConstraints.GRID_FILL_NONE;
    private static final String GRID_ANCHOR_WEST = ESPGridLayoutConstraints.GRID_ANCHOR_WEST;
    private static final String REFRESH = "refresh";
    private static final String ASSIGNWINDOW = "initAssignWindow";
    private static final String TRANSACTIONS = "showTransactions";
    private static final String CONFIRMDELETE = "confirmDelete";
    private static final String DELETE = "delete";
    private FloatBar fbShow = new FloatBar();
    private FloatBar fbDelete = new FloatBar();
    private FloatBar fbIFT = new FloatBar();
    private Action[] rowActions1;
    private Action[] headerActions1;
    private Action[] rowActions2;
    private FloatBar fbCreateCreditForm;
    private FloatBar fbCreateDimensionForm;
    private FloatBar fbCreateMainAccountForm;
    private Company company;
    private CreditBalance creditBalance;
    private IncomingFinancialTransaction incomingFinancialTransaction;
    private GenericGovernmentBP genericGovernmentBP;
    private CreditBalanceBP creditBalanceBP;
    private FieldGroup maFieldGroup = null;
    private Window window;
    private CreditReferenceField crf;
    private Credit credit;
    private CreditPanels panels;
    private ComboBox oldBBVCategory;
    private ComboBox newBBVCategory;
    private ArrayList<Object> deleteList;

    public CostAccountAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.initialize(object);
    }

    private void initialize(DataObject object) throws Exception {
        this.company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        this.genericGovernmentBP = new GenericGovernmentBP(this.company);
        this.creditBalanceBP = new CreditBalanceBP(this.company);
        Action assign = new Action("Button.Assign").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(ASSIGNWINDOW);
        Action transactions = new Action("Button.Transactions").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(TRANSACTIONS);
        Action confirmDelete = new Action("Button.Delete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(CONFIRMDELETE);
        this.rowActions1 = new Action[]{assign, transactions, confirmDelete};
        Action refresh = new Action("Button.Refresh").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(REFRESH);
        this.fbShow.addAction(refresh);
        this.fbShow.addAction(confirmDelete);
        this.fbShow.addAction(this.finish);
        this.headerActions1 = new Action[]{refresh};
        Action iftDetails = new Action("Button.Details").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("showIFTDetails");
        Action edit = new Action("Button.Edit").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("editBBVCategoryWindow");
        this.rowActions2 = new Action[]{iftDetails, edit};
        this.fbIFT.addAction(this.back);
        this.fbIFT.addAction(this.finish);
        Action action = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(DELETE);
        this.fbDelete.addAction(action);
        this.fbDelete.addAction(this.back);
        this.fbDelete.addAction(this.finish);
        this.fbCreateCreditForm = new FloatBar();
        Action previous = new Action("Button.Previous").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("assignWindow");
        this.fbCreateCreditForm.addAction(previous);
        action = new Action("Button.Next").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createDimensionForm");
        action.setDefault(true);
        action.setValidationEnabled(true);
        this.fbCreateCreditForm.addAction(action);
        this.fbCreateCreditForm.addAction(this.cancel);
        CostAccountAdapter.TRANSFORMERS1[3] = new NoInvestmentAccountImageTransformer();
    }

    public DataObject show(DataObject object) throws Exception {
        if (this.companyId == null) {
            object.addUIObject((UIObject)new Message("NoActiveCompany", "error"));
            return this.finish(object);
        }
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.AssignToCostAccount", "screen_name"));
        if (this.table1 == null) {
            this.creditBalanceBP.updateIsDeletable(this.company, this.loginHelper);
            this.createTable();
        } else {
            this.table1.undoSelections();
        }
        object.addUIObject((UIObject)this.searchPanel);
        object.addUIObject((UIObject)this.table1);
        object.addUIObject((UIObject)this.fbShow);
        return object;
    }

    private void createTable() throws Exception {
        CreditBalanceQuery query = new CreditBalanceQuery(this.dbData, this.companyId);
        this.table1 = new ODBTable(CreditBalance.class, (ODBQuery)query, new String[]{"gLAccountId"}, 12);
        this.table1.setName(PAGE);
        this.table1.setCounter((ODBCounter)query);
        this.table1.setColumnNames(NAMES1);
        this.table1.setColumnLabels(LABELS1);
        this.table1.setColumnSizes(SIZES1);
        this.table1.setDisplayTransformers(TRANSFORMERS1);
        this.table1.setSortable(true);
        this.table1.setMultipleSelectable();
        this.searchPanel = this.table1.createSearch(NAMES1, LABELS1);
        Action filterAction = this.table1.createFilterAction(NAMES1, LABELS1, 3);
        this.searchPanel.addAction(filterAction);
        this.searchPanel.setCSSClass("headerPanel");
        TableHelper.createMenu((Table)this.table1, (Action[])this.headerActions1, (Action[])this.rowActions1);
        this.table1.reload();
        TableHelper.setHeaderTooltips((CommonTable)this.table1, (String[])TOOLTIPS1);
    }

    public DataObject refresh(DataObject object) throws Exception {
        this.table1 = null;
        return this.show(object);
    }

    public DataObject showTransactions(DataObject object) throws Exception {
        this.creditBalance = (CreditBalance)TableHelper.getSelectedItem((DataObject)object);
        new CreditBalanceBP(this.company).handleBalanceIsDirty(this.creditBalance);
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.Transactions", "screen_name"));
        HeaderPanel panel = new HeaderPanel();
        ReferenceField account = new ReferenceField("Label.FMSAccount");
        account.setReadonly(true);
        account.setValue(this.creditBalance.getGLAccountId());
        account.setLength(10);
        account.setDescription(this.creditBalance.getDescription());
        account.setDescriptionLength(35);
        panel.addUIObject((UIObject)account);
        FACDecimalField totalAmount = new FACDecimalField("Label.TotalAmount", 15, 2);
        totalAmount.setReadonly(true);
        totalAmount.setValue(this.creditBalance.getTotalBalanceAmount());
        panel.addUIObject((UIObject)totalAmount);
        object.addUIObject((UIObject)panel);
        this.createIncomingFinancialTransactionTable();
        object.addUIObject((UIObject)this.searchPanel2);
        object.addUIObject((UIObject)this.table2);
        object.addUIObject((UIObject)this.fbIFT);
        return object;
    }

    protected void createIncomingFinancialTransactionTable() throws Exception {
        IncomingFinancialTransactionForGLAccountQuery query = new IncomingFinancialTransactionForGLAccountQuery(this.dbData, this.companyId, this.creditBalance.getGLAccountId());
        this.table2 = new ODBTable(IncomingFinancialTransaction.class, (ODBQuery)query, new String[]{"id"}, 12);
        this.table2.setName("CostAccountAdapter.IncomingFinancialTransaction1");
        this.table2.setCounter((ODBCounter)query);
        this.table2.setColumnNames(NAMES2);
        this.table2.setColumnLabels(LABELS2);
        this.table2.setColumnSizes(SIZES2);
        this.table2.setDisplayTransformers(TRANSFORMERS2);
        this.table2.setSortable(true);
        this.searchPanel2 = this.table2.createSearch(SEARCHNAMES2, SEARCHLABELS2);
        Action filterAction = this.table2.createFilterAction(SEARCHNAMES2, SEARCHLABELS2, 3);
        this.searchPanel2.addAction(filterAction);
        TableHelper.createMenu((Table)this.table2, null, (Action[])this.rowActions2);
        this.table2.reload();
        TableHelper.setHeaderTooltips((CommonTable)this.table2, (String[])TOOLTIPS2);
    }

    public DataObject initAssignWindow(DataObject object) throws Exception {
        this.creditBalance = (CreditBalance)TableHelper.getSelectedItem((DataObject)object);
        new CreditBalanceBP(this.company).handleBalanceIsDirty(this.creditBalance);
        this.assignWindow(object);
        return object;
    }

    public DataObject assignWindow(DataObject object) throws Exception {
        if (this.window != null) {
            this.window.closeWindow(object);
        }
        this.window = new Window();
        this.window.setTop("10%");
        this.window.setRight("15%");
        this.window.setLabel("Title.Assign");
        HeaderPanel panel = new HeaderPanel();
        ReferenceField account = new ReferenceField("Label.FMSAccount");
        account.setReadonly(true);
        account.setValue(this.creditBalance.getGLAccountId());
        account.setLength(10);
        account.setDescription(this.creditBalance.getDescription());
        account.setDescriptionLength(35);
        panel.addUIObject((UIObject)account);
        FACDecimalField totalAmount = new FACDecimalField("Label.TotalAmount", 15, 2);
        totalAmount.setReadonly(true);
        totalAmount.setValue(this.creditBalance.getTotalBalanceAmount());
        panel.addUIObject((UIObject)totalAmount);
        this.window.add(panel);
        FieldGroup fg = new FieldGroup();
        this.crf = new CreditReferenceField(this.company, false);
        this.crf.setLabel("Label.Credit");
        fg.add((Field)this.crf);
        this.window.add(fg);
        FloatBar fb = new FloatBar();
        Action next = new Action("Button.Next").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("confirmAssign");
        next.setDefault(true);
        next.setValidationEnabled(true);
        fb.addAction(next);
        fb.addAction(this.cancel);
        this.window.add(fb);
        object.addUIObject((UIObject)this.window);
        return object;
    }

    public DataObject confirmAssign(DataObject object) throws Exception {
        this.window.closeWindow(object);
        this.credit = this.crf.getCredit();
        if (this.credit == null) {
            return this.initCreateForm(object);
        }
        this.window = new Window();
        this.window.setTop("10%");
        this.window.setRight("15%");
        this.window.setLabel("Title.ConfirmAssign");
        HeaderPanel panel = new HeaderPanel();
        ReferenceField account = new ReferenceField("Label.FMSAccount");
        account.setReadonly(true);
        account.setValue(this.creditBalance.getGLAccountId());
        account.setLength(10);
        account.setDescription(this.creditBalance.getDescription());
        account.setDescriptionLength(35);
        panel.addUIObject((UIObject)account);
        FACDecimalField totalAmount = new FACDecimalField("Label.TotalAmount", 15, 2);
        totalAmount.setReadonly(true);
        totalAmount.setValue(this.creditBalance.getTotalBalanceAmount());
        panel.addUIObject((UIObject)totalAmount);
        this.window.add(panel);
        FieldGroup fg = new FieldGroup("Label.Credit");
        this.crf.setReadonly(true);
        this.crf.setLabel("Label.Id");
        fg.add((Field)this.crf);
        FACDecimalField totalCreditValue = new FACDecimalField("Label.TotalCreditAmount", 15, 2);
        totalCreditValue.setReadonly(true);
        totalCreditValue.setValue(TotalEstimationTransactionBO.getTotalCreditAmount(this.credit));
        fg.add((Field)totalCreditValue);
        Field startYear = new Field("Label.StartYear");
        startYear.setReadonly(true);
        startYear.setLength(4);
        startYear.setValue("" + this.credit.getStartYear());
        fg.add(startYear);
        Field endYear = new Field("Label.EndYear");
        endYear.setReadonly(true);
        endYear.setLength(4);
        endYear.setValue("" + this.credit.getEndYear());
        fg.add(endYear);
        this.window.add(fg);
        FloatBar fb = new FloatBar();
        Action previous = new Action("Button.Previous").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("assignWindow");
        fb.addAction(previous);
        Action complete = new Action("Button.Complete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("assign");
        complete.setDefault(true);
        complete.setValidationEnabled(true);
        fb.addAction(complete);
        fb.addAction(this.cancel);
        this.window.add(fb);
        object.addUIObject((UIObject)this.window);
        return object;
    }

    public DataObject assign(DataObject object) throws Exception {
        this.window.closeWindow(object);
        String message = CreditBalanceBO.assign(this.creditBalance, this.credit);
        if (message != null) {
            throw new UserMessageException(message);
        }
        return this.refresh(object);
    }

    public DataObject initCreateForm(DataObject object) throws Exception {
        this.panels = new CreditPanels(this.loginHelper, this.dbData, this.env, this.company, this.bookYearMin, this.bookYearMax, this.numberOfPeriods, null, false, null, null, null, null);
        this.panels.id.setReadonly(this.panels.idReadOnly);
        this.panels.description.setReadonly(false);
        this.panels.startYear.setValue("" + this.company.getCurrentBookYear());
        this.panels.initializeValuationForm();
        this.maFieldGroup = null;
        return this.createCreditForm(object);
    }

    public DataObject createCreditForm(DataObject object) throws Exception {
        this.window.closeWindow(object);
        this.window = new Window();
        this.window.setTop("10%");
        this.window.setRight("15%");
        this.window.setLabel("Title.CreateCredit");
        this.panels.type.setReadonly(false);
        this.window.add(this.panels.headerPanel);
        this.window.add(this.panels.firstPanel);
        this.window.add(this.panels.miscellaneousPanel);
        this.window.add(this.panels.interestPanel);
        this.window.add(this.fbCreateCreditForm);
        object.addUIObject((UIObject)this.window);
        return object;
    }

    public DataObject createDimensionForm(DataObject object) throws Exception {
        String message = this.panels.validateCommonForm();
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        if (!this.panels.resultAccountItem.getValueAsBoolean()) {
            this.panels.getAccountingPrincipleDefaultFromType(this.panels.type.getValue().trim());
            this.panels.depreciationMethodChangeAction.execute(null);
            this.panels.apInterestCalculationMethodChangeAction.execute(null);
        }
        this.window.closeWindow(object);
        this.window = new Window();
        this.window.setTop("10%");
        this.window.setRight("15%");
        this.window.setLabel("Title.CreateCredit");
        this.panels.id.setReadonly(true);
        this.panels.description.setReadonly(true);
        this.window.add(this.panels.headerPanel);
        this.window.add(this.panels.financialPanel);
        this.window.add(this.panels.dimensionPanel);
        this.fbCreateDimensionForm = new FloatBar();
        this.fbCreateDimensionForm.addAction(new Action("Button.Previous").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createCreditForm"));
        Action action = this.panels.resultAccountItem.getValueAsBoolean() ? new Action("Button.Next").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createMainAccountForm") : new Action("Button.Next").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createAccountingPrincipleForm");
        action.setDefault(true);
        action.setValidationEnabled(true);
        this.fbCreateDimensionForm.addAction(action);
        this.fbCreateDimensionForm.addAction(this.cancel);
        this.window.add(this.fbCreateDimensionForm);
        object.addUIObject((UIObject)this.window);
        return object;
    }

    public DataObject createAccountingPrincipleForm(DataObject object) throws Exception {
        this.window.closeWindow(object);
        this.window = new Window();
        this.window.setTop("10%");
        this.window.setRight("15%");
        this.window.setLabel("Title.CreateCredit");
        this.window.add(this.panels.headerPanel);
        FieldGroup fg = new FieldGroup("");
        this.panels.type.setReadonly(true);
        fg.add((Field)this.panels.type);
        this.window.add(fg);
        this.window.add(this.panels.apPanel);
        FloatBar fb = new FloatBar();
        fb.addAction(new Action("Button.Previous").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createDimensionForm"));
        Action action = new Action("Button.Next").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createMainAccountForm");
        action.setDefault(true);
        action.setValidationEnabled(true);
        fb.addAction(action);
        fb.addAction(this.cancel);
        this.window.add(fb);
        object.addUIObject((UIObject)this.window);
        return object;
    }

    public DataObject createMainAccountForm(DataObject object) throws Exception {
        this.window.closeWindow(object);
        this.window = new Window();
        this.window.setTop("10%");
        this.window.setRight("15%");
        this.window.setLabel("Title.CreateCredit");
        this.window.add(this.panels.headerPanel);
        if (this.maFieldGroup == null) {
            this.maFieldGroup = this.genericGovernmentBP.getInitialMainAccountFieldGroup(this.loginHelper, null, 3, this.panels.startYear.getIntValue(), 1);
        }
        this.window.add(this.maFieldGroup);
        this.fbCreateMainAccountForm = new FloatBar();
        if (this.panels.resultAccountItem.getValueAsBoolean()) {
            this.fbCreateMainAccountForm.addAction(new Action("Button.Previous").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createDimensionForm"));
        } else {
            this.fbCreateMainAccountForm.addAction(new Action("Button.Previous").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createAccountingPrincipleForm"));
        }
        Action action = new Action("Button.Complete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createCredit");
        action.setDefault(true);
        action.setValidationEnabled(true);
        this.fbCreateMainAccountForm.addAction(action);
        this.fbCreateMainAccountForm.addAction(this.cancel);
        this.window.add(this.fbCreateMainAccountForm);
        object.addUIObject((UIObject)this.window);
        return object;
    }

    public DataObject createCredit(DataObject object) throws Exception {
        this.panels.mainAccountIds = this.genericGovernmentBP.getFormattedMainAccountIds();
        this.credit = null;
        Object[] result = new CreditBP(this.panels).create();
        String message = (String)result[1];
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        this.credit = (Credit)result[0];
        TotalEstimationTransactionBO.updateBasicTransactions(this.credit);
        TotalEstimationTransaction tet = TotalEstimationTransactionBO.getBaseActivationSchemeTransaction(this.credit);
        TotalEstimationTransactionBO.updateValuation(tet, Integer.parseInt(this.panels.depreciationMethod.getValue()), this.panels.yearPercentageTableId.getValue(), this.panels.degressivePercentage.getBigDecimal(), this.panels.annuityInterestTableId.getValue(), this.panels.annuityPercentage.getBigDecimal(), Integer.parseInt(this.panels.startPeriodHandlingMethod.getValue()), this.panels.depreciatableLife.getIntValue(), this.panels.residualPercentage.getBigDecimal(), this.panels.residualValue.getBigDecimal(), Integer.parseInt(this.panels.apInterestCalculationMethod.getValue()), this.panels.apInterestTableId.getValue(), this.numberOfPeriods, this.panels.apInterestPercentage.getBigDecimal());
        return this.assign(object);
    }

    public DataObject editBBVCategoryWindow(DataObject object) throws Exception {
        this.incomingFinancialTransaction = (IncomingFinancialTransaction)TableHelper.getSelectedItem((DataObject)object);
        this.window = new Window();
        this.window.setTop("10%");
        this.window.setRight("15%");
        this.window.setLabel("Title.ChangeBBVCategory");
        this.window.add(this.getHeader());
        FieldGroup fg = new FieldGroup("Label.BBVCategory");
        this.oldBBVCategory = EnumHelper.createComboBox("Label.Current", GovernmentEnumHelper.getCollection(5), false);
        this.oldBBVCategory.setSelectedOptionValue("" + this.incomingFinancialTransaction.getBBVCategory());
        this.oldBBVCategory.setReadonly(true);
        fg.add(this.oldBBVCategory);
        this.newBBVCategory = EnumHelper.createComboBox("Label.New", GovernmentEnumHelper.getCollection(5), false);
        fg.add(this.newBBVCategory);
        this.window.add(fg);
        FloatBar fb = new FloatBar();
        Action ok = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("editBBVCategory");
        ok.setDefault(true);
        fb.addAction(ok);
        this.window.add(fb);
        object.addUIObject((UIObject)this.window);
        return object;
    }

    private HeaderPanel getHeader() throws Exception {
        HeaderPanel header = new HeaderPanel();
        ESPGridLayout grid = new ESPGridLayout();
        grid.setColumnWidths(new short[]{200, 0});
        Field systemItemNumber = new Field();
        systemItemNumber.setDiscardLabel(true);
        systemItemNumber.setLength(15);
        systemItemNumber.setReadonly(true);
        grid.add((UIObject)new Label("Label.SystemItemNbr"), 0, 0, 1, 1, GRID_FILL_NONE, GRID_ANCHOR_WEST);
        grid.add((UIObject)systemItemNumber, 0, 1, 1, 1, GRID_FILL_NONE, GRID_ANCHOR_WEST);
        BookYearPeriodGrid iftYearPeriod = new BookYearPeriodGrid(null, true);
        grid.add((UIObject)new Label("Label.GLPeriod"), 1, 0, 1, 1, GRID_FILL_NONE, GRID_ANCHOR_WEST);
        grid.add((UIObject)iftYearPeriod, 1, 1, 1, 1, GRID_FILL_NONE, GRID_ANCHOR_WEST);
        Field iftTransactionValue = new Field("", "decimal", null, "", 15);
        iftTransactionValue.setDiscardLabel(true);
        iftTransactionValue.setReadonly(true);
        grid.add((UIObject)new Label("Label.TransactionValue"), 2, 0, 1, 1, GRID_FILL_NONE, GRID_ANCHOR_WEST);
        grid.add((UIObject)iftTransactionValue, 2, 1, 1, 1, GRID_FILL_NONE, GRID_ANCHOR_WEST);
        header.addUIObject((UIObject)grid);
        String sSystemItemNumber = this.incomingFinancialTransaction.getSystemItemSequencenumber() != 0 ? "" + this.incomingFinancialTransaction.getSystemItemNumber() + "/" + this.incomingFinancialTransaction.getSystemItemSequencenumber() : "" + this.incomingFinancialTransaction.getSystemItemNumber();
        systemItemNumber.setValue(sSystemItemNumber);
        iftYearPeriod.setValues("" + this.incomingFinancialTransaction.getBookYear(), "" + this.incomingFinancialTransaction.getPeriod());
        iftTransactionValue.setValue((String)new DecimalTransformer().transform(this.incomingFinancialTransaction.getTransactionValue()));
        return header;
    }

    public DataObject editBBVCategory(DataObject object) throws Exception {
        if (this.oldBBVCategory.getSelectedOptionValue().equals(this.newBBVCategory.getSelectedOptionValue())) {
            this.window.closeWindow(object);
            return object;
        }
        String message = IncomingFinancialTransactionBP.changeBBVCategory(this.incomingFinancialTransaction, Integer.parseInt(this.newBBVCategory.getSelectedOptionValue()));
        if (message != null) {
            this.window.add(new Message(message, "error"));
        } else {
            this.table2.reloadPage();
            this.window.closeWindow(object);
        }
        return object;
    }

    public DataObject showIFTDetails(DataObject object) throws Exception {
        this.incomingFinancialTransaction = (IncomingFinancialTransaction)TableHelper.getSelectedItem((DataObject)object);
        this.getProcess().setAttribute("IncomingFinancialTransaction", (Object)this.incomingFinancialTransaction);
        object.addUIObject((UIObject)new RedirectAction(this.getProcessAdapterPageName(IncomingFinancialTransactionDetailAdapter.PAGE), "showDetails", this.getProcess().getProcessId()));
        return object;
    }

    public DataObject confirmDelete(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.DeleteCostAccounts", "screen_name"));
        object.addUIObject((UIObject)this.createConfirmationTable(object));
        object.addUIObject((UIObject)this.fbDelete);
        return object;
    }

    private CollectionTable createConfirmationTable(DataObject object) throws Exception {
        Object[] items = TableHelper.getSelectedItems((AbstractTable)this.table1, (DataObject)object);
        this.deleteList = new ArrayList(items.length);
        for (int i = 0; i < items.length; ++i) {
            this.deleteList.add(items[i]);
        }
        CollectionTable table = new CollectionTable(CreditBalance.class, this.deleteList, 12);
        table.setName(PAGE);
        table.setColumnNames(NAMES1);
        table.setColumnLabels(LABELS1);
        table.orderByColumn(NAMES1[0]);
        table.setColumnSizes(SIZES1);
        table.setDisplayTransformers(TRANSFORMERS1);
        table.setSortable(true);
        table.reload();
        return table;
    }

    public DataObject delete(DataObject object) throws Exception {
        String message = null;
        Object[] items = this.deleteList.toArray();
        for (int i = 0; i < items.length; ++i) {
            CreditBalance creditBalance = (CreditBalance)items[i];
            if (creditBalance == null || (message = CreditBalanceBO.delete(creditBalance)) == null) continue;
            object.addUIObject((UIObject)new Message(message, "error"));
        }
        if (message != null) {
            return object;
        }
        return this.refresh(object);
    }

    public class NoInvestmentAccountImageTransformer
    implements Transformer {
        private static final long serialVersionUID = 4768199422546283131L;

        public Object transform(Object object) {
            if (((Boolean)object).booleanValue()) {
                return new Image("Label.NoInvestmentAccount", "shape_square_delete.png").setHeight("16").setAlignment("center");
            }
            return "";
        }
    }
}

