/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.gov.adapters;

import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.helpers.TableHelper;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CommonTable;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.ODBQuery;
import nl.ibs.esp.uiobjects.ODBTable;
import nl.ibs.esp.uiobjects.Panel;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.Table;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.Window;
import nl.ibs.esp.util.ODBCounter;
import nl.ibs.esp.util.Transformer;
import nl.ibs.fac.adapters.DecimalTransformer;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.IncomingFinancialTransactionDetailAdapter;
import nl.ibs.fac.adapters.MemoAdapter;
import nl.ibs.fac.adapters.MemoImageTransformer;
import nl.ibs.fac.adapters.NumericIdTransformer;
import nl.ibs.fac.adapters.TransactionAdapter;
import nl.ibs.fac.adapters.ZeroLongToBlankTransformer;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Credit;
import nl.ibs.fac.db.IncomingFinancialTransaction;
import nl.ibs.fac.gov.adapters.BBVCategoryImageTransformer;
import nl.ibs.fac.gov.adapters.ClosedCreditTransactionInfoAdapter;
import nl.ibs.fac.gov.adapters.CreditPanels;
import nl.ibs.fac.gov.adapters.CreditProofDepreciationAdapter;
import nl.ibs.fac.gov.adapters.CreditStateTransformer;
import nl.ibs.fac.gov.adapters.IFTGovernmentCodeImageTransformer;
import nl.ibs.fac.gov.adapters.ValuationMainAccountAdapter;
import nl.ibs.fac.gov.boadapters.CreditBO;
import nl.ibs.fac.gov.queries.CreditQuery;
import nl.ibs.fac.gov.queries.IncomingFinancialTransactionIPCQuery;

public class CreditInfoAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = 3395032969744671332L;
    public static final String PAGE = CreditInfoAdapter.class.getName();
    private Company company;
    private ODBTable table = null;
    private CommonTable.SearchPanel searchPanel;
    private static final String[] TOOLTIPS = new String[]{"Label.State", "Label.Memo"};
    private static final String[] NAMES = new String[]{"id", "totalEstimationAmount", "totalCostAmount", "description", "proFormaTypeId", "startYear", "endYear", "preferedGLAccountId", "state", "hasMemo"};
    private static final String[] LABELS = new String[]{"Label.Id", "Label.CreditAmount", "Label.BalanceAmount", "Label.Description", "Label.Type", "Label.From", "Label.To", "Label.GLAccount", "Label.State", "Label.Memo"};
    private static final String[] SEARCHNAMES = new String[]{"id", "description", "proFormaTypeId", "startYear", "endYear", "preferedGLAccountId", "state", "hasMemo"};
    private static final String[] SEARCHLABELS = new String[]{"Label.Id", "Label.Description", "Label.Type", "Label.From", "Label.To", "Label.GLAccount", "Label.State", "Label.Memo"};
    private static final short[] SIZES = new short[]{80, 125, 125, 250, 80, 40, 40, 80, 20, 20};
    private static final String[] TYPES = new String[]{null, null, null, null, null, null, null, null, "text", null};
    private static final Transformer[] TRANSFORMERS = new Transformer[]{null, new DecimalTransformer(), new DecimalTransformer(), null, null, null, null, null, null, new MemoImageTransformer()};
    private static final boolean[] COLUMNNOWRAPS = new boolean[]{true, true, true, true, true, true, true, true, true, true};
    private static final boolean[] SORTABLE = new boolean[]{true, false, false, true, true, true, true, true, true, true};
    private NumericIdTransformer numericIdTransformer = new NumericIdTransformer();
    private static final String REFRESH = "refresh";
    private static final String DETAILS = "initDetailsForm";
    private FloatBar fbShow = new FloatBar();
    private FloatBar fbDetails = new FloatBar();
    private Action[] rowActions;
    private Action[] headerActions;
    private Credit credit;
    private CreditPanels panels;
    private Action memo;
    private Action detailIFT;
    private Action transactionDetails;
    private Window ipcWindow;
    private ODBTable ipcTable;
    private CommonTable.SearchPanel ipcSearchPanel;
    private static final DecimalTransformer DECIMALTRANSFORMER = new DecimalTransformer();
    private static final ZeroLongToBlankTransformer ZLTBTRANSFORMER = new ZeroLongToBlankTransformer();
    private static final BBVCategoryImageTransformer BBVTRANSFORMER = new BBVCategoryImageTransformer();
    private static final IFTGovernmentCodeImageTransformer GOVCDETRANSFORMER = new IFTGovernmentCodeImageTransformer();
    private static final String[] IPCTOOLTIPS = new String[]{"Label.BBVCategory", "Label.Remark"};
    private static final String[] IPCNAMES = new String[]{"bookYear", "period", "transactionValue", "bBVCategory", "governmentCode", "description", "systemItemNumber", "voucherId", "internalInvoiceId"};
    private static final String[] IPCLABELS = new String[]{"Label.Year", "Label.Period.short", "Label.Amount", "Label.BBVCategory", "Label.Remark", "Label.Description", "Label.SystemItemNbr.Xshort", "Label.VoucherId.short", "Label.InvoiceNbr.Xshort"};
    private static final short[] IPCSIZES = new short[]{50, 30, 125, 20, 20, 210, 100, 80, 120};
    private static final Transformer[] IPCTRANSFORMERS = new Transformer[]{null, null, DECIMALTRANSFORMER, BBVTRANSFORMER, GOVCDETRANSFORMER, null, null, null, ZLTBTRANSFORMER};
    private static final String[] IPCSEARCHNAMES = new String[]{"bookYear", "period", "transactionValue", "description", "systemItemNumber", "voucherId", "internalInvoiceId"};
    private static final String[] IPCSEARCHLABELS = new String[]{"Label.Year", "Label.Period", "Label.Amount", "Label.Description", "Label.SystemItemNbr.short", "Label.VoucherId", "Label.InvoiceNbr.short"};
    private Action[] ipcRowActions;

    public CreditInfoAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.initialize(object);
    }

    private void initialize(DataObject object) throws Exception {
        CreditInfoAdapter.TRANSFORMERS[8] = new CreditStateTransformer();
        this.company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        Action refresh = new Action("Button.Refresh").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(REFRESH);
        this.fbShow.addAction(refresh);
        this.fbShow.addAction(this.finish);
        Action details = new Action("Button.Details").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(DETAILS);
        Action closingDetails = new Action("Afsluitingsinfo").setAdapter(this.getProcessAdapterPageName(ClosedCreditTransactionInfoAdapter.PAGE)).setMethod("show");
        this.memo = new Action("Label.Memo").setAdapter(this.getProcessAdapterPageName(MemoAdapter.PAGE)).setMethod("show");
        this.rowActions = new Action[]{details, closingDetails, this.memo};
        this.detailIFT = new Action("Label.Details").setAdapter(this.getProcessAdapterPageName(IncomingFinancialTransactionDetailAdapter.PAGE)).setMethod("showDetails");
        this.transactionDetails = new Action("Button.Details").setAdapter(this.getProcessAdapterPageName(TransactionAdapter.PAGE)).setMethod("show");
        this.getProcess().setAttribute("MemoAdapterReturnPage", (Object)this.getProcessAdapterPageName(PAGE));
        this.headerActions = new Action[]{refresh};
        this.cancel.setDefault(true);
        this.fbDetails.addAction(this.cancel);
        this.fbDetails.addAction(this.finish);
    }

    public DataObject show(DataObject object) throws Exception {
        if (this.companyId == null) {
            object.addUIObject((UIObject)new Message("NoActiveCompany", "error"));
            return this.finish(object);
        }
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.CreditInfo", "screen_name"));
        if (this.table == null) {
            this.createTable();
        }
        object.addUIObject((UIObject)this.searchPanel);
        object.addUIObject((UIObject)this.table);
        object.addUIObject((UIObject)this.fbShow);
        this.getProcess().setAttribute("Table", (Object)this.table);
        return object;
    }

    private void createTable() throws Exception {
        CreditQuery query = new CreditQuery(this.dbData, this.companyId);
        this.table = new ODBTable(Credit.class, (ODBQuery)query, new String[]{"id"}, 12);
        this.table.setName(PAGE);
        this.table.setCounter((ODBCounter)query);
        this.table.setColumnNames(NAMES);
        this.table.setColumnLabels(LABELS);
        this.table.setColumnSizes(SIZES);
        if (CreditBO.isIdNumeric(this.company)) {
            CreditInfoAdapter.TYPES[0] = "number";
            CreditInfoAdapter.TRANSFORMERS[0] = this.numericIdTransformer;
        }
        this.table.setColumnTypes(TYPES);
        this.table.setDisplayTransformers(TRANSFORMERS);
        this.table.setColumnNoWraps(COLUMNNOWRAPS);
        this.table.setColumnSortable(SORTABLE);
        this.table.setSortable(true);
        this.table.orderByColumn("id");
        this.searchPanel = this.table.createSearch(SEARCHNAMES, SEARCHLABELS);
        Action filterAction = this.table.createFilterAction(SEARCHNAMES, SEARCHLABELS, 3);
        this.searchPanel.addAction(filterAction);
        this.searchPanel.setCSSClass("headerPanel");
        TableHelper.createMenu((Table)this.table, (Action[])this.headerActions, (Action[])this.rowActions);
        this.table.reload();
        TableHelper.setHeaderTooltips((CommonTable)this.table, (String[])TOOLTIPS);
    }

    public DataObject refresh(DataObject object) throws Exception {
        this.table = null;
        return this.show(object);
    }

    public DataObject initDetailsForm(DataObject object) throws Exception {
        this.credit = (Credit)TableHelper.getSelectedItem((DataObject)object);
        this.panels = new CreditPanels(this.loginHelper, this.dbData, this.env, this.company, this.bookYearMin, this.bookYearMax, this.numberOfPeriods, this.credit, true, this.memo, this.detailIFT, this.transactionDetails, this.getProcess());
        this.panels.setValues();
        this.getProcess().setAttribute("credit", (Object)this.credit);
        this.panels.addCommonPanelAction(new Action("Label.MainAccountScheme").setAdapter(this.getProcessAdapterPageName(ValuationMainAccountAdapter.PAGE)).setMethod("showInfoWindow"));
        if (this.credit.getInitialProjectCostsReferenceCounter() > 0) {
            this.panels.addCommonPanelAction(new Action("Label.IPC_short").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("showIPCWindow"));
        }
        this.panels.addEstimationPanelAction(new Action("Kapitaallasten").setAdapter(this.getProcessAdapterPageName(CreditProofDepreciationAdapter.PAGE)).setMethod("show"));
        if (this.credit.getCreditBalanceReferenceCounter() > 1 && this.credit.getEndYear() > this.credit.getStartYear()) {
            this.panels.addGeneralLedgerPanelAction(new Action("Uitsplitsing").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("showGLYearWindow"));
        }
        return this.detailsForm(object);
    }

    public DataObject showGLYearWindow(DataObject object) throws Exception {
        return this.panels.showGLYearWindow(object);
    }

    public DataObject detailsForm(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.CreditDetails", "screen_name"));
        object.addUIObject((UIObject)this.panels.headerPanel2);
        object.addUIObject((UIObject)this.panels.mainTabPanel);
        object.addUIObject((UIObject)this.fbDetails);
        return object;
    }

    public DataObject showIPCWindow(DataObject object) throws Exception {
        if (this.ipcWindow != null) {
            this.ipcWindow.closeWindow(object);
        }
        this.ipcWindow = new Window();
        this.ipcWindow.setLabel("Label.IPC");
        this.createIPCTable();
        this.ipcWindow.add((Panel)this.ipcSearchPanel);
        this.ipcWindow.add((Table)this.ipcTable);
        object.addUIObject((UIObject)this.ipcWindow);
        return object;
    }

    private void createIPCTable() throws Exception {
        IncomingFinancialTransactionIPCQuery query = new IncomingFinancialTransactionIPCQuery(this.dbData, this.credit.getCompanyId(), this.credit.getId());
        this.ipcTable = new ODBTable(IncomingFinancialTransaction.class, (ODBQuery)query, new String[]{"id"}, 12);
        this.ipcTable.setName("CreditPanels.IncomingFinancialTransaction");
        this.ipcTable.setCounter((ODBCounter)query);
        this.ipcTable.setColumnNames(IPCNAMES);
        this.ipcTable.setColumnLabels(IPCLABELS);
        this.ipcTable.setColumnSizes(IPCSIZES);
        this.ipcTable.setDisplayTransformers(IPCTRANSFORMERS);
        this.ipcTable.setSortable(true);
        this.ipcSearchPanel = this.ipcTable.createSearch(IPCSEARCHNAMES, IPCSEARCHLABELS);
        Action ipcShow = new Action("Button.Details").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("showIPCTransaction");
        this.ipcRowActions = new Action[]{ipcShow};
        TableHelper.createMenu((Table)this.ipcTable, null, (Action[])this.ipcRowActions);
        this.ipcTable.reload();
        TableHelper.setHeaderTooltips((CommonTable)this.ipcTable, (String[])IPCTOOLTIPS);
    }

    public DataObject showIPCTransaction(DataObject object) throws Exception {
        IncomingFinancialTransaction incomingFinancialTransaction = (IncomingFinancialTransaction)TableHelper.getSelectedItem((DataObject)object);
        this.getProcess().setAttribute("IncomingFinancialTransaction", (Object)incomingFinancialTransaction);
        object.addUIObject((UIObject)new RedirectAction(this.getProcessAdapterPageName(IncomingFinancialTransactionDetailAdapter.PAGE), "showDetails", this.getProcess().getProcessId()));
        return object;
    }
}

