/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.gov.adapters;

import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FormattedField;
import nl.ibs.esp.uiobjects.ODBQuery;
import nl.ibs.esp.uiobjects.ODBQueryReferenceField;
import nl.ibs.esp.uiobjects.UserErrorMessage;
import nl.ibs.esp.util.Transformer;
import nl.ibs.fac.adapters.NumericIdTransformer;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Credit;
import nl.ibs.fac.gov.boadapters.CreditBO;
import nl.ibs.fac.gov.queries.CreditQuery;

public class CreditReferenceField
extends ODBQueryReferenceField
implements FormattedField {
    private static final long serialVersionUID = 8404649962947926067L;
    private static final String[] NAMES = new String[]{"id", "description"};
    private static final String[] LABELS = new String[]{"Label.Id", "Label.Description"};
    private static final short[] SIZES = new short[]{100, 500};
    private Transformer transformer = null;
    private Company company;
    private Credit credit;
    private boolean includeClosedCredits;

    public CreditReferenceField(Company company, boolean includeClosedCredits) throws Exception {
        super(LABELS[0], "upper", (ODBQuery)new CreditQuery(company.getDBData(), company.getId(), includeClosedCredits, false), Credit.class);
        this.company = company;
        this.includeClosedCredits = includeClosedCredits;
        this.setName(((Object)((Object)this)).getClass().getName());
        this.setTableFields(NAMES);
        this.setTableHeaderLabels(LABELS);
        this.setValueField(NAMES[0]);
        this.setDescriptionField(NAMES[1]);
        this.setTableKeys(new String[]{NAMES[0]});
        this.setTableHeaderSizes(SIZES);
        this.setLength(10);
        this.setMaxLength(10);
        this.setDescriptionLength(50);
        this.setSearchFields(NAMES);
        this.setSearchFieldLabels(LABELS);
        if (CreditBO.isIdNumeric(company)) {
            this.setType("number");
            this.setTableColumnTypes(new String[]{"number", null});
            this.transformer = new NumericIdTransformer();
            this.setTableTransformers(new Transformer[]{this.transformer, null});
        }
    }

    public Field setValue(String value) {
        if (this.transformer != null) {
            value = (String)this.transformer.transform((Object)value);
        }
        return super.setValue(value);
    }

    protected void beforeSelectWindowHook(DataObject object) throws Exception {
        this.commonTable = null;
        this.setReloadNeeded(true);
    }

    protected boolean selectedValueExecuteHook(DataObject object) {
        Credit credit = (Credit)this.getSelectedObject();
        try {
            this.setValue(credit.getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public void validate() throws Exception {
        super.validate();
        if (this.getValue().trim().length() == 0) {
            this.setDescription("");
            return;
        }
        Object[] result = CreditBO.get(this.company, this.getValue().trim());
        if (result[1] != null) {
            this.setInvalidTag();
            throw new UserErrorMessage((String)result[1]);
        }
        this.credit = (Credit)result[0];
        if (!this.includeClosedCredits && this.credit.getState() == 4) {
            this.setInvalidTag();
            throw new UserErrorMessage("key_not_found");
        }
        this.setDescription(this.credit.getDescription());
    }

    public Credit getCredit() {
        return this.credit;
    }

    public String getFormattedId() throws Exception {
        return CreditBO.formatId(this.company, this.getValue());
    }
}

