/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.gov.adapters;

import com.ibm.as400.access.AS400;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.helpers.TableHelper;
import nl.ibs.esp.language.TranslationHelperImpl;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CollectionTable;
import nl.ibs.esp.uiobjects.ComboBox;
import nl.ibs.esp.uiobjects.CommonTable;
import nl.ibs.esp.uiobjects.ContextAction;
import nl.ibs.esp.uiobjects.ContextMenu;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.ODBQuery;
import nl.ibs.esp.uiobjects.ODBTable;
import nl.ibs.esp.uiobjects.Panel;
import nl.ibs.esp.uiobjects.ReferenceField;
import nl.ibs.esp.uiobjects.Separator;
import nl.ibs.esp.uiobjects.Tab;
import nl.ibs.esp.uiobjects.TabbedPanel;
import nl.ibs.esp.uiobjects.Table;
import nl.ibs.esp.uiobjects.TableRow;
import nl.ibs.esp.uiobjects.TableRowMethod;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.UserMessageException;
import nl.ibs.esp.uiobjects.Window;
import nl.ibs.esp.util.ODBCounter;
import nl.ibs.esp.util.Transformer;
import nl.ibs.fac.ComparisonValue;
import nl.ibs.fac.EnumHelper;
import nl.ibs.fac.TransactionTypeEnum;
import nl.ibs.fac.adapters.BookYearField;
import nl.ibs.fac.adapters.ComparisonDifferenceImageTransformer;
import nl.ibs.fac.adapters.DecimalTransformer;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.IncomingFinancialTransactionDetailAdapter;
import nl.ibs.fac.adapters.IncomingFinancialTransactionImageTransformer;
import nl.ibs.fac.adapters.MultipleTypesImageTransformer;
import nl.ibs.fac.adapters.TransactionAdapter;
import nl.ibs.fac.adapters.TransactionStateImageTransformer;
import nl.ibs.fac.adapters.ZeroBigDecimalToBlankTransformer;
import nl.ibs.fac.adapters.ZeroLongToBlankTransformer;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.bp.ComparisonBP;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.IncomingFinancialTransaction;
import nl.ibs.fac.db.ProcessParameters;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.gov.adapters.BBVCategoryImageTransformer;
import nl.ibs.fac.gov.adapters.IFTGovernmentCodeImageTransformer;
import nl.ibs.fac.gov.bp.GOVComparisonBP;
import nl.ibs.fac.gov.queries.IncomingFinancialTransactionForGLAccountQuery;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.language.TokenList;
import nl.ibs.fac.queries.TransactionQuery;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.DBPersistenceManager;

public class GOVGLComparisonAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = -7259799335509142079L;
    public static final String PAGE = GOVGLComparisonAdapter.class.getName();
    private static final BigDecimal ZERO = new BigDecimal("0.00");
    private Company company;
    private ProcessParameters processParms;
    private int year;
    private int accountingPrinciple;
    private int numberOfCorrectionPeriods;
    private int theNumberOfPeriods;
    private String cora = "A";
    private int mainTransactionType;
    private int period;
    private String[] typeIds;
    private int greaterThanPeriod;
    boolean useGreaterThan;
    private GOVComparisonBP businessProcess;
    private ComparisonValue glComparisonValue;
    private ComparisonValue previousComparisonValue;
    private ComparisonValue nextComparisonValue;
    private Collection glComparisonValues;
    private Collection<Serializable> mainGLComparisonValues;
    private Collection<Serializable> subGLComparisonValues;
    private FieldGroup fg1;
    private BookYearField byfYear;
    private ComboBox cbAccountingPrinciple;
    private FloatBar fb1;
    private Action ok;
    private FloatBar fb2;
    private FloatBar fb3B;
    private Action previousType;
    private Action nextType;
    private Action previousAccount;
    private Action nextAccount;
    private String subScreenName;
    private FieldGroup fg3;
    private Field fYear;
    private Field aPrinciple;
    private ReferenceField rfMA1;
    private int mainAccountSeqNr = 0;
    private int currentIndex;
    private Action[] rowActions;
    private Action bookValueRegistrationAction;
    private Action creditBalanceDetailAction;
    private boolean mainAccountViewInitialized = false;
    private boolean multipleTypesViewInitialized = false;
    private boolean investmentAndDisinvestmentViewInitialized = false;
    private boolean transactionViewInitialized = false;
    private boolean IFTransactionViewInitialized = false;
    private CollectionTable table = null;
    private static final String[] NAMES = new String[]{"acquisitionAccountDescription", "multipleTypes", "gLAcquisitionTotal", "fACAcquisitionTotal", "acquisitionTotalDifference", "gLDepreciationTotal", "fACDepreciationTotal", "depreciationTotalDifference"};
    private static final String[] LABELS = new String[]{"Label.Description", "Label.MultipleTypes", "Label.AcquisitionValue_GL", "Label.AcquisitionValue_FAC", "Label.AcquisitionTotalDifference", "Label.DepreciationValue_GL", "Label.DepreciationValue_FAC", "Label.DepreciationTotalDifference"};
    private static final String[] LABELS_BV = new String[]{"Label.Description", "Label.MultipleTypes", "Label.BookValue_GL", "Label.BookValue_FAC", "Label.BookTotalDifference", "Label.DepreciationValue_FAC", "Label.AcquisitionValue_FAC", ""};
    private static final String[] TOOLTIPS = new String[]{"Label.MultipleTypes", "Label.AcquisitionTotalDifference", "Label.DepreciationTotalDifference"};
    private static final String[] TOOLTIPS_BV = new String[]{"Label.MultipleTypes", "Label.BookTotalDifference"};
    private static final short[] SIZES = new short[]{150, 20, 120, 120, 20, 120, 120, 20};
    private static final DecimalTransformer DECIMALTRANSFORMER = new DecimalTransformer();
    private static final ComparisonDifferenceImageTransformer DIFFERENCETRANSFORMER = new ComparisonDifferenceImageTransformer();
    private static final MultipleTypesImageTransformer MULTIPLETYPESTRANSFORMER = new MultipleTypesImageTransformer();
    private Transformer[] transformers = new Transformer[]{null, MULTIPLETYPESTRANSFORMER, DECIMALTRANSFORMER, DECIMALTRANSFORMER, DIFFERENCETRANSFORMER, DECIMALTRANSFORMER, DECIMALTRANSFORMER, DIFFERENCETRANSFORMER};
    private static final String[] NAMES_CR = new String[]{"acquisitionAccount", "acquisitionAccountDescription", "gLAcquisitionTotal", "fACAcquisitionTotal", "acquisitionTotalDifference", "creditId", "assetTypeId"};
    private static final String[] LABELS_CR = new String[]{"Label.MainAccount", "Label.Description", "Label.GeneralLedger", "FAC", "Label.Difference", "Label.CreditId", "Label.Type"};
    private static final String[] TOOLTIPS_CR = new String[]{"Label.Difference"};
    private static final short[] SIZES_CR = new short[]{80, 191, 120, 120, 20, 80, 80};
    private Transformer[] transformers_CR = new Transformer[]{null, null, DECIMALTRANSFORMER, DECIMALTRANSFORMER, DIFFERENCETRANSFORMER, null, null};
    private Action[] MAV_rowActions;
    private CollectionTable mainAccountViewTable = null;
    private static final String[] MAV_NAMES = new String[]{"period", "amount1", "amount2", "differenceIndicator_1", "amount3", "amount4"};
    private static final String[] MAV_LABELS = new String[]{"Label.Period.short", "Label.GeneralLedger", "FAC", "Label.Difference", "Label.GeneralLedger", "FAC"};
    private static final String[] MAV_LABELS_BV = new String[]{"Label.Period.short", "Label.BookValue_GL", "Label.BookValue_FAC", "Label.Difference", "Label.DepreciationValue_FAC", "Label.AcquisitionValue_FAC"};
    private static final String[] MAV_TOOLTIPS = new String[]{"Label.Difference"};
    private static final short[] MAV_SIZES = new short[]{30, 202, 120, 20, 202, 120};
    private Transformer[] MAV_transformers = new Transformer[]{null, DECIMALTRANSFORMER, DECIMALTRANSFORMER, DIFFERENCETRANSFORMER, DECIMALTRANSFORMER, DECIMALTRANSFORMER};
    private static String[] T_NAMES = new String[]{"assetId", "AssetDescription", "valueForAmount1", "documentAndSequenceNumber", "description", "daybookId", "voucherId", "state", "incomingFinancialTransaction"};
    private static String[] T_LABELS = new String[]{"Label.Id", "Label.Description", "Label.Amount", "Label.TransNbrShort", "Label.Description", "Label.Daybook", "Label.VoucherId", "Label.State", "Label.IncomingFinancialTransaction"};
    private static String[] T_TOOLTIPS = new String[]{"Label.State", "Label.IncomingFinancialTransaction"};
    private static short[] T_SIZES = new short[]{80, 180, 110, 80, 180, 60, 60, 20, 20};
    private static String[] T_TYPES = new String[]{"text", null, null, null, null, null, null, null, null};
    private static final ZeroBigDecimalToBlankTransformer ZBD_DECIMALTRANSFORMER = new ZeroBigDecimalToBlankTransformer();
    private static Transformer[] T_TRANSFORMERS = new Transformer[]{null, null, ZBD_DECIMALTRANSFORMER, null, null, null, null, new TransactionStateImageTransformer(), new IncomingFinancialTransactionImageTransformer()};
    private static boolean[] T_COLUMNNOWRAPS = new boolean[]{true, true, true, true, true, true, true, true, true};
    private static boolean[] T_SORTABLE = new boolean[]{true, false, false, false, true, true, true, true, true};
    private static String[] T_SEARCH_NAMES = new String[]{"assetId", "documentNr", "voucherId", "transactionType"};
    private static String[] T_SEARCH_LABELS = new String[]{"Label.AssetId", "Label.Transaction", "Label.VoucherId", "Label.TransactionType"};
    private ODBTable iftTable;
    private static final ZeroLongToBlankTransformer ZLTBTRANSFORMER = new ZeroLongToBlankTransformer();
    private static final BBVCategoryImageTransformer BBVTRANSFORMER = new BBVCategoryImageTransformer();
    private static final IFTGovernmentCodeImageTransformer GOVCDETRANSFORMER = new IFTGovernmentCodeImageTransformer();
    private static final String[] IFT_TOOLTIPS = new String[]{"Label.BBVCategory", "Label.Remark"};
    private static final String[] IFT_NAMES = new String[]{"bookYear", "period", "transactionValue", "bBVCategory", "governmentCode", "description", "systemItemNumber", "voucherId", "internalInvoiceId"};
    private static final String[] IFT_LABELS = new String[]{"Label.Year", "Label.Period.short", "Label.Amount", "Label.BBVCategory", "Label.Remark", "Label.Description", "Label.SystemItemNbr.Xshort", "Label.VoucherId.short", "Label.InvoiceNbr.Xshort"};
    private static final short[] IFT_SIZES = new short[]{50, 30, 125, 20, 20, 210, 100, 80, 120};
    private static final Transformer[] IFT_TRANSFORMERS = new Transformer[]{null, null, DECIMALTRANSFORMER, BBVTRANSFORMER, GOVCDETRANSFORMER, null, null, null, ZLTBTRANSFORMER};
    private CollectionTable subTable = null;
    private static String[] SUB_NAMES = new String[]{"assetTypeId", "assetTypeDescription", "fACAcquisitionTotal", "acquisitionTotalDifference", "fACDepreciationTotal", "depreciationTotalDifference", "fACCostTotal", "costTotalDifference"};
    private static String[] SUB_LABELS = new String[]{"Label.Id", "Label.Description", "Label.AcquisitionValue", "Label.AcquisitionTotalDifference", "Label.Depreciations", "Label.DepreciationTotalDifference", "Label.DepreciationCosts", "Label.CostTotalDifference"};
    private static String[] SUB_TOOLTIPS = new String[]{"Label.AcquisitionTotalDifference", "Label.DepreciationTotalDifference", "Label.CostTotalDifference"};
    private static final short[] SUB_SIZES = new short[]{100, 200, 120, 20, 120, 20, 120, 20};
    private Transformer[] SUB_transformers = new Transformer[]{null, null, DECIMALTRANSFORMER, DIFFERENCETRANSFORMER, DECIMALTRANSFORMER, DIFFERENCETRANSFORMER, DECIMALTRANSFORMER, DIFFERENCETRANSFORMER};
    private Action[] IAD_rowActions;
    private CollectionTable iadTable = null;
    private static final String[] IAD_NAMES = new String[]{"description", "amount1", "differenceIndicator_1", "amount2", "differenceIndicator_2", "amount3", "differenceIndicator_3"};
    private static String[] IAD_LABELS = new String[]{"Label.Description", "Label.AcquisitionValue_FAC", "Label.AcquisitionTotalDifference", "Label.DepreciationValue_FAC", "Label.DepreciationTotalDifference", "Label.BookValue", "Label.BookTotalDifference"};
    private static String[] IAD_TOOLTIPS = new String[]{"Label.AcquisitionTotalDifference", "Label.DepreciationTotalDifference", "Label.BookTotalDifference"};
    private static final short[] IAD_SIZES = new short[]{200, 120, 20, 120, 20, 120, 20};
    private Transformer[] IAD_transformers = new Transformer[]{null, DECIMALTRANSFORMER, DIFFERENCETRANSFORMER, DECIMALTRANSFORMER, DIFFERENCETRANSFORMER, DECIMALTRANSFORMER, DIFFERENCETRANSFORMER};
    private static final String[] TT_NAMES = new String[]{"periodForJournalization", "assetId", "AssetDescription", "valueForAmount1", "valueForAmount2", "documentAndSequenceNumber", "description", "daybookId", "voucherId", "state", "incomingFinancialTransaction"};
    private static final String[] TT_LABELS = new String[]{"Label.Period.short", "Label.Id", "Label.Description", "Label.Acquisition", "Label.Depreciation", "Label.TransNbrShort", "Label.Description", "Label.Daybook", "Label.VoucherId", "Label.State", "Label.IncomingFinancialTransaction"};
    private static final String[] TT_TOOLTIPS = new String[]{"Label.State", "Label.IncomingFinancialTransaction"};
    private static final short[] TT_SIZES = new short[]{30, 80, 180, 110, 110, 80, 180, 60, 60, 20, 20};
    private static final String[] TT_TYPES = new String[]{null, "text", null, null, null, null, null, null, null, null, null};
    private static final Transformer[] TT_TRANSFORMERS = new Transformer[]{null, null, null, ZBD_DECIMALTRANSFORMER, ZBD_DECIMALTRANSFORMER, null, null, null, null, new TransactionStateImageTransformer(), new IncomingFinancialTransactionImageTransformer()};
    private static final boolean[] TT_COLUMNNOWRAPS = new boolean[]{true, true, true, true, true, true, true, true, true, true, true};
    private static final boolean[] TT_SORTABLE = new boolean[]{true, true, false, false, false, false, true, true, true, true, true};
    private static final String[] TT_SEARCH_NAMES = new String[]{"periodForJournalization", "assetId", "documentNr", "voucherId", "transactionType"};
    private static final String[] TT_SEARCH_LABELS = new String[]{"Label.Period", "Label.AssetId", "Label.Transaction", "Label.VoucherId", "Label.TransactionType"};
    private ODBTable transactionTable;
    private CommonTable.SearchPanel searchPanel;
    private Map<String, ComboBox> inputComponents = new HashMap<String, ComboBox>();
    private Action[] transactionRowActions;
    private Action[] iftRowActions;

    public GOVGLComparisonAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.initialize(object);
    }

    private void initialize(DataObject object) throws Exception {
        this.company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        this.numberOfCorrectionPeriods = this.company.getNumberOfCorrectionPeriods();
        this.theNumberOfPeriods = this.numberOfPeriods;
        if (this.numberOfCorrectionPeriods > 0) {
            ++this.theNumberOfPeriods;
        }
        this.processParms = this.company.getProcessParameters();
        this.businessProcess = new GOVComparisonBP(this.dbData, (AS400)this.loginHelper.getAs400(), this.env, this.company, this.numberOfPeriods, this.processParms);
        this.fg1 = new FieldGroup("");
        this.byfYear = new BookYearField("Label.BookYear", this.bookYear, this.bookYearMin, this.bookYearMax);
        this.byfYear.setReadonly(false);
        this.fg1.add((Field)this.byfYear);
        this.cbAccountingPrinciple = new ComboBox("Label.AccountingPrinciple");
        this.cbAccountingPrinciple.addOption(this.env.getAPName1(), "1");
        this.cbAccountingPrinciple.addOption(this.env.getAPName3(), "3");
        this.cbAccountingPrinciple.setSelectedOptionValue("1");
        this.fg1.add(this.cbAccountingPrinciple);
        this.fb1 = new FloatBar();
        this.ok = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("internalShow");
        this.ok.setValidationEnabled(true);
        this.ok.setDefault(true);
        this.fb1.addAction(this.ok);
        this.fb1.addAction(this.finish);
        this.fb2 = new FloatBar();
        this.fb2.addAction(new Action("Button.Back").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("show"));
        this.fb2.addAction(this.finish);
        Action action_1 = new Action("Label.AcquisitionValue").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("showAcquisitionAccount");
        Action action_2 = new Action("Label.Depreciations").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("showDepreciationAccount");
        Action action_3 = new Action("Label.DepreciationCosts").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("showCostAccount");
        Action action_4 = new Action("Label.MultipleTypes").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("showMultipleTypes");
        Action action_5 = new Action("Label.InvestmentsAndDisinvestments").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("showInvestmentAndDisinvestment");
        this.rowActions = new Action[]{action_1, action_2, action_3, action_4, action_5};
        this.bookValueRegistrationAction = new Action("Label.Details").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("showBookValueRegistrationDetails");
        this.creditBalanceDetailAction = new Action("Label.Details").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("showCreditBalanceDetails");
    }

    public DataObject show(DataObject object) throws Exception {
        if (this.companyId == null) {
            object.addUIObject((UIObject)new Message("NoActiveCompany", "error"));
            return this.finish(object);
        }
        if (this.processParms.getBalanceAccountsOnIndividualLevel()) {
            object.addUIObject((UIObject)new Message("Not implemented yet !", "error"));
        }
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.GLComparison", "screen_name"));
        this.byfYear.setMandatory(true);
        object.addUIObject((UIObject)this.fg1);
        object.addUIObject((UIObject)this.fb1);
        DBData defaultDBData = DBData.getDefaultDBData("fac");
        DBPersistenceManager.setDefaultDataBase(this.dbData);
        BigDecimal[] totals = ComparisonBP.retrieveCompanyTotals(this.company, 1, true, true);
        DBPersistenceManager.setDefaultDataBase(defaultDBData);
        if (totals[0].doubleValue() != totals[1].doubleValue() || totals[2].doubleValue() != totals[3].doubleValue()) {
            this.ok.setConfirmationMessage("InternalDifferencesFound");
        }
        return object;
    }

    public DataObject internalShow(DataObject object) throws Exception {
        this.year = Integer.parseInt(this.byfYear.getValue());
        this.accountingPrinciple = Integer.parseInt(this.cbAccountingPrinciple.getValue());
        if (this.table == null) {
            this.glComparisonValues = this.businessProcess.retrieveGLComparisonValues(this.accountingPrinciple, this.year);
            if (this.glComparisonValues == null || this.glComparisonValues.isEmpty()) {
                object.addUIObject((UIObject)new Message("?!?", "error"));
                return object;
            }
            this.createTable();
        }
        if (!this.mainAccountViewInitialized) {
            this.initializeMainAccountView();
            this.mainAccountViewInitialized = true;
        }
        this.cbAccountingPrinciple.setReadonly(true);
        this.byfYear.setReadonly(true);
        this.byfYear.setMandatory(false);
        this.rfMA1.setValue(object.translate("Label.NotApplicable.short", object.getLocale()));
        this.rfMA1.setDescription("");
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.GLComparison", "screen_name"));
        object.addUIObject((UIObject)new Header("Label.Common", "sub_screen_name"));
        object.addUIObject((UIObject)this.fg3);
        object.addUIObject((UIObject)this.table);
        object.addUIObject((UIObject)this.fb2);
        return object;
    }

    private void createTable() throws Exception {
        int index = 0;
        this.mainGLComparisonValues = new Vector<Serializable>();
        for (ComparisonValue glComparisonValue : this.glComparisonValues) {
            if (glComparisonValue.getBeanType() != 0) continue;
            glComparisonValue.setCurrentIndex(index);
            this.mainGLComparisonValues.add(glComparisonValue);
            ++index;
        }
        this.table = new CollectionTable(ComparisonValue.class, this.mainGLComparisonValues, 12);
        if (this.accountingPrinciple != 3) {
            this.table.setName(PAGE);
            this.table.setColumnNames(NAMES);
            if (this.processParms.getGLBookValueRegistration()) {
                this.table.setColumnLabels(LABELS_BV);
            } else {
                this.table.setColumnLabels(LABELS);
            }
            this.table.setColumnSizes(SIZES);
            this.table.setDisplayTransformers(this.transformers);
            this.table.setSortable(false);
            this.table.setSelectable(false);
            TableHelper.createMenu((CommonTable)this.table, null, (Action[])this.rowActions, (TableRowMethod)new GLComparisonValueTableRowMethod());
            if (this.processParms.getGLBookValueRegistration()) {
                this.table.setRowAction(this.bookValueRegistrationAction);
            }
            this.table.reload();
            if (this.processParms.getGLBookValueRegistration()) {
                TableHelper.setHeaderTooltips((CommonTable)this.table, (String[])TOOLTIPS_BV);
            } else {
                TableHelper.setHeaderTooltips((CommonTable)this.table, (String[])TOOLTIPS);
            }
        } else {
            this.table.setName(PAGE + "_CR");
            this.table.setColumnNames(NAMES_CR);
            this.table.setColumnLabels(LABELS_CR);
            this.table.setColumnSizes(SIZES_CR);
            this.table.setDisplayTransformers(this.transformers_CR);
            this.table.setSortable(false);
            this.table.setSelectable(false);
            TableHelper.createMenu((CommonTable)this.table, null, (Action[])this.rowActions, (TableRowMethod)new GLComparisonValueTableRowMethod());
            this.table.setRowAction(this.creditBalanceDetailAction);
            this.table.reload();
            TableHelper.setHeaderTooltips((CommonTable)this.table, (String[])TOOLTIPS_CR);
        }
    }

    public DataObject showAcquisitionAccount(DataObject object) throws Exception {
        this.glComparisonValue = (ComparisonValue)TableHelper.getSelectedItem((DataObject)object);
        this.currentIndex = this.glComparisonValue.getCurrentIndex();
        this.mainAccountSeqNr = 1;
        return this.createMainAccountView(object);
    }

    public DataObject showDepreciationAccount(DataObject object) throws Exception {
        this.glComparisonValue = (ComparisonValue)TableHelper.getSelectedItem((DataObject)object);
        if (this.glComparisonValue.getDepreciationAccount().length() == 0) {
            TokenList tl = new TokenList();
            tl.addNonTranslatable(this.glComparisonValue.getAcquisitionAccount());
            tl.addNonTranslatable(this.glComparisonValue.getAcquisitionAccountDescription());
            tl.addTranslatable("nl.ibs.fac.language", "Depreciations");
            throw new UserMessageException(LanguageHelper.getString("nl.ibs.fac.language", "no_main_account_defined", tl));
        }
        this.currentIndex = this.glComparisonValue.getCurrentIndex();
        this.mainAccountSeqNr = 2;
        return this.createMainAccountView(object);
    }

    public DataObject showCostAccount(DataObject object) throws Exception {
        this.glComparisonValue = (ComparisonValue)TableHelper.getSelectedItem((DataObject)object);
        if (this.glComparisonValue.getCostAccount().length() == 0) {
            TokenList tl = new TokenList();
            tl.addNonTranslatable(this.glComparisonValue.getAcquisitionAccount());
            tl.addNonTranslatable(this.glComparisonValue.getAcquisitionAccountDescription());
            tl.addTranslatable("nl.ibs.fac.language", "DepreciationCosts");
            throw new UserMessageException(LanguageHelper.getString("nl.ibs.fac.language", "no_main_account_defined", tl));
        }
        this.currentIndex = this.glComparisonValue.getCurrentIndex();
        this.mainAccountSeqNr = 3;
        return this.createMainAccountView(object);
    }

    public DataObject showBookValueRegistrationDetails(DataObject object) throws Exception {
        this.glComparisonValue = (ComparisonValue)TableHelper.getSelectedItem((DataObject)object);
        this.currentIndex = this.glComparisonValue.getCurrentIndex();
        this.mainAccountSeqNr = 1;
        return this.createMainAccountViewForBookValueRegistrationDetails(object);
    }

    public DataObject showCreditBalanceDetails(DataObject object) throws Exception {
        this.glComparisonValue = (ComparisonValue)TableHelper.getSelectedItem((DataObject)object);
        this.currentIndex = this.glComparisonValue.getCurrentIndex();
        this.mainAccountSeqNr = 1;
        return this.createMainAccountViewForCreditBalanceDetails(object);
    }

    private void initializeMainAccountView() throws Exception {
        this.fg3 = new FieldGroup("");
        this.fYear = new Field("Label.BookYear");
        this.fYear.setValue(this.byfYear.getValue());
        this.fYear.setReadonly(true);
        this.aPrinciple = new Field("Label.AccountingPrinciple");
        this.aPrinciple.setValue(this.cbAccountingPrinciple.getSelectedOption().getLabel());
        this.aPrinciple.setReadonly(true);
        this.rfMA1 = new ReferenceField("Label.MainAccount");
        this.rfMA1.setDescriptionLength(40);
        this.rfMA1.setReadonly(true);
        this.fg3.add(this.fYear);
        this.fg3.add(this.aPrinciple);
        this.fg3.add((Field)this.rfMA1);
        this.fb3B = new FloatBar();
        this.fb3B.addAction(new Action("Button.Back").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("internalShow"));
        this.previousType = new Action("Button.PreviousType").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("showPreviousType");
        this.nextType = new Action("Button.NextType").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("showNextType");
        this.fb3B.addAction(this.previousType);
        this.fb3B.addAction(this.nextType);
        if (!this.processParms.getGLBookValueRegistration() && this.accountingPrinciple != 3) {
            this.previousAccount = new Action("< Account").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("showPreviousAccount");
            this.nextAccount = new Action("Account >").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("showNextAccount");
            this.fb3B.addAction(this.previousAccount);
            this.fb3B.addAction(this.nextAccount);
        }
        this.fb3B.addAction(this.finish);
        Action action = this.accountingPrinciple != 3 ? new Action("Label.Transactions").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("showMAVTransactions") : new Action("Label.Transactions").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("showIFTTransactions");
        this.MAV_rowActions = new Action[]{action};
        action = new Action("Label.Transactions").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("showIADTransactions");
        this.IAD_rowActions = new Action[]{action};
    }

    /*
     * WARNING - void declaration
     */
    private void determinePreviousAndNextComparisonValue(boolean evokedFromPrevious) throws Exception {
        void var3_8;
        this.nextComparisonValue = null;
        this.previousComparisonValue = null;
        ComparisonValue currentComparisonValue = null;
        Object var3_3 = null;
        for (ComparisonValue comparisonValue : this.mainGLComparisonValues) {
            if (!comparisonValue.equals(this.glComparisonValue)) {
                if (currentComparisonValue == null) {
                    this.previousComparisonValue = comparisonValue;
                    continue;
                }
                this.nextComparisonValue = comparisonValue;
                break;
            }
            currentComparisonValue = comparisonValue;
        }
        if (this.accountingPrinciple == 3 || this.processParms.getGLBookValueRegistration()) {
            return;
        }
        if (evokedFromPrevious && this.previousComparisonValue == null || !evokedFromPrevious && this.nextComparisonValue == null) {
            return;
        }
        if (evokedFromPrevious) {
            ComparisonValue comparisonValue = this.previousComparisonValue;
        } else {
            ComparisonValue comparisonValue = this.nextComparisonValue;
        }
        if (this.mainAccountSeqNr == 2) {
            if (var3_8.getDepreciationAccount().length() == 0) {
                TokenList tl = new TokenList();
                tl.addNonTranslatable(var3_8.getAcquisitionAccount());
                tl.addNonTranslatable(var3_8.getAcquisitionAccountDescription());
                tl.addTranslatable("nl.ibs.fac.language", "Depreciations");
                throw new UserMessageException(LanguageHelper.getString("nl.ibs.fac.language", "no_main_account_defined", tl));
            }
        } else if (this.mainAccountSeqNr == 3 && var3_8.getCostAccount().length() == 0) {
            TokenList tl = new TokenList();
            tl.addNonTranslatable(var3_8.getAcquisitionAccount());
            tl.addNonTranslatable(var3_8.getAcquisitionAccountDescription());
            tl.addTranslatable("nl.ibs.fac.language", "DepreciationCosts");
            throw new UserMessageException(LanguageHelper.getString("nl.ibs.fac.language", "no_main_account_defined", tl));
        }
    }

    public DataObject showPreviousType(DataObject object) throws Exception {
        this.determinePreviousAndNextComparisonValue(true);
        if (this.previousComparisonValue == null) {
            return object;
        }
        this.glComparisonValue = this.previousComparisonValue;
        --this.currentIndex;
        if (this.accountingPrinciple == 3) {
            return this.createMainAccountViewForCreditBalanceDetails(object);
        }
        if (this.processParms.getGLBookValueRegistration()) {
            return this.createMainAccountViewForBookValueRegistrationDetails(object);
        }
        return this.createMainAccountView(object);
    }

    public DataObject showNextType(DataObject object) throws Exception {
        this.determinePreviousAndNextComparisonValue(false);
        if (this.nextComparisonValue == null) {
            return object;
        }
        this.glComparisonValue = this.nextComparisonValue;
        ++this.currentIndex;
        if (this.accountingPrinciple == 3) {
            return this.createMainAccountViewForCreditBalanceDetails(object);
        }
        if (this.processParms.getGLBookValueRegistration()) {
            return this.createMainAccountViewForBookValueRegistrationDetails(object);
        }
        return this.createMainAccountView(object);
    }

    public DataObject showPreviousAccount(DataObject object) throws Exception {
        this.mainAccountSeqNr = this.mainAccountSeqNr == 1 ? 2 : 1;
        return this.createMainAccountView(object);
    }

    public DataObject showNextAccount(DataObject object) throws Exception {
        this.mainAccountSeqNr = this.mainAccountSeqNr == 3 ? 2 : 3;
        return this.createMainAccountView(object);
    }

    private DataObject createMainAccountView(DataObject object) throws Exception {
        this.businessProcess.retrieveGLComparisonValueDetails(this.glComparisonValue);
        this.subScreenName = this.glComparisonValue.getAcquisitionAccountDescription();
        switch (this.mainAccountSeqNr) {
            case 1: {
                this.rfMA1.setDescription(this.glComparisonValue.getAcquisitionAccountDescription());
                this.rfMA1.setValue("" + Integer.parseInt(this.glComparisonValue.getAcquisitionAccount().trim()));
                break;
            }
            case 2: {
                this.rfMA1.setDescription(this.glComparisonValue.getDepreciationAccountDescription());
                this.rfMA1.setValue("" + Integer.parseInt(this.glComparisonValue.getDepreciationAccount().trim()));
                break;
            }
            case 3: {
                this.rfMA1.setDescription(this.glComparisonValue.getCostAccountDescription());
                this.rfMA1.setValue("" + Integer.parseInt(this.glComparisonValue.getCostAccount().trim()));
            }
        }
        Vector<InternalRow> maRows = new Vector<InternalRow>();
        int figureType = (this.mainAccountSeqNr - 1) * 2;
        for (int period = 0; period <= this.theNumberOfPeriods; ++period) {
            InternalRow maRow = new InternalRow();
            maRow.period = period;
            maRow.amount1 = this.glComparisonValue.getFigure(figureType, period);
            maRow.amount3 = this.glComparisonValue.getFigureYTD(figureType, period);
            maRow.amount2 = this.glComparisonValue.getFigure(figureType + 1, period);
            maRow.amount4 = this.glComparisonValue.getFigureYTD(figureType + 1, period);
            switch (this.mainAccountSeqNr) {
                case 1: {
                    maRow.differenceIndicator_1 = this.glComparisonValue.getAcquisitionDetailDifference(period);
                    break;
                }
                case 2: {
                    maRow.differenceIndicator_1 = this.glComparisonValue.getDepreciationDetailDifference(period);
                    break;
                }
                case 3: {
                    maRow.differenceIndicator_1 = this.glComparisonValue.getCostDetailDifference(period);
                }
            }
            maRows.add(maRow);
        }
        this.mainAccountViewTable = new CollectionTable(InternalRow.class, maRows, this.theNumberOfPeriods + 1);
        this.mainAccountViewTable.setName(PAGE + "-mavTable");
        this.mainAccountViewTable.setColumnNames(MAV_NAMES);
        this.mainAccountViewTable.setColumnLabels(MAV_LABELS);
        this.mainAccountViewTable.setColumnSizes(MAV_SIZES);
        this.mainAccountViewTable.setDisplayTransformers(this.MAV_transformers);
        this.mainAccountViewTable.setSortable(false);
        this.mainAccountViewTable.setSelectable(false);
        TableHelper.createMenu((CommonTable)this.mainAccountViewTable, null, (Action[])this.MAV_rowActions, (TableRowMethod)new MainAccountViewTableRowMethod());
        this.mainAccountViewTable.reload();
        TableHelper.setHeaderTooltips((CommonTable)this.mainAccountViewTable, (String[])MAV_TOOLTIPS);
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.GLComparison", "screen_name"));
        object.addUIObject((UIObject)new Header(this.subScreenName, "sub_screen_name"));
        object.addUIObject((UIObject)this.fg3);
        object.addUIObject((UIObject)this.mainAccountViewTable);
        this.previousAccount.setEnabled(true);
        this.nextAccount.setEnabled(true);
        this.previousType.setEnabled(true);
        this.nextType.setEnabled(true);
        if (this.currentIndex == 0) {
            this.previousType.setEnabled(false);
        }
        if (this.currentIndex == this.mainGLComparisonValues.size() - 1) {
            this.nextType.setEnabled(false);
        }
        if (this.mainAccountSeqNr == 1) {
            this.previousAccount.setLabel("Label.Depreciation");
            if (this.glComparisonValue.getDepreciationAccount().length() == 0) {
                this.previousAccount.setEnabled(false);
            }
            this.nextAccount.setLabel("Label.DepreciationCosts.short");
            if (this.glComparisonValue.getCostAccount().length() == 0) {
                this.nextAccount.setEnabled(false);
            }
        } else if (this.mainAccountSeqNr == 2) {
            this.previousAccount.setLabel("Label.AcquisitionValue.short");
            this.nextAccount.setLabel("Label.DepreciationCosts.short");
            if (this.glComparisonValue.getCostAccount().length() == 0) {
                this.nextAccount.setEnabled(false);
            }
        } else {
            this.previousAccount.setLabel("Label.AcquisitionValue.short");
            this.nextAccount.setLabel("Label.Depreciation");
            if (this.glComparisonValue.getDepreciationAccount().length() == 0) {
                this.nextAccount.setEnabled(false);
            }
        }
        object.addUIObject((UIObject)this.fb3B);
        return object;
    }

    private DataObject createMainAccountViewForBookValueRegistrationDetails(DataObject object) throws Exception {
        InternalRow maRow;
        this.businessProcess.retrieveGLComparisonValueDetails(this.glComparisonValue);
        this.subScreenName = this.glComparisonValue.getAcquisitionAccountDescription();
        this.rfMA1.setDescription(this.glComparisonValue.getAcquisitionAccountDescription());
        this.rfMA1.setValue("" + Integer.parseInt(this.glComparisonValue.getAcquisitionAccount().trim()));
        Vector<InternalRow> maRows = new Vector<InternalRow>();
        for (int period = 0; period <= this.theNumberOfPeriods; ++period) {
            maRow = new InternalRow();
            maRow.period = period;
            maRow.amount1 = this.glComparisonValue.getFigure(0, period);
            maRow.amount4 = this.glComparisonValue.getFigure(1, period);
            maRow.amount3 = this.glComparisonValue.getFigure(3, period);
            maRow.amount2 = maRow.amount4.subtract(maRow.amount3);
            maRow.differenceIndicator_1 = maRow.getAmount2().subtract(maRow.getAmount1());
            maRows.add(maRow);
        }
        maRow = new InternalRow();
        maRow.period = 99;
        maRow.amount1 = this.glComparisonValue.getGLAcquisitionTotal();
        maRow.amount2 = this.glComparisonValue.getFACAcquisitionTotal();
        maRow.amount3 = this.glComparisonValue.getGLDepreciationTotal();
        maRow.amount4 = this.glComparisonValue.getFACDepreciationTotal();
        maRow.differenceIndicator_1 = maRow.getAmount2().subtract(maRow.getAmount1());
        maRows.add(maRow);
        this.mainAccountViewTable = new CollectionTable(InternalRow.class, maRows, this.theNumberOfPeriods + 2);
        this.mainAccountViewTable.setName(PAGE + "-mavTable");
        this.mainAccountViewTable.setColumnNames(MAV_NAMES);
        this.mainAccountViewTable.setColumnLabels(MAV_LABELS_BV);
        this.mainAccountViewTable.setColumnSizes(MAV_SIZES);
        this.mainAccountViewTable.setDisplayTransformers(this.MAV_transformers);
        this.mainAccountViewTable.setSortable(false);
        this.mainAccountViewTable.setSelectable(false);
        TableHelper.createMenu((CommonTable)this.mainAccountViewTable, null, (Action[])this.MAV_rowActions, (TableRowMethod)new MainAccountViewTableRowMethod());
        this.mainAccountViewTable.reload();
        TableHelper.setHeaderTooltips((CommonTable)this.mainAccountViewTable, (String[])MAV_TOOLTIPS);
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.GLComparison", "screen_name"));
        object.addUIObject((UIObject)new Header(this.subScreenName, "sub_screen_name"));
        object.addUIObject((UIObject)this.fg3);
        object.addUIObject((UIObject)this.mainAccountViewTable);
        this.previousType.setEnabled(true);
        this.nextType.setEnabled(true);
        if (this.currentIndex == 0) {
            this.previousType.setEnabled(false);
        }
        if (this.currentIndex == this.mainGLComparisonValues.size() - 1) {
            this.nextType.setEnabled(false);
        }
        object.addUIObject((UIObject)this.fb3B);
        return object;
    }

    private DataObject createMainAccountViewForCreditBalanceDetails(DataObject object) throws Exception {
        this.businessProcess.retrieveGLComparisonValueDetailsForCreditBalance(this.glComparisonValue);
        this.subScreenName = "";
        this.rfMA1.setDescription(this.glComparisonValue.getAcquisitionAccountDescription());
        this.rfMA1.setValue("" + Integer.parseInt(this.glComparisonValue.getAcquisitionAccount().trim()));
        Vector<InternalRow> maRows = new Vector<InternalRow>();
        for (int period = 0; period <= this.theNumberOfPeriods; ++period) {
            InternalRow maRow = new InternalRow();
            maRow.period = period;
            maRow.amount1 = this.glComparisonValue.getFigure(0, period);
            maRow.amount3 = this.glComparisonValue.getFigureYTD(0, period);
            maRow.amount2 = this.glComparisonValue.getFigure(1, period);
            maRow.amount4 = this.glComparisonValue.getFigureYTD(1, period);
            maRow.differenceIndicator_1 = this.glComparisonValue.getAcquisitionDetailDifference(period);
            maRows.add(maRow);
        }
        this.mainAccountViewTable = new CollectionTable(InternalRow.class, maRows, this.theNumberOfPeriods + 1);
        this.mainAccountViewTable.setName(PAGE + "-mavTable");
        this.mainAccountViewTable.setColumnNames(MAV_NAMES);
        this.mainAccountViewTable.setColumnLabels(MAV_LABELS);
        this.mainAccountViewTable.setColumnSizes(MAV_SIZES);
        this.mainAccountViewTable.setDisplayTransformers(this.MAV_transformers);
        this.mainAccountViewTable.setSortable(false);
        this.mainAccountViewTable.setSelectable(false);
        TableHelper.createMenu((CommonTable)this.mainAccountViewTable, null, (Action[])this.MAV_rowActions, (TableRowMethod)new MainAccountViewTableRowMethod());
        this.mainAccountViewTable.reload();
        TableHelper.setHeaderTooltips((CommonTable)this.mainAccountViewTable, (String[])MAV_TOOLTIPS);
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.GLComparison", "screen_name"));
        object.addUIObject((UIObject)new Header(this.subScreenName, "sub_screen_name"));
        object.addUIObject((UIObject)this.fg3);
        object.addUIObject((UIObject)this.mainAccountViewTable);
        this.previousType.setEnabled(true);
        this.nextType.setEnabled(true);
        if (this.currentIndex == 0) {
            this.previousType.setEnabled(false);
        }
        if (this.currentIndex == this.mainGLComparisonValues.size() - 1) {
            this.nextType.setEnabled(false);
        }
        object.addUIObject((UIObject)this.fb3B);
        return object;
    }

    private void initializeIFTransactionView() throws Exception {
        Action details = new Action("Button.Details").setAdapter(this.getProcessAdapterPageName(IncomingFinancialTransactionDetailAdapter.PAGE)).setMethod("showDetails");
        this.iftRowActions = new Action[]{details};
    }

    public DataObject showIFTTransactions(DataObject object) throws Exception {
        if (!this.IFTransactionViewInitialized) {
            this.initializeIFTransactionView();
            this.IFTransactionViewInitialized = true;
        }
        InternalRow row = (InternalRow)TableHelper.getSelectedItem((DataObject)object);
        if (row.period == 0) {
            return object;
        }
        Window window = new Window();
        window.setLabel(object.translate("Label.Transactions", object.getLocale()) + " " + this.year + "-" + row.period);
        this.period = row.period;
        this.useGreaterThan = this.period > this.numberOfPeriods;
        this.createIFTransactionTable();
        window.add((Table)this.iftTable);
        object.addUIObject((UIObject)window);
        return object;
    }

    private void createIFTransactionTable() throws Exception {
        IncomingFinancialTransactionForGLAccountQuery query = new IncomingFinancialTransactionForGLAccountQuery(this.dbData, this.companyId, this.glComparisonValue.getAcquisitionAccount(), this.year, this.period, this.useGreaterThan);
        this.iftTable = new ODBTable(IncomingFinancialTransaction.class, (ODBQuery)query, new String[]{"id"}, 12);
        this.iftTable.setName("CostAccountAdapter.IncomingFinancialTransaction1");
        this.iftTable.setCounter((ODBCounter)query);
        this.iftTable.setColumnNames(IFT_NAMES);
        this.iftTable.setColumnLabels(IFT_LABELS);
        this.iftTable.setColumnSizes(IFT_SIZES);
        this.iftTable.setDisplayTransformers(IFT_TRANSFORMERS);
        this.iftTable.setSortable(true);
        TableHelper.createMenu((Table)this.iftTable, null, (Action[])this.iftRowActions);
        this.iftTable.reload();
        TableHelper.setHeaderTooltips((CommonTable)this.iftTable, (String[])IFT_TOOLTIPS);
    }

    private void initializeTransactionView() throws Exception {
        Action details = new Action("Button.Details").setAdapter(this.getProcessAdapterPageName(TransactionAdapter.PAGE)).setMethod("show");
        Action incomingFinancialTransaction = new Action("Button.IncomingFinancialTransaction").setAdapter(this.getProcessAdapterPageName(IncomingFinancialTransactionDetailAdapter.PAGE)).setMethod("showDetails");
        this.transactionRowActions = new Action[]{details, incomingFinancialTransaction};
        ComboBox comboBox = EnumHelper.createComboBox("Label.TransactionType", TransactionTypeEnum.getCollection(), true);
        comboBox.setWidth("170");
        this.inputComponents.put("transactionType", comboBox);
    }

    public DataObject showMAVTransactions(DataObject object) throws Exception {
        if (!this.transactionViewInitialized) {
            this.initializeTransactionView();
            this.transactionViewInitialized = true;
        }
        InternalRow row = (InternalRow)TableHelper.getSelectedItem((DataObject)object);
        if (row.period == 0) {
            return object;
        }
        Window window = new Window();
        window.setLabel(object.translate("Label.Transactions", object.getLocale()) + " " + this.year + "-" + row.period);
        this.period = row.period;
        this.greaterThanPeriod = 0;
        if (this.period > this.numberOfPeriods) {
            this.greaterThanPeriod = this.numberOfPeriods;
        }
        this.typeIds = this.glComparisonValue.retrieveAssetTypeIds();
        if (!this.processParms.getGLBookValueRegistration()) {
            if (this.mainAccountSeqNr == 1) {
                this.mainTransactionType = 1;
                GOVGLComparisonAdapter.T_NAMES[2] = "valueForAmount1";
            }
            if (this.mainAccountSeqNr == 2) {
                this.mainTransactionType = 99;
                GOVGLComparisonAdapter.T_NAMES[2] = "valueForAmount2";
            }
            if (this.mainAccountSeqNr == 3) {
                this.mainTransactionType = 3;
                GOVGLComparisonAdapter.T_NAMES[2] = "valueForAmount2";
            }
            this.createMAVTransactionTable();
            window.add((Panel)this.searchPanel);
            window.add((Table)this.transactionTable);
        } else {
            TabbedPanel tabbedPanel = new TabbedPanel();
            Tab tab1 = new Tab("Label.AcquisitionValue");
            tabbedPanel.add(tab1);
            this.mainTransactionType = 1;
            GOVGLComparisonAdapter.T_NAMES[2] = "valueForAmount1";
            this.createMAVTransactionTable();
            tab1.add((Table)this.transactionTable);
            Tab tab2 = new Tab("Label.Depreciations");
            tabbedPanel.add(tab2);
            this.mainTransactionType = 99;
            GOVGLComparisonAdapter.T_NAMES[2] = "valueForAmount2";
            this.createMAVTransactionTable();
            tab2.add((Table)this.transactionTable);
            tabbedPanel.setActiveTab(0);
            Panel panel = new Panel();
            panel.addUIObject((UIObject)tabbedPanel);
            window.add((Panel)this.searchPanel);
            window.add(panel);
        }
        object.addUIObject((UIObject)window);
        return object;
    }

    private void createMAVTransactionTable() throws Exception {
        TransactionQuery query = new TransactionQuery(this.dbData, this.company, this.accountingPrinciple, this.cora, this.mainTransactionType, this.year, this.period, this.typeIds, this.greaterThanPeriod);
        this.transactionTable = new ODBTable(Transaction.class, (ODBQuery)query, new String[]{"bookYear", "period", "documentNr", "seqNr"}, 12);
        this.transactionTable.setName("mavTTable");
        this.transactionTable.setCounter((ODBCounter)query);
        this.transactionTable.setColumnNames(T_NAMES);
        this.transactionTable.setColumnLabels(T_LABELS);
        this.transactionTable.setColumnSizes(T_SIZES);
        this.transactionTable.setColumnTypes(T_TYPES);
        this.transactionTable.setDisplayTransformers(T_TRANSFORMERS);
        this.transactionTable.setColumnNoWraps(T_COLUMNNOWRAPS);
        this.transactionTable.setColumnSortable(T_SORTABLE);
        this.transactionTable.setInputComponents(this.inputComponents);
        this.transactionTable.setSortable(true);
        this.transactionTable.setSelectable(false);
        TableHelper.createMenu((CommonTable)this.transactionTable, null, (Action[])this.transactionRowActions, (TableRowMethod)new TransactionTableRowMethod());
        this.searchPanel = this.transactionTable.createSearch(T_SEARCH_NAMES, T_SEARCH_LABELS);
        Action filterAction = this.transactionTable.createFilterAction(T_SEARCH_NAMES, T_SEARCH_LABELS, 3);
        this.searchPanel.addAction(filterAction);
        this.transactionTable.reload();
        TableHelper.setHeaderTooltips((CommonTable)this.transactionTable, (String[])T_TOOLTIPS);
    }

    public DataObject showMultipleTypes(DataObject object) throws Exception {
        this.glComparisonValue = (ComparisonValue)TableHelper.getSelectedItem((DataObject)object);
        return this.createMultipleTypesView(object);
    }

    public DataObject createMultipleTypesView(DataObject object) throws Exception {
        if (!this.multipleTypesViewInitialized) {
            this.initializemultipleTypesView();
            this.multipleTypesViewInitialized = true;
        }
        this.businessProcess.retrieveGLComparisonValueDetails(this.glComparisonValue);
        this.subGLComparisonValues = new Vector<Serializable>();
        for (ComparisonValue subBean : this.glComparisonValues) {
            if (subBean.getBeanType() == 0 || !subBean.getAcquisitionAccount().equals(this.glComparisonValue.getAcquisitionAccount())) continue;
            this.subGLComparisonValues.add(subBean);
        }
        ComparisonValue totals = (ComparisonValue)this.glComparisonValue.clone();
        if (this.processParms.getGLBookValueRegistration()) {
            totals.setFACAcquisitionTotal(totals.getFACDepreciationTotal());
            totals.setFACDepreciationTotal(totals.getGLDepreciationTotal());
            totals.setCostTotalDifference(totals.getAcquisitionTotalDifference());
            totals.resetAcquisitionTotalDifference();
        }
        totals.setAssetTypeId(TranslationHelperImpl.getInstance().translate("Label.Total"));
        totals.setAssetTypeDescription(this.glComparisonValue.getAcquisitionAccountDescription());
        this.subGLComparisonValues.add(totals);
        this.subTable = new CollectionTable(ComparisonValue.class, this.subGLComparisonValues, 12);
        this.subTable.setName(PAGE + "-subTable");
        this.subTable.setColumnNames(SUB_NAMES);
        this.subTable.setColumnLabels(SUB_LABELS);
        this.subTable.setColumnSizes(SUB_SIZES);
        this.subTable.setDisplayTransformers(this.SUB_transformers);
        this.subTable.setSortable(false);
        this.subTable.setSelectable(false);
        TableHelper.createMenu((Table)this.subTable, null, null);
        this.subTable.reload();
        TableHelper.setHeaderTooltips((CommonTable)this.subTable, (String[])SUB_TOOLTIPS);
        Window window = new Window();
        window.setLabel(this.glComparisonValue.getAcquisitionAccountDescription() + " - " + object.translate("Label.MultipleTypesView", object.getLocale()));
        window.add((Table)this.subTable);
        object.addUIObject((UIObject)window);
        return object;
    }

    private void initializemultipleTypesView() throws Exception {
        if (this.processParms.getGLBookValueRegistration()) {
            GOVGLComparisonAdapter.SUB_NAMES[6] = "fACBookTotal";
            GOVGLComparisonAdapter.SUB_LABELS[3] = "";
            GOVGLComparisonAdapter.SUB_LABELS[5] = "";
            GOVGLComparisonAdapter.SUB_LABELS[6] = "Label.BookValue";
            GOVGLComparisonAdapter.SUB_LABELS[7] = "Label.BookTotalDifference";
            GOVGLComparisonAdapter.SUB_TOOLTIPS[0] = "Label.BookTotalDifference";
            GOVGLComparisonAdapter.SUB_TOOLTIPS[1] = "";
            GOVGLComparisonAdapter.SUB_TOOLTIPS[2] = "";
        }
    }

    public DataObject showInvestmentAndDisinvestment(DataObject object) throws Exception {
        this.glComparisonValue = (ComparisonValue)TableHelper.getSelectedItem((DataObject)object);
        return this.createInvestmentAndDisinvestmentView(object);
    }

    public DataObject createInvestmentAndDisinvestmentView(DataObject object) throws Exception {
        if (!this.investmentAndDisinvestmentViewInitialized) {
            this.initializeInvestmentAndDisinvestmentView();
            this.investmentAndDisinvestmentViewInitialized = true;
        }
        this.businessProcess.retrieveGLComparisonValueDetails(this.glComparisonValue);
        Vector<InternalRow> rows = new Vector<InternalRow>();
        for (int i = 0; i < 5; ++i) {
            InternalRow row = new InternalRow();
            row.seqNbr = i;
            switch (i) {
                case 0: {
                    row.description = object.translate("Label.OpeningBalance", object.getLocale());
                    row.amount1 = this.glComparisonValue.getFigureYTD(1, 0);
                    row.amount2 = this.glComparisonValue.getFigureYTD(3, 0);
                    break;
                }
                case 1: {
                    row.description = object.translate("Label.Investments", object.getLocale());
                    row.amount1 = this.glComparisonValue.getInvestmentTotalAcquisition();
                    row.amount2 = ZERO;
                    break;
                }
                case 2: {
                    row.description = object.translate("Label.Disinvestments", object.getLocale());
                    row.amount1 = this.glComparisonValue.getDisinvestmentTotalAcquisition();
                    row.amount2 = this.glComparisonValue.getDisinvestmentTotalDepreciation();
                    break;
                }
                case 3: {
                    row.description = object.translate("Label.DepreciationCosts", object.getLocale());
                    row.amount1 = ZERO;
                    row.amount2 = this.glComparisonValue.getFACCostTotal();
                    break;
                }
                case 4: {
                    row.description = object.translate("Label.ClosingBalance", object.getLocale());
                    if (this.processParms.getGLBookValueRegistration()) {
                        row.amount1 = this.glComparisonValue.getFACDepreciationTotal();
                        row.amount2 = this.glComparisonValue.getGLDepreciationTotal();
                        row.differenceIndicator_3 = this.glComparisonValue.getAcquisitionTotalDifference();
                        break;
                    }
                    row.amount1 = this.glComparisonValue.getFACAcquisitionTotal();
                    row.amount2 = this.glComparisonValue.getFACDepreciationTotal();
                    row.differenceIndicator_1 = this.glComparisonValue.getAcquisitionTotalDifference();
                    row.differenceIndicator_2 = this.glComparisonValue.getDepreciationTotalDifference();
                }
            }
            row.amount3 = row.amount1.subtract(row.amount2);
            rows.add(row);
        }
        this.iadTable = new CollectionTable(InternalRow.class, rows, 12);
        this.iadTable.setName(PAGE + "-iadTable");
        this.iadTable.setColumnNames(IAD_NAMES);
        this.iadTable.setColumnLabels(IAD_LABELS);
        this.iadTable.setColumnSizes(IAD_SIZES);
        this.iadTable.setDisplayTransformers(this.IAD_transformers);
        this.iadTable.setSortable(false);
        this.iadTable.setSelectable(false);
        TableHelper.createMenu((CommonTable)this.iadTable, null, (Action[])this.IAD_rowActions, (TableRowMethod)new InvestmentAndDisinvestmentTableRowMethod());
        this.iadTable.reload();
        TableHelper.setHeaderTooltips((CommonTable)this.iadTable, (String[])IAD_TOOLTIPS);
        Window window = new Window();
        window.setLabel(this.glComparisonValue.getAcquisitionAccountDescription() + " - " + object.translate("Label.InvestmentsAndDisinvestments", object.getLocale()) + " " + this.byfYear.getValue());
        window.add((Table)this.iadTable);
        object.addUIObject((UIObject)window);
        return object;
    }

    private void initializeInvestmentAndDisinvestmentView() throws Exception {
        if (this.processParms.getGLBookValueRegistration()) {
            GOVGLComparisonAdapter.IAD_LABELS[2] = "";
            GOVGLComparisonAdapter.IAD_LABELS[4] = "";
            GOVGLComparisonAdapter.IAD_TOOLTIPS[0] = "";
            GOVGLComparisonAdapter.IAD_TOOLTIPS[1] = "";
        } else {
            GOVGLComparisonAdapter.IAD_LABELS[6] = "";
            GOVGLComparisonAdapter.IAD_TOOLTIPS[2] = "";
        }
    }

    public DataObject showIADTransactions(DataObject object) throws Exception {
        if (!this.transactionViewInitialized) {
            this.initializeTransactionView();
        }
        InternalRow row = (InternalRow)TableHelper.getSelectedItem((DataObject)object);
        if (row.seqNbr != 1 && row.seqNbr != 2) {
            return object;
        }
        Window window = new Window();
        if (row.seqNbr == 1) {
            window.setLabel(this.glComparisonValue.getAcquisitionAccountDescription() + " - " + object.translate("Label.Investments", object.getLocale()) + " " + this.year);
            this.mainTransactionType = 1;
        }
        if (row.seqNbr == 2) {
            window.setLabel(this.glComparisonValue.getAcquisitionAccountDescription() + " - " + object.translate("Label.Disinvestments", object.getLocale()) + " " + this.year);
            this.mainTransactionType = 2;
        }
        this.period = 99;
        this.greaterThanPeriod = 0;
        this.typeIds = this.glComparisonValue.retrieveAssetTypeIds();
        this.createIADTransactionTable(object);
        window.add((Panel)this.searchPanel);
        window.add((Table)this.transactionTable);
        object.addUIObject((UIObject)window);
        return object;
    }

    private void createIADTransactionTable(DataObject object) throws Exception {
        TransactionQuery query = new TransactionQuery(this.dbData, this.company, this.accountingPrinciple, this.cora, this.mainTransactionType, this.year, this.period, this.typeIds, this.greaterThanPeriod);
        this.transactionTable = new ODBTable(Transaction.class, (ODBQuery)query, new String[]{"bookYear", "period", "documentNr", "seqNr"}, 12);
        this.transactionTable.setName("iadTTable");
        this.transactionTable.setCounter((ODBCounter)query);
        this.transactionTable.setColumnNames(TT_NAMES);
        this.transactionTable.setColumnLabels(TT_LABELS);
        this.transactionTable.setColumnSizes(TT_SIZES);
        this.transactionTable.setColumnTypes(TT_TYPES);
        this.transactionTable.setDisplayTransformers(TT_TRANSFORMERS);
        this.transactionTable.setColumnNoWraps(TT_COLUMNNOWRAPS);
        this.transactionTable.setColumnSortable(TT_SORTABLE);
        this.transactionTable.setInputComponents(this.inputComponents);
        this.transactionTable.setSortable(true);
        this.transactionTable.setSelectable(false);
        TableHelper.createMenu((CommonTable)this.transactionTable, null, (Action[])this.transactionRowActions, (TableRowMethod)new TransactionTableRowMethod());
        this.searchPanel = this.transactionTable.createSearch(TT_SEARCH_NAMES, TT_SEARCH_LABELS);
        Action filterAction = this.transactionTable.createFilterAction(TT_SEARCH_NAMES, TT_SEARCH_LABELS, 3);
        this.searchPanel.addAction(filterAction);
        this.transactionTable.reload();
        TableHelper.setHeaderTooltips((CommonTable)this.transactionTable, (String[])TT_TOOLTIPS);
    }

    private class TransactionTableRowMethod
    implements TableRowMethod,
    Serializable {
        private static final long serialVersionUID = 1831254000940657085L;

        private TransactionTableRowMethod() {
        }

        public void postprocesCreatedRow(TableRow row, ContextAction[] rowActions) throws Exception {
            Transaction transaction = (Transaction)row.getObject();
            ContextMenu menu = new ContextMenu();
            for (int i = 0; i < rowActions.length; ++i) {
                if (i == 1 && transaction.getIncomingFinancialTransaction() == null) continue;
                ContextAction rowAction = new ContextAction(rowActions[i].getName());
                rowAction.setAdapter(rowActions[i].getPageid());
                rowAction.setMethod(rowActions[i].getMethod());
                menu.addContextMenuItem(rowAction);
            }
            row.setContextMenu(menu);
        }
    }

    private class InvestmentAndDisinvestmentTableRowMethod
    implements TableRowMethod,
    Serializable {
        private static final long serialVersionUID = 8385678926615648537L;

        private InvestmentAndDisinvestmentTableRowMethod() {
        }

        public void postprocesCreatedRow(TableRow row, ContextAction[] rowActions) throws Exception {
            InternalRow internalRow = (InternalRow)row.getObject();
            ContextMenu menu = new ContextMenu();
            ContextAction rowAction = new ContextAction(rowActions[0].getName());
            if (internalRow.seqNbr == 1 || internalRow.seqNbr == 2) {
                rowAction.setAdapter(rowActions[0].getPageid());
                rowAction.setMethod(rowActions[0].getMethod());
            } else {
                rowAction.setEnabled(false);
            }
            menu.addContextMenuItem(rowAction);
            row.setContextMenu(menu);
        }
    }

    private class MainAccountViewTableRowMethod
    implements TableRowMethod,
    Serializable {
        private static final long serialVersionUID = 173490715489703693L;

        private MainAccountViewTableRowMethod() {
        }

        public void postprocesCreatedRow(TableRow row, ContextAction[] rowActions) throws Exception {
            InternalRow internalRow = (InternalRow)row.getObject();
            ContextMenu menu = new ContextMenu();
            ContextAction rowAction = new ContextAction(rowActions[0].getName());
            if (internalRow.period > 0) {
                rowAction.setAdapter(rowActions[0].getPageid());
                rowAction.setMethod(rowActions[0].getMethod());
            } else {
                rowAction.setEnabled(false);
            }
            menu.addContextMenuItem(rowAction);
            row.setContextMenu(menu);
        }
    }

    private class GLComparisonValueTableRowMethod
    implements TableRowMethod,
    Serializable {
        private static final long serialVersionUID = 8783248279555229442L;

        private GLComparisonValueTableRowMethod() {
        }

        public void postprocesCreatedRow(TableRow row, ContextAction[] rowActions) throws Exception {
            ComparisonValue glComparisonValue = (ComparisonValue)row.getObject();
            ContextMenu menu = new ContextMenu();
            for (int i = 0; i < rowActions.length; ++i) {
                ContextAction rowAction;
                if (GOVGLComparisonAdapter.this.accountingPrinciple == 3) {
                    if (i != 0) continue;
                    rowAction = new ContextAction(GOVGLComparisonAdapter.this.creditBalanceDetailAction.getName());
                    rowAction.setAdapter(GOVGLComparisonAdapter.this.creditBalanceDetailAction.getPageid());
                    rowAction.setMethod(GOVGLComparisonAdapter.this.creditBalanceDetailAction.getMethod());
                    menu.addContextMenuItem(rowAction);
                    continue;
                }
                if (GOVGLComparisonAdapter.this.processParms.getGLBookValueRegistration()) {
                    if (i == 0) {
                        rowAction = new ContextAction(GOVGLComparisonAdapter.this.bookValueRegistrationAction.getName());
                        rowAction.setAdapter(GOVGLComparisonAdapter.this.bookValueRegistrationAction.getPageid());
                        rowAction.setMethod(GOVGLComparisonAdapter.this.bookValueRegistrationAction.getMethod());
                        menu.addContextMenuItem(rowAction);
                    }
                    if (i < 3) continue;
                }
                if (i == 3) {
                    menu.addContextMenuItem(new Separator());
                    if (!glComparisonValue.getMultipleTypes()) continue;
                }
                rowAction = new ContextAction(rowActions[i].getName());
                rowAction.setAdapter(rowActions[i].getPageid());
                rowAction.setMethod(rowActions[i].getMethod());
                menu.addContextMenuItem(rowAction);
            }
            row.setContextMenu(menu);
        }
    }

    public class InternalRow
    implements Serializable {
        private static final long serialVersionUID = 6253036941608626499L;
        public static final String PERIOD = "period";
        public static final String DESCRIPTION = "description";
        public static final String AMOUNT1 = "amount1";
        public static final String AMOUNT2 = "amount2";
        public static final String AMOUNT3 = "amount3";
        public static final String AMOUNT4 = "amount4";
        public static final String DIFFERENCE_INDICATOR_1 = "differenceIndicator_1";
        public static final String DIFFERENCE_INDICATOR_2 = "differenceIndicator_2";
        public static final String DIFFERENCE_INDICATOR_3 = "differenceIndicator_3";
        int seqNbr;
        int period;
        String description;
        BigDecimal amount1;
        BigDecimal amount2;
        BigDecimal amount3;
        BigDecimal amount4;
        BigDecimal differenceIndicator_1;
        BigDecimal differenceIndicator_2;
        BigDecimal differenceIndicator_3;

        InternalRow() {
        }

        public int getPeriod() {
            return this.period;
        }

        public String getDescription() {
            return this.description;
        }

        public BigDecimal getAmount1() {
            return this.amount1;
        }

        public BigDecimal getAmount2() {
            return this.amount2;
        }

        public BigDecimal getAmount3() {
            return this.amount3;
        }

        public BigDecimal getAmount4() {
            return this.amount4;
        }

        public BigDecimal getDifferenceIndicator_1() {
            return this.differenceIndicator_1;
        }

        public BigDecimal getDifferenceIndicator_2() {
            return this.differenceIndicator_2;
        }

        public BigDecimal getDifferenceIndicator_3() {
            return this.differenceIndicator_3;
        }
    }
}

