/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.gov.boadapters;

import java.math.BigDecimal;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.CreditBalance;
import nl.ibs.fac.db.CreditBalanceDetail;
import nl.ibs.fac.db.CreditBalanceDetailDataBean;
import nl.ibs.fac.db.CreditBalanceDetailManager;
import nl.ibs.fac.db.CreditBalanceDetailManagerFactory;
import nl.ibs.fac.db.CreditBalanceDetailPK;
import nl.ibs.fac.db.IncomingFinancialTransaction;
import nl.ibs.fac.gov.boadapters.CreditBalanceBO;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransaction;
import nl.ibs.jsql.exception.FinderException;

public abstract class CreditBalanceDetailBO
extends BOAdapter {
    public static Object[] get(Company company, String id, int year, int creditBalanceDetailType) throws Exception {
        Object[] result = new Object[2];
        CreditBalanceDetailPK key = new CreditBalanceDetailPK();
        key.setCompanyId(company.getId());
        key.setGLAccountId(id);
        key.setYear(year);
        key.setCreditBalanceDetailType(creditBalanceDetailType);
        try {
            result[0] = CreditBalanceDetailManagerFactory.getInstance(company.getDBData()).findByPrimaryKey(key);
        }
        catch (FinderException e) {
            result[1] = "key_not_found";
        }
        return result;
    }

    public static Object[] create(Company company, IncomingFinancialTransaction ift, String creditId) throws Exception {
        Object[] result = new Object[2];
        CreditBalanceDetailManager manager = CreditBalanceDetailManagerFactory.getInstance(company.getDBData());
        CreditBalanceDetailDataBean bean = new CreditBalanceDetailDataBean();
        bean.setCompanyId(company.getId());
        bean.setGLAccountId(ift.getMainAccount());
        bean.setYear(ift.getBookYear());
        bean.setCreditId(creditId);
        bean.setCreditBalanceDetailType(0);
        switch (ift.getBBVCategory()) {
            case 0: {
                bean.setBalanceAmount1(ift.getTransactionValue());
                break;
            }
            case 1: {
                bean.setBalanceAmount2(ift.getTransactionValue());
                break;
            }
            case 2: {
                bean.setBalanceAmount3(ift.getTransactionValue());
            }
        }
        boolean alreadyActive = CreditBalanceDetailBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            result[0] = manager.create(bean);
            CreditBalanceDetailBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            result[1] = CreditBalanceDetailBO.investigate(e, dbTransaction);
        }
        return result;
    }

    public static String update(CreditBalanceDetail detail, IncomingFinancialTransaction ift) throws Exception {
        boolean alreadyActive = CreditBalanceDetailBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            switch (ift.getBBVCategory()) {
                case 0: {
                    detail.setBalanceAmount1(detail.getBalanceAmount1().add(ift.getTransactionValue()));
                    break;
                }
                case 1: {
                    detail.setBalanceAmount2(detail.getBalanceAmount2().add(ift.getTransactionValue()));
                    break;
                }
                case 2: {
                    detail.setBalanceAmount3(detail.getBalanceAmount3().add(ift.getTransactionValue()));
                }
            }
            CreditBalanceDetailBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            return CreditBalanceDetailBO.investigate(e, dbTransaction);
        }
        return null;
    }

    public static void updateInterestTotal(Company company, String id, int year, int cbdType, String creditId, BigDecimal amount) throws Exception {
        CreditBalanceDetail cbd = (CreditBalanceDetail)CreditBalanceDetailBO.get(company, id, year, cbdType)[0];
        if (cbd == null) {
            CreditBalanceDetailManager manager = CreditBalanceDetailManagerFactory.getInstance(company.getDBData());
            CreditBalanceDetailDataBean bean = new CreditBalanceDetailDataBean();
            bean.setCompanyId(company.getId());
            bean.setGLAccountId(id);
            bean.setYear(year);
            bean.setCreditId(creditId);
            bean.setCreditBalanceDetailType(0);
            cbd = manager.create(bean);
        }
        cbd.setBalanceAmount5(cbd.getBalanceAmount5().add(amount));
        CreditBalance cb = (CreditBalance)CreditBalanceBO.get(company, id)[0];
        cb.setTotalInterestAmount(cb.getTotalInterestAmount().add(amount));
    }
}

