/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.gov.boadapters;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Iterator;
import nl.ibs.esp.language.TranslationHelperImpl;
import nl.ibs.fac.boadapters.AssetTypeAccountingPrincipleDefaultBO;
import nl.ibs.fac.boadapters.AssetTypeBO;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.InterestTableBO;
import nl.ibs.fac.boadapters.MemoBO;
import nl.ibs.fac.boadapters.YearPercentageTableBO;
import nl.ibs.fac.db.AssetType;
import nl.ibs.fac.db.AssetTypeAccountingPrincipleDefault;
import nl.ibs.fac.db.Credit;
import nl.ibs.fac.db.DetailEstimationTransaction;
import nl.ibs.fac.db.DetailEstimationTransactionManagerFactory;
import nl.ibs.fac.db.DetailEstimationTransactionPK;
import nl.ibs.fac.db.InterestTable;
import nl.ibs.fac.db.Memo;
import nl.ibs.fac.db.TotalEstimationTransaction;
import nl.ibs.fac.db.TotalEstimationTransactionDataBean;
import nl.ibs.fac.db.TotalEstimationTransactionManagerFactory;
import nl.ibs.fac.db.YearPercentageTable;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransaction;
import nl.ibs.jsql.ExecutableQuery;
import nl.ibs.jsql.QueryFactory;

public abstract class TotalEstimationTransactionBO
extends BOAdapter {
    public static Collection<?> getEstimationTransactions(Credit credit, Boolean forEstimation) throws Exception {
        String sql = "companyId = '" + credit.getCompanyId() + "' AND " + "creditId" + " = '" + credit.getId() + "'";
        if (forEstimation != null) {
            sql = forEstimation != false ? sql + " AND " + "estimationTransactionType" + " < " + 100 : sql + " AND " + "estimationTransactionType" + " >= " + 100;
        }
        ExecutableQuery query = QueryFactory.create(TotalEstimationTransaction.class, sql, "estimationTransactionType");
        return TotalEstimationTransactionManagerFactory.getInstance(credit.getDBData()).getCollection(query);
    }

    public static TotalEstimationTransaction getEstimationTransaction(Credit credit) throws Exception {
        ExecutableQuery query = QueryFactory.create(TotalEstimationTransaction.class, "companyId = '" + credit.getCompanyId() + "' AND " + "creditId" + " = '" + credit.getId() + "' AND " + "estimationTransactionType" + " = " + 0);
        return TotalEstimationTransactionManagerFactory.getInstance(credit.getDBData()).getFirstObject(query);
    }

    public static TotalEstimationTransaction getBaseActivationSchemeTransaction(Credit credit) throws Exception {
        ExecutableQuery query = QueryFactory.create(TotalEstimationTransaction.class, "companyId = '" + credit.getCompanyId() + "' AND " + "creditId" + " = '" + credit.getId() + "' AND " + "estimationTransactionType" + " = " + 100);
        return TotalEstimationTransactionManagerFactory.getInstance(credit.getDBData()).getFirstObject(query);
    }

    public static BigDecimal getTotalCreditAmount(Credit credit) throws Exception {
        BigDecimal result = new BigDecimal("0.00");
        for (TotalEstimationTransaction transaction : TotalEstimationTransactionBO.getEstimationTransactions(credit, new Boolean(true))) {
            result = result.add(transaction.getTotalTransactionAmount());
        }
        return result;
    }

    public static TotalEstimationTransaction createTransaction(Credit credit, int type, String description, BigDecimal amount, String assetTypeId) throws Exception {
        int internalNumberMax = TotalEstimationTransactionManagerFactory.getInstance(credit.getDBData()).getInternalNumberMax(credit.getCompanyId());
        TotalEstimationTransactionDataBean bean = new TotalEstimationTransactionDataBean();
        bean.setInternalNumber(internalNumberMax + 1);
        bean.setCompanyId(credit.getCompanyId());
        bean.setCreditId(credit.getId());
        bean.setEstimationTransactionType(type);
        bean.setTotalTransactionAmount(amount);
        bean.setDescription(description);
        bean.setAssetTypeId(assetTypeId);
        return TotalEstimationTransactionManagerFactory.getInstance(credit.getDBData()).create(bean);
    }

    public static DetailEstimationTransaction createDetailTransaction(TotalEstimationTransaction totalEstimationTransaction, Credit credit) throws Exception {
        DetailEstimationTransactionPK key = new DetailEstimationTransactionPK();
        key.setCompanyId(totalEstimationTransaction.getCompanyId());
        key.setParentNumber(totalEstimationTransaction.getInternalNumber());
        key.setYear(credit.getEndYear() + 1);
        DetailEstimationTransaction detailEstimationTransaction = DetailEstimationTransactionManagerFactory.getInstance(totalEstimationTransaction.getDBData()).findOrCreate(key);
        detailEstimationTransaction.setCreditId(credit.getId());
        detailEstimationTransaction.setDetailTransactionAmount(totalEstimationTransaction.getTotalTransactionAmount());
        detailEstimationTransaction.setEstimationTransactionType(totalEstimationTransaction.getEstimationTransactionType());
        return detailEstimationTransaction;
    }

    public static void updateValuation(TotalEstimationTransaction totalEstimationTransaction, int depreciationMethod, String yearPercentageTableId, BigDecimal degressivePercentage, String annuityInterestTableId, BigDecimal annuityPercentage, int startPeriodHandlingMethod, int depreciatableLife, BigDecimal residualPercentage, BigDecimal residualValue, int interestCalculationMethod, String interestTableId, int numberOfPeriods, BigDecimal interestPercentage) throws Exception {
        totalEstimationTransaction.setDepreciationMethod(depreciationMethod);
        YearPercentageTable yearPercentageTable = null;
        if (yearPercentageTableId != null && yearPercentageTableId.trim().length() > 0) {
            yearPercentageTable = (YearPercentageTable)YearPercentageTableBO.get(totalEstimationTransaction.getDBData(), yearPercentageTableId)[0];
        }
        totalEstimationTransaction.setYearPercentageTable(yearPercentageTable);
        totalEstimationTransaction.setDegressivePercentage(degressivePercentage);
        totalEstimationTransaction.setAnnuityPercentage(annuityPercentage);
        InterestTable interestTable = null;
        if (annuityInterestTableId != null && annuityInterestTableId.length() > 0) {
            interestTable = (InterestTable)InterestTableBO.get(totalEstimationTransaction.getDBData(), annuityInterestTableId, numberOfPeriods)[0];
        }
        totalEstimationTransaction.setAnnuityInterestTable(interestTable);
        totalEstimationTransaction.setStartPeriodHandlingMethod(startPeriodHandlingMethod);
        totalEstimationTransaction.setDepreciatableLife(depreciatableLife);
        totalEstimationTransaction.setResidualPercentage(residualPercentage);
        totalEstimationTransaction.setResidualValue(residualValue);
        totalEstimationTransaction.setInterestCalculationMethod(interestCalculationMethod);
        interestTable = null;
        if (interestTableId != null && interestTableId.length() > 0) {
            interestTable = (InterestTable)InterestTableBO.get(totalEstimationTransaction.getDBData(), interestTableId, numberOfPeriods)[0];
        }
        totalEstimationTransaction.setInterestTable(interestTable);
        totalEstimationTransaction.setInterestPercentage(interestPercentage);
    }

    public static void createEstimationTransactions(Credit credit) throws Exception {
        for (TotalEstimationTransaction totalEstimationTransaction : TotalEstimationTransactionBO.getEstimationTransactions(credit, new Boolean(true))) {
            if (totalEstimationTransaction.getEstimationTransactionType() == 0) {
                credit.setOriginalInvestmentCreditAmount(totalEstimationTransaction.getTotalTransactionAmount());
            }
            String whereClause = "companyId = '" + credit.getCompanyId() + "' AND " + "parentNumber" + " = " + totalEstimationTransaction.getInternalNumber() + " AND ( " + "year" + " < " + credit.getStartYear() + " OR " + "year" + " > " + credit.getEndYear() + " ) ";
            DetailEstimationTransactionManagerFactory.getInstance(credit.getDBData()).generalDelete(whereClause);
            DetailEstimationTransactionPK key = new DetailEstimationTransactionPK();
            key.setCompanyId(credit.getCompanyId());
            key.setParentNumber(totalEstimationTransaction.getInternalNumber());
            for (int year = credit.getStartYear(); year <= credit.getEndYear(); ++year) {
                key.setYear(year);
                DetailEstimationTransaction detailEstimationTransaction = DetailEstimationTransactionManagerFactory.getInstance(credit.getDBData()).findOrCreate(key);
                if (detailEstimationTransaction.getCreditId() == null) {
                    detailEstimationTransaction.setCreditId(credit.getId());
                }
                if (credit.getStartYear() == credit.getEndYear()) {
                    detailEstimationTransaction.setDetailTransactionAmount(totalEstimationTransaction.getTotalTransactionAmount());
                }
                detailEstimationTransaction.setEstimationTransactionType(totalEstimationTransaction.getEstimationTransactionType());
            }
        }
    }

    public static void createActivationSchemeTransactions(Credit credit) throws Exception {
        Iterator<Object> iterator = TotalEstimationTransactionBO.getEstimationTransactions(credit, new Boolean(false)).iterator();
        if (credit.getIsResultAccountItem()) {
            while (iterator.hasNext()) {
                TotalEstimationTransaction totalEstimationTransaction = (TotalEstimationTransaction)iterator.next();
                TotalEstimationTransactionBO.delete(totalEstimationTransaction);
            }
        } else {
            DetailEstimationTransaction detailEstimationTransaction;
            TotalEstimationTransaction totalEstimationTransaction;
            BigDecimal totalAmount = TotalEstimationTransactionBO.getTotalCreditAmount(credit);
            TotalEstimationTransaction transaction100 = null;
            TotalEstimationTransaction transaction104 = null;
            while (iterator.hasNext()) {
                totalEstimationTransaction = (TotalEstimationTransaction)iterator.next();
                Iterator iterator2 = totalEstimationTransaction.getDetailEstimationTransactionsCollection(QueryFactory.create()).iterator();
                detailEstimationTransaction = (DetailEstimationTransaction)iterator2.next();
                detailEstimationTransaction.setYear(9999);
                switch (totalEstimationTransaction.getEstimationTransactionType()) {
                    case 100: {
                        transaction100 = totalEstimationTransaction;
                        totalAmount = totalAmount.subtract(totalEstimationTransaction.getTotalTransactionAmount());
                        break;
                    }
                    case 102: {
                        totalAmount = totalAmount.subtract(totalEstimationTransaction.getTotalTransactionAmount());
                        break;
                    }
                    case 104: {
                        transaction104 = totalEstimationTransaction;
                    }
                }
            }
            if (transaction100 == null) {
                String description = "";
                AssetType assetType = (AssetType)AssetTypeBO.get(credit.getDBData(), credit.getCompanyId(), credit.getProFormaTypeId())[0];
                if (assetType != null) {
                    description = assetType.getDescription();
                }
                totalEstimationTransaction = TotalEstimationTransactionBO.createTransaction(credit, 100, description, credit.getOriginalInvestmentCreditAmount(), credit.getProFormaTypeId());
                TotalEstimationTransactionBO.createDetailTransaction(totalEstimationTransaction, credit);
                TotalEstimationTransactionBO.setBasicActivationSchemeTransactionDefaults(totalEstimationTransaction);
                totalAmount = totalAmount.subtract(totalEstimationTransaction.getTotalTransactionAmount());
            } else {
                transaction100.setAssetTypeId(credit.getProFormaTypeId());
            }
            if (totalAmount.doubleValue() == 0.0) {
                if (transaction104 != null) {
                    TotalEstimationTransactionBO.delete(transaction104);
                }
            } else if (transaction104 == null) {
                totalEstimationTransaction = TotalEstimationTransactionBO.createTransaction(credit, 104, TranslationHelperImpl.getInstance().translate("difference_with_estimation"), totalAmount, "");
                TotalEstimationTransactionBO.createDetailTransaction(totalEstimationTransaction, credit);
            } else {
                transaction104.setTotalTransactionAmount(totalAmount);
                iterator = transaction104.getDetailEstimationTransactionsCollection(QueryFactory.create()).iterator();
                detailEstimationTransaction = (DetailEstimationTransaction)iterator.next();
                detailEstimationTransaction.setDetailTransactionAmount(transaction104.getTotalTransactionAmount());
            }
        }
    }

    private static void setBasicActivationSchemeTransactionDefaults(TotalEstimationTransaction tet) throws Exception {
        AssetTypeAccountingPrincipleDefault atapd = (AssetTypeAccountingPrincipleDefault)AssetTypeAccountingPrincipleDefaultBO.get(tet.getDBData(), tet.getCompanyId(), tet.getAssetTypeId(), 1)[0];
        if (atapd != null) {
            tet.setDepreciationMethod(atapd.getDepreciationMethod());
            tet.setStartPeriodHandlingMethod(atapd.getStartPeriodHandlingMethod());
            tet.setDegressivePercentage(atapd.getDegressivePercentage());
            tet.setYearPercentageTable(atapd.getYearPercentageTable());
            tet.setAnnuityPercentage(atapd.getAnnuityPercentage());
            tet.setAnnuityInterestTable(atapd.getAnnuityInterestTable());
            tet.setDepreciatableLife(atapd.getDepreciatableLife());
            tet.setResidualValue(atapd.getResidualValue());
            tet.setResidualPercentage(atapd.getResidualPercentage());
            tet.setInterestCalculationMethod(atapd.getInterestCalculationMethod());
            tet.setInterestPercentage(atapd.getInterestPercentage());
            tet.setInterestTable(atapd.getInterestTable());
        }
        Iterator detIterator = tet.getDetailEstimationTransactionsCollection(QueryFactory.create()).iterator();
        DetailEstimationTransaction detailEstimationTransaction = (DetailEstimationTransaction)detIterator.next();
        detailEstimationTransaction.setYear(9999);
    }

    public static void updateBasicTransactions(Credit credit) throws Exception {
        for (TotalEstimationTransaction tet : TotalEstimationTransactionBO.getEstimationTransactions(credit, null)) {
            if (tet.getEstimationTransactionType() == 100) {
                TotalEstimationTransactionBO.setBasicActivationSchemeTransactionDefaults(tet);
            }
            if (tet.getEstimationTransactionType() != 0) continue;
            for (DetailEstimationTransaction detailEstimationTransaction : tet.getDetailEstimationTransactionsCollection(QueryFactory.create())) {
                if (detailEstimationTransaction.getYear() != credit.getStartYear()) continue;
                detailEstimationTransaction.setDetailTransactionAmount(tet.getTotalTransactionAmount());
            }
        }
    }

    public static void changeActivationTransaction(Credit credit, TotalEstimationTransaction totalEstimationTransaction, String assetTypeId, BigDecimal transactionAmount, String description) throws Exception {
        if (totalEstimationTransaction.getEstimationTransactionType() == 100) {
            credit.setProFormaTypeId(assetTypeId);
        }
        totalEstimationTransaction.setAssetTypeId(assetTypeId);
        totalEstimationTransaction.setTotalTransactionAmount(transactionAmount);
        totalEstimationTransaction.setDescription(description);
        Iterator iterator = totalEstimationTransaction.getDetailEstimationTransactionsCollection(QueryFactory.create()).iterator();
        DetailEstimationTransaction detailEstimationTransaction = (DetailEstimationTransaction)iterator.next();
        detailEstimationTransaction.setDetailTransactionAmount(totalEstimationTransaction.getTotalTransactionAmount());
    }

    public static void changeEstimationTransaction(Credit credit, TotalEstimationTransaction totalEstimationTransaction, BigDecimal transactionAmount, String description, int category) throws Exception {
        totalEstimationTransaction.setDescription(description);
        totalEstimationTransaction.setTotalTransactionAmount(transactionAmount);
        if (totalEstimationTransaction.getEstimationTransactionType() == 0) {
            credit.setOriginalInvestmentCreditAmount(transactionAmount);
        }
        totalEstimationTransaction.setBBVCategory(category);
        for (DetailEstimationTransaction detailEstimationTransaction : totalEstimationTransaction.getDetailEstimationTransactionsCollection(QueryFactory.create())) {
            detailEstimationTransaction.setBBVCategory(totalEstimationTransaction.getBBVCategory());
            if (credit.getStartYear() != credit.getEndYear()) continue;
            detailEstimationTransaction.setDetailTransactionAmount(totalEstimationTransaction.getTotalTransactionAmount());
        }
    }

    public static String delete(TotalEstimationTransaction totalEstimationTransaction) throws Exception {
        boolean alreadyActive = TotalEstimationTransactionBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            String message = null;
            if (totalEstimationTransaction.getHasMemo()) {
                Object[] oa = MemoBO.get(totalEstimationTransaction);
                message = oa[0] == null ? (String)oa[1] : MemoBO.delete(totalEstimationTransaction, (Memo)oa[0]);
            }
            if (message != null) {
                return message;
            }
            totalEstimationTransaction.delete();
            TotalEstimationTransactionBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            return TotalEstimationTransactionBO.investigate(e, dbTransaction);
        }
        return null;
    }
}

