/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.gov.bp;

import java.math.BigDecimal;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.BookYearBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.bp.GenericTransactionBP;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Credit;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransaction;

public class CreditAdditionalDepreciationBP
extends GenericTransactionBP {
    private static final long serialVersionUID = 546352479696049433L;

    public CreditAdditionalDepreciationBP(Company company, int numberOfPeriods) throws Exception {
        super(company, numberOfPeriods);
    }

    public String[] validateFACYearAndPeriod(Credit credit, int facYear, int facPeriod) throws Exception {
        int status;
        String[] messages = new String[2];
        int index = 0;
        if (facYear < credit.getStartYear()) {
            messages[index] = "FACPeriodBeforeCreditStartYear";
            ++index;
        }
        if (facYear > credit.getEndYear()) {
            messages[index] = "FACPeriodAfterCreditEndYear";
            ++index;
        }
        if ((status = BookYearBO.getPeriodStatus(this.company, facYear, facPeriod)) == 0) {
            messages[index] = "bookYear_not_found";
            ++index;
        }
        if (status == 1) {
            messages[index] = "FACPeriodBlockedForManualTransactions";
            ++index;
        }
        if (index == 0) {
            messages = null;
        }
        return messages;
    }

    public String[] validateAmounts(BigDecimal bd1, BigDecimal bd2) throws Exception {
        String[] messages = new String[1];
        int index = 0;
        if (!(bd1 != null && bd1.doubleValue() != 0.0 || bd2 != null && bd2.doubleValue() != 0.0)) {
            messages[index] = "AtLeastOneAmountShouldBeEntered";
            ++index;
        }
        if (index == 0) {
            messages = null;
        }
        return messages;
    }

    public String createAdditionalDepreciation(Credit credit, int facYear, int facPeriod, int finYear, int finPeriod, BigDecimal depreciationAmount, BigDecimal interestAmount, String description, String user) throws Exception {
        String message = null;
        this.documentNr = 0;
        this.seqNr = 0;
        if (finYear == 0) {
            this.finBookYear = facYear;
            this.finBookPeriod = facPeriod;
        } else {
            this.finBookYear = finYear;
            this.finBookPeriod = finPeriod;
        }
        this.finDimId1 = credit.getFinDimId1();
        this.finDimId2 = credit.getFinDimId2();
        this.finDimId3 = credit.getFinDimId3();
        this.finDimId4 = credit.getFinDimId4();
        this.finDimId5 = credit.getPreferedGLAccountId();
        if (description.equals("")) {
            description = LanguageHelper.getString("nl.ibs.fac.language", "AdditionalDepreciationAndInterest");
            if (interestAmount.doubleValue() == 0.0) {
                description = LanguageHelper.getString("nl.ibs.fac.language", "AdditionalDepreciation");
            }
            if (depreciationAmount.doubleValue() == 0.0) {
                description = LanguageHelper.getString("nl.ibs.fac.language", "AdditionalInterest");
            }
        }
        boolean alreadyActive = BOAdapter.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            Object[] objects = TransactionBO.create(this.company.getDBData(), this.company.getId(), this.documentNr, ++this.seqNr, description, "C", null, 3, 3, 90, facYear, facPeriod, this.finBookYear, this.finBookPeriod, new BigDecimal(0), depreciationAmount, interestAmount, null, this.finDimId1, this.finDimId2, this.finDimId3, this.finDimId4, this.finDimId5, this.retrieveJournalingState(3, 3), 0, -1, user, credit.getProFormaTypeId());
            if (objects[0] == null) {
                message = (String)objects[1];
            } else {
                Transaction transaction = (Transaction)objects[0];
                transaction.setCreditId(credit.getId());
                transaction.setState(1);
            }
            if (message != null) {
                BOAdapter.investigate(null, dbTransaction);
                return message;
            }
            BOAdapter.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            message = BOAdapter.investigate(e, dbTransaction);
        }
        return message;
    }
}

