/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.gov.bp;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import nl.ibs.fac.CalculationValue;
import nl.ibs.fac.CalculatorParameter;
import nl.ibs.fac.ProofDepreciationCalculator;
import nl.ibs.fac.boadapters.InterestTableHelper;
import nl.ibs.fac.boadapters.ProcessParametersBO;
import nl.ibs.fac.bp.GenericTransactionBP;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Credit;
import nl.ibs.fac.db.CreditBalance;
import nl.ibs.fac.db.CreditBalanceDetail;
import nl.ibs.fac.db.DetailEstimationTransaction;
import nl.ibs.fac.db.ProcessParameters;
import nl.ibs.fac.db.TotalEstimationTransaction;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.TransactionManagerFactory;
import nl.ibs.fac.gov.boadapters.CreditBalanceBO;
import nl.ibs.fac.gov.boadapters.CreditBalanceDetailBO;
import nl.ibs.fac.gov.boadapters.TotalEstimationTransactionBO;
import nl.ibs.fac.gov.bp.CreditBalanceBP;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.ExecutableQuery;
import nl.ibs.jsql.QueryFactory;

public class CreditDepreciationBP
extends GenericTransactionBP {
    private static final long serialVersionUID = 3107027767827172982L;
    private double[] costAmounts;
    private double[] cumCostAmounts;
    private double[] deprAmounts;
    private double[] baseAmounts;
    private double[] interestPercentages;
    private double[] interestYearAmounts;
    private ProcessParameters processParameters;
    private ProofDepreciationCalculator calculator;
    private CalculationValue calculationValue;
    private Collection allCalculationValues;
    private InterestTableHelper interestTableHelper = new InterestTableHelper();
    private static final BigDecimal ZERO = new BigDecimal("0.00");

    public CreditDepreciationBP(Company company, int numberOfPeriods) throws Exception {
        super(company, numberOfPeriods, true);
        this.processParameters = (ProcessParameters)ProcessParametersBO.get(company.getDBData(), this.dataSet.getId())[0];
        this.calculator = new ProofDepreciationCalculator(this.processParameters.getFullInterestIn1stPeriod());
    }

    public String proofDepreciate(Credit credit, int yearTo, boolean estimationBased) throws Exception {
        this.allCalculationValues = new ArrayList();
        this.interestPercentages = new double[credit.getEndYear() - credit.getStartYear() + 1];
        this.costAmounts = new double[credit.getEndYear() - credit.getStartYear() + 1];
        this.cumCostAmounts = new double[credit.getEndYear() - credit.getStartYear() + 1];
        this.deprAmounts = new double[credit.getEndYear() - credit.getStartYear() + 1];
        this.baseAmounts = new double[credit.getEndYear() - credit.getStartYear() + 1];
        this.interestYearAmounts = new double[credit.getEndYear() - credit.getStartYear() + 1];
        this.retrieveInterestPercentages(credit, credit.getEndYear());
        Collection<TotalEstimationTransaction> tets = TotalEstimationTransactionBO.getEstimationTransactions(credit, true);
        for (TotalEstimationTransaction tet : tets) {
            this.retrieveEstimationAmounts(tet, credit.getStartYear());
        }
        this.calculateBaseAmounts();
        this.calculateInterestYearAmounts();
        for (int index = 0; index < this.costAmounts.length; ++index) {
            this.calculationValue = new CalculationValue(98, credit.getStartYear() + index, this.numberOfPeriods, ZERO, this.round(this.interestYearAmounts[index]), null, null, this.round(this.cumCostAmounts[index]), ZERO, ZERO, ZERO, this.round(this.costAmounts[index]), new BigDecimal(this.interestPercentages[index], new MathContext(3)), ZERO, false, new BigDecimal("0"));
            this.calculationValue.setCredit(credit);
            this.allCalculationValues.add(this.calculationValue);
        }
        tets = TotalEstimationTransactionBO.getEstimationTransactions(credit, false);
        for (TotalEstimationTransaction tet : tets) {
            CalculatorParameter parameter = new CalculatorParameter();
            parameter.setCorrectionAmount445A(new BigDecimal("0.00"));
            parameter.setCorrectionAmount445B(new BigDecimal("0.00"));
            parameter.setDegressivePercentage(tet.getDegressivePercentage());
            parameter.setAnnuityPercentage(tet.getAnnuityPercentage());
            parameter.setDepreciatableLife(tet.getDepreciatableLife());
            parameter.setDepreciationMethod(tet.getDepreciationMethod());
            parameter.setDepreciationPaused(false);
            parameter.setInterestCalculationMethod(tet.getInterestCalculationMethod());
            parameter.setInterestPercentage(tet.getInterestPercentage());
            parameter.setInterestTableId(tet.getInterestTableId());
            parameter.setNumberOfDepreciatedPeriods(0);
            parameter.setResidualPercentage(tet.getResidualPercentage());
            parameter.setResidualValue(tet.getResidualValue());
            parameter.setYearPercentageTableId(tet.getYearPercentageTableId());
            parameter.setStartUseYear(credit.getEndYear() + 1);
            parameter.setStartUsePeriod(1);
            parameter.setStartPeriodHandlingMethod(tet.getStartPeriodHandlingMethod());
            parameter.setStartDepreciationBookYear(parameter.getStartUseYear());
            parameter.setStartDepreciationPeriod(parameter.getStartUsePeriod());
            if (parameter.getStartPeriodHandlingMethod() == 6) {
                parameter.setStartDepreciationPeriod(7);
            }
            if (parameter.getStartPeriodHandlingMethod() == 5) {
                parameter.setStartDepreciationBookYear(parameter.getStartDepreciationBookYear() + 1);
            }
            DetailEstimationTransaction det = tet.getDetailEstimationTransactionsObject(null);
            parameter.setPostedAcquisitionBalance(det.getDetailTransactionAmount());
            parameter.setPostedDepreciationBalance(ZERO);
            parameter.setPreviousBookvalueBalance(det.getDetailTransactionAmount());
            ArrayList collection = (ArrayList)this.calculator.calculate(tet.getDBData(), this.company, this.numberOfPeriods, false, yearTo, this.numberOfPeriods, parameter);
            Iterator ci = collection.iterator();
            int levelYear = 0;
            CalculationValue firstValue = null;
            CalculationValue secondValue = null;
            while (ci.hasNext()) {
                secondValue = (CalculationValue)ci.next();
                if (levelYear != secondValue.getYear()) {
                    if (levelYear != 0) {
                        this.allCalculationValues.add(firstValue);
                    }
                    levelYear = secondValue.getYear();
                    firstValue = secondValue;
                    continue;
                }
                firstValue.setDepreciationAmount(firstValue.getDepreciationAmount().add(secondValue.getDepreciationAmount()), false);
                firstValue.setInterestAmount(firstValue.getInterestAmount().add(secondValue.getInterestAmount()));
                firstValue.setAssetTypeId(tet.getAssetTypeId());
                firstValue.setPreviousBookvalueBalance(ZERO);
            }
            if (firstValue == null) continue;
            this.allCalculationValues.add(firstValue);
        }
        return null;
    }

    private void retrieveEstimationAmounts(TotalEstimationTransaction tet, int startYear) throws Exception {
        Collection dets = tet.getDetailEstimationTransactionsCollection(null);
        for (DetailEstimationTransaction det : dets) {
            int index = det.getYear() - startYear;
            this.costAmounts[index] = this.costAmounts[index] + det.getDetailTransactionAmount().doubleValue();
            for (int cumIndex = index; cumIndex < this.cumCostAmounts.length; ++cumIndex) {
                this.cumCostAmounts[cumIndex] = this.cumCostAmounts[cumIndex] + det.getDetailTransactionAmount().doubleValue();
            }
        }
    }

    public String depreciate(Credit credit, int bookYearTo, int periodTo) throws Exception {
        this.allCalculationValues = new ArrayList();
        int theEndYear = credit.getEndYear();
        if (bookYearTo > theEndYear) {
            theEndYear = bookYearTo;
        }
        if (credit.getStartYear() == theEndYear) {
            return null;
        }
        if (credit.getStartYear() >= bookYearTo) {
            return null;
        }
        if (credit.getInterestCalculationMethod() == 0) {
            return null;
        }
        CreditBalanceBP creditBalanceBP = new CreditBalanceBP(this.company);
        this.interestPercentages = new double[theEndYear - credit.getStartYear() + 1];
        this.retrieveInterestPercentages(credit, theEndYear);
        Collection creditBalances = CreditBalanceBO.retrieveCreditBalances(credit);
        for (CreditBalance creditBalance : creditBalances) {
            double theJournalizedInterestYearAmount;
            BigDecimal theInterestAmountToBeJournalized;
            creditBalanceBP.handleBalanceIsDirty(creditBalance);
            this.costAmounts = new double[theEndYear - credit.getStartYear() + 1];
            this.deprAmounts = new double[theEndYear - credit.getStartYear() + 1];
            this.baseAmounts = new double[theEndYear - credit.getStartYear() + 1];
            this.interestYearAmounts = new double[theEndYear - credit.getStartYear() + 1];
            this.retrieveCostAmounts(creditBalance.getGLAccountId(), credit.getStartYear(), theEndYear);
            if (creditBalance.getGLAccountId().equals(credit.getPreferedGLAccountId())) {
                this.retrieveDepreciationAmounts(credit, credit.getStartYear(), theEndYear);
            }
            this.calculateBaseAmounts();
            int index = bookYearTo - credit.getStartYear();
            if (this.baseAmounts[index] == 0.0) continue;
            this.calculateInterestYearAmounts();
            double theCalculatedInterestYearAmount = this.interestYearAmounts[index];
            if (periodTo < this.numberOfPeriods) {
                theCalculatedInterestYearAmount = theCalculatedInterestYearAmount * (double)periodTo / (double)this.numberOfPeriods;
            }
            if ((theInterestAmountToBeJournalized = this.round(theCalculatedInterestYearAmount - (theJournalizedInterestYearAmount = this.retrieveJournalizedInterestYearAmount(creditBalance, bookYearTo).doubleValue()))).doubleValue() == 0.0) continue;
            this.calculationValue = new CalculationValue(0, bookYearTo, periodTo, ZERO, theInterestAmountToBeJournalized, null, null, ZERO, ZERO, ZERO, ZERO, ZERO, new BigDecimal(this.interestPercentages[index], new MathContext(3)), ZERO, false, new BigDecimal("0"));
            this.calculationValue.setCredit(credit);
            Log.debug((String)credit.getId());
            this.calculationValue.setCreditBalance(creditBalance);
            this.allCalculationValues.add(this.calculationValue);
        }
        return null;
    }

    private BigDecimal round(double input) {
        double intermediate = Math.round(input * 100.0);
        return new BigDecimal("" + (intermediate /= 100.0));
    }

    public Collection getAllCalculationValues() {
        return this.allCalculationValues;
    }

    private void retrieveInterestPercentages(Credit credit, int theEndYear) throws Exception {
        int startYear;
        for (int year = startYear = credit.getStartYear(); year <= theEndYear; ++year) {
            this.interestPercentages[year - startYear] = this.getInterestPercentage(credit, year).doubleValue();
        }
    }

    private BigDecimal getInterestPercentage(Credit credit, int year) throws Exception {
        if (credit.getInterestCalculationMethod() == 0) {
            return new BigDecimal("0.000");
        }
        BigDecimal interestPercentage = credit.getInterestPercentage();
        if (interestPercentage != null && interestPercentage.doubleValue() != 0.0) {
            return interestPercentage;
        }
        interestPercentage = this.interestTableHelper.getPercentage(credit.getDBData(), credit.getInterestTableId(), year, 1);
        if (interestPercentage != null) {
            return interestPercentage;
        }
        return new BigDecimal("0.000");
    }

    private void retrieveCostAmounts(String glAccountId, int startYear, int endYear) throws Exception {
        for (int year = startYear; year <= endYear; ++year) {
            CreditBalanceDetail cbd = (CreditBalanceDetail)CreditBalanceDetailBO.get(this.company, glAccountId, year, 0)[0];
            this.costAmounts[year - startYear] = cbd == null ? 0.0 : cbd.getBalanceAmount1().add(cbd.getBalanceAmount2()).add(cbd.getBalanceAmount3()).doubleValue();
        }
    }

    private void calculateBaseAmounts() throws Exception {
        this.baseAmounts[0] = 0.0;
        for (int i = 1; i < this.costAmounts.length; ++i) {
            this.baseAmounts[i] = this.costAmounts[i - 1] - this.deprAmounts[i - 1] + this.baseAmounts[i - 1];
        }
    }

    private void calculateInterestYearAmounts() throws Exception {
        for (int i = 1; i < this.costAmounts.length; ++i) {
            this.interestYearAmounts[i] = this.interestPercentages[i] == 0.0 || this.baseAmounts[i] == 0.0 ? 0.0 : this.baseAmounts[i] * this.interestPercentages[i] / 100.0;
        }
    }

    private BigDecimal retrieveJournalizedInterestYearAmount(CreditBalance creditBalance, int year) throws Exception {
        BigDecimal journalizedInterestYearAmount = new BigDecimal("0.00");
        String sql = "companyId = '" + creditBalance.getCompanyId();
        sql = sql + "' AND " + "finDimId5" + " = '" + creditBalance.getGLAccountId();
        sql = sql + "' AND " + "mainTransactionType" + " = '" + 3;
        sql = sql + "' AND " + "bookYearForJournalization" + " = '" + year + "'";
        ExecutableQuery query = QueryFactory.create(Transaction.class, sql, "documentNr");
        Collection transactions = TransactionManagerFactory.getInstance(creditBalance.getDBData()).getCollection(query);
        for (Transaction transaction : transactions) {
            journalizedInterestYearAmount = journalizedInterestYearAmount.add(transaction.getAmount3());
        }
        return journalizedInterestYearAmount;
    }

    private void retrieveDepreciationAmounts(Credit credit, int startYear, int endYear) throws Exception {
        String sql = "companyId = '" + credit.getCompanyId();
        sql = sql + "' AND " + "creditId" + " = '" + credit.getId();
        sql = sql + "' AND " + "mainTransactionType" + " = '" + 3;
        sql = sql + "' AND " + "transactionType" + " = '" + 90;
        sql = sql + "' AND " + "bookYearForJournalization" + " < '" + (endYear + 1) + "'";
        ExecutableQuery query = QueryFactory.create(Transaction.class, sql, "documentNr");
        Collection transactions = TransactionManagerFactory.getInstance(credit.getDBData()).getCollection(query);
        for (Transaction transaction : transactions) {
            int index = transaction.getBookYearForJournalization() - startYear;
            if (index < 0) {
                index = 0;
            }
            this.deprAmounts[index] = this.deprAmounts[index] + transaction.getAmount2().doubleValue();
        }
    }
}

