/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.gov.queries;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import nl.ibs.esp.uiobjects.ODBQuery;
import nl.ibs.esp.util.ODBCounter;
import nl.ibs.esp.util.ODBCounterImpl;
import nl.ibs.fac.db.Credit;
import nl.ibs.fac.db.CreditManager;
import nl.ibs.fac.db.CreditManagerFactory;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.ExecutableQuery;
import nl.ibs.jsql.QueryFactory;
import nl.ibs.vegas.persistence.Manager;

public class CreditQuery
implements ODBQuery,
ODBCounter {
    private static final long serialVersionUID = -3107010301527759950L;
    private ExecutableQuery qry;
    private CreditManager manager;
    private ODBCounter counter;
    private String companyId;
    private String sql = "companyId = ?_companyId";
    private String creditId;

    public CreditQuery(DBData dbData, String companyId) throws Exception {
        this.manager = CreditManagerFactory.getInstance(dbData);
        this.counter = new ODBCounterImpl((Manager)this.manager);
        this.qry = QueryFactory.create(Credit.class, this.sql, "id");
        this.qry.setCacheable(true);
        this.companyId = companyId;
    }

    public CreditQuery(DBData dbData, String companyId, boolean includeClosedCredits, boolean onlyApprovedCredits) throws Exception {
        this(dbData, companyId);
        if (!includeClosedCredits) {
            this.sql = this.sql + " AND " + "state" + " < " + 4;
        }
        if (onlyApprovedCredits) {
            this.sql = this.sql + " AND " + "state" + " = " + 2;
        }
    }

    public CreditQuery(DBData dbData, String companyId, String creditId) throws Exception {
        this(dbData, companyId);
        this.creditId = creditId;
        this.sql = this.sql + " AND " + "id" + " = ?_id";
    }

    public Collection fetchData(String filter, String order, Map parameters, int maxObjects) throws Exception {
        if (filter != null) {
            this.qry.setFilter(this.sql + " AND " + filter);
        } else {
            this.qry.setFilter(this.sql);
        }
        parameters = parameters == null ? new HashMap() : parameters;
        parameters.put("_companyId", this.companyId);
        if (this.creditId != null) {
            parameters.put("_id", this.creditId);
        }
        this.qry.setParameters(parameters);
        this.qry.setMaxObjects(maxObjects);
        this.qry.setOrdering(order);
        return this.manager.getCollection(this.qry);
    }

    public long count(String filter, Map parameters) throws Exception {
        parameters = parameters == null ? new HashMap() : parameters;
        parameters.put("_companyId", this.companyId);
        if (this.creditId != null) {
            parameters.put("_id", this.creditId);
        }
        if (filter != null && filter.trim().length() > 0) {
            return this.counter.count(this.sql + " AND " + filter, parameters);
        }
        return this.counter.count(this.sql, parameters);
    }
}

