/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.gov.queries;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import nl.ibs.esp.uiobjects.ODBQuery;
import nl.ibs.esp.util.ODBCounter;
import nl.ibs.esp.util.ODBCounterImpl;
import nl.ibs.fac.db.IncomingFinancialTransaction;
import nl.ibs.fac.db.IncomingFinancialTransactionManager;
import nl.ibs.fac.db.IncomingFinancialTransactionManagerFactory;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.ExecutableQuery;
import nl.ibs.jsql.QueryFactory;
import nl.ibs.vegas.persistence.Manager;

public class IncomingFinancialTransactionForGLAccountQuery
implements ODBQuery,
ODBCounter {
    private static final long serialVersionUID = 7486662578236684969L;
    private ExecutableQuery qry;
    private IncomingFinancialTransactionManager manager;
    private ODBCounter counter;
    private String companyId;
    private String mainAccountId;
    private int year = 0;
    private int period = 0;
    private String sql = "companyId = ?_companyId AND mainAccount = ?_mainAccountId";
    private String sql_plus_A = "bookYear = ?_bookYear";
    private String sql_plus_B = "period = ?_period";
    private String sql_plus_C = "period >= ?_period";

    public IncomingFinancialTransactionForGLAccountQuery(DBData dbData, String companyId, String mainAccountId) throws Exception {
        this.manager = IncomingFinancialTransactionManagerFactory.getInstance(dbData);
        this.counter = new ODBCounterImpl((Manager)this.manager);
        this.qry = QueryFactory.create(IncomingFinancialTransaction.class, this.sql, "id");
        this.qry.setCacheable(true);
        this.companyId = companyId;
        this.mainAccountId = mainAccountId;
    }

    public IncomingFinancialTransactionForGLAccountQuery(DBData dbData, String companyId, String mainAccountId, int year, int period, boolean useGreaterThan) throws Exception {
        this.sql = this.sql + " AND " + this.sql_plus_A;
        this.sql = useGreaterThan ? this.sql + " AND " + this.sql_plus_C : this.sql + " AND " + this.sql_plus_B;
        this.manager = IncomingFinancialTransactionManagerFactory.getInstance(dbData);
        this.qry = QueryFactory.create(IncomingFinancialTransaction.class, this.sql, "id");
        this.qry.setCacheable(true);
        this.companyId = companyId;
        this.mainAccountId = mainAccountId;
        this.year = year;
        this.period = useGreaterThan ? period : period;
    }

    public Collection fetchData(String filter, String order, Map parameters, int maxObjects) throws Exception {
        if (filter != null) {
            this.qry.setFilter(this.sql + " AND " + filter);
        } else {
            this.qry.setFilter(this.sql);
        }
        parameters = parameters == null ? new HashMap() : parameters;
        parameters.put("_companyId", this.companyId);
        parameters.put("_mainAccountId", this.mainAccountId);
        if (this.year > 0) {
            parameters.put("_bookYear", new Integer(this.year));
            parameters.put("_period", new Integer(this.period));
        }
        this.qry.setParameters(parameters);
        this.qry.setMaxObjects(maxObjects);
        this.qry.setOrdering(order);
        return this.manager.getCollection(this.qry);
    }

    public long count(String filter, Map parameters) throws Exception {
        parameters = parameters == null ? new HashMap() : parameters;
        parameters.put("_companyId", this.companyId);
        parameters.put("_mainAccountId", this.mainAccountId);
        if (this.year > 0) {
            parameters.put("_bookYear", new Integer(this.year));
            parameters.put("_period", new Integer(this.period));
        }
        if (filter != null && filter.trim().length() > 0) {
            return this.counter.count(this.sql + " AND " + filter, parameters);
        }
        return this.counter.count(this.sql, parameters);
    }
}

