/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.gov.reports;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import nl.ibs.fac.boadapters.AdditionalJournalingDataBO;
import nl.ibs.fac.boadapters.AssetTypeBO;
import nl.ibs.fac.boadapters.MainAccountSchemeBO;
import nl.ibs.fac.db.AdditionalJournalingData;
import nl.ibs.fac.db.AssetType;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.MainAccountScheme;
import nl.ibs.fac.fms.FMSHelper;

public class AdditionalJournalingDataHelper {
    private FMSHelper fmsHelper;
    private Company company;
    private int year;
    private int period = 1;
    private Collection assetTypes = null;
    private Iterator ati;
    private AssetType assetType;
    private String key;
    private String value;
    private int apLimit;
    public HashMap ids;
    public HashMap descriptions;

    public AdditionalJournalingDataHelper(Company company, int year, FMSHelper fmsHelper) throws Exception {
        this.company = company;
        this.year = year;
        this.fmsHelper = fmsHelper;
        this.initialize();
    }

    private void initialize() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("facLib", this.company.getDBData().getSchema());
        map.put("Company", this.company.getId());
        this.assetTypes = AssetTypeBO.getAssetTypes(map);
        if (this.assetTypes == null || this.assetTypes.isEmpty()) {
            return;
        }
        this.initializeHashMap();
        this.retrieveAdditionalJournalingData();
    }

    private void initializeHashMap() throws Exception {
        this.ids = new HashMap();
        this.descriptions = new HashMap();
        this.value = "";
        for (AssetType this.assetType : this.assetTypes) {
            this.apLimit = 1;
            if (this.assetType.getAccountingPrinciple2IsUsed()) {
                this.apLimit = 2;
            }
            for (int index2 = 1; index2 <= this.apLimit; ++index2) {
                for (int index3 = 10; index3 <= 90; ++index3) {
                    this.key = this.assetType.getId() + "/" + index2 + "/" + index3 + "/0";
                    this.ids.put(this.key, this.value);
                    this.descriptions.put(this.key, this.value);
                    for (int index4 = 1; index4 <= 5; ++index4) {
                        this.key = this.assetType.getId() + "/" + index2 + "/" + index3 + "/" + index4;
                        this.ids.put(this.key, this.value);
                        this.descriptions.put(this.key, this.value);
                    }
                }
            }
        }
    }

    private void retrieveAdditionalJournalingData() throws Exception {
        for (AssetType this.assetType : this.assetTypes) {
            this.apLimit = 1;
            if (this.assetType.getAccountingPrinciple2IsUsed()) {
                this.apLimit = 2;
            }
            for (int index2 = 1; index2 <= this.apLimit; ++index2) {
                MainAccountScheme mas = MainAccountSchemeBO.getMainAccountSchemeToUse(this.assetType, index2, this.year, this.period);
                if (mas == null) continue;
                String[] mad = this.retrieveMainAccountData(mas);
                for (int index3 = 10; index3 <= 90; ++index3) {
                    this.key = this.assetType.getId() + "/" + index2 + "/" + index3 + "/0";
                    int madIndex = index3 / 10 - 1;
                    this.ids.put(this.key, mad[madIndex]);
                    this.descriptions.put(this.key, mad[madIndex + 9]);
                    AdditionalJournalingData ajd = (AdditionalJournalingData)AdditionalJournalingDataBO.get(this.company.getDBData(), this.company.getId(), this.assetType.getId(), index2, index3, 0)[0];
                    if (ajd == null) continue;
                    String[] fdd = this.retrieveAdditionalJournalingData(ajd);
                    for (int index4 = 1; index4 <= 5; ++index4) {
                        this.key = this.assetType.getId() + "/" + index2 + "/" + index3 + "/" + index4;
                        int fddIndex = index4 - 1;
                        this.ids.put(this.key, fdd[fddIndex]);
                        this.descriptions.put(this.key, fdd[fddIndex + 5]);
                    }
                }
            }
        }
    }

    private String[] retrieveMainAccountData(MainAccountScheme mas) throws Exception {
        String[] mad = new String[18];
        mad[0] = mas.getMainAccountId1();
        mad[1] = mas.getMainAccountId2();
        mad[2] = mas.getMainAccountId3();
        mad[3] = mas.getMainAccountId4();
        mad[4] = mas.getMainAccountId5();
        mad[5] = mas.getMainAccountId6();
        mad[6] = mas.getMainAccountId7();
        mad[7] = mas.getMainAccountId8();
        mad[8] = mas.getMainAccountId9();
        for (int index = 0; index < 9; ++index) {
            if (mad[index].trim().length() <= 0 || this.fmsHelper == null) continue;
            mad[index + 9] = this.fmsHelper.getDescription(mad[index], 0);
        }
        return mad;
    }

    private String[] retrieveAdditionalJournalingData(AdditionalJournalingData ajd) throws Exception {
        String[] fdd = new String[10];
        fdd[0] = ajd.getFixedDimension1();
        fdd[1] = ajd.getFixedDimension2();
        fdd[2] = ajd.getFixedDimension3();
        fdd[3] = ajd.getFixedDimension4();
        fdd[4] = "";
        for (int index = 0; index < 4; ++index) {
            if (fdd[index].trim().length() <= 0 || this.fmsHelper == null) continue;
            fdd[index + 5] = this.fmsHelper.getDescription(fdd[index], index + 1);
        }
        fdd[9] = "";
        return fdd;
    }

    public String[] getIdAndDescription(String type, int ap, int jt, int seqNr) throws Exception {
        String[] values = new String[]{this.getId(type, ap, jt, seqNr), this.getDescription(type, ap, jt, seqNr)};
        return values;
    }

    public String getId(String type, int ap, int jt, int seqNr) throws Exception {
        String key = type + "/" + ap + "/" + jt + "/" + seqNr;
        String value = (String)this.ids.get(key);
        if (value == null) {
            value = "";
        }
        return value;
    }

    public String getDescription(String type, int ap, int jt, int seqNr) throws Exception {
        String key = type + "/" + ap + "/" + jt + "/" + seqNr;
        String value = (String)this.descriptions.get(key);
        if (value == null) {
            value = "";
        }
        return value;
    }
}

