/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.gov.reports;

import java.math.BigDecimal;
import java.util.Collection;
import nl.ibs.fac.CalculationValue;
import nl.ibs.fac.db.Credit;
import nl.ibs.fac.db.DetailEstimationTransaction;
import nl.ibs.fac.db.TotalEstimationTransaction;
import nl.ibs.fac.gov.boadapters.TotalEstimationTransactionBO;
import nl.ibs.fac.gov.bp.CreditDepreciationBP;

public abstract class CreditProofDepreciationReportHelper2 {
    private static final BigDecimal ZERO = new BigDecimal("0.00");

    public static BigDecimal[] retrieveAmounts(CreditDepreciationBP businessProcess, Credit credit, int bookYearFrom, int numberOfYears) throws Exception {
        BigDecimal[] amounts = new BigDecimal[2 + numberOfYears * 2 + 2];
        for (int index = 0; index < amounts.length; ++index) {
            amounts[index] = ZERO;
        }
        int bookYearTo = credit.getState() == 4 ? credit.getClosingYear() : bookYearFrom - 1 + numberOfYears;
        BigDecimal[] investmentAmounts = CreditProofDepreciationReportHelper2.retrieveInvestmentBalanceAmounts(credit, bookYearFrom, bookYearTo, numberOfYears);
        amounts[0] = investmentAmounts[0];
        amounts[numberOfYears * 2 + 2] = investmentAmounts[numberOfYears + 1];
        String message = businessProcess.proofDepreciate(credit, bookYearTo, true);
        if (message != null) {
            return amounts;
        }
        Collection values = businessProcess.getAllCalculationValues();
        for (CalculationValue value : values) {
            if (value.getYear() < bookYearFrom || value.getYear() > bookYearTo) continue;
            int mainIndex = value.getYear() - bookYearFrom;
            if (value.getDepreciationAmount().doubleValue() != 0.0) {
                amounts[mainIndex * 2 + 2] = amounts[mainIndex * 2 + 2].add(value.getDepreciationAmount());
                amounts[numberOfYears * 2 + 3] = amounts[numberOfYears * 2 + 3].add(value.getDepreciationAmount());
            }
            if (value.getInterestAmount().doubleValue() == 0.0) continue;
            amounts[mainIndex * 2 + 3] = amounts[mainIndex * 2 + 3].add(value.getInterestAmount());
        }
        return amounts;
    }

    public static BigDecimal[] retrieveInvestmentBalanceAmounts(Credit credit, int bookYearFrom, int bookYearTo, int numberOfYears) throws Exception {
        BigDecimal[] investmentAmounts = new BigDecimal[numberOfYears + 2];
        for (int i = 0; i < investmentAmounts.length; ++i) {
            investmentAmounts[i] = ZERO;
        }
        Collection<TotalEstimationTransaction> tets = TotalEstimationTransactionBO.getEstimationTransactions(credit, new Boolean(true));
        for (TotalEstimationTransaction tet : tets) {
            Collection dets = tet.getDetailEstimationTransactionsCollection(null);
            for (DetailEstimationTransaction det : dets) {
                if (det.getYear() < bookYearFrom) {
                    investmentAmounts[0] = investmentAmounts[0].add(det.getDetailTransactionAmount());
                }
                if (det.getYear() >= bookYearFrom && det.getYear() <= bookYearTo) {
                    investmentAmounts[det.getYear() - bookYearFrom + 1] = det.getDetailTransactionAmount();
                }
                if (det.getYear() > bookYearTo) continue;
                investmentAmounts[numberOfYears + 1] = investmentAmounts[numberOfYears + 1].add(det.getDetailTransactionAmount());
            }
        }
        if (credit.getState() == 4) {
            investmentAmounts[numberOfYears + 1] = ZERO;
        }
        return investmentAmounts;
    }
}

