/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.gov.reports;

import java.io.FileOutputStream;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import nl.ibs.fac.BatchJobHelper;
import nl.ibs.fac.DepreciationMethodEnum;
import nl.ibs.fac.IBSDecimal;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.ReportFileHelper;
import nl.ibs.fac.StartPeriodHandlingEnum;
import nl.ibs.fac.boadapters.AnalysisGroupBO;
import nl.ibs.fac.boadapters.AssetTypeBO;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.EnvironmentBO;
import nl.ibs.fac.boadapters.IncomingFinancialTransactionBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.boadapters.ValuationBO;
import nl.ibs.fac.db.AnalysisGroup;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.AssetAnalysisCode;
import nl.ibs.fac.db.AssetType;
import nl.ibs.fac.db.AssetValue;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Credit;
import nl.ibs.fac.db.CreditBalance;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.db.IncomingFinancialTransaction;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.Valuation;
import nl.ibs.fac.fis.FISHelper;
import nl.ibs.fac.fms.FMSHelper;
import nl.ibs.fac.gov.boadapters.CreditBalanceBO;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.reports.CSVHelper;
import nl.ibs.fac.ui.AssetSelection;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;
import nl.ibs.util.Stopwatch;

public class GOVAssetSheetToCSV
extends CSVHelper {
    public static final String CLASSNAME = GOVAssetSheetToCSV.class.getName();
    private static final String FILENAME = "AssetSheetReport";
    private static final String[][] BASELABELS = new String[][]{{"Asset", "SubId", "StartPeriod", "Investering(BB)", "Afschr/Afl.(BB)", "Boekwaarde(BB)", "Vermeerdering", "Vermindering", "Bijdr. 3den", "Afschrijving", "Aflossing", "Rente", "Kap. lasten", "Desinv. AW", "Desinv. CA", "Investering(EB)", "Afschr/Afl.(EB)", "Boekwaarde(EB)", null, "Type", null, "Dim1", null, "Dim2", null, "Dim3", null, "Dim4", null, "Dim5", null, "DepreciationTime", "Depreciated", "Rest", "ResidualValue", "Lopend act.", "DepreciationMethod", "Afhandeling"}};
    private int numberOfColumns;
    private static String[][] LABELS;
    private static String[] facdim_labels;
    private static int maxSeqNbr;
    private int theAccountingPrinciple;
    private int accountingPrinciple;
    private int bookYearForReport = 0;
    private int fromPeriodForReport = 0;
    private int toPeriodForReport = 0;
    private boolean credit = false;
    private static final BigDecimal ZERO;
    private BigDecimal OB_A = ZERO;
    private BigDecimal OB_B = ZERO;
    private BigDecimal CY_A = ZERO;
    private BigDecimal CY_B = ZERO;
    private BigDecimal CY_C = ZERO;
    private BigDecimal CY_D = ZERO;
    private BigDecimal CY_E = ZERO;
    private BigDecimal CY_F = ZERO;
    private BigDecimal CY_G = ZERO;
    private BigDecimal CY_H = ZERO;
    private Asset asset = null;
    private Valuation valuation = null;
    private Credit theCredit = null;
    private boolean includeDisinvested;
    private boolean excludeBookValueZero;
    private Company company;
    private boolean finDimd1Description = false;
    private boolean finDimd2Description = false;
    private boolean finDimd3Description = false;
    private boolean finDimd4Description = false;
    private boolean finDimd5Description = false;
    private boolean typeDescription = false;
    private boolean assetDescription = false;

    public GOVAssetSheetToCSV(String[][] selections, Collection collection, String[][] labels, FMSHelper fmsHelper, FISHelper fisHelper, Company company, boolean finDimd1Description, boolean finDimd2Description, boolean finDimd3Description, boolean finDimd4Description, boolean finDimd5Description, boolean typeDescription, boolean assetDescription) throws Exception {
        super(selections, collection, labels, fmsHelper, fisHelper);
        this.numberOfColumns = labels[0].length;
        this.theAccountingPrinciple = Integer.parseInt(this.extractFromSelections("AccountingPrinciple", selections));
        this.accountingPrinciple = Integer.parseInt(this.extractFromSelections("AccountingPrinciple", selections));
        this.bookYearForReport = Integer.parseInt(this.extractFromSelections("BookYearForReport", selections));
        this.fromPeriodForReport = Integer.parseInt(this.extractFromSelections("PeriodFrom", selections));
        this.toPeriodForReport = Integer.parseInt(this.extractFromSelections("PeriodTo", selections));
        this.company = company;
        this.finDimd1Description = finDimd1Description;
        this.finDimd2Description = finDimd2Description;
        this.finDimd3Description = finDimd3Description;
        this.finDimd4Description = finDimd4Description;
        this.finDimd5Description = finDimd5Description;
        this.typeDescription = typeDescription;
        this.assetDescription = assetDescription;
    }

    public void setIncludeDisinvested(boolean includeDisinvested) {
        this.includeDisinvested = includeDisinvested;
    }

    public void setExcludeBookValueZero(boolean excludeBookValueZero) {
        this.excludeBookValueZero = excludeBookValueZero;
    }

    @Override
    protected String[] getRowValues(Object object) throws Exception {
        if (object instanceof Credit) {
            this.theCredit = (Credit)object;
            if (this.theAccountingPrinciple == 9) {
                this.accountingPrinciple = 3;
            }
            return this.getCreditAttributes();
        }
        this.asset = (Asset)object;
        if (this.theAccountingPrinciple == 9) {
            this.accountingPrinciple = 1;
        }
        return this.getAttributes();
    }

    private String[] getCreditAttributes() throws Exception {
        int i;
        if (!this.includeDisinvested && this.theCredit.getClosingYear() > 0 && PeriodHelper.isBefore(this.theCredit.getClosingYear(), this.theCredit.getClosingPeriod(), this.bookYearForReport, this.fromPeriodForReport)) {
            return null;
        }
        this.processCreditTransactions();
        if (this.excludeBookValueZero && this.OB_A.subtract(this.OB_B).doubleValue() == 0.0 && this.OB_A.add(this.CY_A).add(this.CY_B).add(this.CY_C).subtract(this.OB_B).subtract(this.CY_D).subtract(this.CY_E).doubleValue() == 0.0) {
            return null;
        }
        String[] value = new String[this.numberOfColumns];
        int v = 0;
        value[v++] = this.theCredit.getId();
        value[v++] = "";
        value[v++] = "" + this.theCredit.getStartYear() + "-1";
        value[v++] = IBSDecimal.format(this.OB_A, true);
        value[v++] = IBSDecimal.format(this.OB_B, true);
        value[v++] = IBSDecimal.format(this.OB_A.subtract(this.OB_B), true);
        value[v++] = IBSDecimal.format(this.CY_A, true);
        value[v++] = IBSDecimal.format(this.CY_B, true);
        value[v++] = IBSDecimal.format(this.CY_C, true);
        value[v++] = IBSDecimal.format(this.CY_D, true);
        value[v++] = IBSDecimal.format(this.CY_E, true);
        value[v++] = IBSDecimal.format(this.CY_F, true);
        value[v++] = IBSDecimal.format(this.CY_D.add(this.CY_F), true);
        value[v++] = IBSDecimal.format(this.CY_G, true);
        value[v++] = IBSDecimal.format(this.CY_H, true);
        value[v++] = IBSDecimal.format(this.OB_A.add(this.CY_A).add(this.CY_B).add(this.CY_C), true);
        value[v++] = IBSDecimal.format(this.OB_B.add(this.CY_D).add(this.CY_E), true);
        value[v++] = IBSDecimal.format(this.OB_A.add(this.CY_A).add(this.CY_B).add(this.CY_C).subtract(this.OB_B).subtract(this.CY_D).subtract(this.CY_E), true);
        value[18] = this.theCredit.getDescription();
        value[19] = this.theCredit.getProFormaTypeId();
        value[20] = this.theCredit.getFinDimId1();
        value[21] = this.theCredit.getFinDimId2();
        value[22] = this.theCredit.getFinDimId3();
        value[23] = this.theCredit.getFinDimId4();
        value[24] = "";
        if (this.assetDescription) {
            value[v++] = this.theCredit.getDescription();
        }
        value[v++] = this.theCredit.getProFormaTypeId();
        if (this.typeDescription) {
            value[v++] = ((AssetType)AssetTypeBO.get(this.asset.getDBData(), this.asset.getCompanyId(), this.theCredit.getProFormaTypeId())[0]).getDescription();
        }
        value[v++] = this.theCredit.getFinDimId1();
        if (this.finDimd1Description) {
            value[v++] = this.theCredit.getFinDimId1().length() == 0 ? "" : (this.fisHelper != null ? this.fisHelper.getDescription(this.theCredit.getFinDimId1(), this.asset.getCompanyId(), "" + this.bookYearForReport, 1) : this.fmsHelper.getDescription(this.theCredit.getFinDimId1(), 1));
        }
        value[v++] = this.theCredit.getFinDimId2();
        if (this.finDimd2Description) {
            value[v++] = this.theCredit.getFinDimId2().length() == 0 ? "" : (this.fisHelper != null ? this.fisHelper.getDescription(this.theCredit.getFinDimId2(), this.asset.getCompanyId(), "" + this.bookYearForReport, 2) : this.fmsHelper.getDescription(this.theCredit.getFinDimId2(), 2));
        }
        value[v++] = this.theCredit.getFinDimId3();
        if (this.finDimd3Description) {
            value[v++] = this.theCredit.getFinDimId3().length() == 0 ? "" : (this.fisHelper != null ? this.fisHelper.getDescription(this.theCredit.getFinDimId3(), this.asset.getCompanyId(), "" + this.bookYearForReport, 3) : this.fmsHelper.getDescription(this.theCredit.getFinDimId3(), 3));
        }
        value[v++] = this.theCredit.getFinDimId4();
        if (this.finDimd4Description) {
            value[v++] = this.theCredit.getFinDimId4().length() == 0 ? "" : (this.fisHelper != null ? this.fisHelper.getDescription(this.theCredit.getFinDimId4(), this.asset.getCompanyId(), "" + this.bookYearForReport, 4) : this.fmsHelper.getDescription(this.theCredit.getFinDimId4(), 4));
        }
        value[v++] = "";
        if (this.finDimd5Description) {
            value[v++] = "";
        }
        for (i = v; i < v + maxSeqNbr; ++i) {
            value[i] = "";
        }
        i = v - 1;
        if (this.theCredit.getDimValue1().trim().length() > 0) {
            value[i + this.company.getSeqNr1().intValue()] = this.theCredit.getDimValue1();
        }
        if (this.theCredit.getDimValue2().trim().length() > 0) {
            value[i + this.company.getSeqNr2().intValue()] = this.theCredit.getDimValue2();
        }
        if (this.theCredit.getDimValue3().trim().length() > 0) {
            value[i + this.company.getSeqNr3().intValue()] = this.theCredit.getDimValue3();
        }
        if (this.theCredit.getDimValue4().trim().length() > 0) {
            value[i + this.company.getSeqNr4().intValue()] = this.theCredit.getDimValue4();
        }
        if (this.theCredit.getDimValue5().trim().length() > 0) {
            value[i + this.company.getSeqNr5().intValue()] = this.theCredit.getDimValue5();
        }
        if (this.theCredit.getDimValue6().trim().length() > 0) {
            value[i + this.company.getSeqNr6().intValue()] = this.theCredit.getDimValue6();
        }
        v += maxSeqNbr;
        while (v < value.length) {
            value[v] = "";
            ++v;
        }
        return value;
    }

    private String[] getAttributes() throws Exception {
        int i;
        if (!this.includeDisinvested && this.asset.getDisinvestmentYear() > 0 && PeriodHelper.isBefore(this.asset.getDisinvestmentYear(), this.asset.getDisinvestmentPeriod(), this.bookYearForReport, this.fromPeriodForReport)) {
            return null;
        }
        this.valuation = (Valuation)ValuationBO.getValuation(this.asset.getDBData(), this.asset.getCompanyId(), this.asset.getCora(), this.asset.getId(), this.accountingPrinciple)[0];
        if (this.valuation == null) {
            return null;
        }
        this.processTransactions();
        BigDecimal avcb = this.OB_A.add(this.CY_A).add(this.CY_B).add(this.CY_C).add(this.CY_G);
        BigDecimal dvcb = this.OB_B.add(this.CY_D).add(this.CY_E).add(this.CY_H);
        if (this.excludeBookValueZero && this.OB_A.subtract(this.OB_B).doubleValue() == 0.0 && avcb.subtract(dvcb).doubleValue() == 0.0) {
            return null;
        }
        String[] value = new String[this.numberOfColumns];
        int v = 0;
        value[v++] = this.asset.getParentId() == null ? this.asset.getId() : this.asset.getParentId();
        value[v++] = this.asset.getParentId() == null ? "" : this.asset.getId();
        value[v++] = "" + this.valuation.getStartDepreciationBookYear() + "-" + this.valuation.getStartDepreciationPeriod();
        value[v++] = IBSDecimal.format(this.OB_A, true);
        value[v++] = IBSDecimal.format(this.OB_B, true);
        value[v++] = IBSDecimal.format(this.OB_A.subtract(this.OB_B), true);
        value[v++] = IBSDecimal.format(this.CY_A, true);
        value[v++] = IBSDecimal.format(this.CY_B, true);
        value[v++] = IBSDecimal.format(this.CY_C, true);
        value[v++] = IBSDecimal.format(this.CY_D, true);
        value[v++] = IBSDecimal.format(this.CY_E, true);
        value[v++] = IBSDecimal.format(this.CY_F, true);
        value[v++] = IBSDecimal.format(this.CY_D.add(this.CY_F), true);
        value[v++] = IBSDecimal.format(this.CY_G, true);
        value[v++] = IBSDecimal.format(this.CY_H, true);
        value[v++] = IBSDecimal.format(avcb, true);
        value[v++] = IBSDecimal.format(dvcb, true);
        value[v++] = IBSDecimal.format(avcb.subtract(dvcb), true);
        if (this.assetDescription) {
            value[v++] = this.asset.getDescription();
        }
        value[v++] = this.asset.getTypeId();
        if (this.typeDescription) {
            value[v++] = ((AssetType)AssetTypeBO.get(this.asset.getDBData(), this.asset.getCompanyId(), this.asset.getTypeId())[0]).getDescription();
        }
        value[v++] = this.asset.getFinDimId1();
        if (this.finDimd1Description) {
            value[v++] = this.asset.getFinDimId1().length() == 0 ? "" : (this.fisHelper != null ? this.fisHelper.getDescription(this.asset.getFinDimId1(), this.asset.getCompanyId(), "" + this.bookYearForReport, 1) : this.fmsHelper.getDescription(this.asset.getFinDimId1(), 1));
        }
        value[v++] = this.asset.getFinDimId2();
        if (this.finDimd2Description) {
            value[v++] = this.asset.getFinDimId2().length() == 0 ? "" : (this.fisHelper != null ? this.fisHelper.getDescription(this.asset.getFinDimId2(), this.asset.getCompanyId(), "" + this.bookYearForReport, 2) : this.fmsHelper.getDescription(this.asset.getFinDimId2(), 2));
        }
        value[v++] = this.asset.getFinDimId3();
        if (this.finDimd3Description) {
            value[v++] = this.asset.getFinDimId3().length() == 0 ? "" : (this.fisHelper != null ? this.fisHelper.getDescription(this.asset.getFinDimId3(), this.asset.getCompanyId(), "" + this.bookYearForReport, 3) : this.fmsHelper.getDescription(this.asset.getFinDimId3(), 3));
        }
        value[v++] = this.asset.getFinDimId4();
        if (this.finDimd4Description) {
            value[v++] = this.asset.getFinDimId4().length() == 0 ? "" : (this.fisHelper != null ? this.fisHelper.getDescription(this.asset.getFinDimId4(), this.asset.getCompanyId(), "" + this.bookYearForReport, 4) : this.fmsHelper.getDescription(this.asset.getFinDimId4(), 4));
        }
        value[v++] = this.asset.getFinDimId5();
        if (this.finDimd5Description) {
            if (this.asset.getFinDimId5().length() == 0) {
                value[v++] = "";
            } else if (this.fisHelper != null) {
                value[v++] = this.fisHelper.getDescription(this.asset.getFinDimId5(), this.asset.getCompanyId(), "" + this.bookYearForReport, 5);
            }
        }
        for (i = v; i < v + maxSeqNbr; ++i) {
            value[i] = "";
        }
        i = v - 1;
        Collection assetAnalysisCodes = this.asset.getAssetAnalysisCodeCollection(null);
        for (AssetAnalysisCode assetAnalysisCode : assetAnalysisCodes) {
            value[i + assetAnalysisCode.getSeqNr()] = "" + assetAnalysisCode.getCode();
        }
        Collection assetValues = this.asset.getAssetValueCollection(null);
        for (AssetValue assetValue : assetValues) {
            value[i + assetValue.getSeqNr()] = "" + assetValue.getValue();
        }
        v += maxSeqNbr;
        value[v++] = "" + this.valuation.getDepreciatableLife();
        value[v++] = "" + this.valuation.getNumberOfDepreciatedPeriods();
        value[28 + GOVAssetSheetToCSV.maxSeqNbr] = "";
        value[v++] = this.valuation.getResidualPercentage().doubleValue() > 0.0 ? IBSDecimal.format(this.valuation.getResidualPercentage()) + "%" : "";
        value[v++] = this.valuation.getResidualValue().doubleValue() != 0.0 ? IBSDecimal.format(this.valuation.getResidualValue()) : "";
        value[v++] = LanguageHelper.getString(this.asset.getCurrentCapitalization());
        value[v++] = DepreciationMethodEnum.getValue(this.valuation.getDepreciationMethod());
        value[v++] = StartPeriodHandlingEnum.getValue(this.valuation.getStartPeriodHandlingMethod());
        return value;
    }

    private void processTransactions() throws Exception {
        this.OB_A = ZERO;
        this.OB_B = ZERO;
        this.CY_A = ZERO;
        this.CY_B = ZERO;
        this.CY_C = ZERO;
        this.CY_D = ZERO;
        this.CY_E = ZERO;
        this.CY_F = ZERO;
        this.CY_G = ZERO;
        this.CY_H = ZERO;
        Iterator transactions = TransactionBO.getBeforeOrEquals(this.asset, this.bookYearForReport, this.toPeriodForReport, this.accountingPrinciple, true, true).iterator();
        Transaction transaction = null;
        int bookYearTransaction = 0;
        int bookPeriodTransaction = 0;
        while (transactions.hasNext()) {
            transaction = (Transaction)transactions.next();
            bookYearTransaction = transaction.getBookYearForJournalization();
            bookPeriodTransaction = transaction.getPeriodForJournalization();
            switch (transaction.getMainTransactionType()) {
                case 1: {
                    if (bookYearTransaction < this.bookYearForReport || bookYearTransaction == this.bookYearForReport && bookPeriodTransaction < this.fromPeriodForReport) {
                        this.OB_A = this.OB_A.add(transaction.getAmount1());
                        this.OB_B = this.OB_B.add(transaction.getAmount2());
                        break;
                    }
                    if (transaction.getTransactionType() == 20) {
                        if (transaction.getPeriodForJournalization() == 1) {
                            this.OB_A = this.OB_A.add(transaction.getAmount1());
                            this.OB_B = this.OB_B.add(transaction.getAmount2());
                            break;
                        }
                        switch (transaction.getBookingIndicator()) {
                            case 1: {
                                this.CY_B = this.CY_B.add(transaction.getAmount1());
                                break;
                            }
                            case 2: {
                                this.CY_C = this.CY_C.add(transaction.getAmount1());
                                break;
                            }
                            default: {
                                this.CY_A = this.CY_A.add(transaction.getAmount1());
                            }
                        }
                        if (this.asset.getLoan()) {
                            this.CY_E = this.CY_E.add(transaction.getAmount2());
                            break;
                        }
                        this.CY_D = this.CY_D.add(transaction.getAmount2());
                        break;
                    }
                    switch (transaction.getBookingIndicator()) {
                        case 1: {
                            this.CY_B = this.CY_B.add(transaction.getAmount1());
                            break;
                        }
                        case 2: {
                            this.CY_C = this.CY_C.add(transaction.getAmount1());
                            break;
                        }
                        default: {
                            this.CY_A = this.CY_A.add(transaction.getAmount1());
                        }
                    }
                    if (this.asset.getLoan()) {
                        this.CY_E = this.CY_E.add(transaction.getAmount2());
                        break;
                    }
                    this.CY_D = this.CY_D.add(transaction.getAmount2());
                    break;
                }
                case 2: {
                    if (bookYearTransaction < this.bookYearForReport || bookYearTransaction == this.bookYearForReport && bookPeriodTransaction < this.fromPeriodForReport) {
                        this.OB_A = this.OB_A.add(transaction.getAmount1());
                        this.OB_B = this.OB_B.add(transaction.getAmount2());
                        break;
                    }
                    this.CY_G = this.CY_G.add(transaction.getAmount1());
                    this.CY_H = this.CY_H.add(transaction.getAmount2());
                    break;
                }
                case 3: {
                    if (bookYearTransaction < this.bookYearForReport || bookYearTransaction == this.bookYearForReport && bookPeriodTransaction < this.fromPeriodForReport) {
                        this.OB_B = this.OB_B.add(transaction.getAmount2());
                        break;
                    }
                    if (this.asset.getLoan()) {
                        this.CY_E = this.CY_E.add(transaction.getAmount2());
                    } else {
                        this.CY_D = this.CY_D.add(transaction.getAmount2());
                    }
                    this.CY_F = this.CY_F.add(transaction.getAmount3());
                }
            }
        }
    }

    private void processCreditTransactions() throws Exception {
        this.OB_A = ZERO;
        this.OB_B = ZERO;
        this.CY_A = ZERO;
        this.CY_B = ZERO;
        this.CY_C = ZERO;
        this.CY_D = ZERO;
        this.CY_E = ZERO;
        this.CY_F = ZERO;
        this.CY_G = ZERO;
        this.CY_H = ZERO;
        Iterator transactions = TransactionBO.getBeforeOrEquals(this.theCredit, this.bookYearForReport, this.toPeriodForReport, this.accountingPrinciple, true, true).iterator();
        Transaction transaction = null;
        int bookYearTransaction = 0;
        int bookPeriodTransaction = 0;
        while (transactions.hasNext()) {
            transaction = (Transaction)transactions.next();
            bookYearTransaction = transaction.getBookYearForJournalization();
            bookPeriodTransaction = transaction.getPeriodForJournalization();
            switch (transaction.getMainTransactionType()) {
                case 1: {
                    if (bookYearTransaction < this.bookYearForReport || bookYearTransaction == this.bookYearForReport && bookPeriodTransaction < this.fromPeriodForReport) {
                        this.OB_A = this.OB_A.add(transaction.getAmount1());
                        this.OB_B = this.OB_B.add(transaction.getAmount2());
                        break;
                    }
                    switch (transaction.getBookingIndicator()) {
                        case 1: {
                            this.CY_B = this.CY_B.add(transaction.getAmount1());
                            break;
                        }
                        case 2: {
                            this.CY_C = this.CY_C.add(transaction.getAmount1());
                            break;
                        }
                        default: {
                            this.CY_A = this.CY_A.add(transaction.getAmount1());
                        }
                    }
                    this.CY_D = this.CY_D.add(transaction.getAmount2());
                    break;
                }
                case 3: {
                    if (bookYearTransaction < this.bookYearForReport || bookYearTransaction == this.bookYearForReport && bookPeriodTransaction < this.fromPeriodForReport) {
                        this.OB_B = this.OB_B.add(transaction.getAmount2());
                        break;
                    }
                    this.CY_D = this.CY_D.add(transaction.getAmount2());
                    this.CY_F = this.CY_F.add(transaction.getAmount3());
                }
            }
        }
        int bookYearIFT = 0;
        int bookPeriodIFT = 0;
        Collection cbs = CreditBalanceBO.retrieveCreditBalances(this.theCredit);
        for (CreditBalance cb : cbs) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("facLib", cb.getDBData().getSchema());
            map.put("Company", cb.getCompanyId());
            map.put("MainAccountFrom", cb.getGLAccountId());
            map.put("MainAccountTo", cb.getGLAccountId());
            Collection ifts = IncomingFinancialTransactionBO.getIncomingFinancialTransactions(map);
            block14: for (IncomingFinancialTransaction ift : ifts) {
                bookYearIFT = ift.getBookYear();
                bookPeriodIFT = ift.getPeriod();
                if (bookYearIFT > this.bookYearForReport || bookYearIFT == this.bookYearForReport && bookPeriodIFT > this.toPeriodForReport) continue;
                if (bookYearIFT < this.bookYearForReport || bookYearIFT == this.bookYearForReport && bookPeriodIFT < this.fromPeriodForReport) {
                    this.OB_A = this.OB_A.add(ift.getUnAllocatedValue());
                    continue;
                }
                switch (ift.getBBVCategory()) {
                    case 1: {
                        this.CY_B = this.CY_B.add(ift.getUnAllocatedValue());
                        continue block14;
                    }
                    case 2: {
                        this.CY_C = this.CY_C.add(ift.getUnAllocatedValue());
                        continue block14;
                    }
                }
                this.CY_A = this.CY_A.add(ift.getUnAllocatedValue());
            }
        }
    }

    public static void main(String[] args) {
        Stopwatch sw = null;
        if (Log.debug()) {
            sw = new Stopwatch();
            sw.start();
        }
        try {
            GOVAssetSheetToCSV.execute(args);
        }
        catch (Exception e) {
            Log.error((Exception)e);
            System.exit(-1);
        }
        if (sw != null) {
            Log.debug((String)("Elapsed time: " + sw.stop(1) + " seconds"));
        }
        System.exit(0);
    }

    public static void execute(String[] args) throws Exception {
        boolean governmentActivated;
        String bookYear;
        String companyId;
        String[][] selections;
        Map map;
        LoginHelper loginHelper;
        String message;
        if (Log.debug() && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                Log.debug((String)("*** execute argumenten : " + args[i]));
            }
        }
        if ((message = (loginHelper = BatchJobHelper.getLoginHelper(map = BatchJobHelper.getSelections(selections = BatchJobHelper.getSelections(args)))).login()) != null) {
            message = LanguageHelper.getString("nl.ibs.fac.language", message);
            Log.error((String)message);
            return;
        }
        Environment environment = (Environment)EnvironmentBO.get((String)map.get("facLib"))[0];
        message = loginHelper.login(environment, companyId = (String)map.get("Company"), bookYear = (String)map.get("BookYear"));
        if (message != null && message.trim().length() > 0) {
            message = LanguageHelper.getString("nl.ibs.fac.language", message);
            Log.error((String)message);
            return;
        }
        FMSHelper fmsHelper = null;
        FISHelper fisHelper = null;
        if (environment.getOperationArea().trim().length() > 0) {
            fmsHelper = new FMSHelper(loginHelper);
        } else {
            fisHelper = new FISHelper(loginHelper);
        }
        GOVAssetSheetToCSV.BASELABELS[0][21] = environment.getName1();
        GOVAssetSheetToCSV.BASELABELS[0][23] = environment.getName2();
        GOVAssetSheetToCSV.BASELABELS[0][25] = environment.getName3();
        GOVAssetSheetToCSV.BASELABELS[0][27] = environment.getName4();
        GOVAssetSheetToCSV.BASELABELS[0][29] = environment.getName5();
        String assetSelectionAsString = (String)map.get(AssetSelection.ASSETSELECTION);
        String assetSelectionAsString2 = (String)map.get(AssetSelection.ASSETSELECTION + "2");
        AssetSelection assetSelection = new AssetSelection(assetSelectionAsString + assetSelectionAsString2);
        boolean finDimd1Description = false;
        boolean finDimd2Description = false;
        boolean finDimd3Description = false;
        boolean finDimd4Description = false;
        boolean finDimd5Description = false;
        boolean typeDescription = false;
        boolean assetDescription = false;
        int maxDescriptions = 0;
        GOVAssetSheetToCSV.BASELABELS[0][18] = null;
        GOVAssetSheetToCSV.BASELABELS[0][20] = null;
        GOVAssetSheetToCSV.BASELABELS[0][22] = null;
        GOVAssetSheetToCSV.BASELABELS[0][24] = null;
        GOVAssetSheetToCSV.BASELABELS[0][26] = null;
        GOVAssetSheetToCSV.BASELABELS[0][28] = null;
        GOVAssetSheetToCSV.BASELABELS[0][30] = null;
        int i = 0;
        StringTokenizer st = new StringTokenizer(assetSelection.getDescription(), ",");
        while (st.hasMoreTokens()) {
            boolean value = Boolean.parseBoolean(st.nextToken());
            if (value) {
                ++maxDescriptions;
                switch (i) {
                    case 0: {
                        finDimd1Description = value;
                        GOVAssetSheetToCSV.BASELABELS[0][22] = LanguageHelper.getString("nl.ibs.fac.language", "Description");
                        break;
                    }
                    case 1: {
                        finDimd2Description = value;
                        GOVAssetSheetToCSV.BASELABELS[0][24] = LanguageHelper.getString("nl.ibs.fac.language", "Description");
                        break;
                    }
                    case 2: {
                        finDimd3Description = value;
                        GOVAssetSheetToCSV.BASELABELS[0][26] = LanguageHelper.getString("nl.ibs.fac.language", "Description");
                        break;
                    }
                    case 3: {
                        finDimd4Description = value;
                        GOVAssetSheetToCSV.BASELABELS[0][28] = LanguageHelper.getString("nl.ibs.fac.language", "Description");
                        break;
                    }
                    case 4: {
                        typeDescription = value;
                        GOVAssetSheetToCSV.BASELABELS[0][20] = LanguageHelper.getString("nl.ibs.fac.language", "Description");
                        break;
                    }
                    case 5: {
                        assetDescription = value;
                        GOVAssetSheetToCSV.BASELABELS[0][18] = LanguageHelper.getString("nl.ibs.fac.language", "Description");
                        break;
                    }
                }
            }
            ++i;
        }
        if (!assetDescription) {
            ++maxDescriptions;
        }
        assetDescription = true;
        GOVAssetSheetToCSV.BASELABELS[0][18] = LanguageHelper.getString("nl.ibs.fac.language", "Description");
        Collection analysisGroups = AnalysisGroupBO.getAnalysisGroups(map);
        Iterator agi1 = analysisGroups.iterator();
        maxSeqNbr = 0;
        while (agi1.hasNext()) {
            AnalysisGroup analysisGroup = (AnalysisGroup)agi1.next();
            if (analysisGroup.getSeqNr() <= maxSeqNbr) continue;
            maxSeqNbr = analysisGroup.getSeqNr();
        }
        if (maxSeqNbr > 0) {
            facdim_labels = new String[maxSeqNbr];
            for (AnalysisGroup analysisGroup : analysisGroups) {
                GOVAssetSheetToCSV.facdim_labels[analysisGroup.getSeqNr() - 1] = analysisGroup.getShortName();
            }
        }
        LABELS = new String[1][31 + maxSeqNbr + maxDescriptions];
        int j = 0;
        for (i = 0; i < 31; ++i) {
            if (BASELABELS[0][i] == null) continue;
            Log.debug((String)("*** 1 Naar LABELS BASELABELS: [0][" + i + "] = " + BASELABELS[0][i]));
            GOVAssetSheetToCSV.LABELS[0][j++] = BASELABELS[0][i];
        }
        if (maxSeqNbr > 0) {
            for (i = j; i < j + maxSeqNbr; ++i) {
                Log.debug((String)("*** 2 Naar LABELS facdim_labels: [" + (i - j) + "] = " + facdim_labels[i - j]));
                GOVAssetSheetToCSV.LABELS[0][i] = facdim_labels[i - j];
            }
        } else {
            i = j;
        }
        j = 0;
        Log.debug((String)"*** 2++ Inhoud LABELS:");
        Log.debug((String)("*** 2+ waarde i = " + i));
        while (i < LABELS[0].length) {
            GOVAssetSheetToCSV.LABELS[0][i] = BASELABELS[0][31 + j++];
            Log.debug((String)("*** 3 Naar LABELS[0][" + i + "] = " + LABELS[0][i]));
            ++i;
        }
        DBData dbData = BOAdapter.getDBData(map);
        Company company = (Company)CompanyBO.get(dbData, companyId)[0];
        assetSelection.governmentActivated = governmentActivated = Boolean.valueOf((String)map.get("governmentActivated")).booleanValue();
        assetSelection.ap = Integer.parseInt((String)map.get("AccountingPrinciple"));
        Log.debug((String)"*** VLAK voor GOVAssetSheetToCSV assetSheetToCSV = new GOVAssetSheetToCSV");
        GOVAssetSheetToCSV assetSheetToCSV = new GOVAssetSheetToCSV(selections, assetSelection.getCollection(), LABELS, fmsHelper, fisHelper, company, finDimd1Description, finDimd2Description, finDimd3Description, finDimd4Description, finDimd5Description, typeDescription, assetDescription);
        assetSheetToCSV.setIncludeDisinvested(assetSelection.getIncludeDisinvested());
        assetSheetToCSV.setExcludeBookValueZero(assetSelection.getExcludeBookValueZero());
        FileOutputStream fos = new FileOutputStream(ReportFileHelper.getFileName(args, FILENAME, "csv"));
        fos.write(assetSheetToCSV.createCsv());
        fos.close();
        loginHelper.logout(environment, companyId, bookYear);
        loginHelper.logout();
    }

    static {
        ZERO = new BigDecimal(0.0);
    }
}

