/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.inport;

import java.io.BufferedReader;
import java.util.List;
import java.util.Map;
import nl.ibs.fac.BatchJobHelper;
import nl.ibs.fac.boadapters.AssetTypeBO;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.MainAccountSchemeBO;
import nl.ibs.fac.db.AssetType;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.inport.ImportCSVHelper;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.language.TokenList;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;

public class AssetTypeCSV
extends ImportCSVHelper {
    public static final String FILENAME = "AssetType.csv";
    public static final String CLASSNAME = AssetTypeCSV.class.getName();
    public static String savedCompanyId;
    public static Company company;
    public static int initialYear;
    public static int ap;
    public static int startWith;

    public static void main(String[] args) {
        try {
            AssetTypeCSV.execute(args);
        }
        catch (Exception e) {
            Log.error((Exception)e);
            System.exit(-1);
        }
        System.exit(0);
    }

    public static void execute(String[] args) throws Exception {
        if (Log.debug() && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                Log.debug((String)args[i]);
            }
        }
        String[][] selections = BatchJobHelper.getSelections(args);
        Map map = BatchJobHelper.getSelections(selections);
        String contextName = BatchJobHelper.getContextName(args);
        BufferedReader bufferedReader = AssetTypeCSV.getReader(map, FILENAME, contextName);
        String line = bufferedReader.readLine();
        List names = AssetTypeCSV.getColumnNames(line);
        int size = names.size();
        int[] index = new int[size];
        index[0] = names.indexOf("operationArea");
        index[1] = names.indexOf("dataLib");
        index[2] = names.indexOf("adminId");
        index[3] = names.indexOf("companyId");
        index[4] = names.indexOf("branchId");
        index[5] = names.indexOf("id");
        index[6] = names.indexOf("description");
        index[7] = names.indexOf("mandatoryDims");
        index[8] = names.indexOf("F010");
        index[9] = names.indexOf("F020");
        index[10] = names.indexOf("F030");
        index[11] = names.indexOf("F040");
        index[12] = names.indexOf("F050");
        index[13] = names.indexOf("F060");
        index[14] = names.indexOf("F070");
        index[15] = names.indexOf("F080");
        index[16] = names.indexOf("F090");
        index[17] = names.indexOf("C010");
        index[18] = names.indexOf("C020");
        index[19] = names.indexOf("C030");
        index[20] = names.indexOf("C040");
        index[21] = names.indexOf("C050");
        index[22] = names.indexOf("C060");
        index[23] = names.indexOf("C070");
        index[24] = names.indexOf("C080");
        index[25] = names.indexOf("C090");
        int lineCount = 0;
        int okCount = 0;
        String[] values = new String[size];
        String[] saved = new String[size];
        Environment env = null;
        DBData dbData = null;
        line = bufferedReader.readLine();
        while (line != null) {
            ++lineCount;
            if (!(values = AssetTypeCSV.getColumnValues(line, values))[index[0]].equals(saved[index[0]]) || !values[index[1]].equals(saved[index[1]])) {
                env = AssetTypeCSV.getEnvironment(values[index[0]], values[index[1]]);
                if (env == null) {
                    Log.info((String)("environment not found for: " + values[index[0]] + " " + values[index[1]]));
                    line = bufferedReader.readLine();
                    continue;
                }
                dbData = AssetTypeCSV.getDBData(env);
                saved[index[0]] = values[index[0]];
                saved[index[1]] = values[index[1]];
            }
            if (AssetTypeCSV.createAssetType(values, index, dbData)) {
                ++okCount;
            }
            line = bufferedReader.readLine();
        }
        TokenList tl = new TokenList();
        tl.addNonTranslatable(String.valueOf(lineCount));
        tl.addNonTranslatable(String.valueOf(lineCount - okCount));
        String message = LanguageHelper.getString("nl.ibs.fac.language", "Processed_failed", tl);
        Log.info((String)message);
    }

    private static boolean createAssetType(String[] values, int[] index, DBData dbData) throws Exception {
        String[] defaults;
        int[] usageFinDims;
        Object[] result;
        String description;
        String companyId = values[index[2]];
        if (companyId.length() == 0) {
            companyId = values[index[4]].equals("0") ? values[index[3]] : values[index[3]] + '/' + values[index[4]];
        }
        if ((description = values[index[6]]).length() > 50) {
            description = description.substring(0, 49);
        }
        if ((result = AssetTypeBO.create(dbData, companyId, values[index[5]], description, 0, false, false, false, false, false, usageFinDims = new int[]{2, 2, 1, 1, 1}, new int[10], new boolean[10], defaults = new String[]{"", "", "", "", "", "", "", "", "", ""}, false))[0] != null) {
            Log.info((String)((AssetType)result[0]).getId());
            if (!companyId.equals(savedCompanyId)) {
                company = (Company)CompanyBO.get(dbData, companyId)[0];
                initialYear = company.getInitialBookYear();
            }
            ap = 1;
            startWith = 8;
            AssetTypeCSV.createMAS(values, index, dbData, company, initialYear, ap, startWith);
            ap = 2;
            startWith = 17;
            AssetTypeCSV.createMAS(values, index, dbData, company, initialYear, ap, startWith);
        } else {
            Log.info((String)((String)result[1]));
        }
        return result[1] == null;
    }

    private static void createMAS(String[] values, int[] index, DBData dbData, Company company, int initialYear, int ap, int startWith) throws Exception {
        boolean doIt = false;
        for (int i = startWith; i <= startWith + 8; ++i) {
            if (values[index[i]] == null) {
                values[index[i]] = "";
            }
            if (values[index[i]].trim().equals("")) continue;
            doIt = true;
        }
        if (doIt) {
            MainAccountSchemeBO.create(dbData, company.getId(), values[index[5]], ap, initialYear, 1, "" + values[index[startWith]], "" + values[index[startWith + 1]], "" + values[index[startWith + 2]], "" + values[index[startWith + 3]], "" + values[index[startWith + 4]], "" + values[index[startWith + 5]], "" + values[index[startWith + 6]], "" + values[index[startWith + 7]], "" + values[index[startWith + 8]], "", "");
        }
    }
}

