/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.inport;

import java.io.BufferedReader;
import java.util.List;
import java.util.Map;
import nl.ibs.fac.BatchJobHelper;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.ProcessParametersBO;
import nl.ibs.fac.commands.BookYearSynchronizeCommand;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.inport.ImportCSVHelper;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.language.TokenList;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;

public class CompanyCSV
extends ImportCSVHelper {
    public static final String FILENAME = "Company.csv";
    public static final String CLASSNAME = CompanyCSV.class.getName();

    public static void main(String[] args) {
        try {
            CompanyCSV.execute(args);
        }
        catch (Exception e) {
            Log.error((Exception)e);
            System.exit(-1);
        }
        System.exit(0);
    }

    public static void execute(String[] args) throws Exception {
        String message;
        if (Log.debug() && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                Log.debug((String)args[i]);
            }
        }
        String[][] selections = BatchJobHelper.getSelections(args);
        Map map = BatchJobHelper.getSelections(selections);
        String contextName = BatchJobHelper.getContextName(args);
        BufferedReader bufferedReader = CompanyCSV.getReader(map, FILENAME, contextName);
        String line = bufferedReader.readLine();
        List names = CompanyCSV.getColumnNames(line);
        int size = names.size();
        int[] index = new int[size];
        index[0] = names.indexOf("operationArea");
        index[1] = names.indexOf("dataLib");
        index[2] = names.indexOf("adminId");
        index[3] = names.indexOf("companyId");
        index[4] = names.indexOf("branchId");
        index[5] = names.indexOf("description");
        index[6] = names.indexOf("currentBookYear");
        index[7] = names.indexOf("dataSetId");
        index[8] = names.indexOf("numberOfPeriods");
        index[9] = names.indexOf("assetIdType");
        index[10] = names.indexOf("assetIdLength");
        index[11] = names.indexOf("assetIdAuto");
        index[12] = names.indexOf("assetIdStartValue");
        index[13] = names.indexOf("creditIdType");
        index[14] = names.indexOf("creditIdLength");
        index[15] = names.indexOf("creditIdAuto");
        index[16] = names.indexOf("creditIdStartValue");
        index[17] = names.indexOf("initialBookYear");
        int lineCount = 0;
        int okCount = 0;
        String[] values = new String[size];
        String[] saved = new String[size];
        Environment env = null;
        Environment savedEnv = null;
        DBData dbData = null;
        String[] args2 = new String[args.length + 2];
        System.arraycopy(args, 0, args2, 0, args.length);
        args2[args.length] = "facLib";
        line = bufferedReader.readLine();
        while (line != null) {
            ++lineCount;
            if (!(values = CompanyCSV.getColumnValues(line, values))[index[0]].equals(saved[index[0]]) || !values[index[1]].equals(saved[index[1]])) {
                if (savedEnv != null) {
                    args2[args.length + 1] = "" + savedEnv.getFacLib();
                    message = BookYearSynchronizeCommand.execute(args2);
                    if (message != null) {
                        Log.error((String)message);
                    }
                }
                if ((env = CompanyCSV.getEnvironment(values[index[0]], values[index[1]])) == null) {
                    Log.info((String)("environment not found for: " + values[index[0]] + " " + values[index[1]]));
                    line = bufferedReader.readLine();
                    continue;
                }
                dbData = CompanyCSV.getDBData(env);
                saved[index[0]] = values[index[0]];
                saved[index[1]] = values[index[1]];
                savedEnv = env;
            }
            if (CompanyCSV.createCompany(values, index, env, dbData)) {
                ++okCount;
            }
            line = bufferedReader.readLine();
        }
        if (savedEnv != null) {
            args2[args.length + 1] = "" + savedEnv.getFacLib();
            message = BookYearSynchronizeCommand.execute(args2);
            if (message != null) {
                Log.error((String)message);
            }
        }
        TokenList tl = new TokenList();
        tl.addNonTranslatable(String.valueOf(lineCount));
        tl.addNonTranslatable(String.valueOf(lineCount - okCount));
        message = LanguageHelper.getString("nl.ibs.fac.language", "Processed_failed", tl);
        Log.info((String)message);
    }

    private static boolean createCompany(String[] values, int[] index, Environment env, DBData dbData) throws Exception {
        Object[] result;
        String description;
        String id = values[index[2]];
        String dataSetId = values[index[7]];
        if (id.length() == 0) {
            id = values[index[4]].equals("0") ? values[index[3]] : values[index[3]] + '/' + values[index[4]];
            int i = dataSetId.indexOf(47);
            if (i > 0 && dataSetId.substring(i + 1).equals("0")) {
                dataSetId = dataSetId.substring(0, i);
            }
        }
        if ((description = values[index[5]]).length() > 50) {
            description = description.substring(0, 49);
        }
        boolean assetIdAuto = false;
        if ("true".equals(values[index[11]].toLowerCase())) {
            assetIdAuto = true;
        }
        boolean creditIdAuto = false;
        if ("true".equals(values[index[15]].toLowerCase())) {
            creditIdAuto = true;
        }
        if ((result = CompanyBO.create(dbData, id, description, Integer.parseInt(values[index[17]]), Integer.parseInt(values[index[6]]), dataSetId, Integer.parseInt(values[index[8]]), 0, "", values[index[9]], Integer.parseInt(values[index[10]]), assetIdAuto, Integer.parseInt(values[index[12]]), values[index[13]], Integer.parseInt(values[index[14]]), creditIdAuto, Integer.parseInt(values[index[16]]), new int[11], new String[5], new String[5], 0, ""))[0] != null) {
            Company company = (Company)result[0];
            Log.info((String)company.getId());
            ProcessParametersBO.create(dbData, company.getId(), false, false, false, true, 1, false, false, false, false, 0, false, 0, 0, false, false, 0, false, false, false);
        }
        if (result[1] != null) {
            Log.info((String)((String)result[1]));
        }
        return result[1] == null;
    }
}

