/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.inport;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Map;
import nl.ibs.fac.BatchJobHelper;
import nl.ibs.fac.DateHelper;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.IncomingFinancialTransactionBO;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.db.IncomingFinancialTransaction;
import nl.ibs.fac.fis.FISHelper;
import nl.ibs.fac.fms.FMSHelper;
import nl.ibs.fac.inport.ImportCSVHelper;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.language.TokenList;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;

public class IncomingFinancialTransactionCSV
extends ImportCSVHelper {
    public static final String FILENAME = "IncomingFinancialTransaction.csv";
    public static final String CLASSNAME = IncomingFinancialTransactionCSV.class.getName();

    public static void main(String[] args) {
        try {
            IncomingFinancialTransactionCSV.execute(args);
        }
        catch (Exception e) {
            Log.error((Exception)e);
            System.exit(-1);
        }
        System.exit(0);
    }

    public static void execute(String[] args) throws Exception {
        String[][] selections;
        Map map;
        LoginHelper loginHelper;
        String message;
        if (Log.debug() && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                Log.debug((String)args[i]);
            }
        }
        if ((message = (loginHelper = BatchJobHelper.getLoginHelper(map = BatchJobHelper.getSelections(selections = BatchJobHelper.getSelections(args)))).login()) != null) {
            message = LanguageHelper.getString("nl.ibs.fac.language", message);
            Log.error((String)message);
            return;
        }
        String contextName = BatchJobHelper.getContextName(args);
        BufferedReader bufferedReader = IncomingFinancialTransactionCSV.getReader(map, FILENAME, contextName);
        String line = bufferedReader.readLine();
        List names = IncomingFinancialTransactionCSV.getColumnNames(line);
        int size = names.size();
        int[] index = new int[size];
        index[0] = names.indexOf("operationArea");
        index[1] = names.indexOf("dataLib");
        index[2] = names.indexOf("adminId");
        index[3] = names.indexOf("companyId");
        index[4] = names.indexOf("branchId");
        index[5] = names.indexOf("id");
        index[6] = names.indexOf("mainAccount");
        index[7] = names.indexOf("finDimId1");
        index[8] = names.indexOf("finDimId2");
        index[9] = names.indexOf("finDimId3");
        index[10] = names.indexOf("finDimId4");
        index[11] = names.indexOf("finDimId5");
        index[12] = names.indexOf("transactionValue");
        index[13] = names.indexOf("bookYear");
        index[14] = names.indexOf("period");
        index[15] = names.indexOf("internalInvoiceId");
        index[16] = names.indexOf("description");
        index[17] = names.indexOf("bookDate");
        index[18] = names.indexOf("voucherId");
        index[19] = names.indexOf("documentId");
        index[20] = names.indexOf("daybookId");
        index[21] = names.indexOf("unAllocatedValue");
        index[22] = names.indexOf("confirmed");
        int lineCount = 0;
        int okCount = 0;
        String[] values = new String[size];
        String[] saved = new String[size];
        Environment env = null;
        DBData dbData = null;
        String companyId = null;
        String savedCompanyId = null;
        FMSHelper fmsHelper = null;
        Company company = null;
        FileOutputStream fos = null;
        StringBuffer sb = null;
        int idCount = 0;
        DecimalFormat formatter = new DecimalFormat("0000000000");
        line = bufferedReader.readLine();
        while (line != null) {
            String id;
            ++lineCount;
            if (!(values = IncomingFinancialTransactionCSV.getColumnValues(line, values))[index[0]].equals(saved[index[0]]) || !values[index[1]].equals(saved[index[1]])) {
                env = IncomingFinancialTransactionCSV.getEnvironment(values[index[0]], values[index[1]]);
                if (env == null) {
                    Log.info((String)("environment not found for: " + values[index[0]] + " " + values[index[1]]));
                    line = bufferedReader.readLine();
                    continue;
                }
                dbData = IncomingFinancialTransactionCSV.getDBData(env);
                saved[index[0]] = values[index[0]];
                saved[index[1]] = values[index[1]];
            }
            if ((companyId = values[index[2]]).length() == 0) {
                companyId = values[index[4]].equals("0") ? values[index[3]] : values[index[3]] + '/' + values[index[4]];
            } else {
                fmsHelper = new FMSHelper(loginHelper);
            }
            if (!companyId.equals(savedCompanyId)) {
                if (fmsHelper != null && company != null) {
                    loginHelper.logout(env, savedCompanyId, "" + company.getCurrentBookYear());
                }
                if (fmsHelper != null) {
                    company = (Company)CompanyBO.get(dbData, companyId)[0];
                    message = loginHelper.login(env, companyId, "" + company.getCurrentBookYear());
                    if (message != null && message.trim().length() > 0) {
                        Log.error((String)message);
                        loginHelper.logout();
                        return;
                    }
                }
                savedCompanyId = companyId;
                if (fos != null) {
                    fos.close();
                }
                fos = IncomingFinancialTransactionCSV.getFileOutputStream(map, "IFT" + companyId.replace('/', '_') + ".csv", contextName);
                idCount = 0;
            }
            if ((id = values[index[5]]).startsWith("'")) {
                id = id.substring(1);
            }
            sb = new StringBuffer();
            sb.append(id);
            sb.append(";");
            String newId = formatter.format(++idCount);
            sb.append(newId);
            sb.append("\n");
            fos.write(sb.toString().getBytes());
            if (IncomingFinancialTransactionCSV.createIncomingFinancialTransaction(values, index, dbData, companyId, id, newId, fmsHelper)) {
                ++okCount;
            }
            line = bufferedReader.readLine();
        }
        if (fos != null) {
            fos.close();
        }
        if (fmsHelper != null && company != null) {
            loginHelper.logout(env, companyId, "" + company.getCurrentBookYear());
        }
        loginHelper.logout();
        TokenList tl = new TokenList();
        tl.addNonTranslatable(String.valueOf(lineCount));
        tl.addNonTranslatable(String.valueOf(lineCount - okCount));
        message = LanguageHelper.getString("nl.ibs.fac.language", "Processed_failed", tl);
        Log.info((String)message);
    }

    private static boolean createIncomingFinancialTransaction(String[] values, int[] index, DBData dbData, String companyId, String id, String newId, FMSHelper fmsHelper) throws Exception {
        String finDimId5;
        String finDimId4;
        String finDimId3;
        String finDimId2;
        String finDimId1;
        String mainAccount = values[index[6]];
        if (mainAccount.startsWith("'")) {
            mainAccount = mainAccount.substring(1);
        }
        if ((finDimId1 = values[index[7]]).startsWith("'")) {
            finDimId1 = finDimId1.substring(1);
        }
        if ((finDimId2 = values[index[8]]).startsWith("'")) {
            finDimId2 = finDimId2.substring(1);
        }
        if ((finDimId3 = values[index[9]]).startsWith("'")) {
            finDimId3 = finDimId3.substring(1);
        }
        if ((finDimId4 = values[index[10]]).startsWith("'")) {
            finDimId4 = finDimId4.substring(1);
        }
        if ((finDimId5 = values[index[11]]).startsWith("'")) {
            finDimId5 = finDimId5.substring(1);
        }
        boolean confirmed = false;
        if ("true".equals(values[index[22]].toLowerCase())) {
            confirmed = true;
        }
        int systemItemNumber = 0;
        int systemItemSequencenumber = 0;
        try {
            if (values[index[2]].length() == 0) {
                systemItemNumber = Integer.parseInt(id.substring(17, id.length() - 3));
                systemItemSequencenumber = Integer.parseInt(id.substring(id.length() - 3));
                finDimId1 = FISHelper.formatId(finDimId1, 1);
                finDimId2 = FISHelper.formatId(finDimId2, 2);
                finDimId3 = FISHelper.formatId(finDimId3, 3);
                finDimId4 = FISHelper.formatId(finDimId4, 4);
                finDimId5 = FISHelper.formatId(finDimId5, 5);
            } else {
                systemItemNumber = Integer.parseInt(id.substring(5, 10));
                systemItemSequencenumber = Integer.parseInt(id.substring(28));
                finDimId1 = fmsHelper.formatId(finDimId1, 1);
                finDimId2 = fmsHelper.formatId(finDimId2, 2);
                finDimId3 = fmsHelper.formatId(finDimId3, 3);
                finDimId4 = fmsHelper.formatId(finDimId4, 4);
                finDimId5 = "";
            }
        }
        catch (Exception e) {
            Log.info((String)("invalid detailkey: " + id));
        }
        Object[] result = IncomingFinancialTransactionBO.create(dbData, companyId, newId, mainAccount, finDimId1, finDimId2, finDimId3, finDimId4, finDimId5, new BigDecimal(values[index[12]]), Integer.parseInt(values[index[13]]), Integer.parseInt(values[index[14]]), Integer.parseInt(values[index[15]]), values[index[16]], DateHelper.getDate(values[index[17]]), values[index[18]], values[index[19]], values[index[20]], new BigDecimal(values[index[21]]), confirmed, systemItemNumber, systemItemSequencenumber);
        if (result[0] != null) {
            IncomingFinancialTransaction incomingFinancialTransaction = (IncomingFinancialTransaction)result[0];
            Log.info((String)incomingFinancialTransaction.getId());
        }
        if (result[1] != null) {
            Log.info((String)((String)result[1]));
        }
        return result[1] == null;
    }
}

