/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.language;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import nl.ibs.fac.language.Token;
import nl.ibs.fac.language.UserContext;
import nl.ibs.jeelog.Log;

public class TranslatableToken
implements Token {
    public static final String ERRORS_BUNDLE = "Texts";
    private String packageName;
    private String msgToken;

    public TranslatableToken(String packageName, String msgToken) {
        this.packageName = packageName;
        this.msgToken = msgToken;
    }

    protected String translate(Locale locale) {
        String result = null;
        try {
            ResourceBundle resource = ResourceBundle.getBundle(this.getBundleName(), locale);
            result = resource.getString(this.msgToken);
        }
        catch (MissingResourceException e) {
            Log.warn((String)("Missing Resource for: Token[" + this.msgToken + "] Package [" + this.packageName + "] Locale [" + locale + "]"));
            result = this.msgToken;
        }
        return result;
    }

    @Override
    public String getValue() {
        return this.translate(UserContext.getLocale());
    }

    public String toString() {
        return this.getValue();
    }

    protected String getBundleName() {
        String result = null;
        result = this.packageName == null || "".equals(this.packageName) ? ERRORS_BUNDLE : this.packageName + "." + ERRORS_BUNDLE;
        return result;
    }
}

