/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.queries;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import nl.ibs.esp.uiobjects.ODBQuery;
import nl.ibs.fac.db.AssetAnalysisCode;
import nl.ibs.fac.db.AssetAnalysisCodeManager;
import nl.ibs.fac.db.AssetAnalysisCodeManagerFactory;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.ExecutableQuery;
import nl.ibs.jsql.QueryFactory;

public class AssetAnalysisCodeQuery
implements ODBQuery {
    private static final long serialVersionUID = 6978474661463229721L;
    private ExecutableQuery qry;
    private AssetAnalysisCodeManager manager;
    private String companyId;
    private int seqNr;
    private String sql = "companyId = ?_companyId AND seqNr = ?_seqNr";

    public AssetAnalysisCodeQuery(DBData dbData, String companyId, int seqNr) throws Exception {
        this.manager = AssetAnalysisCodeManagerFactory.getInstance(dbData);
        this.qry = QueryFactory.create(AssetAnalysisCode.class, this.sql, "assetId");
        this.qry.setCacheable(true);
        this.companyId = companyId;
        this.seqNr = seqNr;
    }

    public AssetAnalysisCodeQuery(DBData dbData, String companyId, int seqNr, Boolean parentAsset, Boolean subAsset, boolean credit, boolean limitedDepreciation) throws Exception {
        this(dbData, companyId, seqNr);
        if (parentAsset != null) {
            this.sql = this.sql + " AND " + "ownedByAssetAsAssetAnalysisCode" + '.' + "parentAsset" + " = '" + parentAsset.toString() + "'";
        }
        if (subAsset != null) {
            this.sql = this.sql + " AND " + "ownedByAssetAsAssetAnalysisCode" + '.' + "subAsset" + " = '" + subAsset.toString() + "'";
        }
        this.sql = this.sql + " AND " + "ownedByAssetAsAssetAnalysisCode" + '.' + "credit" + " = '" + credit + "'";
        if (limitedDepreciation) {
            this.sql = this.sql + " AND " + "ownedByAssetAsAssetAnalysisCode" + '.' + "assetType" + '.' + "limitedDepreciation" + " = '" + limitedDepreciation + "'";
        }
    }

    public Collection fetchData(String filter, String order, Map parameters, int maxObjects) throws Exception {
        if (filter != null) {
            this.qry.setFilter(this.sql + " AND " + filter);
        } else {
            this.qry.setFilter(this.sql);
        }
        parameters = parameters == null ? new HashMap() : parameters;
        parameters.put("_companyId", this.companyId);
        parameters.put("_seqNr", new Integer(this.seqNr));
        this.qry.setParameters(parameters);
        this.qry.setMaxObjects(maxObjects);
        this.qry.setOrdering(order);
        return this.manager.getCollection(this.qry);
    }
}

