/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.queries;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import nl.ibs.esp.uiobjects.ODBQuery;
import nl.ibs.esp.util.ODBCounter;
import nl.ibs.esp.util.ODBCounterImpl;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.AssetAnalysisCode;
import nl.ibs.fac.db.AssetManager;
import nl.ibs.fac.db.AssetManagerFactory;
import nl.ibs.fac.db.AssetValue;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.ExecutableQuery;
import nl.ibs.jsql.QueryFactory;
import nl.ibs.vegas.persistence.Manager;

public class AssetQuery
implements ODBQuery,
ODBCounter {
    private static final long serialVersionUID = 5254592417607072111L;
    private ExecutableQuery qry;
    private AssetManager manager;
    private ODBCounter counter;
    private String companyId;
    private String sql = "companyId = ?_companyId";

    public AssetQuery(DBData dbData, String companyId) throws Exception {
        this.manager = AssetManagerFactory.getInstance(dbData);
        this.counter = new ODBCounterImpl((Manager)this.manager);
        this.qry = QueryFactory.create(Asset.class, this.sql, "id");
        this.qry.setCacheable(true);
        this.companyId = companyId;
    }

    public AssetQuery(DBData dbData, String companyId, Boolean parentAsset, Boolean subAsset, boolean activated, Boolean currentCapitalization, boolean info, boolean credit) throws Exception {
        this(dbData, companyId, parentAsset, subAsset, activated, currentCapitalization, info, credit, null);
    }

    public AssetQuery(DBData dbData, String companyId, Boolean parentAsset, Boolean subAsset, boolean activated, Boolean currentCapitalization, boolean info, boolean credit, Boolean loan) throws Exception {
        this(dbData, companyId);
        if (parentAsset != null) {
            this.sql = this.sql + " AND " + "parentAsset" + " = '" + parentAsset.toString() + "'";
        }
        if (subAsset != null) {
            this.sql = this.sql + " AND " + "subAsset" + " = '" + subAsset.toString() + "'";
        }
        if (activated) {
            this.sql = parentAsset != null && parentAsset.booleanValue() ? this.sql + " AND (" + "subAsset" + " = 'false' OR " + "state" + " = '" + 2 + "')" : this.sql + " AND " + "state" + " = '" + 2 + "'";
        } else if (currentCapitalization != null) {
            if (currentCapitalization.booleanValue()) {
                this.sql = this.sql + " AND " + "state" + " = '" + 0 + "' AND " + "currentCapitalization" + " = '" + currentCapitalization.toString() + "' AND " + "creditId" + " IS NULL";
            } else if (!info) {
                this.sql = this.sql + " AND " + "state" + " <> '" + 0 + "'";
            }
        }
        this.sql = this.sql + " AND " + "credit" + " = '" + credit + "'";
        if (loan != null) {
            this.sql = this.sql + " AND " + "loan" + " = '" + loan + "'";
        }
    }

    public void setQueryForLimitedDepreciation() {
        this.sql = this.sql + " AND " + "credit" + " = 'false'";
        this.sql = this.sql + " AND (" + "subAsset" + " = 'false'";
        this.sql = this.sql + " OR " + "parentAsset" + " = 'true' AND " + "state" + " <> '" + 0 + "')";
        this.sql = this.sql + " AND " + "assetType" + '.' + "limitedDepreciation" + " = 'true'";
    }

    public void setQueryForSubAssets(String parentId, boolean credit) {
        this.sql = this.sql + " AND " + "parentId" + " = '" + parentId + "' AND " + "credit" + " = '" + credit + "'";
    }

    public Collection fetchData(String filter, String order, Map parameters, int maxObjects) throws Exception {
        if (filter != null) {
            this.setFilter(filter);
        } else {
            this.qry.setFilter(this.sql);
        }
        if (order != null) {
            int j;
            int i = order.indexOf("assetAnalysisCode");
            if (i != -1) {
                j = order.indexOf(",", i + 1);
                order = order.substring(0, i) + order.substring(j + 1);
            }
            if ((i = order.indexOf("assetValue")) != -1) {
                j = order.indexOf(",", i + 1);
                order = order.substring(0, i) + order.substring(j + 1);
            }
        }
        parameters = parameters == null ? new HashMap() : parameters;
        parameters.put("_companyId", this.companyId);
        this.qry.setParameters(parameters);
        this.qry.setMaxObjects(maxObjects);
        this.qry.setOrdering(order);
        return this.manager.getCollection(this.qry);
    }

    private String setFilter(String filter) throws Exception {
        String select;
        int k;
        String seqNr;
        int j;
        int i = filter.indexOf("assetAnalysisCode");
        if (i != -1) {
            if (filter.substring(filter.indexOf(" ", i)).trim().startsWith("IS NULL")) {
                this.qry.setFilter(this.sql);
                return filter;
            }
            this.qry.addImport(AssetAnalysisCode.class);
        }
        while (i != -1) {
            j = filter.indexOf(" ", i);
            seqNr = filter.substring(i + "assetAnalysisCode".length(), j);
            k = filter.indexOf("'", filter.indexOf("'", j + 1) + 1);
            if (filter.substring(j).trim().startsWith("LIKE")) {
                k = filter.indexOf("|") + 2;
            }
            if (filter.substring(j).trim().startsWith("BETWEEN")) {
                k = filter.indexOf("'", filter.indexOf("'", k + 1) + 1);
            }
            select = filter.substring(j, k + 1);
            filter = filter.substring(0, i) + "assetAnalysisCode" + ".contains(" + "seqNr" + " = " + seqNr + " AND " + "code" + select + ")" + filter.substring(k + 1);
            i = filter.indexOf("assetAnalysisCode", k + 1);
        }
        i = filter.indexOf("assetValue");
        if (i != -1) {
            if (filter.substring(filter.indexOf(" ", i)).trim().startsWith("IS NULL")) {
                this.qry.setFilter(this.sql);
                return filter;
            }
            this.qry.addImport(AssetValue.class);
        }
        while (i != -1) {
            j = filter.indexOf(" ", i);
            seqNr = filter.substring(i + "assetValue".length(), j);
            k = filter.indexOf("'", filter.indexOf("'", j + 1) + 1);
            if (filter.substring(j).trim().startsWith("LIKE")) {
                k = filter.indexOf("|") + 2;
            }
            if (filter.substring(j).trim().startsWith("BETWEEN")) {
                k = filter.indexOf("'", filter.indexOf("'", k + 1) + 1);
            }
            select = filter.substring(j, k + 1);
            filter = filter.substring(0, i) + "assetValue" + ".contains(" + "seqNr" + " = " + seqNr + " AND " + "value" + select + ")" + filter.substring(k + 1);
            i = filter.indexOf("assetValue", k + 1);
        }
        this.qry.setFilter(this.sql + " AND " + filter);
        return filter;
    }

    public long count(String filter, Map parameters) throws Exception {
        parameters = parameters == null ? new HashMap() : parameters;
        parameters.put("_companyId", this.companyId);
        if (filter != null && filter.trim().length() > 0) {
            filter = this.setFilter(filter);
            return this.counter.count(this.sql + " AND " + filter, parameters);
        }
        return this.counter.count(this.sql, parameters);
    }
}

