/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.reports;

import java.io.FileOutputStream;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import nl.ibs.fac.BatchJobHelper;
import nl.ibs.fac.DepreciationMethodEnum;
import nl.ibs.fac.IBSDecimal;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.ReportFileHelper;
import nl.ibs.fac.StartPeriodHandlingEnum;
import nl.ibs.fac.boadapters.AnalysisGroupBO;
import nl.ibs.fac.boadapters.AssetTypeBO;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.CompanyAccountingPrincipleDefaultBO;
import nl.ibs.fac.boadapters.EnvironmentBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.boadapters.ValuationBO;
import nl.ibs.fac.db.AnalysisGroup;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.AssetAnalysisCode;
import nl.ibs.fac.db.AssetType;
import nl.ibs.fac.db.AssetValue;
import nl.ibs.fac.db.CompanyAccountingPrincipleDefault;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.Valuation;
import nl.ibs.fac.fis.FISHelper;
import nl.ibs.fac.fms.FMSHelper;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.reports.CSVHelper;
import nl.ibs.fac.ui.AssetSelection;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;
import nl.ibs.util.Stopwatch;

public class AssetSheetToCSV
extends CSVHelper {
    public static final String CLASSNAME = AssetSheetToCSV.class.getName();
    private static final String FILENAME = "AssetSheetReport";
    private static final String[][] BASELABELS = new String[][]{{"Asset", "SubId", "StartPeriod", "Inv0101", "Inv0000", "Inv3112", "Dep0101", "Dep0000", "Dep3112", "DisInvestment", "DisDepr", "YieldValue", "Result", "Interest0101", "Interest0000", "Interest3112", "BookValue0101", "BookValue3112", null, "Type", null, "Dim1", null, "Dim2", null, "Dim3", null, "Dim4", null, "Dim5", null, "DepreciationTime", "Depreciated", "Rest", "ResidualValue", "CurrentCapitalization", "DepreciationMethod", "Afhandeling"}};
    private int numberOfColumns;
    private static String[][] LABELS;
    private static String[] facdim_labels;
    private static int maxSeqNbr;
    private int accountingPrinciple;
    private int bookYearForReport = 0;
    private int fromPeriodForReport = 0;
    private int toPeriodForReport = 0;
    private boolean credit = false;
    private static final BigDecimal ZERO;
    private BigDecimal INV0101 = ZERO;
    private BigDecimal DEP0101 = ZERO;
    private BigDecimal INT0101 = ZERO;
    private BigDecimal INV0000 = ZERO;
    private BigDecimal DEP0000 = ZERO;
    private BigDecimal DIS0000 = ZERO;
    private BigDecimal DDP0000 = ZERO;
    private BigDecimal YLD0000 = ZERO;
    private BigDecimal INT0000 = ZERO;
    private Asset asset = null;
    private Valuation valuation = null;
    private boolean includeDisinvested;
    private boolean excludeBookValueZero;
    private boolean finDimd1Description = false;
    private boolean finDimd2Description = false;
    private boolean finDimd3Description = false;
    private boolean finDimd4Description = false;
    private boolean finDimd5Description = false;
    private boolean typeDescription = false;
    private boolean assetDescription = false;
    private boolean interest;

    public AssetSheetToCSV(String[][] selections, Collection collection, String[][] labels, FMSHelper fmsHelper, FISHelper fisHelper, boolean finDimd1Description, boolean finDimd2Description, boolean finDimd3Description, boolean finDimd4Description, boolean finDimd5Description, boolean typeDescription, boolean assetDescription, boolean interest) throws Exception {
        super(selections, collection, labels, fmsHelper, fisHelper);
        this.numberOfColumns = labels[0].length;
        this.accountingPrinciple = Integer.parseInt(this.extractFromSelections("AccountingPrinciple", selections));
        this.bookYearForReport = Integer.parseInt(this.extractFromSelections("BookYearForReport", selections));
        this.fromPeriodForReport = Integer.parseInt(this.extractFromSelections("PeriodFrom", selections));
        this.toPeriodForReport = Integer.parseInt(this.extractFromSelections("PeriodTo", selections));
        this.finDimd1Description = finDimd1Description;
        this.finDimd2Description = finDimd2Description;
        this.finDimd3Description = finDimd3Description;
        this.finDimd4Description = finDimd4Description;
        this.finDimd5Description = finDimd5Description;
        this.typeDescription = typeDescription;
        this.assetDescription = assetDescription;
        this.interest = interest;
    }

    public void setIncludeDisinvested(boolean includeDisinvested) {
        this.includeDisinvested = includeDisinvested;
    }

    public void setExcludeBookValueZero(boolean excludeBookValueZero) {
        this.excludeBookValueZero = excludeBookValueZero;
    }

    @Override
    protected String[] getRowValues(Object object) throws Exception {
        this.asset = (Asset)object;
        Log.debug((String)this.asset.getId());
        return this.getAttributes();
    }

    private String[] getAttributes() throws Exception {
        int i;
        if (!this.includeDisinvested && this.asset.getDisinvestmentYear() > 0 && PeriodHelper.isBefore(this.asset.getDisinvestmentYear(), this.asset.getDisinvestmentPeriod(), this.bookYearForReport, this.fromPeriodForReport)) {
            return null;
        }
        this.valuation = (Valuation)ValuationBO.getValuation(this.asset.getDBData(), this.asset.getCompanyId(), this.asset.getCora(), this.asset.getId(), this.accountingPrinciple)[0];
        if (this.valuation == null) {
            return null;
        }
        this.processTransactions();
        if (this.excludeBookValueZero && this.INV0101.subtract(this.DEP0101).doubleValue() == 0.0 && this.INV0101.add(this.INV0000).add(this.DIS0000).subtract(this.DEP0101).subtract(this.DEP0000).subtract(this.DDP0000).doubleValue() == 0.0) {
            return null;
        }
        String[] value = new String[this.numberOfColumns];
        int v = 0;
        value[v++] = this.asset.getParentId() == null ? this.asset.getId() : this.asset.getParentId();
        value[v++] = this.asset.getParentId() == null ? "" : this.asset.getId();
        value[v++] = "" + this.valuation.getStartDepreciationBookYear() + "-" + this.valuation.getStartDepreciationPeriod();
        value[v++] = IBSDecimal.format(this.INV0101);
        value[v++] = IBSDecimal.format(this.INV0000);
        value[v++] = IBSDecimal.format(this.INV0101.add(this.INV0000).add(this.DIS0000));
        value[v++] = IBSDecimal.format(this.DEP0101);
        value[v++] = IBSDecimal.format(this.DEP0000);
        value[v++] = IBSDecimal.format(this.DEP0101.add(this.DEP0000).add(this.DDP0000));
        value[v++] = IBSDecimal.format(this.DIS0000);
        value[v++] = IBSDecimal.format(this.DDP0000);
        value[v++] = IBSDecimal.format(this.YLD0000);
        value[v++] = this.asset.getState() != 5 ? IBSDecimal.format(this.DIS0000.subtract(this.DDP0000).add(this.YLD0000).negate()) : IBSDecimal.format(ZERO);
        if (this.interest) {
            value[v++] = IBSDecimal.format(this.INT0101);
            value[v++] = IBSDecimal.format(this.INT0000);
            value[v++] = IBSDecimal.format(this.INT0101.add(this.INT0000));
        }
        value[v++] = IBSDecimal.format(this.INV0101.subtract(this.DEP0101));
        value[v++] = IBSDecimal.format(this.INV0101.add(this.INV0000).add(this.DIS0000).subtract(this.DEP0101).subtract(this.DEP0000).subtract(this.DDP0000));
        if (this.assetDescription) {
            value[v++] = this.asset.getDescription();
        }
        value[v++] = this.asset.getTypeId();
        if (this.typeDescription) {
            value[v++] = ((AssetType)AssetTypeBO.get(this.asset.getDBData(), this.asset.getCompanyId(), this.asset.getTypeId())[0]).getDescription();
        }
        value[v++] = this.asset.getFinDimId1();
        if (this.finDimd1Description) {
            value[v++] = this.asset.getFinDimId1().length() == 0 ? "" : (this.fisHelper != null ? this.fisHelper.getDescription(this.asset.getFinDimId1(), this.asset.getCompanyId(), "" + this.bookYearForReport, 1) : this.fmsHelper.getDescription(this.asset.getFinDimId1(), 1));
        }
        value[v++] = this.asset.getFinDimId2();
        if (this.finDimd2Description) {
            value[v++] = this.asset.getFinDimId2().length() == 0 ? "" : (this.fisHelper != null ? this.fisHelper.getDescription(this.asset.getFinDimId2(), this.asset.getCompanyId(), "" + this.bookYearForReport, 2) : this.fmsHelper.getDescription(this.asset.getFinDimId2(), 2));
        }
        value[v++] = this.asset.getFinDimId3();
        if (this.finDimd3Description) {
            value[v++] = this.asset.getFinDimId3().length() == 0 ? "" : (this.fisHelper != null ? this.fisHelper.getDescription(this.asset.getFinDimId3(), this.asset.getCompanyId(), "" + this.bookYearForReport, 3) : this.fmsHelper.getDescription(this.asset.getFinDimId3(), 3));
        }
        value[v++] = this.asset.getFinDimId4();
        if (this.finDimd4Description) {
            value[v++] = this.asset.getFinDimId4().length() == 0 ? "" : (this.fisHelper != null ? this.fisHelper.getDescription(this.asset.getFinDimId4(), this.asset.getCompanyId(), "" + this.bookYearForReport, 4) : this.fmsHelper.getDescription(this.asset.getFinDimId4(), 4));
        }
        value[v++] = this.asset.getFinDimId5();
        if (this.finDimd5Description) {
            if (this.asset.getFinDimId5().length() == 0) {
                value[v++] = "";
            } else if (this.fisHelper != null) {
                value[v++] = this.fisHelper.getDescription(this.asset.getFinDimId5(), this.asset.getCompanyId(), "" + this.bookYearForReport, 5);
            }
        }
        for (i = v; i < v + maxSeqNbr; ++i) {
            value[i] = "";
        }
        i = v - 1;
        Collection assetAnalysisCodes = this.asset.getAssetAnalysisCodeCollection(null);
        for (AssetAnalysisCode assetAnalysisCode : assetAnalysisCodes) {
            value[i + assetAnalysisCode.getSeqNr()] = "" + assetAnalysisCode.getCode();
        }
        Collection assetValues = this.asset.getAssetValueCollection(null);
        for (AssetValue assetValue : assetValues) {
            value[i + assetValue.getSeqNr()] = "" + assetValue.getValue();
        }
        v += maxSeqNbr;
        value[v++] = "" + this.valuation.getDepreciatableLife();
        value[v++] = "" + this.valuation.getNumberOfDepreciatedPeriods();
        value[v++] = this.valuation.getResidualPercentage().doubleValue() > 0.0 ? IBSDecimal.format(this.valuation.getResidualPercentage()) + "%" : "";
        value[v++] = this.valuation.getResidualValue().doubleValue() != 0.0 ? IBSDecimal.format(this.valuation.getResidualValue()) : "";
        value[v++] = LanguageHelper.getString(this.asset.getCurrentCapitalization());
        value[v++] = DepreciationMethodEnum.getValue(this.valuation.getDepreciationMethod());
        value[v++] = StartPeriodHandlingEnum.getValue(this.valuation.getStartPeriodHandlingMethod());
        return value;
    }

    private void processTransactions() throws Exception {
        this.INV0101 = ZERO;
        this.DEP0101 = ZERO;
        this.INV0000 = ZERO;
        this.DEP0000 = ZERO;
        this.DIS0000 = ZERO;
        this.DDP0000 = ZERO;
        this.YLD0000 = ZERO;
        this.INT0000 = ZERO;
        Iterator transactions = TransactionBO.getBeforeOrEquals(this.asset, this.bookYearForReport, this.toPeriodForReport, this.accountingPrinciple, true, true).iterator();
        Transaction transaction = null;
        int bookYearTransaction = 0;
        int bookPeriodTransaction = 0;
        while (transactions.hasNext()) {
            transaction = (Transaction)transactions.next();
            bookYearTransaction = transaction.getBookYearForJournalization();
            bookPeriodTransaction = transaction.getPeriodForJournalization();
            switch (transaction.getMainTransactionType()) {
                case 1: {
                    if (bookYearTransaction < this.bookYearForReport || bookYearTransaction == this.bookYearForReport && bookPeriodTransaction < this.fromPeriodForReport) {
                        this.INV0101 = this.INV0101.add(transaction.getAmount1());
                        this.DEP0101 = this.DEP0101.add(transaction.getAmount2());
                        break;
                    }
                    if (transaction.getTransactionType() == 140 || transaction.getTransactionType() == 142) {
                        this.DIS0000 = this.DIS0000.add(transaction.getAmount1());
                        this.DDP0000 = this.DDP0000.add(transaction.getAmount2());
                        break;
                    }
                    if (transaction.getTransactionType() == 20) {
                        if (transaction.getPeriodForJournalization() <= this.fromPeriodForReport) {
                            this.INV0101 = this.INV0101.add(transaction.getAmount1());
                            this.DEP0101 = this.DEP0101.add(transaction.getAmount2());
                            break;
                        }
                        this.INV0000 = this.INV0000.add(transaction.getAmount1());
                        this.DEP0000 = this.DEP0000.add(transaction.getAmount2());
                        break;
                    }
                    this.INV0000 = this.INV0000.add(transaction.getAmount1());
                    this.DDP0000 = this.DDP0000.add(transaction.getAmount2());
                    break;
                }
                case 2: {
                    if (bookYearTransaction < this.bookYearForReport || bookYearTransaction == this.bookYearForReport && bookPeriodTransaction < this.fromPeriodForReport) {
                        this.INV0101 = this.INV0101.add(transaction.getAmount1());
                        this.DEP0101 = this.DEP0101.add(transaction.getAmount2());
                        break;
                    }
                    this.DIS0000 = this.DIS0000.add(transaction.getAmount1());
                    this.DDP0000 = this.DDP0000.add(transaction.getAmount2());
                    this.YLD0000 = this.YLD0000.add(transaction.getAmount3());
                    break;
                }
                case 3: {
                    if (bookYearTransaction < this.bookYearForReport || bookYearTransaction == this.bookYearForReport && bookPeriodTransaction < this.fromPeriodForReport) {
                        this.DEP0101 = this.DEP0101.add(transaction.getAmount2());
                        this.INT0101 = this.INT0101.add(transaction.getAmount3());
                        break;
                    }
                    this.DEP0000 = this.DEP0000.add(transaction.getAmount2());
                    this.INT0000 = this.INT0000.add(transaction.getAmount3());
                }
            }
        }
    }

    public static void main(String[] args) {
        Stopwatch sw = null;
        if (Log.debug()) {
            sw = new Stopwatch();
            sw.start();
        }
        try {
            AssetSheetToCSV.execute(args);
        }
        catch (Exception e) {
            Log.error((Exception)e);
            System.exit(-1);
        }
        if (sw != null) {
            Log.debug((String)("Elapsed time: " + sw.stop(1) + " seconds"));
        }
        System.exit(0);
    }

    public static void execute(String[] args) throws Exception {
        String bookYear;
        String companyId;
        String[][] selections;
        Map map;
        LoginHelper loginHelper;
        String message;
        if (Log.debug() && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                Log.debug((String)args[i]);
            }
        }
        if ((message = (loginHelper = BatchJobHelper.getLoginHelper(map = BatchJobHelper.getSelections(selections = BatchJobHelper.getSelections(args)))).login()) != null) {
            message = LanguageHelper.getString("nl.ibs.fac.language", message);
            Log.error((String)message);
            return;
        }
        Environment environment = (Environment)EnvironmentBO.get((String)map.get("facLib"))[0];
        message = loginHelper.login(environment, companyId = (String)map.get("Company"), bookYear = (String)map.get("BookYear"));
        if (message != null && message.trim().length() > 0) {
            message = LanguageHelper.getString("nl.ibs.fac.language", message);
            Log.error((String)message);
            return;
        }
        FMSHelper fmsHelper = null;
        FISHelper fisHelper = null;
        if (environment.getOperationArea().trim().length() > 0) {
            fmsHelper = new FMSHelper(loginHelper);
        } else {
            fisHelper = new FISHelper(loginHelper);
        }
        DBData dbData = BOAdapter.getDBData(map);
        int accountingPrinciple = Integer.parseInt((String)map.get("AccountingPrinciple"));
        CompanyAccountingPrincipleDefault capd = (CompanyAccountingPrincipleDefault)CompanyAccountingPrincipleDefaultBO.get(dbData, companyId, accountingPrinciple)[0];
        boolean interest = capd == null ? true : capd.getCalculateInterest();
        AssetSheetToCSV.BASELABELS[0][3] = LanguageHelper.getString("nl.ibs.fac.language", "Investment") + " 01/01";
        AssetSheetToCSV.BASELABELS[0][4] = LanguageHelper.getString("nl.ibs.fac.language", "Investment");
        AssetSheetToCSV.BASELABELS[0][5] = LanguageHelper.getString("nl.ibs.fac.language", "Investment") + " 31/12";
        AssetSheetToCSV.BASELABELS[0][6] = LanguageHelper.getString("nl.ibs.fac.language", "Depreciation") + " 01/01";
        AssetSheetToCSV.BASELABELS[0][7] = LanguageHelper.getString("nl.ibs.fac.language", "Depreciation");
        AssetSheetToCSV.BASELABELS[0][8] = LanguageHelper.getString("nl.ibs.fac.language", "Depreciation") + " 31/12";
        AssetSheetToCSV.BASELABELS[0][13] = LanguageHelper.getString("nl.ibs.fac.language", "Interest") + " 01/01";
        AssetSheetToCSV.BASELABELS[0][14] = LanguageHelper.getString("nl.ibs.fac.language", "Interest");
        AssetSheetToCSV.BASELABELS[0][15] = LanguageHelper.getString("nl.ibs.fac.language", "Interest") + " 31/12";
        AssetSheetToCSV.BASELABELS[0][16] = LanguageHelper.getString("nl.ibs.fac.language", "BookValue") + " 01/01";
        AssetSheetToCSV.BASELABELS[0][17] = LanguageHelper.getString("nl.ibs.fac.language", "BookValue") + " 31/12";
        AssetSheetToCSV.BASELABELS[0][21] = environment.getName1();
        AssetSheetToCSV.BASELABELS[0][23] = environment.getName2();
        AssetSheetToCSV.BASELABELS[0][25] = environment.getName3();
        AssetSheetToCSV.BASELABELS[0][27] = environment.getName4();
        AssetSheetToCSV.BASELABELS[0][29] = environment.getName5();
        if (!interest) {
            AssetSheetToCSV.BASELABELS[0][13] = null;
            AssetSheetToCSV.BASELABELS[0][14] = null;
            AssetSheetToCSV.BASELABELS[0][15] = null;
        }
        String assetSelectionAsString = (String)map.get(AssetSelection.ASSETSELECTION);
        String assetSelectionAsString2 = (String)map.get(AssetSelection.ASSETSELECTION + "2");
        AssetSelection assetSelection = new AssetSelection(assetSelectionAsString + assetSelectionAsString2);
        boolean finDimd1Description = false;
        boolean finDimd2Description = false;
        boolean finDimd3Description = false;
        boolean finDimd4Description = false;
        boolean finDimd5Description = false;
        boolean typeDescription = false;
        boolean assetDescription = false;
        int maxDescriptions = 0;
        AssetSheetToCSV.BASELABELS[0][18] = null;
        AssetSheetToCSV.BASELABELS[0][20] = null;
        AssetSheetToCSV.BASELABELS[0][22] = null;
        AssetSheetToCSV.BASELABELS[0][24] = null;
        AssetSheetToCSV.BASELABELS[0][26] = null;
        AssetSheetToCSV.BASELABELS[0][28] = null;
        AssetSheetToCSV.BASELABELS[0][30] = null;
        int i = 0;
        StringTokenizer st = new StringTokenizer(assetSelection.getDescription(), ",");
        while (st.hasMoreTokens()) {
            boolean value = Boolean.parseBoolean(st.nextToken());
            if (value) {
                ++maxDescriptions;
                switch (i) {
                    case 0: {
                        finDimd1Description = value;
                        AssetSheetToCSV.BASELABELS[0][22] = LanguageHelper.getString("nl.ibs.fac.language", "Description");
                        break;
                    }
                    case 1: {
                        finDimd2Description = value;
                        AssetSheetToCSV.BASELABELS[0][24] = LanguageHelper.getString("nl.ibs.fac.language", "Description");
                        break;
                    }
                    case 2: {
                        finDimd3Description = value;
                        AssetSheetToCSV.BASELABELS[0][26] = LanguageHelper.getString("nl.ibs.fac.language", "Description");
                        break;
                    }
                    case 3: {
                        finDimd4Description = value;
                        AssetSheetToCSV.BASELABELS[0][28] = LanguageHelper.getString("nl.ibs.fac.language", "Description");
                        break;
                    }
                    case 4: {
                        if (environment.getOperationArea().trim().length() > 0) {
                            typeDescription = value;
                            AssetSheetToCSV.BASELABELS[0][20] = LanguageHelper.getString("nl.ibs.fac.language", "Description");
                            break;
                        }
                        finDimd5Description = value;
                        AssetSheetToCSV.BASELABELS[0][30] = LanguageHelper.getString("nl.ibs.fac.language", "Description");
                        break;
                    }
                    case 5: {
                        if (environment.getOperationArea().trim().length() > 0) {
                            assetDescription = value;
                            AssetSheetToCSV.BASELABELS[0][18] = LanguageHelper.getString("nl.ibs.fac.language", "Description");
                            break;
                        }
                        typeDescription = value;
                        AssetSheetToCSV.BASELABELS[0][20] = LanguageHelper.getString("nl.ibs.fac.language", "Description");
                        break;
                    }
                    case 6: {
                        assetDescription = value;
                        AssetSheetToCSV.BASELABELS[0][18] = LanguageHelper.getString("nl.ibs.fac.language", "Description");
                    }
                }
            }
            ++i;
        }
        Collection analysisGroups = AnalysisGroupBO.getAnalysisGroups(map);
        Iterator agi1 = analysisGroups.iterator();
        maxSeqNbr = 0;
        while (agi1.hasNext()) {
            AnalysisGroup analysisGroup = (AnalysisGroup)agi1.next();
            if (analysisGroup.getSeqNr() <= maxSeqNbr) continue;
            maxSeqNbr = analysisGroup.getSeqNr();
        }
        if (maxSeqNbr > 0) {
            facdim_labels = new String[maxSeqNbr];
            for (AnalysisGroup analysisGroup : analysisGroups) {
                AssetSheetToCSV.facdim_labels[analysisGroup.getSeqNr() - 1] = analysisGroup.getShortName();
            }
        }
        LABELS = interest ? new String[1][31 + maxSeqNbr + maxDescriptions] : new String[1][31 + maxSeqNbr + maxDescriptions - 3];
        int j = 0;
        for (i = 0; i < 31; ++i) {
            if (BASELABELS[0][i] == null) continue;
            AssetSheetToCSV.LABELS[0][j++] = BASELABELS[0][i];
        }
        if (maxSeqNbr > 0) {
            for (i = j; i < j + maxSeqNbr; ++i) {
                AssetSheetToCSV.LABELS[0][i] = facdim_labels[i - j];
            }
        } else {
            i = j;
        }
        j = 0;
        while (i < LABELS[0].length) {
            AssetSheetToCSV.LABELS[0][i] = BASELABELS[0][31 + j++];
            ++i;
        }
        AssetSheetToCSV assetSheetToCSV = new AssetSheetToCSV(selections, assetSelection.getCollection(), LABELS, fmsHelper, fisHelper, finDimd1Description, finDimd2Description, finDimd3Description, finDimd4Description, finDimd5Description, typeDescription, assetDescription, interest);
        assetSheetToCSV.setIncludeDisinvested(assetSelection.getIncludeDisinvested());
        assetSheetToCSV.setExcludeBookValueZero(assetSelection.getExcludeBookValueZero());
        FileOutputStream fos = new FileOutputStream(ReportFileHelper.getFileName(args, FILENAME, "csv"));
        fos.write(assetSheetToCSV.createCsv());
        fos.close();
        loginHelper.logout(environment, companyId, bookYear);
        loginHelper.logout();
    }

    static {
        ZERO = new BigDecimal(0.0);
    }
}

