/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.reports;

import com.itextpdf.text.Rectangle;
import java.io.FileOutputStream;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Map;
import nl.ibs.fac.BatchJobHelper;
import nl.ibs.fac.IBSDecimal;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.ReportFileHelper;
import nl.ibs.fac.adapters.NumericIdTransformer;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.CompanyAccountingPrincipleDefaultBO;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.EnvironmentBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.boadapters.ValuationBO;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.CompanyAccountingPrincipleDefault;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.Valuation;
import nl.ibs.fac.fis.FISHelper;
import nl.ibs.fac.fms.FMSHelper;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.reports.PdfHelper;
import nl.ibs.fac.ui.AssetSelection;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;
import nl.ibs.util.Stopwatch;

public class AssetSheetToPDF
extends PdfHelper {
    public static final String CLASSNAME = AssetSheetToPDF.class.getName();
    private static final String FILENAME = "AssetSheetReport";
    private static final String REPORTTITLE = "AssetSheetReport";
    private static final String[][] LABELS = new String[][]{{"Asset", "Description", "StartPeriod", "DepreciationTime", "Depreciated", "Rest", "Investment", "Depreciation", "BookValue", "Investment", "Depreciation", "DisInvestment", "DisInvestmentDepr", "YieldValue", "ResultValue", "Interest", "Investment", "Depreciation", "BookValue"}};
    private static final String[][] LABELSNOINTEREST = new String[][]{{"Asset", "Description", "StartPeriod", "DepreciationTime", "Depreciated", "Rest", "Investment", "Depreciation", "BookValue", "Investment", "Depreciation", "DisInvestment", "DisInvestmentDepr", "YieldValue", "ResultValue", "Investment", "Depreciation", "BookValue"}};
    private static final int[] SIZES = new int[]{400, 1200, 250, 160, 160, 160, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500};
    private static final int[] SIZESNOINTEREST = new int[]{400, 1200, 250, 160, 160, 160, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500};
    private static final boolean[] RIGHTALIGN = new boolean[]{false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true};
    private static final boolean[] RIGHTALIGNNOINTEREST = new boolean[]{false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true};
    private int accountingPrinciple = 0;
    private int bookYearForReport = 0;
    private int fromPeriodForReport = 0;
    private int toPeriodForReport = 0;
    private int numberOfColumns = 0;
    private int printedLines = 0;
    private int[] orderByField = null;
    private boolean numericId;
    private boolean credit = false;
    private static final BigDecimal ZERO = new BigDecimal(0.0);
    private BigDecimal INV0101 = ZERO;
    private BigDecimal DEP0101 = ZERO;
    private BigDecimal INT0101 = ZERO;
    private BigDecimal INV0000 = ZERO;
    private BigDecimal DEP0000 = ZERO;
    private BigDecimal DIS0000 = ZERO;
    private BigDecimal DDP0000 = ZERO;
    private BigDecimal YLD0000 = ZERO;
    private BigDecimal INT0000 = ZERO;
    private NumericIdTransformer numericIdTransformer = new NumericIdTransformer();
    private Environment env = null;
    private Asset asset = null;
    private Valuation valuation = null;
    private AssetSelection selection;

    public AssetSheetToPDF(String reportTitle, String[][] selections, AssetSelection assetSelection, boolean governmentActivated, Environment environment, FMSHelper fmsHelper, FISHelper fisHelper, String companyId, String bookYear, boolean numericId, boolean interest) throws Exception {
        super(reportTitle, selections, assetSelection.getCollection(), fmsHelper, fisHelper, companyId, bookYear, interest);
        this.env = environment;
        this.numberOfColumns = interest ? LABELS[0].length : LABELSNOINTEREST[0].length;
        this.numericId = numericId;
        this.selection = assetSelection;
        this.orderByField = assetSelection.getOrderBy();
        this.value = new String[this.numberOfColumns];
        this.bold = new boolean[this.numberOfColumns];
        this.translate = new boolean[this.numberOfColumns];
        this.accountingPrinciple = Integer.parseInt(this.extractFromSelections("AccountingPrinciple"));
        this.bookYearForReport = Integer.parseInt(this.extractFromSelections("BookYearForReport"));
        this.fromPeriodForReport = Integer.parseInt(this.extractFromSelections("PeriodFrom"));
        this.toPeriodForReport = Integer.parseInt(this.extractFromSelections("PeriodTo"));
        this.interest = interest;
        this.init();
    }

    private void init() throws Exception {
        this.document.setPageSize(new Rectangle(2000.0f, 1200.0f));
        if (this.selection.getJustTotals()) {
            AssetSheetToPDF.LABELS[0][0] = "";
            AssetSheetToPDF.LABELS[0][1] = "Description";
            AssetSheetToPDF.LABELS[0][2] = "";
            AssetSheetToPDF.LABELS[0][3] = "";
            AssetSheetToPDF.LABELS[0][4] = "";
            AssetSheetToPDF.LABELS[0][5] = "";
            AssetSheetToPDF.LABELSNOINTEREST[0][0] = "";
            AssetSheetToPDF.LABELSNOINTEREST[0][1] = "Description";
            AssetSheetToPDF.LABELSNOINTEREST[0][2] = "";
            AssetSheetToPDF.LABELSNOINTEREST[0][3] = "";
            AssetSheetToPDF.LABELSNOINTEREST[0][4] = "";
            AssetSheetToPDF.LABELSNOINTEREST[0][5] = "";
        }
        if (this.interest) {
            this.createTable(true, LABELS, SIZES, RIGHTALIGN, null);
        } else {
            this.createTable(true, LABELSNOINTEREST, SIZESNOINTEREST, RIGHTALIGNNOINTEREST, null);
        }
        this.addTableHeaderFirstLine();
        this.addTableHeader(1);
    }

    private void addTableHeaderFirstLine() throws Exception {
        this.resetCellBorders();
        if (this.interest) {
            this.setCellBorder(6, 5);
            this.setCellBorder(7, 1);
            this.setCellBorder(8, 1);
            this.setCellBorder(9, 5);
            this.setCellBorder(10, 1);
            this.setCellBorder(11, 1);
            this.setCellBorder(12, 1);
            this.setCellBorder(13, 1);
            this.setCellBorder(14, 1);
            this.setCellBorder(15, 1);
            this.setCellBorder(16, 5);
            this.setCellBorder(17, 1);
            this.setCellBorder(18, 1);
            this.clearCells();
            this.setCell(7, LanguageHelper.getString("nl.ibs.fac.language", "BalanceBegin"), false, false);
            this.setCell(12, LanguageHelper.getString("nl.ibs.fac.language", "CumMutations"), false, false);
            this.setCell(17, LanguageHelper.getString("nl.ibs.fac.language", "BalanceEnd"), false, false);
            this.addTableRow();
            this.resetCellBorders();
            this.setCellBorder(6, 4);
            this.setCellBorder(9, 4);
            this.setCellBorder(16, 4);
        } else {
            this.setCellBorder(6, 5);
            this.setCellBorder(7, 1);
            this.setCellBorder(8, 1);
            this.setCellBorder(9, 5);
            this.setCellBorder(10, 1);
            this.setCellBorder(11, 1);
            this.setCellBorder(12, 1);
            this.setCellBorder(13, 1);
            this.setCellBorder(14, 1);
            this.setCellBorder(15, 5);
            this.setCellBorder(16, 1);
            this.setCellBorder(17, 1);
            this.clearCells();
            this.setCell(7, LanguageHelper.getString("nl.ibs.fac.language", "BalanceBegin"), false, false);
            this.setCell(12, LanguageHelper.getString("nl.ibs.fac.language", "CumMutations"), false, false);
            this.setCell(16, LanguageHelper.getString("nl.ibs.fac.language", "BalanceEnd"), false, false);
            this.addTableRow();
            this.resetCellBorders();
            this.setCellBorder(6, 4);
            this.setCellBorder(9, 4);
            this.setCellBorder(15, 4);
        }
    }

    @Override
    protected void processObject(Object object) throws Exception {
        this.asset = (Asset)object;
        Log.debug((String)this.asset.getId());
        if (this.printedLines > 0) {
            this.printSubTotals();
        }
        this.printedLines = 0;
        this.valuation = (Valuation)ValuationBO.getValuation(this.asset.getDBData(), this.asset.getCompanyId(), this.asset.getCora(), this.asset.getId(), this.accountingPrinciple)[0];
        this.printAsset();
    }

    private void printAsset() throws Exception {
        if (!this.selection.getIncludeDisinvested() && this.asset.getDisinvestmentYear() > 0 && PeriodHelper.isBefore(this.asset.getDisinvestmentYear(), this.asset.getDisinvestmentPeriod(), this.bookYearForReport, this.fromPeriodForReport)) {
            return;
        }
        if (this.valuation == null) {
            return;
        }
        this.processTransactions();
        if (this.selection.getExcludeBookValueZero() && this.INV0101.subtract(this.DEP0101).doubleValue() == 0.0 && this.INV0101.add(this.INV0000).add(this.DIS0000).subtract(this.DEP0101).subtract(this.DEP0000).subtract(this.DDP0000).doubleValue() == 0.0) {
            return;
        }
        String[] attr = this.getPrintAttributes();
        for (int i = 0; i < attr.length; ++i) {
            this.setCell(i, attr[i], false, false);
        }
        if (!this.selection.getJustTotals()) {
            this.addTableRow();
            ++this.printedLines;
        }
        this.cumulate(this.asset);
    }

    private String[] getPrintAttributes() throws Exception {
        String[] attr = new String[this.numberOfColumns];
        int v = 0;
        attr[v++] = AssetSheetToPDF.formatAssetId(this.asset, this.numericId);
        attr[v++] = this.asset.getDescription();
        attr[v++] = "" + this.valuation.getStartDepreciationBookYear() + "-" + this.valuation.getStartDepreciationPeriod();
        attr[v++] = "" + this.valuation.getDepreciatableLife();
        attr[v++] = "" + this.valuation.getNumberOfDepreciatedPeriods();
        attr[v++] = "" + (this.valuation.getDepreciatableLife() - this.valuation.getNumberOfDepreciatedPeriods());
        attr[v++] = IBSDecimal.format(this.INV0101, true);
        attr[v++] = IBSDecimal.format(this.DEP0101, true);
        attr[v++] = IBSDecimal.format(this.INV0101.subtract(this.DEP0101), true);
        attr[v++] = IBSDecimal.format(this.INV0000, true);
        attr[v++] = IBSDecimal.format(this.DEP0000, true);
        attr[v++] = IBSDecimal.format(this.DIS0000, true);
        attr[v++] = IBSDecimal.format(this.DDP0000, true);
        attr[v++] = IBSDecimal.format(this.YLD0000, true);
        attr[v++] = this.asset.getState() != 5 ? IBSDecimal.format(this.DIS0000.subtract(this.DDP0000).add(this.YLD0000).negate(), true) : IBSDecimal.format(ZERO, true);
        if (this.interest) {
            attr[v++] = IBSDecimal.format(this.INT0000, true);
        }
        attr[v++] = IBSDecimal.format(this.INV0101.add(this.INV0000).add(this.DIS0000), true);
        attr[v++] = IBSDecimal.format(this.DEP0101.add(this.DEP0000).add(this.DDP0000), true);
        attr[v++] = IBSDecimal.format(this.INV0101.add(this.INV0000).add(this.DIS0000).subtract(this.DEP0101).subtract(this.DEP0000).subtract(this.DDP0000), true);
        return attr;
    }

    protected void printSubTotals() throws Exception {
        int o = this.orderByField.length;
        int[] orderBy = new int[o];
        for (int i = 0; i < this.orderByField.length; ++i) {
            orderBy[i] = this.orderByField[--o];
        }
        for (o = 0; o < orderBy.length; ++o) {
            int lvl = orderBy[o];
            if (lvl <= 0 || !this.cumulator.getSwitchCumulationLevel(lvl) || !this.cumulator.levelBreak(this.asset, lvl) && !this.endOfFile || lvl == 8 && this.printedLines <= 1) continue;
            this.addSubTotalRow(lvl);
        }
        if (this.endOfFile && this.selection.getGrandTotal()) {
            this.addSubTotalRow(0);
        }
    }

    protected void addSubTotalRow(int level) throws Exception {
        String id = (String)this.numericIdTransformer.transform(this.cumulator.getLevelValue(level)[0]);
        String descr = this.cumulator.getLevelValue(level)[1];
        if (level >= 1 && level <= 6) {
            descr = this.getFinDimDescription(id, level - 1);
        }
        BigDecimal[] total = this.getTotalsForLevel(level);
        int v = 0;
        if (level == 0) {
            this.setCell(v++, this.totalGenText, false, true);
            this.setCell(v++, "", false, true);
        } else {
            this.setCell(v++, this.totalText, false, true);
            this.setCell(v++, this.cumulator.getLevelName(level, this.env) + " " + id + " (" + descr + ")", false, true);
        }
        this.setCell(v++, "", false, true);
        this.setCell(v++, "", false, true);
        this.setCell(v++, "", false, true);
        this.setCell(v++, "", false, true);
        this.setCell(v++, IBSDecimal.format(total[6], true), false, true);
        this.setCell(v++, IBSDecimal.format(total[7], true), false, true);
        this.setCell(v++, IBSDecimal.format(total[8], true), false, true);
        this.setCell(v++, IBSDecimal.format(total[9], true), false, true);
        this.setCell(v++, IBSDecimal.format(total[10], true), false, true);
        this.setCell(v++, IBSDecimal.format(total[11], true), false, true);
        this.setCell(v++, IBSDecimal.format(total[12], true), false, true);
        this.setCell(v++, IBSDecimal.format(total[13], true), false, true);
        this.setCell(v++, IBSDecimal.format(total[14], true), false, true);
        if (this.interest) {
            this.setCell(v++, IBSDecimal.format(total[15], true), false, true);
            this.setCell(v++, IBSDecimal.format(total[16], true), false, true);
            this.setCell(v++, IBSDecimal.format(total[17], true), false, true);
            this.setCell(v++, IBSDecimal.format(total[18], true), false, true);
        } else {
            this.setCell(v++, IBSDecimal.format(total[15], true), false, true);
            this.setCell(v++, IBSDecimal.format(total[16], true), false, true);
            this.setCell(v++, IBSDecimal.format(total[17], true), false, true);
        }
        this.addTableRow();
        this.addEmptyTableRow();
    }

    @Override
    protected void addTotalGenRow() throws Exception {
        this.printSubTotals();
    }

    @Override
    protected int[] getColumnsToCumulate() throws Exception {
        if (this.interest) {
            return new int[]{6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18};
        }
        return new int[]{6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17};
    }

    public static void main(String[] args) {
        Stopwatch sw = null;
        if (Log.debug()) {
            sw = new Stopwatch();
            sw.start();
        }
        try {
            AssetSheetToPDF.execute(args);
        }
        catch (Exception e) {
            Log.error((Exception)e);
            System.exit(-1);
        }
        if (sw != null) {
            Log.debug((String)("Elapsed time: " + sw.stop(1) + " seconds"));
        }
        System.exit(0);
    }

    public static void execute(String[] args) throws Exception {
        String bookYear;
        String companyId;
        String[][] selections;
        Map map;
        LoginHelper loginHelper;
        String message;
        if (Log.debug() && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                Log.debug((String)args[i]);
            }
        }
        if ((message = (loginHelper = BatchJobHelper.getLoginHelper(map = BatchJobHelper.getSelections(selections = BatchJobHelper.getSelections(args)))).login()) != null) {
            message = LanguageHelper.getString("nl.ibs.fac.language", message);
            Log.error((String)message);
            return;
        }
        String assetSelectionAsString = (String)map.get(AssetSelection.ASSETSELECTION);
        String assetSelectionAsString2 = (String)map.get(AssetSelection.ASSETSELECTION + "2");
        AssetSelection assetSelection = new AssetSelection(assetSelectionAsString + assetSelectionAsString2);
        boolean governmentActivated = Boolean.valueOf((String)map.get("governmentActivated"));
        Environment environment = (Environment)EnvironmentBO.get((String)map.get("facLib"))[0];
        message = loginHelper.login(environment, companyId = (String)map.get("Company"), bookYear = (String)map.get("BookYear"));
        if (message != null && message.trim().length() > 0) {
            message = LanguageHelper.getString("nl.ibs.fac.language", message);
            Log.error((String)message);
            return;
        }
        FMSHelper fmsHelper = null;
        FISHelper fisHelper = null;
        if (environment.getOperationArea().trim().length() > 0) {
            fmsHelper = new FMSHelper(loginHelper);
        } else {
            fisHelper = new FISHelper(loginHelper);
        }
        DBData dbData = BOAdapter.getDBData(map);
        int accountingPrinciple = Integer.parseInt((String)map.get("AccountingPrinciple"));
        CompanyAccountingPrincipleDefault capd = (CompanyAccountingPrincipleDefault)CompanyAccountingPrincipleDefaultBO.get(dbData, companyId, accountingPrinciple)[0];
        boolean interest = capd == null ? true : capd.getCalculateInterest();
        Company company = (Company)CompanyBO.get(dbData, companyId)[0];
        AssetSheetToPDF assetSheetToPDF = new AssetSheetToPDF("AssetSheetReport", selections, assetSelection, governmentActivated, environment, fmsHelper, fisHelper, companyId, bookYear, AssetBO.isIdNumeric(company, false), interest);
        FileOutputStream fos = new FileOutputStream(ReportFileHelper.getFileName(args, "AssetSheetReport", "pdf"));
        fos.write(assetSheetToPDF.createPdf().toByteArray());
        fos.close();
        loginHelper.logout(environment, companyId, bookYear);
        loginHelper.logout();
    }

    private void processTransactions() throws Exception {
        this.INV0101 = ZERO;
        this.DEP0101 = ZERO;
        this.INV0000 = ZERO;
        this.DEP0000 = ZERO;
        this.DIS0000 = ZERO;
        this.DDP0000 = ZERO;
        this.YLD0000 = ZERO;
        this.INT0000 = ZERO;
        Iterator transactions = TransactionBO.getBeforeOrEquals(this.asset, this.bookYearForReport, this.toPeriodForReport, this.accountingPrinciple, true, true).iterator();
        Transaction transaction = null;
        int bookYearTransaction = 0;
        int bookPeriodTransaction = 0;
        while (transactions.hasNext()) {
            transaction = (Transaction)transactions.next();
            bookYearTransaction = transaction.getBookYearForJournalization();
            bookPeriodTransaction = transaction.getPeriodForJournalization();
            switch (transaction.getMainTransactionType()) {
                case 1: {
                    if (bookYearTransaction < this.bookYearForReport || bookYearTransaction == this.bookYearForReport && bookPeriodTransaction < this.fromPeriodForReport) {
                        this.INV0101 = this.INV0101.add(transaction.getAmount1());
                        this.DEP0101 = this.DEP0101.add(transaction.getAmount2());
                        break;
                    }
                    if (transaction.getTransactionType() == 20) {
                        if (transaction.getPeriodForJournalization() == 1) {
                            this.INV0101 = this.INV0101.add(transaction.getAmount1());
                            this.DEP0101 = this.DEP0101.add(transaction.getAmount2());
                            break;
                        }
                        this.INV0000 = this.INV0000.add(transaction.getAmount1());
                        this.DEP0000 = this.DEP0000.add(transaction.getAmount2());
                        break;
                    }
                    this.INV0000 = this.INV0000.add(transaction.getAmount1());
                    this.DEP0000 = this.DEP0000.add(transaction.getAmount2());
                    break;
                }
                case 2: {
                    if (bookYearTransaction < this.bookYearForReport || bookYearTransaction == this.bookYearForReport && bookPeriodTransaction < this.fromPeriodForReport) {
                        this.INV0101 = this.INV0101.add(transaction.getAmount1());
                        this.DEP0101 = this.DEP0101.add(transaction.getAmount2());
                        break;
                    }
                    this.DIS0000 = this.DIS0000.add(transaction.getAmount1());
                    this.DDP0000 = this.DDP0000.add(transaction.getAmount2());
                    this.YLD0000 = this.YLD0000.add(transaction.getAmount3());
                    break;
                }
                case 3: {
                    if (bookYearTransaction < this.bookYearForReport || bookYearTransaction == this.bookYearForReport && bookPeriodTransaction < this.fromPeriodForReport) {
                        this.DEP0101 = this.DEP0101.add(transaction.getAmount2());
                        this.INT0101 = this.INT0101.add(transaction.getAmount3());
                        break;
                    }
                    this.DEP0000 = this.DEP0000.add(transaction.getAmount2());
                    this.INT0000 = this.INT0000.add(transaction.getAmount3());
                }
            }
        }
    }
}

