/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.reports;

import com.itextpdf.text.Rectangle;
import java.io.FileOutputStream;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Map;
import nl.ibs.fac.AssetStateEnum;
import nl.ibs.fac.BatchJobHelper;
import nl.ibs.fac.DateHelper;
import nl.ibs.fac.DepreciationMethodEnum;
import nl.ibs.fac.IBSDecimal;
import nl.ibs.fac.InterestCalculationMethodEnum;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.ReportFileHelper;
import nl.ibs.fac.StartPeriodHandlingEnum;
import nl.ibs.fac.TransactionTypeEnum;
import nl.ibs.fac.boadapters.AssetAnalysisCodeBO;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.boadapters.AssetValueBO;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.EnvironmentBO;
import nl.ibs.fac.boadapters.MemoBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.boadapters.WozValueBO;
import nl.ibs.fac.db.AnalysisGroup;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.AssetAnalysisCode;
import nl.ibs.fac.db.AssetType;
import nl.ibs.fac.db.AssetValue;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.db.Memo;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.Valuation;
import nl.ibs.fac.db.WozValue;
import nl.ibs.fac.fis.FISHelper;
import nl.ibs.fac.fms.FMSHelper;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.reports.CreditToPDF;
import nl.ibs.fac.reports.PdfHelper;
import nl.ibs.fac.ui.AssetSelection;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.ExecutableQuery;
import nl.ibs.jsql.QueryFactory;
import nl.ibs.util.NameValuePair;
import nl.ibs.util.Stopwatch;

public class AssetToPDF
extends PdfHelper {
    public static final String CLASSNAME = AssetToPDF.class.getName();
    private static final String FILENAME = "Asset";
    private static final String REPORTTITLE = "Assets";
    private String[][] labels;
    private int[] sizes;
    private boolean[] rightAlign;
    private float indent;
    private static final String[][] LABELS1 = new String[][]{{"", "", ""}};
    private static final int[] SIZES1 = new int[]{100, 10, 290};
    private static final boolean[] RIGHTALIGN1 = new boolean[]{false, false, false};
    private static final String[][] LABELS2 = new String[][]{{"", "", "", "", "", ""}};
    private static final int[] SIZES2 = new int[]{100, 10, 90, 100, 10, 90};
    private static final boolean[] RIGHTALIGN2 = new boolean[]{false, false, false, false, false, false};
    private static final String[][] LABELS4 = new String[][]{{"", "", "", ""}};
    private static final int[] SIZES4 = new int[]{100, 10, 50, 240};
    private static final boolean[] RIGHTALIGN4 = new boolean[]{false, false, false, false};
    private static final String[][] LABELS3 = new String[][]{{"Period", "TransactionType", "ACQUISITION", "Depreciation", "Interest", "", "Description", "TransactionNumber.short"}};
    private static final int[] SIZES3 = new int[]{40, 90, 60, 60, 60, 10, 100, 50};
    private static final boolean[] RIGHTALIGN3 = new boolean[]{false, false, true, true, true, false, false, false};
    private Environment environment;
    private FMSHelper fmsHelper;
    private FISHelper fisHelper;
    private String companyId;
    private String bookYear;
    private boolean numericId;
    private Asset asset = null;
    private AssetType assetType;
    private boolean doTransactions;
    private static final BigDecimal ZERO = new BigDecimal("0.00");

    public AssetToPDF(String reportTitle, String[][] selections, Collection collection, boolean governmentActivated, Environment environment, FMSHelper fmsHelper, FISHelper fisHelper, String companyId, String bookYear, boolean numericId, int accountingPrinciple2Usage) throws Exception {
        super(reportTitle, selections, collection, fmsHelper, fisHelper, companyId, bookYear);
        this.document.setPageSize(new Rectangle(1000.0f, 1400.0f));
        this.environment = environment;
        this.fmsHelper = fmsHelper;
        this.fisHelper = fisHelper;
        this.companyId = companyId;
        this.bookYear = bookYear;
        this.numericId = numericId;
        String printTrans = this.extractFromSelections("PrintTransactions");
        if (printTrans != null) {
            this.doTransactions = Boolean.valueOf(printTrans);
        }
    }

    @Override
    protected void processObject(Object object) throws Exception {
        this.setLayout(1);
        this.createTable(true, this.labels, this.sizes, this.rightAlign, null);
        if (this.asset != null) {
            this.document.newPage();
        }
        this.asset = (Asset)object;
        this.assetType = this.asset.getAssetType();
        this.printCommon();
        this.printDimensions();
        this.printValuations();
    }

    private void printCommon() throws Exception {
        Memo memo;
        this.setCell(0, "Algemeen", false, true);
        this.addTableRow();
        this.addEmptyTableRow();
        this.indent = 10.0f;
        this.defaultCell.setIndent(this.indent);
        this.setCell(0, "Id", true, false);
        this.setCell(1, ":", false, false);
        String id = this.asset.getId();
        if (this.numericId) {
            try {
                id = String.valueOf(Integer.parseInt(id.trim()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.setCell(2, id, false, false);
        this.addTableRow();
        this.setCell(0, "Description", true, false);
        this.setCell(2, this.asset.getDescription(), false, false);
        this.addTableRow();
        if (this.asset.getParentId() != null) {
            this.setCell(0, "ParentAsset", true, false);
            if (this instanceof CreditToPDF) {
                this.setCell(0, "ParentCredit", true, false);
            }
            this.setCell(2, this.asset.getParent().getId() + " - " + this.asset.getParent().getDescription(), false, false);
            this.addTableRow();
        }
        this.setCell(0, "State", true, false);
        String assetState = AssetStateEnum.getValue(this.asset.getState());
        if (this.asset.getState() == 4 || this.asset.getState() == 5 || this.asset.getState() == 7) {
            assetState = assetState + " (" + this.asset.getDisinvestmentYear() + "-" + this.asset.getDisinvestmentPeriod() + ")";
        }
        this.setCell(2, assetState, false, false);
        this.addTableRow();
        this.setCell(0, "AssetType", true, false);
        this.setCell(2, this.asset.getTypeId() + " : " + this.assetType.getDescription(), false, false);
        this.addTableRow();
        if (!this.asset.getSubAsset()) {
            this.setCell(0, "ParentAsset", true, false);
            if (this instanceof CreditToPDF) {
                this.setCell(0, "ParentCredit", true, false);
            }
            this.setCell(2, Boolean.toString(true), true, false);
            this.addTableRow();
            this.addEmptyTableRow();
            return;
        }
        this.addEmptyTableRow();
        if (this.asset.getCurrentCapitalization()) {
            this.setCell(0, "CurrentCapitalization", true, false);
            this.setCell(2, "" + this.asset.getCurrentCapitalization(), true, false);
            this.addTableRow();
            this.setCell(0, "HistAcqDate", true, false);
            this.setCell(2, DateHelper.format(this.asset.getAcquisitionDate()), false, false);
            this.addTableRow();
            this.setCell(0, "HistAcqPeriod", true, false);
            this.setCell(2, PeriodHelper.toString(this.asset.getHistoricalYear(), this.asset.getHistoricalPeriod()), false, false);
            this.addTableRow();
        } else {
            this.setCell(0, "AcquisitionDate", true, false);
            if (this instanceof CreditToPDF) {
                this.setCell(0, "CreditDate", true, false);
            }
            this.setCell(2, DateHelper.format(this.asset.getAcquisitionDate()), false, false);
            this.addTableRow();
        }
        this.setCell(0, "FACStartPeriod", true, false);
        this.setCell(2, PeriodHelper.toString(this.asset.getStartUseYear(), this.asset.getStartUsePeriod()), false, false);
        this.addTableRow();
        this.setCell(0, "CurrentAcquisitionValue", true, false);
        if (this instanceof CreditToPDF) {
            this.setCell(0, "CurrentCreditValue", true, false);
        }
        this.setCell(2, IBSDecimal.format(AssetBO.getAcquisitionValue(this.asset), true), false, false);
        this.addTableRow();
        if (this.asset.getParentAsset() && this.assetType.getLimitedDepreciation()) {
            this.addWOZValue(0);
        }
        if (this.asset.getNegativeInvestment()) {
            this.setCell(0, "NegativeInvestment", true, false);
            this.setCell(2, "" + this.asset.getNegativeInvestment(), true, false);
            this.addTableRow();
        }
        if (this.asset.getLoan()) {
            this.setCell(0, "Loan", true, false);
            this.setCell(2, "" + this.asset.getLoan(), true, false);
            this.addTableRow();
        }
        if ((memo = (Memo)MemoBO.get(this.asset)[0]) != null) {
            this.setCell(0, "Memo", true, false);
            this.setCell(2, memo.getMemo(), false, false);
            this.addTableRow();
        }
        this.addEmptyTableRow();
    }

    private void addWOZValue(int accountingPrinciple) throws Exception {
        WozValue wozValue;
        String coraAberNichtVonMora = "A";
        if (this instanceof CreditToPDF) {
            coraAberNichtVonMora = "C";
        }
        if ((wozValue = WozValueBO.getLastWozValue(this.asset.getDBData(), this.companyId, coraAberNichtVonMora, this.asset.getId())) != null) {
            if (accountingPrinciple == 0) {
                this.setCell(0, "CurrentWOZValue", true, false);
                this.setCell(2, IBSDecimal.format(wozValue.getWOZAmount(), true), false, false);
            } else {
                this.setCell(0, "LimitValue", true, false);
                if (accountingPrinciple == 1) {
                    this.setCell(2, IBSDecimal.format(wozValue.getLimitAmount1()), false, false);
                } else {
                    this.setCell(2, IBSDecimal.format(wozValue.getLimitAmount2()), false, false);
                }
            }
            this.addTableRow();
        }
    }

    private void printDimensions() throws Exception {
        this.setLayout(4);
        this.createTable(true, this.labels, this.sizes, this.rightAlign, null);
        this.table.setSpacingBefore(20.0f);
        this.setCell(0, "Dimensions", true, true);
        this.addTableRow();
        this.addEmptyTableRow();
        this.indent = 10.0f;
        this.defaultCell.setIndent(this.indent);
        this.printFinancialDimensions();
        this.addEmptyTableRow();
        this.setLayout(1);
        this.createTable(true, this.labels, this.sizes, this.rightAlign, null);
        this.indent = 10.0f;
        this.defaultCell.setIndent(this.indent);
        this.printFacDimensions();
    }

    private void printFinancialDimensions() throws Exception {
        this.setCell(0, "FinancialDimensions", true, true);
        this.addTableRow();
        this.setCell(1, ":", false, false);
        if (this.assetType.getFinancialDimension1Usage() != 0) {
            this.setCell(0, this.environment.getName1(), false, false);
            this.printFinancialDimension(this.asset.getFinDimId1(), 1);
        }
        if (this.assetType.getFinancialDimension2Usage() != 0) {
            this.setCell(0, this.environment.getName2(), false, false);
            this.printFinancialDimension(this.asset.getFinDimId2(), 2);
        }
        if (this.assetType.getFinancialDimension3Usage() != 0) {
            this.setCell(0, this.environment.getName3(), false, false);
            this.printFinancialDimension(this.asset.getFinDimId3(), 3);
        }
        if (this.assetType.getFinancialDimension4Usage() != 0) {
            this.setCell(0, this.environment.getName4(), false, false);
            this.printFinancialDimension(this.asset.getFinDimId4(), 4);
        }
        if (this.assetType.getFinancialDimension5Usage() != 0) {
            this.setCell(0, this.environment.getName5(), false, false);
            this.printFinancialDimension(this.asset.getFinDimId5(), 5);
        }
    }

    private void printFinancialDimension(String id, int index) throws Exception {
        this.value[2] = "-";
        this.value[3] = null;
        if (id.length() > 0) {
            if (this.fmsHelper != null) {
                this.value[2] = this.fmsHelper.unFormatId(id, index);
                NameValuePair pair = this.fmsHelper.getNameValuePair(id, index);
                if (pair != null) {
                    this.value[3] = pair.getValue();
                }
            } else {
                this.value[2] = FISHelper.unFormatId(id);
                this.value[3] = this.fisHelper.getDescription(id, this.companyId, this.bookYear, index);
            }
        }
        this.setCell(2, this.value[2], false, false);
        this.setCell(3, this.value[3], false, false);
        this.addTableRow();
        this.value[2] = "-";
        this.value[3] = null;
    }

    private void printFacDimensions() throws Exception {
        if (this.assetType.getAnalysisGroup1() == null && this.assetType.getAnalysisGroup2() == null && this.assetType.getAnalysisGroup3() == null && this.assetType.getAnalysisGroup4() == null && this.assetType.getAnalysisGroup5() == null && this.assetType.getAnalysisGroup6() == null && this.assetType.getAnalysisGroup7() == null && this.assetType.getAnalysisGroup8() == null && this.assetType.getAnalysisGroup9() == null && this.assetType.getAnalysisGroup10() == null) {
            return;
        }
        this.setCell(0, "Other", true, true);
        this.setCell(1, null, false, false);
        this.setCell(2, null, false, false);
        this.addTableRow();
        this.setCell(1, ":", false, false);
        this.printFacDimension(this.assetType.getAnalysisGroup1());
        this.printFacDimension(this.assetType.getAnalysisGroup2());
        this.printFacDimension(this.assetType.getAnalysisGroup3());
        this.printFacDimension(this.assetType.getAnalysisGroup4());
        this.printFacDimension(this.assetType.getAnalysisGroup5());
        this.printFacDimension(this.assetType.getAnalysisGroup6());
        this.printFacDimension(this.assetType.getAnalysisGroup7());
        this.printFacDimension(this.assetType.getAnalysisGroup8());
        this.printFacDimension(this.assetType.getAnalysisGroup9());
        this.printFacDimension(this.assetType.getAnalysisGroup10());
        this.addEmptyTableRow();
    }

    private void printFacDimension(AnalysisGroup analysisGroup) throws Exception {
        if (analysisGroup == null) {
            return;
        }
        this.setCell(0, analysisGroup.getName(), false, false);
        if (analysisGroup.getUsage() == 1) {
            AssetAnalysisCode code = (AssetAnalysisCode)AssetAnalysisCodeBO.get(this.asset.getDBData(), this.companyId, analysisGroup.getSeqNr(), this.asset.getCora(), this.asset.getId())[0];
            if (code != null) {
                String value = code.getCode();
                if (analysisGroup.getType().equals("N")) {
                    try {
                        value = String.valueOf(Integer.parseInt(value));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                this.setCell(2, value + " : " + code.getAnalysisCode().getDescription(), false, false);
            } else {
                this.setCell(2, "-", false, false);
            }
            this.addTableRow();
        } else {
            AssetValue value = (AssetValue)AssetValueBO.get(this.asset.getDBData(), this.companyId, analysisGroup.getSeqNr(), this.asset.getCora(), this.asset.getId())[0];
            if (value == null) {
                this.setCell(2, "-", false, false);
                this.addTableRow();
            } else if (analysisGroup.getUsage() == 3) {
                Company company = (Company)CompanyBO.get(this.asset.getDBData(), this.companyId)[0];
                if (this.environment.getOperationArea().length() == 0) {
                    int index = 10;
                    if (analysisGroup.getSeqNr() == company.getAGCreditorSequenceNbr()) {
                        index = 11;
                    }
                    this.printOtherFinancialDimension(value.getValue(), index);
                } else {
                    int index = 10;
                    if (analysisGroup.getSeqNr() == company.getAGCreditorSequenceNbr()) {
                        index = 11;
                    }
                    if (analysisGroup.getSeqNr() == company.getAGRelationSequenceNbr()) {
                        index = 12;
                    }
                    this.printOtherFinancialDimension(value.getValue(), index);
                }
            } else {
                this.setCell(2, value.getValue(), false, false);
                this.addTableRow();
            }
        }
    }

    private void printOtherFinancialDimension(String id, int index) throws Exception {
        this.value[2] = "-";
        if (id.length() > 0) {
            if (this.fmsHelper != null) {
                this.value[2] = this.fmsHelper.unFormatId(id, index);
                NameValuePair pair = this.fmsHelper.getNameValuePair(id, index);
                if (pair != null) {
                    this.value[2] = this.value[2] + " : " + pair.getValue();
                }
            } else {
                this.value[2] = FISHelper.unFormatId(id);
                this.value[2] = this.value[2] + " : " + this.fisHelper.getDCDescription(id, this.companyId, index);
            }
        }
        this.setCell(2, this.value[2], false, false);
        this.addTableRow();
        this.value[2] = "-";
    }

    private void printValuations() throws Exception {
        String apName = null;
        ExecutableQuery qry = QueryFactory.create(Valuation.class, null, "accountingPrinciple");
        for (Valuation valuation : this.asset.getValuationsCollection(qry)) {
            switch (valuation.getAccountingPrinciple()) {
                case 1: {
                    apName = this.environment.getAPName1();
                    break;
                }
                case 2: {
                    apName = this.environment.getAPName2();
                    break;
                }
                case 3: {
                    apName = this.environment.getAPName3();
                    break;
                }
                case 4: {
                    apName = this.environment.getAPName4();
                }
            }
            this.setLayout(2);
            this.createTable(true, this.labels, this.sizes, this.rightAlign, null);
            this.table.setSpacingBefore(20.0f);
            if (valuation.getAccountingPrinciple() > 1 && this.doTransactions) {
                this.document.newPage();
            }
            this.setCell(0, apName, false, true);
            this.value[1] = null;
            this.value[2] = null;
            this.addTableRow();
            this.addEmptyTableRow();
            this.indent = 10.0f;
            this.defaultCell.setIndent(this.indent);
            this.setCell(0, "DepreciationAndInterests", true, true);
            this.addTableRow();
            this.setCell(1, ":", false, false);
            this.setCell(4, ":", false, false);
            this.setCell(0, "AcquisitionValue", true, false);
            this.setCell(2, IBSDecimal.format(valuation.getPostedAcquisitionBalance(), true), false, false);
            this.setCell(3, "DepreciationLife", true, false);
            this.setCell(5, IBSDecimal.format(new BigDecimal(valuation.getDepreciatableLife()), 0, true), false, false);
            this.addTableRow();
            this.setCell(0, "Depreciations", true, false);
            this.setCell(2, IBSDecimal.format(valuation.getPostedDepreciationBalance(), true), false, false);
            this.setCell(3, "DepreciatedPeriods", true, false);
            this.setCell(5, IBSDecimal.format(new BigDecimal(valuation.getNumberOfDepreciatedPeriods()), 0, true), false, false);
            this.addTableRow();
            this.setCell(0, "BookValue", true, false);
            this.setCell(2, IBSDecimal.format(valuation.getPostedAcquisitionBalance().subtract(valuation.getPostedDepreciationBalance()), true), false, false);
            this.setCell(3, "RemainingLife", true, false);
            this.setCell(5, IBSDecimal.format(new BigDecimal(valuation.getDepreciatableLife() - valuation.getNumberOfDepreciatedPeriods()), 0, true), false, false);
            this.addTableRow();
            this.addEmptyTableRow();
            this.value[3] = null;
            this.value[4] = null;
            this.value[5] = null;
            this.setCell(0, "DepreciationMethod", true, false);
            this.setCell(2, DepreciationMethodEnum.getValue(valuation.getDepreciationMethod()), false, false);
            this.addTableRow();
            switch (valuation.getDepreciationMethod()) {
                case 3: {
                    if (valuation.getYearPercentageTable() == null) break;
                    this.setCell(0, "YearPercentageTable", true, false);
                    this.setCell(2, valuation.getYearPercentageTable().getId() + " : " + valuation.getYearPercentageTable().getDescription(), false, false);
                    this.addTableRow();
                    this.value[2] = null;
                    break;
                }
                case 2: {
                    this.setCell(0, "Percentage", true, false);
                    this.setCell(2, IBSDecimal.format(valuation.getDegressivePercentage(), true), false, false);
                    this.addTableRow();
                    break;
                }
                case 12: {
                    this.setCell(0, "Percentage", true, false);
                    this.setCell(2, IBSDecimal.format(valuation.getAnnuityPercentage(), 3, true), false, false);
                    this.addTableRow();
                    break;
                }
                case 11: {
                    this.setCell(0, "Percentage", true, false);
                    this.setCell(2, IBSDecimal.format(valuation.getAnnuityPercentage(), 3, true), false, false);
                    this.addTableRow();
                }
            }
            this.setCell(0, "StartPeriodHandlingPolicy", true, false);
            this.setCell(2, StartPeriodHandlingEnum.getValue(valuation.getStartPeriodHandlingMethod()), false, false);
            this.addTableRow();
            this.setCell(0, "StartPeriod", true, false);
            this.setCell(2, PeriodHelper.toString(valuation.getStartDepreciationBookYear(), valuation.getStartDepreciationPeriod()), false, false);
            this.addTableRow();
            this.setCell(0, "LastDepreciated", true, false);
            if (valuation.getLastDepreciationBookYear() > 0) {
                this.setCell(2, PeriodHelper.toString(valuation.getLastDepreciationBookYear(), valuation.getLastDepreciationPeriod()), false, false);
            } else {
                this.setCell(2, "-", false, false);
            }
            this.addTableRow();
            this.setCell(0, "ResidualValuePercentage", true, false);
            if (valuation.getResidualPercentage().doubleValue() != 0.0) {
                this.setCell(2, IBSDecimal.format(valuation.getResidualPercentage(), true), false, false);
            } else {
                this.setCell(2, "-", false, false);
            }
            this.addTableRow();
            this.setCell(0, "ResidualValueAmount", true, false);
            if (valuation.getResidualValue().doubleValue() != 0.0) {
                this.setCell(2, IBSDecimal.format(valuation.getResidualValue(), true), false, false);
            } else {
                this.setCell(2, "-", false, false);
            }
            this.addTableRow();
            if (this.asset.getParentAsset() && this.assetType.getLimitedDepreciation()) {
                this.addWOZValue(valuation.getAccountingPrinciple());
            }
            this.addEmptyTableRow();
            this.setCell(0, "InterestCalculationMethod", true, false);
            this.setCell(2, InterestCalculationMethodEnum.getValue(valuation.getInterestCalculationMethod()), false, false);
            this.addTableRow();
            if (valuation.getInterestCalculationMethod() != 0) {
                this.setCell(0, "Percentage", true, false);
                if (valuation.getInterestPercentage().doubleValue() != 0.0) {
                    this.setCell(2, IBSDecimal.format(valuation.getInterestPercentage(), 3, true), false, false);
                    this.addTableRow();
                }
                if (valuation.getInterestTable() != null) {
                    this.setCell(0, "InterestTable", true, false);
                    this.setCell(2, valuation.getInterestTable().getId() + " : " + valuation.getInterestTable().getDescription(), false, false);
                    this.addTableRow();
                    this.value[2] = null;
                    this.addTableRow();
                }
            }
            this.addEmptyTableRow();
            if (!this.doTransactions) continue;
            this.printTransactions(valuation.getAccountingPrinciple());
        }
    }

    private void printTransactions(int accountingPrinciple) throws Exception {
        this.setLayout(3);
        this.createTable(true, this.labels, this.sizes, this.rightAlign, null);
        this.addTableHeader();
        Transaction transaction2 = null;
        BigDecimal investment = null;
        BigDecimal depreciation = null;
        BigDecimal interest = null;
        for (Transaction transaction2 : TransactionBO.getTransactions(this.asset)) {
            if (transaction2.getAccountingPrinciple() != accountingPrinciple) continue;
            switch (transaction2.getMainTransactionType()) {
                case 1: {
                    investment = transaction2.getAmount1();
                    depreciation = transaction2.getAmount2();
                    interest = ZERO;
                    break;
                }
                case 2: {
                    investment = transaction2.getAmount1();
                    depreciation = transaction2.getAmount2();
                    interest = ZERO;
                    break;
                }
                case 3: {
                    investment = ZERO;
                    depreciation = transaction2.getAmount2();
                    interest = transaction2.getAmount3();
                    break;
                }
                case 9: {
                    investment = ZERO;
                    depreciation = ZERO;
                    interest = ZERO;
                }
            }
            this.setCell(0, PeriodHelper.toString(transaction2.getBookYear(), transaction2.getPeriod()), false, false);
            this.setCell(1, TransactionTypeEnum.getValue(transaction2.getTransactionType()), false, false);
            this.setCell(2, IBSDecimal.format(investment, true), false, false);
            this.setCell(3, IBSDecimal.format(depreciation, true), false, false);
            this.setCell(4, IBSDecimal.format(interest, true), false, false);
            this.setCell(6, transaction2.getDescription(), false, false);
            this.setCell(7, transaction2.getDocumentAndSequenceNumber(), false, false);
            this.addTableRow();
        }
        this.addEmptyTableRow();
    }

    public static void main(String[] args) {
        Stopwatch sw = null;
        if (Log.debug()) {
            sw = new Stopwatch();
            sw.start();
        }
        try {
            AssetToPDF.execute(args);
        }
        catch (Exception e) {
            Log.error((Exception)e);
            System.exit(-1);
        }
        if (sw != null) {
            Log.debug((String)("Elapsed time: " + sw.stop(1) + " seconds"));
        }
        System.exit(0);
    }

    public static void execute(String[] args) throws Exception {
        String[][] selections;
        Map map;
        LoginHelper loginHelper;
        String message;
        if (Log.debug() && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                Log.debug((String)args[i]);
            }
        }
        if ((message = (loginHelper = BatchJobHelper.getLoginHelper(map = BatchJobHelper.getSelections(selections = BatchJobHelper.getSelections(args)))).login()) != null) {
            message = LanguageHelper.getString("nl.ibs.fac.language", message);
            Log.error((String)message);
            return;
        }
        boolean governmentActivated = Boolean.valueOf((String)map.get("governmentActivated"));
        Environment environment = (Environment)EnvironmentBO.get((String)map.get("facLib"))[0];
        String companyId = (String)map.get("Company");
        String bookYear = (String)map.get("BookYear");
        String assetSelectionAsString = (String)map.get(AssetSelection.ASSETSELECTION);
        String assetSelectionAsString2 = (String)map.get(AssetSelection.ASSETSELECTION + "2");
        AssetSelection selection = null;
        if (assetSelectionAsString != null) {
            selection = new AssetSelection(assetSelectionAsString + assetSelectionAsString2);
        }
        if ((message = loginHelper.login(environment, companyId, bookYear)) != null && message.trim().length() > 0) {
            message = LanguageHelper.getString("nl.ibs.fac.language", message);
            Log.error((String)message);
            return;
        }
        FMSHelper fmsHelper = null;
        FISHelper fisHelper = null;
        if (environment.getOperationArea().trim().length() > 0) {
            fmsHelper = new FMSHelper(loginHelper);
        } else {
            fisHelper = new FISHelper(loginHelper);
        }
        DBData dbData = BOAdapter.getDBData(map);
        Company company = (Company)CompanyBO.get(dbData, companyId)[0];
        int ap2Usage = company.getAccountingPrinciple2Usage();
        if (ap2Usage < 0) {
            Company dataSet = (Company)CompanyBO.get(dbData, company.getDataSetId())[0];
            ap2Usage = dataSet.getAccountingPrinciple2Usage();
        }
        AssetToPDF fixedAssetToPDF = new AssetToPDF(REPORTTITLE, selections, selection != null ? selection.getCollection() : AssetBO.getAssets(map, false), governmentActivated, environment, fmsHelper, fisHelper, companyId, bookYear, AssetBO.isIdNumeric(company, false), ap2Usage);
        FileOutputStream fos = new FileOutputStream(ReportFileHelper.getFileName(args, FILENAME, "pdf"));
        fos.write(fixedAssetToPDF.createPdf().toByteArray());
        fos.close();
        loginHelper.logout(environment, companyId, bookYear);
        loginHelper.logout();
    }

    @Override
    protected int[] getColumnsToCumulate() throws Exception {
        return null;
    }

    private void setLayout(int layout) throws Exception {
        int limit = 0;
        switch (layout) {
            case 1: {
                this.labels = LABELS1;
                this.sizes = SIZES1;
                this.rightAlign = RIGHTALIGN1;
                this.value = new String[3];
                this.translate = new boolean[3];
                this.bold = new boolean[3];
                limit = 3;
                break;
            }
            case 2: {
                this.labels = LABELS2;
                this.sizes = SIZES2;
                this.rightAlign = RIGHTALIGN2;
                this.value = new String[6];
                this.translate = new boolean[6];
                this.bold = new boolean[6];
                limit = 6;
                break;
            }
            case 3: {
                this.labels = LABELS3;
                this.sizes = SIZES3;
                this.rightAlign = RIGHTALIGN3;
                this.value = new String[8];
                this.translate = new boolean[8];
                this.bold = new boolean[8];
                limit = 8;
                break;
            }
            case 4: {
                this.labels = LABELS4;
                this.sizes = SIZES4;
                this.rightAlign = RIGHTALIGN4;
                this.value = new String[4];
                this.translate = new boolean[4];
                this.bold = new boolean[4];
                limit = 4;
                break;
            }
        }
        for (int i = 0; i < limit; ++i) {
            this.value[i] = null;
        }
    }
}

