/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.reports;

import com.itextpdf.text.Rectangle;
import java.io.FileOutputStream;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Map;
import nl.ibs.fac.BatchJobHelper;
import nl.ibs.fac.DepreciationMethodEnum;
import nl.ibs.fac.GenericUsageEnum;
import nl.ibs.fac.IBSDecimal;
import nl.ibs.fac.InterestCalculationMethodEnum;
import nl.ibs.fac.JournalingsTermEnum;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.ReportFileHelper;
import nl.ibs.fac.StartPeriodHandlingEnum;
import nl.ibs.fac.boadapters.AssetTypeBO;
import nl.ibs.fac.boadapters.EnvironmentBO;
import nl.ibs.fac.boadapters.MainAccountSchemeBO;
import nl.ibs.fac.db.AssetType;
import nl.ibs.fac.db.AssetTypeAccountingPrincipleDefault;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.db.MainAccountScheme;
import nl.ibs.fac.fis.FISHelper;
import nl.ibs.fac.fms.FMSHelper;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.reports.PdfHelper;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.ExecutableQuery;
import nl.ibs.jsql.QueryFactory;
import nl.ibs.util.NameValuePair;
import nl.ibs.util.Stopwatch;

public class AssetTypeToPDF
extends PdfHelper {
    public static final String CLASSNAME = AssetTypeToPDF.class.getName();
    private static final String FILENAME = "AssetType";
    private static final String REPORTTITLE = "AssetTypes";
    private String[][] labels;
    private int[] sizes;
    private boolean[] rightAlign;
    private float indent;
    private static final String[][] LABELS1 = new String[][]{{"", "", ""}};
    private static final int[] SIZES1 = new int[]{100, 10, 290};
    private static final boolean[] RIGHTALIGN1 = new boolean[]{false, false, false};
    private static final String[][] LABELS4 = new String[][]{{"", "", "", ""}};
    private static final int[] SIZES4 = new int[]{100, 10, 50, 240};
    private static final boolean[] RIGHTALIGN4 = new boolean[]{false, false, false, false};
    private AssetType assetType = null;
    private Environment environment;
    private FMSHelper fmsHelper;
    private FISHelper fisHelper;
    private String companyId;
    private String bookYear;

    public AssetTypeToPDF(String reportTitle, String[][] selections, Collection collection, Environment environment, FMSHelper fmsHelper, FISHelper fisHelper, String companyId, String bookYear) throws Exception {
        super(reportTitle, selections, collection, fmsHelper, fisHelper, companyId, bookYear);
        this.document.setPageSize(new Rectangle(1000.0f, 1400.0f));
        this.environment = environment;
        this.fmsHelper = fmsHelper;
        this.fisHelper = fisHelper;
        this.companyId = companyId;
        this.bookYear = bookYear;
    }

    @Override
    protected void processObject(Object object) throws Exception {
        this.setLayout(1);
        this.createTable(true, this.labels, this.sizes, this.rightAlign, null);
        if (this.assetType != null) {
            this.value[1] = null;
            this.value[2] = null;
            this.document.newPage();
        }
        this.assetType = (AssetType)object;
        this.printCommon();
        this.printDimensions();
        this.printAccountingPrincipleDefaults();
    }

    private void printCommon() throws Exception {
        this.setCell(0, "Common", true, true);
        this.addTableRow();
        this.addEmptyTableRow();
        this.indent = 10.0f;
        this.defaultCell.setIndent(this.indent);
        this.setCell(0, "Common", true, true);
        this.addTableRow();
        this.setCell(0, "Id", true, false);
        this.setCell(1, ":", false, false);
        this.setCell(2, this.assetType.getId(), false, false);
        this.addTableRow();
        this.setCell(0, "Description", true, false);
        this.setCell(2, this.assetType.getDescription(), false, false);
        this.addTableRow();
        if (this.assetType.getAccountingPrinciple2IsUsed()) {
            this.setCell(0, "AccountingPrinciple2", true, true);
            this.setCell(1, null, false, false);
            this.setCell(2, null, false, false);
            this.addTableRow();
            this.setCell(0, "InUse", true, false);
            this.setCell(1, ":", false, false);
            this.setCell(2, "" + this.assetType.getAccountingPrinciple2IsUsed(), true, false);
            this.addTableRow();
            this.setCell(0, "DifferentAcquisitionValue", true, false);
            this.setCell(2, "" + this.assetType.getUseDifferentAcquisitionValues(), true, false);
            this.addTableRow();
        }
        this.setCell(0, "Other", true, true);
        this.setCell(1, null, false, false);
        this.setCell(2, null, false, false);
        this.addTableRow();
        this.setCell(0, "LimitedDepreciation", true, false);
        this.setCell(1, ":", false, false);
        this.setCell(2, "" + this.assetType.getLimitedDepreciation(), true, false);
        this.addTableRow();
        this.setCell(0, "DepreciateBeyondEconomicLife", true, false);
        this.setCell(1, ":", false, false);
        this.setCell(2, "" + this.assetType.getDepreciateBeyondEconomicLife(), true, false);
        this.addTableRow();
        this.setCell(0, "ExclWriteOff", true, false);
        this.setCell(2, "" + this.assetType.getExclWriteOff(), true, false);
        this.addTableRow();
        this.setCell(0, "NotUsedAnymore", true, false);
        this.setCell(2, "" + this.assetType.getNotUsed(), true, false);
        this.addTableRow();
        this.addEmptyTableRow();
    }

    private void printDimensions() throws Exception {
        this.createTable(true, this.labels, this.sizes, this.rightAlign, null);
        this.table.setSpacingBefore(20.0f);
        this.setCell(0, "Dimensions", true, true);
        this.value[1] = null;
        this.value[2] = null;
        this.addTableRow();
        this.addEmptyTableRow();
        this.indent = 10.0f;
        this.defaultCell.setIndent(this.indent);
        this.printFinancialDimensions();
        this.addEmptyTableRow();
        this.printFacDimensions();
    }

    private void printFinancialDimensions() throws Exception {
        this.setCell(0, "FinancialDimensions", true, true);
        this.addTableRow();
        this.setCell(1, ":", false, false);
        this.setCell(0, this.environment.getName1(), false, false);
        this.setCell(2, GenericUsageEnum.getValue(this.assetType.getFinancialDimension1Usage()), false, false);
        this.addTableRow();
        this.setCell(0, this.environment.getName2(), false, false);
        this.setCell(2, GenericUsageEnum.getValue(this.assetType.getFinancialDimension2Usage()), false, false);
        this.addTableRow();
        this.setCell(0, this.environment.getName3(), false, false);
        this.setCell(2, GenericUsageEnum.getValue(this.assetType.getFinancialDimension3Usage()), false, false);
        this.addTableRow();
        this.setCell(0, this.environment.getName4(), false, false);
        this.setCell(2, GenericUsageEnum.getValue(this.assetType.getFinancialDimension4Usage()), false, false);
        this.addTableRow();
        if (this.environment.getDataLib().length() > 0) {
            this.setCell(0, this.environment.getName5(), false, false);
            this.setCell(2, GenericUsageEnum.getValue(this.assetType.getFinancialDimension5Usage()), false, false);
            this.addTableRow();
        }
    }

    private void printFacDimensions() throws Exception {
        this.setCell(0, "Other", true, true);
        this.setCell(1, null, false, false);
        this.setCell(2, null, false, false);
        this.addTableRow();
        this.setCell(1, ":", false, false);
        boolean hasFACDimensions = false;
        if (this.assetType.getAnalysisGroup1() != null) {
            hasFACDimensions = true;
            this.setCell(0, this.assetType.getAnalysisGroup1().getName(), false, false);
            if (this.assetType.getSeqNr1Mandatory()) {
                this.setCell(2, "Mandatory", true, false);
            } else {
                this.setCell(2, "Optional", true, false);
            }
            this.addTableRow();
        }
        if (this.assetType.getAnalysisGroup2() != null) {
            hasFACDimensions = true;
            this.setCell(0, this.assetType.getAnalysisGroup2().getName(), false, false);
            if (this.assetType.getSeqNr2Mandatory()) {
                this.setCell(2, "Mandatory", true, false);
            } else {
                this.setCell(2, "Optional", true, false);
            }
            this.addTableRow();
        }
        if (this.assetType.getAnalysisGroup3() != null) {
            hasFACDimensions = true;
            this.setCell(0, this.assetType.getAnalysisGroup3().getName(), false, false);
            if (this.assetType.getSeqNr3Mandatory()) {
                this.setCell(2, "Mandatory", true, false);
            } else {
                this.setCell(2, "Optional", true, false);
            }
            this.addTableRow();
        }
        if (this.assetType.getAnalysisGroup4() != null) {
            hasFACDimensions = true;
            this.setCell(0, this.assetType.getAnalysisGroup4().getName(), false, false);
            if (this.assetType.getSeqNr4Mandatory()) {
                this.setCell(2, "Mandatory", true, false);
            } else {
                this.setCell(2, "Optional", true, false);
            }
            this.addTableRow();
        }
        if (this.assetType.getAnalysisGroup5() != null) {
            hasFACDimensions = true;
            this.setCell(0, this.assetType.getAnalysisGroup5().getName(), false, false);
            if (this.assetType.getSeqNr5Mandatory()) {
                this.setCell(2, "Mandatory", true, false);
            } else {
                this.setCell(2, "Optional", true, false);
            }
            this.addTableRow();
        }
        if (this.assetType.getAnalysisGroup6() != null) {
            hasFACDimensions = true;
            this.setCell(0, this.assetType.getAnalysisGroup6().getName(), false, false);
            if (this.assetType.getSeqNr6Mandatory()) {
                this.setCell(2, "Mandatory", true, false);
            } else {
                this.setCell(2, "Optional", true, false);
            }
            this.addTableRow();
        }
        if (hasFACDimensions) {
            this.addEmptyTableRow();
        }
    }

    private void printAccountingPrincipleDefaults() throws Exception {
        Object[] jte = JournalingsTermEnum.getCollection().toArray();
        String mainAccountId = "";
        String apName = null;
        ExecutableQuery qry = QueryFactory.create(AssetTypeAccountingPrincipleDefault.class, null, "accountingPrinciple");
        for (AssetTypeAccountingPrincipleDefault assetTypeAccountingPrincipleDefault : this.assetType.getAccountingPrincipleDefaultsCollection(qry)) {
            switch (assetTypeAccountingPrincipleDefault.getAccountingPrinciple()) {
                case 1: {
                    apName = this.environment.getAPName1();
                    break;
                }
                case 2: {
                    apName = this.environment.getAPName2();
                    break;
                }
                case 3: {
                    apName = this.environment.getAPName3();
                    break;
                }
                case 4: {
                    apName = this.environment.getAPName4();
                }
            }
            this.setLayout(1);
            this.createTable(true, this.labels, this.sizes, this.rightAlign, null);
            this.table.setSpacingBefore(20.0f);
            this.setCell(0, apName, false, true);
            this.value[1] = null;
            this.value[2] = null;
            this.addTableRow();
            this.addEmptyTableRow();
            this.indent = 10.0f;
            this.defaultCell.setIndent(this.indent);
            this.setCell(0, "Afschrijving en rente", true, true);
            this.addTableRow();
            this.setCell(1, ":", false, false);
            this.setCell(0, "CalculateDepreciations", true, false);
            this.setCell(2, "" + assetTypeAccountingPrincipleDefault.getCalculateDepreciation(), true, false);
            this.addTableRow();
            if (assetTypeAccountingPrincipleDefault.getCalculateDepreciation()) {
                this.setCell(0, "DepreciationMethod", true, false);
                this.setCell(2, DepreciationMethodEnum.getValue(assetTypeAccountingPrincipleDefault.getDepreciationMethod()), false, false);
                this.addTableRow();
                switch (assetTypeAccountingPrincipleDefault.getDepreciationMethod()) {
                    case 3: {
                        if (assetTypeAccountingPrincipleDefault.getYearPercentageTable() == null) break;
                        this.setCell(0, "YearPercentageTable", true, false);
                        this.setCell(2, assetTypeAccountingPrincipleDefault.getYearPercentageTable().getId() + " : " + assetTypeAccountingPrincipleDefault.getYearPercentageTable().getDescription(), false, false);
                        this.addTableRow();
                        this.value[2] = null;
                        break;
                    }
                    case 2: {
                        this.setCell(0, "Percentage", true, false);
                        this.setCell(2, IBSDecimal.format(assetTypeAccountingPrincipleDefault.getDegressivePercentage(), true), false, false);
                        this.addTableRow();
                        break;
                    }
                    case 12: {
                        this.setCell(0, "Percentage", true, false);
                        this.setCell(2, IBSDecimal.format(assetTypeAccountingPrincipleDefault.getAnnuityPercentage(), 3, true), false, false);
                        this.addTableRow();
                        break;
                    }
                    case 11: {
                        this.setCell(0, "Percentage", true, false);
                        this.setCell(2, IBSDecimal.format(assetTypeAccountingPrincipleDefault.getAnnuityPercentage(), 3, true), false, false);
                        this.addTableRow();
                        if (assetTypeAccountingPrincipleDefault.getAnnuityInterestTable() == null) break;
                        this.setCell(0, "InterestTable", true, false);
                        this.setCell(2, assetTypeAccountingPrincipleDefault.getAnnuityInterestTable().getId() + " : " + assetTypeAccountingPrincipleDefault.getAnnuityInterestTable().getDescription(), false, false);
                        this.addTableRow();
                        this.value[2] = null;
                    }
                }
                this.setCell(0, "StartPeriodHandlingPolicy", true, false);
                this.setCell(2, StartPeriodHandlingEnum.getValue(assetTypeAccountingPrincipleDefault.getStartPeriodHandlingMethod()), false, false);
                this.addTableRow();
                this.addEmptyTableRow();
                this.setCell(0, "DepreciationLife", true, false);
                if (assetTypeAccountingPrincipleDefault.getDepreciatableLife() != 0) {
                    this.setCell(2, IBSDecimal.format(new BigDecimal(assetTypeAccountingPrincipleDefault.getDepreciatableLife()), 0, true), false, false);
                } else {
                    this.setCell(2, "-", false, false);
                }
                this.addTableRow();
                this.setCell(0, "ResidualValuePercentage", true, false);
                if (assetTypeAccountingPrincipleDefault.getResidualPercentage().doubleValue() != 0.0) {
                    this.setCell(2, IBSDecimal.format(assetTypeAccountingPrincipleDefault.getResidualPercentage(), true), false, false);
                } else {
                    this.setCell(2, "-", false, false);
                }
                this.addTableRow();
                this.setCell(0, "ResidualValueAmount", true, false);
                if (assetTypeAccountingPrincipleDefault.getResidualValue().doubleValue() != 0.0) {
                    this.setCell(2, IBSDecimal.format(assetTypeAccountingPrincipleDefault.getResidualValue(), true), false, false);
                } else {
                    this.setCell(2, "-", false, false);
                }
                this.addTableRow();
                if (this.assetType.getDepreciateBeyondEconomicLife()) {
                    this.setCell(0, "BeyondEconomicLifePercentage", true, false);
                    if (assetTypeAccountingPrincipleDefault.getBeyondEconomicLifePercentage().doubleValue() != 0.0) {
                        this.setCell(2, IBSDecimal.format(assetTypeAccountingPrincipleDefault.getBeyondEconomicLifePercentage(), true), false, false);
                    } else {
                        this.setCell(2, "-", false, false);
                    }
                    this.addTableRow();
                }
            }
            this.addEmptyTableRow();
            this.setCell(0, "CalculateInterest", true, false);
            this.setCell(2, "" + assetTypeAccountingPrincipleDefault.getCalculateInterest(), true, false);
            this.addTableRow();
            if (assetTypeAccountingPrincipleDefault.getCalculateInterest()) {
                this.setCell(0, "InterestCalculationMethod", true, false);
                this.setCell(2, InterestCalculationMethodEnum.getValue(assetTypeAccountingPrincipleDefault.getInterestCalculationMethod()), false, false);
                this.addTableRow();
                if (assetTypeAccountingPrincipleDefault.getInterestCalculationMethod() != 0) {
                    this.setCell(0, "Percentage", true, false);
                    if (assetTypeAccountingPrincipleDefault.getInterestPercentage().doubleValue() != 0.0) {
                        this.setCell(2, IBSDecimal.format(assetTypeAccountingPrincipleDefault.getInterestPercentage(), 3, true), false, false);
                    } else {
                        this.setCell(2, "-", false, false);
                    }
                    this.addTableRow();
                    if (assetTypeAccountingPrincipleDefault.getInterestTable() != null) {
                        this.setCell(0, "InterestTable", true, false);
                        this.setCell(2, assetTypeAccountingPrincipleDefault.getInterestTable().getId() + " : " + assetTypeAccountingPrincipleDefault.getInterestTable().getDescription(), false, false);
                        this.addTableRow();
                        this.value[2] = null;
                    }
                }
            }
            this.addEmptyTableRow();
            MainAccountScheme mainAccountScheme = MainAccountSchemeBO.getMainAccountSchemeToUse(this.assetType, assetTypeAccountingPrincipleDefault.getAccountingPrinciple(), 9999, 99);
            if (mainAccountScheme == null) continue;
            this.setLayout(4);
            this.createTable(true, this.labels, this.sizes, this.rightAlign, null);
            this.indent = 10.0f;
            this.defaultCell.setIndent(this.indent);
            this.setCell(0, "MainAccounts", true, true);
            this.setCell(1, null, false, false);
            this.setCell(2, null, false, false);
            this.setCell(3, null, false, false);
            this.addTableRow();
            this.setCell(1, ":", false, false);
            for (int i = 0; i < jte.length; ++i) {
                if (!this.assetType.getDepreciateBeyondEconomicLife() && (i == 9 || i == 10)) continue;
                NameValuePair pair = (NameValuePair)jte[i];
                this.setCell(0, pair.getValue(), true, false);
                switch (i) {
                    case 0: {
                        mainAccountId = mainAccountScheme.getMainAccountId1();
                        break;
                    }
                    case 1: {
                        mainAccountId = mainAccountScheme.getMainAccountId2();
                        break;
                    }
                    case 2: {
                        mainAccountId = mainAccountScheme.getMainAccountId3();
                        break;
                    }
                    case 3: {
                        mainAccountId = mainAccountScheme.getMainAccountId4();
                        break;
                    }
                    case 4: {
                        mainAccountId = mainAccountScheme.getMainAccountId5();
                        break;
                    }
                    case 5: {
                        mainAccountId = mainAccountScheme.getMainAccountId6();
                        break;
                    }
                    case 6: {
                        mainAccountId = mainAccountScheme.getMainAccountId7();
                        break;
                    }
                    case 7: {
                        mainAccountId = mainAccountScheme.getMainAccountId8();
                        break;
                    }
                    case 8: {
                        mainAccountId = mainAccountScheme.getMainAccountId9();
                        break;
                    }
                    case 9: {
                        mainAccountId = mainAccountScheme.getMainAccountId10();
                        break;
                    }
                    case 10: {
                        mainAccountId = mainAccountScheme.getMainAccountId11();
                    }
                }
                this.value[2] = "-";
                this.value[3] = null;
                if (mainAccountId.length() > 0) {
                    if (this.fmsHelper != null) {
                        this.value[2] = this.fmsHelper.unFormatId(mainAccountId, 0);
                        pair = this.fmsHelper.getNameValuePair(mainAccountId, 0);
                        if (pair != null) {
                            this.value[3] = pair.getValue();
                        }
                    } else {
                        this.value[2] = FISHelper.unFormatId(mainAccountId);
                        this.value[3] = this.fisHelper.getDescription(mainAccountId, this.companyId, "" + this.bookYear, 0);
                    }
                }
                this.setCell(2, this.value[2], false, false);
                this.setCell(3, this.value[3], false, false);
                this.addTableRow();
                this.value[2] = "-";
                this.value[3] = null;
            }
            this.addEmptyTableRow();
        }
    }

    public static void main(String[] args) {
        Stopwatch sw = null;
        if (Log.debug()) {
            sw = new Stopwatch();
            sw.start();
        }
        try {
            AssetTypeToPDF.execute(args);
        }
        catch (Exception e) {
            Log.error((Exception)e);
            System.exit(-1);
        }
        if (sw != null) {
            Log.debug((String)("Elapsed time: " + sw.stop(1) + " seconds"));
        }
        System.exit(0);
    }

    public static void execute(String[] args) throws Exception {
        String bookYear;
        String companyId;
        String[][] selections;
        Map map;
        LoginHelper loginHelper;
        String message;
        if (Log.debug() && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                Log.debug((String)args[i]);
            }
        }
        if ((message = (loginHelper = BatchJobHelper.getLoginHelper(map = BatchJobHelper.getSelections(selections = BatchJobHelper.getSelections(args)))).login()) != null) {
            message = LanguageHelper.getString("nl.ibs.fac.language", message);
            Log.error((String)message);
            return;
        }
        Environment environment = (Environment)EnvironmentBO.get((String)map.get("facLib"))[0];
        message = loginHelper.login(environment, companyId = (String)map.get("Company"), bookYear = (String)map.get("BookYear"));
        if (message != null && message.trim().length() > 0) {
            message = LanguageHelper.getString("nl.ibs.fac.language", message);
            Log.error((String)message);
            return;
        }
        FMSHelper fmsHelper = null;
        FISHelper fisHelper = null;
        if (environment.getOperationArea().trim().length() > 0) {
            fmsHelper = new FMSHelper(loginHelper);
        } else {
            fisHelper = new FISHelper(loginHelper);
        }
        AssetTypeToPDF assetTypeToPDF = new AssetTypeToPDF(REPORTTITLE, selections, AssetTypeBO.getAssetTypes(map), environment, fmsHelper, fisHelper, companyId, bookYear);
        FileOutputStream fos = new FileOutputStream(ReportFileHelper.getFileName(args, FILENAME, "pdf"));
        fos.write(assetTypeToPDF.createPdf().toByteArray());
        fos.close();
        loginHelper.logout(environment, companyId, bookYear);
        loginHelper.logout();
    }

    @Override
    protected int[] getColumnsToCumulate() throws Exception {
        return null;
    }

    protected int[] getLevelsToCumulate() throws Exception {
        return null;
    }

    private void setLayout(int layout) throws Exception {
        int limit = 0;
        switch (layout) {
            case 1: {
                this.labels = LABELS1;
                this.sizes = SIZES1;
                this.rightAlign = RIGHTALIGN1;
                this.value = new String[3];
                this.translate = new boolean[3];
                this.bold = new boolean[3];
                limit = 3;
                break;
            }
            case 4: {
                this.labels = LABELS4;
                this.sizes = SIZES4;
                this.rightAlign = RIGHTALIGN4;
                this.value = new String[4];
                this.translate = new boolean[4];
                this.bold = new boolean[4];
                limit = 4;
                break;
            }
        }
        for (int i = 0; i < limit; ++i) {
            this.value[i] = null;
        }
    }
}

