/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.reports;

import java.util.Collection;
import java.util.Iterator;
import nl.ibs.fac.DateHelper;
import nl.ibs.fac.FacConstants;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.EnvironmentBO;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.fis.FISHelper;
import nl.ibs.fac.fms.FMSHelper;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.ui.AssetSelection;
import nl.ibs.fac.ui.IncomingFinancialTransactionSelection;
import nl.ibs.jeelog.Log;

public abstract class CSVHelper {
    private Collection collection;
    protected static final String FILETYPE = "csv";
    private StringBuffer sb = new StringBuffer();
    protected FISHelper fisHelper = null;
    protected FMSHelper fmsHelper = null;

    protected CSVHelper(String[][] selections, Collection collection, String[][] labels, FMSHelper fmsHelper, FISHelper fisHelper) throws Exception {
        this.collection = collection;
        this.fmsHelper = fmsHelper;
        this.fisHelper = fisHelper;
        if (selections != null) {
            this.addSelections(selections);
        }
        this.addTableHeader(labels);
    }

    public byte[] createCsv() throws Exception {
        if (Log.debug()) {
            Log.debug((String)("" + this.collection.size()));
        }
        Iterator iterator = this.collection.iterator();
        while (iterator.hasNext()) {
            String[] values = this.getRowValues(iterator.next());
            if (values == null) continue;
            this.addRow(values);
        }
        if (Log.debug()) {
            Log.debug((String)("" + this.sb.length()));
        }
        return this.sb.toString().getBytes();
    }

    protected abstract String[] getRowValues(Object var1) throws Exception;

    protected void addSelections(String[][] selections) {
        String ap1Description = "";
        String ap2Description = "";
        String ap3Description = "";
        for (int i = 0; i < selections.length; ++i) {
            int l;
            String[] lines2;
            if (selections[i][0] == null || selections[i][0].equals("Password") || selections[i][0].equals("System") || selections[i][0].equals("operationArea") || selections[i][0].equals("dataLib") || selections[i][0].equals("BookYear") || selections[i][0].equals("Environment") || selections[i][0].equals("governmentActivated") || (AssetSelection.ASSETSELECTION + "2").equals(selections[i][0])) continue;
            if (AssetSelection.ASSETSELECTION.equals(selections[i][0])) {
                this.sb.append(LanguageHelper.getString("nl.ibs.fac.language", "SelectSort") + ":");
                try {
                    lines2 = new AssetSelection(selections[i][1]).toString(this.fisHelper, this.fmsHelper).split("\n");
                    for (l = 0; l < lines2.length; ++l) {
                        if (lines2[l].trim().length() <= 0 || lines2[l].startsWith("Hoofdact.:") || lines2[l].startsWith("Afdrukken tot.generaal:") || lines2[l].startsWith("Incl. gedesinv.:")) continue;
                        this.sb.append(';');
                        this.sb.append(lines2[l]);
                        this.sb.append(FacConstants.EOL);
                    }
                    continue;
                }
                catch (Exception lines2) {
                    continue;
                }
            }
            if (IncomingFinancialTransactionSelection.IFTSELECTION.equals(selections[i][0])) {
                this.sb.append(LanguageHelper.getString("nl.ibs.fac.language", "SelectSort") + ":");
                try {
                    lines2 = new IncomingFinancialTransactionSelection(selections[i][1]).toString(this.fisHelper, this.fmsHelper).split("\n");
                    for (l = 0; l < lines2.length; ++l) {
                        if (lines2[l].trim().length() <= 0) continue;
                        this.sb.append(';');
                        this.sb.append(lines2[l]);
                        this.sb.append(FacConstants.EOL);
                    }
                    continue;
                }
                catch (Exception lines3) {
                    continue;
                }
            }
            if ("facLib".equals(selections[i][0])) {
                try {
                    Environment environment = (Environment)EnvironmentBO.get(selections[i][1])[0];
                    if (environment != null) {
                        ap1Description = environment.getAPName1();
                        ap2Description = environment.getAPName2();
                        ap3Description = environment.getAPName3();
                    }
                }
                catch (Exception environment) {
                    // empty catch block
                }
            }
            if ("AccountingPrinciple".equals(selections[i][0])) {
                String apDescription = "";
                if ("1".equals(selections[i][1])) {
                    apDescription = ap1Description;
                } else if ("2".equals(selections[i][1])) {
                    apDescription = ap2Description;
                } else if ("3".equals(selections[i][1])) {
                    apDescription = ap3Description;
                } else if ("9".equals(selections[i][1])) {
                    apDescription = ap1Description + " + " + ap3Description;
                }
                this.sb.append(LanguageHelper.getString("nl.ibs.fac.language", selections[i][0]));
                this.sb.append(';');
                this.sb.append(apDescription);
                this.sb.append(FacConstants.EOL);
                continue;
            }
            if ("PeriodType".equals(selections[i][0])) {
                String periodType = "";
                if ("B".equals(selections[i][1])) {
                    periodType = LanguageHelper.getString("nl.ibs.fac.language", "BookYear");
                } else if ("P".equals(selections[i][1])) {
                    periodType = LanguageHelper.getString("nl.ibs.fac.language", "Period");
                }
                this.sb.append(LanguageHelper.getString("nl.ibs.fac.language", selections[i][0]));
                this.sb.append(';');
                this.sb.append(periodType);
                this.sb.append(FacConstants.EOL);
                continue;
            }
            this.sb.append(LanguageHelper.getString("nl.ibs.fac.language", selections[i][0]));
            this.sb.append(';');
            if (selections[i][1] != null) {
                if ("orderBy".equals(selections[i][0])) {
                    this.sb.append(BOAdapter.transLateOrderBy(selections[i][1]));
                } else {
                    this.sb.append(selections[i][1]);
                }
            }
            this.sb.append(FacConstants.EOL);
        }
        this.sb.append(DateHelper.getDate());
        this.sb.append(';');
        this.sb.append(DateHelper.getTime());
        this.sb.append(FacConstants.EOL);
    }

    protected void addTableHeader(String[][] labels) throws Exception {
        for (int i = 0; i < labels.length; ++i) {
            for (int j = 0; j < labels[0].length; ++j) {
                this.sb.append(LanguageHelper.getString("nl.ibs.fac.language", labels[i][j]));
                this.sb.append(';');
            }
            this.sb.append(FacConstants.EOL);
        }
    }

    protected void addRow(String[] value) throws Exception {
        for (int i = 0; i < value.length; ++i) {
            this.sb.append('\"');
            this.sb.append(value[i]);
            this.sb.append('\"');
            this.sb.append(';');
        }
        this.sb.append(FacConstants.EOL);
    }

    protected String extractFromSelections(String key, String[][] selections) throws Exception {
        String result = null;
        for (int i = 0; i < selections.length; ++i) {
            if (!selections[i][0].equals(key)) continue;
            result = selections[i][1];
        }
        return result;
    }
}

