/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.reports;

import com.itextpdf.text.Rectangle;
import java.io.FileOutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import nl.ibs.fac.AlphaNumericEnum;
import nl.ibs.fac.BatchJobHelper;
import nl.ibs.fac.DaybookEnum;
import nl.ibs.fac.DepreciationMethodEnum;
import nl.ibs.fac.GenericUsageEnum;
import nl.ibs.fac.IBSDecimal;
import nl.ibs.fac.InterestCalculationMethodEnum;
import nl.ibs.fac.JournalingMethodEnum;
import nl.ibs.fac.JournalingsTermEnum;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.ReportFileHelper;
import nl.ibs.fac.StartPeriodHandlingEnum;
import nl.ibs.fac.VoucherDateHandlingEnum;
import nl.ibs.fac.boadapters.BookYearBO;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.EnvironmentBO;
import nl.ibs.fac.boadapters.ProcessParametersBO;
import nl.ibs.fac.db.BookYear;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.CompanyAccountingPrincipleDefault;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.db.ProcessParameters;
import nl.ibs.fac.fis.FISHelper;
import nl.ibs.fac.fms.FMSHelper;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.reports.PdfHelper;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.ExecutableQuery;
import nl.ibs.jsql.QueryFactory;
import nl.ibs.util.NameValuePair;
import nl.ibs.util.Stopwatch;

public class CompanyToPDF
extends PdfHelper {
    public static final String CLASSNAME = CompanyToPDF.class.getName();
    private static final String FILENAME = "Company";
    private static final String REPORTTITLE = "Companies";
    private String[][] labels;
    private int[] sizes;
    private boolean[] rightAlign;
    private float indent;
    private static final String[][] LABELS1 = new String[][]{{"", "", ""}};
    private static final int[] SIZES1 = new int[]{100, 10, 290};
    private static final boolean[] RIGHTALIGN1 = new boolean[]{false, false, false};
    private static final String[][] LABELS2 = new String[][]{{"", "", "", "", "", ""}};
    private static final int[] SIZES2 = new int[]{100, 10, 90, 100, 10, 90};
    private static final boolean[] RIGHTALIGN2 = new boolean[]{false, false, false, false, false, false};
    private static final String[][] LABELS3 = new String[][]{{"", "", "", "", "", ""}};
    private static final int[] SIZES3 = new int[]{100, 10, 50, 50, 50, 140};
    private static final boolean[] RIGHTALIGN3 = new boolean[]{false, false, false, false, false, false};
    private static final String[][] LABELS4 = new String[][]{{"", "", "", ""}};
    private static final int[] SIZES4 = new int[]{100, 10, 50, 240};
    private static final boolean[] RIGHTALIGN4 = new boolean[]{false, false, false, false};
    private boolean governmentActivated;
    private Environment environment;
    private LoginHelper loginHelper;
    private FMSHelper fmsHelper;
    private FISHelper fisHelper;
    private Company company = null;

    public CompanyToPDF(String[][] selections, Collection collection, boolean governmentActivated, Environment environment, LoginHelper loginHelper, FMSHelper fmsHelper, FISHelper fisHelper) throws Exception {
        super(REPORTTITLE, selections, collection, LABELS1, SIZES1, RIGHTALIGN1, fmsHelper, fisHelper, "", "");
        this.document.setPageSize(new Rectangle(1000.0f, 1400.0f));
        this.governmentActivated = governmentActivated;
        this.environment = environment;
        this.loginHelper = loginHelper;
        this.fmsHelper = fmsHelper;
        this.fisHelper = fisHelper;
    }

    @Override
    protected void processObject(Object object) throws Exception {
        boolean skip = this.company != null;
        this.company = (Company)object;
        String message = this.loginHelper.login(this.environment, this.company.getId(), "" + this.company.getCurrentBookYear());
        if (message != null && message.trim().length() > 0) {
            return;
        }
        this.setLayout(1);
        this.createTable(true, this.labels, this.sizes, this.rightAlign, null);
        if (skip) {
            this.document.newPage();
        }
        this.printCommon();
        this.printProcessParameters();
        if (this.company.getDataSet() == null) {
            this.printDimensions();
            this.printAccountingPrincipleDefaults();
        }
        this.loginHelper.logout(this.environment, this.company.getId(), "" + this.company.getCurrentBookYear());
    }

    private void printCommon() throws Exception {
        this.setCell(0, "Common", true, true);
        this.value[1] = null;
        this.value[2] = null;
        this.addTableRow();
        this.addEmptyTableRow();
        this.indent = 10.0f;
        this.defaultCell.setIndent(this.indent);
        this.setCell(0, "Common", true, true);
        this.addTableRow();
        this.setCell(0, "Id", true, false);
        this.setCell(1, ":", false, false);
        this.setCell(2, this.company.getId(), false, false);
        this.addTableRow();
        this.setCell(0, "Description", true, false);
        this.setCell(2, this.company.getDescription(), false, false);
        this.addTableRow();
        this.setCell(0, "ActualYear", true, false);
        this.setCell(2, "" + this.company.getCurrentBookYear(), false, false);
        this.addTableRow();
        BookYear bookYear = (BookYear)BookYearBO.get(this.company, this.company.getCurrentBookYear())[0];
        this.setCell(0, "BlockedTo", true, false);
        this.value[2] = null;
        if (bookYear != null && bookYear.getPeriodTo() > 0) {
            this.setCell(2, "> " + bookYear.getPeriodTo(), false, false);
        } else {
            this.setCell(2, "-", false, false);
        }
        this.addTableRow();
        this.setCell(0, "BlockedFrom", true, false);
        this.value[2] = null;
        if (bookYear != null && bookYear.getPeriodTo() > 0) {
            this.setCell(2, "> " + bookYear.getPeriodFrom(), false, false);
        } else {
            this.setCell(2, "-", false, false);
        }
        this.addTableRow();
        this.setCell(0, "LastDepreciationRun", true, false);
        this.value[2] = null;
        if (this.company.getLastDepreciationRunYear() > 0) {
            this.setCell(2, PeriodHelper.toString(this.company.getLastDepreciationRunYear(), this.company.getLastDepreciationRunPeriod()), false, false);
        } else {
            this.setCell(2, "-", false, false);
        }
        this.addTableRow();
        this.addEmptyTableRow();
        this.setCell(0, "Other", true, true);
        this.value[1] = null;
        this.value[2] = null;
        this.addTableRow();
        this.setCell(1, ":", false, false);
        this.setCell(0, "StartYear", true, false);
        this.setCell(2, "" + this.company.getInitialBookYear(), false, false);
        this.addTableRow();
        Company dataSet = this.company.getDataSet();
        if (dataSet == null) {
            this.setCell(0, "FormatDepreciationYear", true, false);
            this.setCell(2, "" + this.company.getNumberOfPeriods(), false, false);
            this.addTableRow();
            this.setCell(0, "NumberOfCorrectionPeriods", true, false);
            this.value[2] = null;
            if (this.company.getNumberOfCorrectionPeriods() > 0) {
                this.setCell(2, "" + this.company.getNumberOfCorrectionPeriods(), false, false);
            } else {
                this.setCell(2, "-", false, false);
            }
            this.addTableRow();
            this.setCell(0, "AccountingPrinciple2", true, false);
            this.setCell(2, GenericUsageEnum.getValue(this.company.getAccountingPrinciple2Usage()), false, false);
            this.addTableRow();
        } else {
            this.setCell(0, "MasterDataComingFrom", true, false);
            this.setCell(2, dataSet.getId() + " - " + dataSet.getDescription(), false, false);
            this.addTableRow();
        }
        if (this.environment.getDataLib().length() > 0) {
            this.setCell(0, "MemberPrefixFIS2000", true, false);
            String prefix = this.company.getFamMemberPrefix();
            if (prefix == null || prefix.trim().length() == 0) {
                prefix = "-";
            }
            this.setCell(2, prefix, false, false);
            this.addTableRow();
        }
        this.addEmptyTableRow();
        this.setLayout(2);
        this.createTable(true, this.labels, this.sizes, this.rightAlign, null);
        this.table.setSpacingBefore(20.0f);
        this.indent = 10.0f;
        this.defaultCell.setIndent(this.indent);
        this.setCell(0, "Asset", true, true);
        if (this.company.getCreditIdLength() > 0) {
            this.setCell(3, "Credit", true, true);
        }
        this.addTableRow();
        this.setCell(0, "AssetId", true, false);
        this.setCell(1, ":", false, false);
        this.setCell(2, AlphaNumericEnum.getValue(this.company.getAssetIdType()), false, false);
        if (this.company.getCreditIdLength() > 0) {
            this.setCell(3, "CreditId", true, false);
            this.setCell(4, ":", false, false);
            this.setCell(5, AlphaNumericEnum.getValue(this.company.getCreditIdType()), false, false);
        }
        this.addTableRow();
        this.setCell(0, "Length", true, false);
        this.setCell(2, "" + this.company.getAssetIdLength(), false, false);
        if (this.company.getCreditIdLength() > 0) {
            this.setCell(3, "Length", true, false);
            this.setCell(5, "" + this.company.getCreditIdLength(), false, false);
        }
        this.addTableRow();
        this.setCell(0, "AutoNumber", true, false);
        this.setCell(2, "" + this.company.getAssetIdAuto(), true, false);
        if (this.company.getCreditIdLength() > 0) {
            this.setCell(3, "AutoNumber", true, false);
            this.setCell(5, "" + this.company.getCreditIdAuto(), true, false);
        }
        this.addTableRow();
        this.addEmptyTableRow();
    }

    private void printProcessParameters() throws Exception {
        ProcessParameters parameters = (ProcessParameters)ProcessParametersBO.get(this.company.getDBData(), this.company.getId())[0];
        if (parameters == null) {
            return;
        }
        this.setLayout(1);
        this.createTable(true, this.labels, this.sizes, this.rightAlign, null);
        this.table.setSpacingBefore(20.0f);
        this.setCell(0, "ProcessProperties", true, true);
        this.addTableRow();
        this.addEmptyTableRow();
        this.indent = 10.0f;
        this.defaultCell.setIndent(this.indent);
        this.setCell(0, "Common", true, true);
        this.addTableRow();
        this.setCell(0, "FillBookPeriodBeforehand", true, false);
        this.setCell(1, ":", false, false);
        this.setCell(2, "" + parameters.getDefaultValueInBookPeriod(), true, false);
        this.addTableRow();
        this.setCell(0, "JournalizeCurrentAssets", true, false);
        this.setCell(2, "" + parameters.getJournalizeCurrentAssets(), true, false);
        this.addTableRow();
        if (this.company.getAccountingPrinciple2Usage() != 0) {
            this.setCell(0, "DifferentAcquisitionValueForAP2", true, false);
            this.setCell(2, "" + parameters.getUseDifferentAcquisitionValues(), true, false);
            this.addTableRow();
        }
        this.setCell(0, "AutomaticUpdateBlockedPeriods", true, false);
        this.setCell(2, "" + parameters.getAutoUpdateBlockedPeriods(), true, false);
        this.addTableRow();
        this.setCell(0, "UseCorrectionCodeDC", true, false);
        this.setCell(2, "" + parameters.getUseCorrectionCodeDC(), true, false);
        this.addTableRow();
        this.setCell(0, "VoucherDate", true, false);
        this.setCell(2, VoucherDateHandlingEnum.getValue(parameters.getStandardVoucherDate()), false, false);
        this.addTableRow();
        this.addEmptyTableRow();
        this.setCell(0, "AllocataIFTs", true, true);
        this.value[1] = null;
        this.value[2] = null;
        this.addTableRow();
        this.setCell(0, "WarningDifferentMainAccounts", true, false);
        this.setCell(1, ":", false, false);
        this.setCell(2, "" + parameters.getWarningForDifferentType(), true, false);
        this.addTableRow();
        this.setCell(0, "AutomaticConfirmation", true, false);
        this.setCell(2, "" + parameters.getAutoConfirmIFT(), true, false);
        this.addTableRow();
        this.setCell(0, "VoucherDate", true, false);
        this.setCell(2, VoucherDateHandlingEnum.getValue(parameters.getVoucherDateIFTT()), false, false);
        this.addTableRow();
        this.addEmptyTableRow();
        this.setCell(0, "PeriodicalDepreciationAndInterest", true, true);
        this.value[1] = null;
        this.value[2] = null;
        this.addTableRow();
        this.setCell(0, "SummarizeFinancialTransactions", true, false);
        this.setCell(1, ":", false, false);
        this.setCell(2, "" + parameters.getSummarizeOnKey(), true, false);
        this.addTableRow();
        this.setCell(0, "FullInterestInFirstPeriod", true, false);
        this.setCell(2, "" + parameters.getFullInterestIn1stPeriod(), true, false);
        this.addTableRow();
        if (this.company.getNumberOfPeriods() == 12) {
            this.setCell(0, "VoucherDate", true, false);
            this.setCell(2, VoucherDateHandlingEnum.getValue(parameters.getVoucherDateDIR()), false, false);
            this.addTableRow();
            this.setCell(0, "DifferentFirstPeriod", true, false);
            if (parameters.getStartMonth() > 0) {
                this.setCell(2, "" + parameters.getStartMonth(), false, false);
            } else {
                this.setCell(2, "-", false, false);
            }
            this.addTableRow();
        }
        this.addEmptyTableRow();
    }

    private void printDimensions() throws Exception {
        this.setLayout(3);
        this.createTable(true, this.labels, this.sizes, this.rightAlign, null);
        this.table.setSpacingBefore(20.0f);
        this.setCell(0, "Dimensions", true, true);
        this.addTableRow();
        this.addEmptyTableRow();
        this.indent = 10.0f;
        this.defaultCell.setIndent(this.indent);
        this.printFinancialDimensions();
        this.createTable(true, this.labels, this.sizes, this.rightAlign, null);
        this.defaultCell.setIndent(this.indent);
        this.printExternalDimensions();
    }

    private void printFinancialDimensions() throws Exception {
        this.setCell(0, "FinancialDimensions", true, true);
        this.setCell(3, "From", true, true);
        this.setCell(4, "To", true, true);
        this.addTableRow();
        this.value[3] = null;
        this.value[4] = null;
        this.setCell(0, this.environment.getName1(), false, false);
        this.setCell(1, ":", false, false);
        this.setCell(2, GenericUsageEnum.getValue(this.company.getFinancialDimension1Usage()), false, false);
        if (this.fmsHelper != null) {
            this.setCell(3, this.fmsHelper.unFormatId(this.company.getFD1From(), 1), false, false);
        } else {
            this.setCell(3, FISHelper.unFormatId(this.company.getFD1From()), false, false);
        }
        if (this.fmsHelper != null) {
            this.setCell(4, this.fmsHelper.unFormatId(this.company.getFD1To(), 1), false, false);
        } else {
            this.setCell(4, FISHelper.unFormatId(this.company.getFD1To()), false, false);
        }
        this.addTableRow();
        this.setCell(0, this.environment.getName2(), false, false);
        this.setCell(2, GenericUsageEnum.getValue(this.company.getFinancialDimension2Usage()), false, false);
        if (this.fmsHelper != null) {
            this.setCell(3, this.fmsHelper.unFormatId(this.company.getFD2From(), 2), false, false);
        } else {
            this.setCell(3, FISHelper.unFormatId(this.company.getFD2From()), false, false);
        }
        if (this.fmsHelper != null) {
            this.setCell(4, this.fmsHelper.unFormatId(this.company.getFD2To(), 2), false, false);
        } else {
            this.setCell(4, FISHelper.unFormatId(this.company.getFD2To()), false, false);
        }
        this.addTableRow();
        this.setCell(0, this.environment.getName3(), false, false);
        this.setCell(2, GenericUsageEnum.getValue(this.company.getFinancialDimension3Usage()), false, false);
        if (this.fmsHelper != null) {
            this.setCell(3, this.fmsHelper.unFormatId(this.company.getFD3From(), 3), false, false);
        } else {
            this.setCell(3, FISHelper.unFormatId(this.company.getFD3From()), false, false);
        }
        if (this.fmsHelper != null) {
            this.setCell(4, this.fmsHelper.unFormatId(this.company.getFD3To(), 3), false, false);
        } else {
            this.setCell(4, FISHelper.unFormatId(this.company.getFD3To()), false, false);
        }
        this.addTableRow();
        this.setCell(0, this.environment.getName4(), false, false);
        this.setCell(2, GenericUsageEnum.getValue(this.company.getFinancialDimension4Usage()), false, false);
        if (this.fmsHelper != null) {
            this.setCell(3, this.fmsHelper.unFormatId(this.company.getFD4From(), 4), false, false);
        } else {
            this.setCell(3, FISHelper.unFormatId(this.company.getFD4From()), false, false);
        }
        if (this.fmsHelper != null) {
            this.setCell(4, this.fmsHelper.unFormatId(this.company.getFD4To(), 4), false, false);
        } else {
            this.setCell(4, FISHelper.unFormatId(this.company.getFD4To()), false, false);
        }
        this.addTableRow();
        if (this.environment.getDataLib().length() > 0) {
            this.setCell(0, this.environment.getName5(), false, false);
            this.setCell(2, GenericUsageEnum.getValue(this.company.getFinancialDimension5Usage()), false, false);
            this.setCell(3, FISHelper.unFormatId(this.company.getFD5From()), false, false);
            this.setCell(4, FISHelper.unFormatId(this.company.getFD5To()), false, false);
            this.addTableRow();
        }
        this.addEmptyTableRow();
    }

    private void printExternalDimensions() throws Exception {
        if (this.environment.getOperationArea().trim().length() == 0) {
            this.setCell(0, "D/C", false, true);
        } else {
            this.setCell(0, "D/C/R", false, true);
        }
        this.setCell(0, "D/C", false, true);
        this.value[1] = null;
        this.value[2] = null;
        this.value[3] = null;
        this.value[4] = null;
        this.addTableRow();
        this.setCell(0, this.environment.getNameCreditor(), false, false);
        this.setCell(1, ":", false, false);
        if (this.company.getAGCreditorUsed()) {
            this.setCell(2, GenericUsageEnum.getValue(1), false, false);
        } else {
            this.setCell(2, GenericUsageEnum.getValue(0), false, false);
        }
        this.addTableRow();
        this.setCell(0, this.environment.getNameDebtor(), false, false);
        if (this.company.getAGDebtorUsed()) {
            this.setCell(2, GenericUsageEnum.getValue(1), false, false);
        } else {
            this.setCell(2, GenericUsageEnum.getValue(0), false, false);
        }
        this.addTableRow();
        if (this.environment.getOperationArea().trim().length() != 0) {
            this.setCell(0, this.environment.getNameRelation(), false, false);
            if (this.company.getAGRelationUsed()) {
                this.setCell(2, GenericUsageEnum.getValue(1), false, false);
            } else {
                this.setCell(2, GenericUsageEnum.getValue(0), false, false);
            }
            this.addTableRow();
        }
        this.addEmptyTableRow();
        this.setCell(0, "CMS/PRS", false, true);
        this.value[1] = null;
        this.value[2] = null;
        this.addTableRow();
        this.setCell(0, this.environment.getCMSName1(), false, false);
        this.setCell(1, ":", false, false);
        if (this.company.getCMSDimension1Used()) {
            this.setCell(2, GenericUsageEnum.getValue(1), false, false);
        } else {
            this.setCell(2, GenericUsageEnum.getValue(0), false, false);
        }
        this.addTableRow();
        this.setCell(0, this.environment.getCMSName2(), false, false);
        if (this.company.getCMSDimension2Used()) {
            this.setCell(2, GenericUsageEnum.getValue(1), false, false);
        } else {
            this.setCell(2, GenericUsageEnum.getValue(0), false, false);
        }
        this.addTableRow();
        this.setCell(0, this.environment.getCMSName3(), false, false);
        if (this.company.getCMSDimension3Used()) {
            this.setCell(2, GenericUsageEnum.getValue(1), false, false);
        } else {
            this.setCell(2, GenericUsageEnum.getValue(0), false, false);
        }
        this.addTableRow();
        this.addEmptyTableRow();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void printAccountingPrincipleDefaults() throws Exception {
        String apName = null;
        Object[] jte = JournalingsTermEnum.getCollection().toArray();
        String mainAccountId = "";
        Object[] dbe = DaybookEnum.getCollection().toArray();
        String dayBookId = "";
        ExecutableQuery qry = QueryFactory.create(CompanyAccountingPrincipleDefault.class, null, "accountingPrinciple");
        Iterator iterator = this.company.getAccountingPrincipleDefaultsCollection(qry).iterator();
        boolean firstAP = true;
        while (iterator.hasNext()) {
            NameValuePair pair;
            int i;
            CompanyAccountingPrincipleDefault companyAccountingPrincipleDefault = (CompanyAccountingPrincipleDefault)iterator.next();
            switch (companyAccountingPrincipleDefault.getAccountingPrinciple()) {
                case 1: {
                    apName = this.environment.getAPName1();
                    break;
                }
                case 2: {
                    apName = this.environment.getAPName2();
                    break;
                }
                case 3: {
                    apName = this.environment.getAPName3();
                    break;
                }
                case 4: {
                    apName = this.environment.getAPName4();
                    break;
                }
            }
            this.setLayout(1);
            this.createTable(true, this.labels, this.sizes, this.rightAlign, null);
            if (firstAP) {
                firstAP = false;
                this.document.newPage();
            } else {
                this.table.setSpacingBefore(20.0f);
            }
            this.setCell(0, apName, false, true);
            this.addTableRow();
            this.addEmptyTableRow();
            this.indent = 10.0f;
            this.defaultCell.setIndent(this.indent);
            this.setCell(0, "DepreciationAndInterests", true, true);
            this.addTableRow();
            this.setCell(0, "CalculateDepreciations", true, false);
            this.setCell(1, ":", false, false);
            this.setCell(2, "" + companyAccountingPrincipleDefault.getCalculateDepreciation(), true, false);
            this.addTableRow();
            if (companyAccountingPrincipleDefault.getCalculateDepreciation()) {
                this.setCell(0, "DepreciationMethod", true, false);
                this.setCell(2, DepreciationMethodEnum.getValue(companyAccountingPrincipleDefault.getDepreciationMethod()), false, false);
                this.addTableRow();
                switch (companyAccountingPrincipleDefault.getDepreciationMethod()) {
                    case 3: {
                        if (companyAccountingPrincipleDefault.getYearPercentageTable() == null) break;
                        this.setCell(0, "YearPercentageTable", true, false);
                        this.setCell(2, companyAccountingPrincipleDefault.getYearPercentageTable().getId() + " : " + companyAccountingPrincipleDefault.getYearPercentageTable().getDescription(), false, false);
                        this.addTableRow();
                        this.value[2] = null;
                        break;
                    }
                    case 2: {
                        this.setCell(0, "Percentage", true, false);
                        this.setCell(2, IBSDecimal.format(companyAccountingPrincipleDefault.getDegressivePercentage()), false, false);
                        this.addTableRow();
                        break;
                    }
                    case 12: {
                        this.setCell(0, "Percentage", true, false);
                        this.setCell(2, IBSDecimal.format(companyAccountingPrincipleDefault.getAnnuityPercentage(), 3), false, false);
                        this.addTableRow();
                        break;
                    }
                    case 11: {
                        this.setCell(0, "Percentage", true, false);
                        this.setCell(2, IBSDecimal.format(companyAccountingPrincipleDefault.getAnnuityPercentage(), 3), false, false);
                        this.addTableRow();
                        break;
                    }
                }
                this.setCell(0, "StartPeriodHandlingPolicy", true, false);
                this.setCell(2, StartPeriodHandlingEnum.getValue(companyAccountingPrincipleDefault.getStartPeriodHandlingMethod()), false, false);
                this.addTableRow();
            }
            this.addEmptyTableRow();
            this.setCell(0, "CalculateInterest", true, false);
            this.setCell(2, "" + companyAccountingPrincipleDefault.getCalculateInterest(), true, false);
            this.addTableRow();
            if (companyAccountingPrincipleDefault.getCalculateInterest()) {
                this.setCell(0, "InterestCalculationMethod", true, false);
                this.setCell(2, InterestCalculationMethodEnum.getValue(companyAccountingPrincipleDefault.getInterestCalculationMethod()), false, false);
                this.addTableRow();
                if (companyAccountingPrincipleDefault.getInterestCalculationMethod() != 0) {
                    this.setCell(0, "Percentage", false, false);
                    if (companyAccountingPrincipleDefault.getInterestPercentage().doubleValue() != 0.0) {
                        this.setCell(2, IBSDecimal.format(companyAccountingPrincipleDefault.getInterestPercentage(), 3), false, false);
                    } else {
                        this.setCell(2, "-", false, false);
                    }
                    this.addTableRow();
                    if (companyAccountingPrincipleDefault.getInterestTable() != null) {
                        this.setCell(0, "InterestTable", true, false);
                        this.setCell(2, companyAccountingPrincipleDefault.getInterestTable().getId() + " : " + companyAccountingPrincipleDefault.getInterestTable().getDescription(), false, false);
                        this.addTableRow();
                        this.value[2] = null;
                    }
                }
            }
            this.addEmptyTableRow();
            this.setCell(0, "JournalingMethod", true, false);
            this.setCell(2, JournalingMethodEnum.getValue(companyAccountingPrincipleDefault.getJournalingMethod()), false, false);
            this.addTableRow();
            this.addEmptyTableRow();
            this.setLayout(4);
            this.createTable(true, this.labels, this.sizes, this.rightAlign, null);
            this.indent = 10.0f;
            this.defaultCell.setIndent(this.indent);
            this.setCell(0, "MainAccounts", true, true);
            this.setCell(1, null, false, false);
            this.setCell(2, null, false, false);
            this.setCell(3, null, false, false);
            this.addTableRow();
            this.setCell(1, ":", false, false);
            for (i = 3; i < jte.length; ++i) {
                pair = (NameValuePair)jte[i];
                this.setCell(0, pair.getValue(), true, false);
                switch (i) {
                    case 3: {
                        mainAccountId = companyAccountingPrincipleDefault.getMainAccountId4();
                        break;
                    }
                    case 4: {
                        mainAccountId = companyAccountingPrincipleDefault.getMainAccountId5();
                        break;
                    }
                    case 5: {
                        mainAccountId = companyAccountingPrincipleDefault.getMainAccountId6();
                        break;
                    }
                    case 6: {
                        mainAccountId = companyAccountingPrincipleDefault.getMainAccountId7();
                        break;
                    }
                    case 7: {
                        mainAccountId = companyAccountingPrincipleDefault.getMainAccountId8();
                        break;
                    }
                    case 8: {
                        mainAccountId = companyAccountingPrincipleDefault.getMainAccountId9();
                        break;
                    }
                }
                this.value[2] = "-";
                this.value[3] = null;
                if (mainAccountId.length() > 0) {
                    if (this.fmsHelper != null) {
                        this.value[2] = this.fmsHelper.unFormatId(mainAccountId, 0);
                        pair = this.fmsHelper.getNameValuePair(mainAccountId, 0);
                        if (pair != null) {
                            this.value[3] = pair.getValue();
                        }
                    } else {
                        this.value[2] = FISHelper.unFormatId(mainAccountId);
                        this.value[3] = this.fisHelper.getDescription(mainAccountId, this.company.getId(), "" + this.company.getCurrentBookYear(), 0);
                    }
                }
                this.setCell(2, this.value[2], false, false);
                this.setCell(3, this.value[3], false, false);
                this.addTableRow();
                this.value[2] = "-";
                this.value[3] = null;
            }
            this.addEmptyTableRow();
            this.setCell(0, "DayBooks", true, true);
            this.setCell(1, null, false, false);
            this.setCell(2, null, false, false);
            this.setCell(3, null, false, false);
            this.addTableRow();
            this.setCell(1, ":", false, false);
            block31: for (i = 0; i < dbe.length; ++i) {
                pair = (NameValuePair)dbe[i];
                this.setCell(0, pair.getValue(), true, false);
                switch (i) {
                    case 0: {
                        dayBookId = companyAccountingPrincipleDefault.getDaybookId1();
                        break;
                    }
                    case 1: {
                        dayBookId = companyAccountingPrincipleDefault.getDaybookId2();
                        break;
                    }
                    case 2: {
                        dayBookId = companyAccountingPrincipleDefault.getDaybookId3();
                        break;
                    }
                    case 3: {
                        dayBookId = companyAccountingPrincipleDefault.getDaybookId4();
                        break;
                    }
                    case 4: {
                        dayBookId = companyAccountingPrincipleDefault.getDaybookId5();
                        break;
                    }
                    case 5: {
                        dayBookId = companyAccountingPrincipleDefault.getDaybookId6();
                        break;
                    }
                    case 6: {
                        if (!this.governmentActivated) continue block31;
                        dayBookId = companyAccountingPrincipleDefault.getDaybookId7();
                    }
                }
                this.value[2] = "-";
                this.value[3] = null;
                if (dayBookId.length() > 0) {
                    if (this.fmsHelper != null) {
                        this.value[2] = this.fmsHelper.unFormatId(dayBookId, -1);
                        pair = this.fmsHelper.getNameValuePair(dayBookId, -1);
                        if (pair != null) {
                            this.value[3] = pair.getValue();
                        }
                    } else {
                        this.value[2] = FISHelper.unFormatId(dayBookId);
                        this.value[3] = this.fisHelper.getDescription(dayBookId, this.company.getId(), "" + this.company.getCurrentBookYear(), -1);
                    }
                }
                this.setCell(1, this.value[1], false, false);
                this.setCell(2, this.value[2], false, false);
                this.addTableRow();
                this.value[2] = "-";
                this.value[3] = null;
            }
            this.addEmptyTableRow();
        }
        return;
    }

    public static void main(String[] args) {
        Stopwatch sw = null;
        if (Log.debug()) {
            sw = new Stopwatch();
            sw.start();
        }
        try {
            CompanyToPDF.execute(args);
        }
        catch (Exception e) {
            Log.error((Exception)e);
            System.exit(-1);
        }
        if (sw != null) {
            Log.debug((String)("Elapsed time: " + sw.stop(1) + " seconds"));
        }
        System.exit(0);
    }

    public static void execute(String[] args) throws Exception {
        if (Log.debug() && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                Log.debug((String)args[i]);
            }
        }
        String[][] selections = BatchJobHelper.getSelections(args);
        Map map = BatchJobHelper.getSelections(selections);
        selections = CompanyToPDF.nullifySelection("governmentActivated", selections);
        selections = CompanyToPDF.nullifySelection("Environment", selections);
        selections = CompanyToPDF.nullifySelection("orderBy", selections);
        LoginHelper loginHelper = BatchJobHelper.getLoginHelper(map);
        String message = loginHelper.login();
        if (message != null) {
            message = LanguageHelper.getString("nl.ibs.fac.language", message);
            Log.error((String)message);
            return;
        }
        boolean governmentActivated = Boolean.valueOf((String)map.get("governmentActivated"));
        Environment environment = (Environment)EnvironmentBO.get((String)map.get("facLib"))[0];
        FMSHelper fmsHelper = null;
        FISHelper fisHelper = null;
        if (environment.getOperationArea().trim().length() > 0) {
            fmsHelper = new FMSHelper(loginHelper);
        } else {
            fisHelper = new FISHelper(loginHelper);
        }
        CompanyToPDF companyToPDF = new CompanyToPDF(selections, CompanyBO.getCompanies(map), governmentActivated, environment, loginHelper, fmsHelper, fisHelper);
        FileOutputStream fos = new FileOutputStream(ReportFileHelper.getFileName(args, FILENAME, "pdf"));
        fos.write(companyToPDF.createPdf().toByteArray());
        fos.close();
        loginHelper.logout();
    }

    private static String[][] nullifySelection(String key, String[][] selections) throws Exception {
        for (int i = 0; i < selections.length; ++i) {
            if (!key.equals(selections[i][0])) continue;
            selections[i][0] = null;
            break;
        }
        return selections;
    }

    @Override
    protected int[] getColumnsToCumulate() throws Exception {
        return null;
    }

    protected int[] getLevelsToCumulate() throws Exception {
        return null;
    }

    private void setLayout(int layout) throws Exception {
        int limit = 0;
        switch (layout) {
            case 1: {
                this.labels = LABELS1;
                this.sizes = SIZES1;
                this.rightAlign = RIGHTALIGN1;
                this.value = new String[3];
                this.translate = new boolean[3];
                this.bold = new boolean[3];
                limit = 3;
                break;
            }
            case 2: {
                this.labels = LABELS2;
                this.sizes = SIZES2;
                this.rightAlign = RIGHTALIGN2;
                this.value = new String[6];
                this.translate = new boolean[6];
                this.bold = new boolean[6];
                limit = 6;
                break;
            }
            case 3: {
                this.labels = LABELS3;
                this.sizes = SIZES3;
                this.rightAlign = RIGHTALIGN3;
                this.value = new String[6];
                this.translate = new boolean[6];
                this.bold = new boolean[6];
                limit = 6;
                break;
            }
            case 4: {
                this.labels = LABELS4;
                this.sizes = SIZES4;
                this.rightAlign = RIGHTALIGN4;
                this.value = new String[4];
                this.translate = new boolean[4];
                this.bold = new boolean[4];
                limit = 4;
                break;
            }
        }
        for (int i = 0; i < limit; ++i) {
            this.value[i] = null;
        }
    }
}

