/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.reports;

import java.io.FileOutputStream;
import java.util.Collection;
import java.util.Map;
import nl.ibs.fac.BatchJobHelper;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.ReportFileHelper;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.EnvironmentBO;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.fis.FISHelper;
import nl.ibs.fac.fms.FMSHelper;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.reports.AssetToPDF;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;
import nl.ibs.util.Stopwatch;

public class CreditToPDF
extends AssetToPDF {
    public static final String CLASSNAME = CreditToPDF.class.getName();
    private static final String FILENAME = "Credit";
    private static final String REPORTTITLE = "Credits";

    public CreditToPDF(String reportTitle, String[][] selections, Collection collection, boolean governmentActivated, Environment environment, FMSHelper fmsHelper, FISHelper fisHelper, String companyId, String bookYear, boolean numericId, int accountingPrinciple2Usage) throws Exception {
        super(reportTitle, selections, collection, governmentActivated, environment, fmsHelper, fisHelper, companyId, bookYear, numericId, accountingPrinciple2Usage);
    }

    public static void main(String[] args) {
        Stopwatch sw = null;
        if (Log.debug()) {
            sw = new Stopwatch();
            sw.start();
        }
        try {
            CreditToPDF.execute(args);
        }
        catch (Exception e) {
            Log.error((Exception)e);
            System.exit(-1);
        }
        if (sw != null) {
            Log.debug((String)("Elapsed time: " + sw.stop(1) + " seconds"));
        }
        System.exit(0);
    }

    public static void execute(String[] args) throws Exception {
        String bookYear;
        String companyId;
        String[][] selections;
        Map map;
        LoginHelper loginHelper;
        String message;
        if (Log.debug() && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                Log.debug((String)args[i]);
            }
        }
        if ((message = (loginHelper = BatchJobHelper.getLoginHelper(map = BatchJobHelper.getSelections(selections = BatchJobHelper.getSelections(args)))).login()) != null) {
            message = LanguageHelper.getString("nl.ibs.fac.language", message);
            Log.error((String)message);
            return;
        }
        boolean governmentActivated = Boolean.valueOf((String)map.get("governmentActivated"));
        Environment environment = (Environment)EnvironmentBO.get((String)map.get("facLib"))[0];
        message = loginHelper.login(environment, companyId = (String)map.get("Company"), bookYear = (String)map.get("BookYear"));
        if (message != null && message.trim().length() > 0) {
            message = LanguageHelper.getString("nl.ibs.fac.language", message);
            Log.error((String)message);
            return;
        }
        FMSHelper fmsHelper = null;
        FISHelper fisHelper = null;
        if (environment.getOperationArea().trim().length() > 0) {
            fmsHelper = new FMSHelper(loginHelper);
        } else {
            fisHelper = new FISHelper(loginHelper);
        }
        DBData dbData = BOAdapter.getDBData(map);
        Company company = (Company)CompanyBO.get(dbData, companyId)[0];
        int ap2Usage = company.getAccountingPrinciple2Usage();
        if (ap2Usage < 0) {
            Company dataSet = (Company)CompanyBO.get(dbData, company.getDataSetId())[0];
            ap2Usage = dataSet.getAccountingPrinciple2Usage();
        }
        CreditToPDF creditToPDF = new CreditToPDF(REPORTTITLE, selections, AssetBO.getAssets(map, true), governmentActivated, environment, fmsHelper, fisHelper, companyId, bookYear, AssetBO.isIdNumeric(company, true), ap2Usage);
        FileOutputStream fos = new FileOutputStream(ReportFileHelper.getFileName(args, FILENAME, "pdf"));
        fos.write(creditToPDF.createPdf().toByteArray());
        fos.close();
        loginHelper.logout(environment, companyId, bookYear);
        loginHelper.logout();
    }
}

