/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.reports;

import java.io.FileOutputStream;
import java.util.Collection;
import java.util.Map;
import nl.ibs.fac.BatchJobHelper;
import nl.ibs.fac.IBSDecimal;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.ReasonCodeEnum;
import nl.ibs.fac.ReportFileHelper;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.EnvironmentBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.boadapters.TransactionBatchBO;
import nl.ibs.fac.boadapters.ValuationMainAccountBO;
import nl.ibs.fac.bp.DepreciationProposalBP;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Credit;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.TransactionBatch;
import nl.ibs.fac.db.ValuationMainAccount;
import nl.ibs.fac.gov.boadapters.CreditBO;
import nl.ibs.fac.gov.reports.AdditionalJournalingDataHelper;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.reports.CSVHelper;
import nl.ibs.fac.reports.DepreciationProposalToPDF;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;
import nl.ibs.util.Stopwatch;

public class DepreciationProposalToCSV
extends CSVHelper {
    public static final String CLASSNAME = DepreciationProposalToCSV.class.getName();
    private static final String FILENAME = "DepreciationProposal";
    private static final String[] LABELS = new String[]{"Id", "Description", "Type", "Period", "DepreciationValue", "InterestValue", "ReasonCode"};
    private String[] finTexts;
    private int numberOfColumns;
    private boolean governmentActivated;
    private AdditionalJournalingDataHelper ajdHelper;
    private ValuationMainAccount vma;

    public DepreciationProposalToCSV(String[][] selections, Collection collection, String[][] labels, String[] finTexts) throws Exception {
        super(selections, collection, labels, null, null);
        this.numberOfColumns = labels[0].length;
        this.finTexts = finTexts;
    }

    public void setGovernmentActivated(boolean governmentActivated, Company company, int year) throws Exception {
        this.governmentActivated = governmentActivated;
        if (governmentActivated) {
            this.ajdHelper = new AdditionalJournalingDataHelper(company, year, null);
        }
    }

    @Override
    protected String[] getRowValues(Object object) throws Exception {
        Transaction transaction = (Transaction)object;
        String[] value = new String[this.numberOfColumns];
        if ("A".equals(transaction.getCora())) {
            value[0] = transaction.getAssetId();
            value[1] = transaction.getAsset().getDescription();
        } else {
            value[0] = transaction.getCreditId();
            value[1] = ((Credit)CreditBO.get((Company)CompanyBO.get(transaction.getDBData(), transaction.getCompanyId())[0], transaction.getCreditId())[0]).getDescription();
        }
        value[2] = transaction.getProFormaTypeId();
        value[3] = PeriodHelper.toString(transaction.getBookYear(), transaction.getPeriod());
        value[4] = IBSDecimal.format(transaction.getAmount2());
        value[5] = IBSDecimal.format(transaction.getAmount3());
        value[6] = ReasonCodeEnum.getValue(transaction.getReasonCode());
        int i = 7;
        String finDimId1 = transaction.getFinDimId1();
        String finDimId2 = transaction.getFinDimId2();
        String finDimId3 = transaction.getFinDimId3();
        String finDimId4 = transaction.getFinDimId4();
        String finDimId5 = transaction.getFinDimId5();
        if (this.finTexts[0] != null) {
            value[i++] = finDimId1;
        }
        if (this.finTexts[1] != null) {
            value[i++] = finDimId2;
        }
        if (this.finTexts[2] != null) {
            value[i++] = finDimId3;
        }
        if (this.finTexts[3] != null) {
            value[i++] = finDimId4;
        }
        if (this.finTexts[4] != null) {
            value[i++] = finDimId5;
        }
        if (this.governmentActivated) {
            if ("A".equals(transaction.getCora())) {
                this.vma = ValuationMainAccountBO.getValuationMainAccountToUse(transaction.getDBData(), transaction.getCompanyId(), "A", transaction.getAssetId(), 1, transaction.getBookYearForJournalization(), 1);
                value[i++] = this.vma != null ? this.vma.getMainAccountId3() : this.ajdHelper.getId(transaction.getProFormaTypeId(), 1, 30, 0);
                value[i++] = this.ajdHelper.getId(transaction.getProFormaTypeId(), 1, 30, 1);
                value[i++] = this.vma != null ? this.vma.getMainAccountId8() : this.ajdHelper.getId(transaction.getProFormaTypeId(), 1, 80, 0);
                value[i++] = this.ajdHelper.getId(transaction.getProFormaTypeId(), 1, 80, 1);
            } else {
                this.vma = ValuationMainAccountBO.getValuationMainAccountToUse(transaction.getDBData(), transaction.getCompanyId(), "C", transaction.getCreditId(), 3, transaction.getBookYearForJournalization(), 1);
                value[i++] = this.vma != null ? this.vma.getMainAccountId3() : "";
                value[i++] = transaction.getProFormaTypeId().trim().length() > 0 ? this.ajdHelper.getId(transaction.getProFormaTypeId(), 1, 30, 1) : "";
                value[i++] = this.vma != null ? this.vma.getMainAccountId8() : "";
                value[i++] = transaction.getProFormaTypeId().trim().length() > 0 ? this.ajdHelper.getId(transaction.getProFormaTypeId(), 1, 80, 1) : "";
            }
        }
        return value;
    }

    public static void main(String[] args) {
        Stopwatch sw = null;
        if (Log.debug()) {
            sw = new Stopwatch();
            sw.start();
        }
        try {
            DepreciationProposalToCSV.execute(args);
        }
        catch (Exception e) {
            Log.error((Exception)e);
            System.exit(-1);
        }
        if (sw != null) {
            Log.debug((String)("Elapsed time: " + sw.stop(1) + " seconds"));
        }
        System.exit(0);
    }

    public static void execute(String[] args) throws Exception {
        TransactionBatch transactionBatch;
        if (Log.debug() && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                Log.debug((String)args[i]);
            }
        }
        String[][] selections = BatchJobHelper.getSelections(args);
        Map map = BatchJobHelper.getSelections(selections);
        String companyId = (String)map.get("Company");
        DBData dbData = BOAdapter.getDBData(map);
        Environment env = (Environment)EnvironmentBO.get((String)map.get("facLib"))[0];
        if (map.containsKey("batchId")) {
            int batchId = Integer.parseInt((String)map.get("batchId"));
            transactionBatch = (TransactionBatch)TransactionBatchBO.get(dbData, companyId, batchId)[0];
        } else {
            transactionBatch = DepreciationProposalBP.getCurrentDepreciationBatch(dbData, companyId);
            if (transactionBatch != null) {
                map.put("batchId", "" + transactionBatch.getBatchId());
            }
        }
        if (transactionBatch == null) {
            String message = LanguageHelper.getString("nl.ibs.fac.language", "batch_not_found");
            Log.error((String)message);
            return;
        }
        map.put("governmentActivated", new Boolean(env.getGovernmentActivated()));
        String[][] modifiedSelections = DepreciationProposalToPDF.modifySelections(selections, env, transactionBatch);
        if (transactionBatch.getCodeFiscal()) {
            DepreciationProposalToCSV.processAccountingPrinciple(args, map, modifiedSelections, env, transactionBatch, false);
        }
        if (transactionBatch.getCodeAccountingPrinciple2() || env.getGovernmentActivated()) {
            DepreciationProposalToCSV.processAccountingPrinciple(args, map, modifiedSelections, env, transactionBatch, true);
        }
    }

    private static void processAccountingPrinciple(String[] args, Map map, String[][] modifiedSelections, Environment environment, TransactionBatch transactionBatch, boolean ap2) throws Exception {
        int i;
        if (ap2) {
            map.remove("AccountingPrinciple2");
            modifiedSelections[5][1] = environment.getGovernmentActivated() ? ": " + environment.getAPName3() : ": " + environment.getAPName2();
        } else {
            modifiedSelections[5][1] = ": " + environment.getAPName1();
        }
        map.put("AccountingPrinciple2", new Boolean(ap2));
        DBData dbData = transactionBatch.getDBData();
        String companyId = (String)map.get("Company");
        Company company = (Company)CompanyBO.get(dbData, companyId)[0];
        String[] finTexts = new String[5];
        if (company.retrieveFinancialDimension1Usage() != 0) {
            finTexts[0] = environment.getName1();
        }
        if (company.retrieveFinancialDimension2Usage() != 0) {
            finTexts[1] = environment.getName2();
        }
        if (company.retrieveFinancialDimension3Usage() != 0) {
            finTexts[2] = environment.getName3();
        }
        if (company.retrieveFinancialDimension4Usage() != 0) {
            finTexts[3] = environment.getName4();
        }
        if (company.retrieveFinancialDimension5Usage() != 0) {
            finTexts[4] = environment.getName5();
        }
        int numberOfDims = 0;
        for (int i2 = 0; i2 < finTexts.length; ++i2) {
            if (finTexts[i2] == null) continue;
            ++numberOfDims;
        }
        if (environment.getGovernmentActivated()) {
            numberOfDims += 4;
        }
        String[][] labels = new String[1][LABELS.length + numberOfDims];
        int index = 0;
        for (i = 0; i < LABELS.length; ++i) {
            labels[0][index++] = LABELS[i];
        }
        for (i = 0; i < finTexts.length; ++i) {
            if (finTexts[i] == null) continue;
            labels[0][index++] = finTexts[i];
        }
        if (environment.getGovernmentActivated()) {
            labels[0][index++] = "Afschr.kosten";
            labels[0][index++] = "Categorie AK";
            labels[0][index++] = "Rentekosten";
            labels[0][index++] = "Categorie RK";
        }
        DepreciationProposalToCSV depreciationProposalToCSV = new DepreciationProposalToCSV(modifiedSelections, TransactionBO.getTransactions(map, transactionBatch), labels, finTexts);
        depreciationProposalToCSV.setGovernmentActivated(environment.getGovernmentActivated(), company, transactionBatch.getEndYear());
        FileOutputStream fos = new FileOutputStream(ReportFileHelper.getFileName(args, LanguageHelper.getString("nl.ibs.fac.language", FILENAME) + '-' + modifiedSelections[5][1].substring(2), "csv"));
        fos.write(depreciationProposalToCSV.createCsv());
        fos.close();
    }
}

