/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.reports;

import com.itextpdf.text.Rectangle;
import java.io.FileOutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import nl.ibs.fac.BatchJobHelper;
import nl.ibs.fac.IBSDecimal;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.ReportFileHelper;
import nl.ibs.fac.adapters.NumericIdTransformer;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.EnvironmentBO;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.db.IncomingFinancialTransaction;
import nl.ibs.fac.fis.FISHelper;
import nl.ibs.fac.fms.FMSHelper;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.reports.PdfHelper;
import nl.ibs.fac.ui.IncomingFinancialTransactionSelection;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;
import nl.ibs.util.Stopwatch;

public class IncomingFinancialTransactionToPDF
extends PdfHelper {
    public static final String CLASSNAME = IncomingFinancialTransactionToPDF.class.getName();
    private static final String FILENAME = "IncomingFinancialTransactionReport";
    private static final String REPORTTITLE = "IncomingFinancialTransactionReport";
    private int[] orderByField = null;
    private int numberOfColumns = 0;
    private boolean[] used = new boolean[5];
    private String[] attr;
    private Environment env;
    private Company company;
    private IncomingFinancialTransaction ift = null;
    private IncomingFinancialTransactionSelection selection = null;
    private NumericIdTransformer numericIdTransformer = new NumericIdTransformer();

    public IncomingFinancialTransactionToPDF(String reportTitle, String[][] selections, IncomingFinancialTransactionSelection selection, boolean governmentActivated, Environment environment, FMSHelper fmsHelper, FISHelper fisHelper, Company company, String bookYear) throws Exception {
        super(reportTitle, selections, selection.getCollection(), fmsHelper, fisHelper, company.getId(), bookYear);
        this.env = environment;
        this.company = company;
        this.selection = selection;
        this.orderByField = selection.getOrderBy();
        this.cumulator.setSwitchCumulationLevel(0, selection.getGrandTotal());
        this.init();
    }

    private void init() throws Exception {
        this.document.setPageSize(new Rectangle(1000.0f, 1400.0f));
        this.used[0] = this.company.getFinancialDimension1Usage() != 0;
        this.used[1] = this.company.getFinancialDimension2Usage() != 0;
        this.used[2] = this.company.getFinancialDimension3Usage() != 0;
        this.used[3] = this.company.getFinancialDimension4Usage() != 0;
        this.used[4] = this.company.getFinancialDimension5Usage() != 0;
        ArrayList<String> labels = new ArrayList<String>();
        labels.add(LanguageHelper.getString("nl.ibs.fac.language", "Period"));
        labels.add(LanguageHelper.getString("nl.ibs.fac.language", "Description"));
        labels.add(LanguageHelper.getString("nl.ibs.fac.language", "Amount"));
        labels.add(LanguageHelper.getString("nl.ibs.fac.language", "ToAccountFor"));
        labels.add(LanguageHelper.getString("nl.ibs.fac.language", "MainAccount"));
        if (this.used[0]) {
            labels.add(this.env.getShortName1());
        }
        if (this.used[1]) {
            labels.add(this.env.getShortName2());
        }
        if (this.used[2]) {
            labels.add(this.env.getShortName3());
        }
        if (this.used[3]) {
            labels.add(this.env.getShortName4());
        }
        if (this.used[4]) {
            labels.add(this.env.getShortName5());
        }
        labels.add(LanguageHelper.getString("nl.ibs.fac.language", "SystemItemNumber.short"));
        labels.add(LanguageHelper.getString("nl.ibs.fac.language", "VoucherId.short"));
        labels.add(LanguageHelper.getString("nl.ibs.fac.language", "InternalInvoiceId.short"));
        this.numberOfColumns = labels.size();
        this.value = new String[this.numberOfColumns];
        this.bold = new boolean[this.numberOfColumns];
        this.translate = new boolean[this.numberOfColumns];
        this.attr = new String[this.numberOfColumns];
        String[][] LABELS = new String[][]{new String[0]};
        LABELS[0] = new String[this.numberOfColumns];
        int[] SIZES = new int[this.numberOfColumns];
        boolean[] RIGHTALIGN = new boolean[this.numberOfColumns];
        block5: for (int i = 0; i < this.numberOfColumns; ++i) {
            LABELS[0][i] = (String)labels.get(i);
            switch (i) {
                case 1: {
                    SIZES[i] = 150;
                    RIGHTALIGN[i] = false;
                    continue block5;
                }
                case 2: {
                    SIZES[i] = 75;
                    RIGHTALIGN[i] = true;
                    continue block5;
                }
                case 3: {
                    SIZES[i] = 75;
                    RIGHTALIGN[i] = true;
                    continue block5;
                }
                default: {
                    SIZES[i] = 50;
                    RIGHTALIGN[i] = false;
                }
            }
        }
        this.createTable(true, LABELS, SIZES, RIGHTALIGN, null);
        this.addTableHeader();
    }

    @Override
    protected void processObject(Object object) throws Exception {
        this.ift = (IncomingFinancialTransaction)object;
        this.printSubTotals();
        this.printObject();
    }

    private void printObject() throws Exception {
        int a = 0;
        this.attr[a++] = PeriodHelper.toString(this.ift.getBookYear(), this.ift.getPeriod());
        this.attr[a++] = this.ift.getDescription();
        this.attr[a++] = IBSDecimal.format(this.ift.getTransactionValue(), true);
        this.attr[a++] = IBSDecimal.format(this.ift.getUnAllocatedValue(), true);
        this.attr[a++] = (String)this.numericIdTransformer.transform(this.ift.getMainAccount());
        if (this.used[0]) {
            this.attr[a++] = (String)this.numericIdTransformer.transform(this.ift.getFinDimId1());
        }
        if (this.used[1]) {
            this.attr[a++] = (String)this.numericIdTransformer.transform(this.ift.getFinDimId2());
        }
        if (this.used[2]) {
            this.attr[a++] = (String)this.numericIdTransformer.transform(this.ift.getFinDimId3());
        }
        if (this.used[3]) {
            this.attr[a++] = (String)this.numericIdTransformer.transform(this.ift.getFinDimId4());
        }
        if (this.used[4]) {
            this.attr[a++] = (String)this.numericIdTransformer.transform(this.ift.getFinDimId5());
        }
        this.attr[a++] = "" + this.ift.getSystemItemNumber();
        this.attr[a++] = this.ift.getVoucherId();
        this.attr[a++] = "" + this.ift.getInternalInvoiceId();
        for (int i = 0; i < this.numberOfColumns; ++i) {
            this.setCell(i, this.attr[i], false, false);
        }
        if (!this.selection.getJustTotals()) {
            this.addTableRow();
        }
        this.cumulate(this.ift);
    }

    protected void printSubTotals() throws Exception {
        int o = this.orderByField.length;
        int[] orderBy = new int[o];
        for (int i = 0; i < this.orderByField.length; ++i) {
            orderBy[i] = this.orderByField[--o];
        }
        for (o = 0; o < orderBy.length; ++o) {
            int lvl = orderBy[o];
            if (lvl <= 0 || !this.cumulator.getSwitchCumulationLevel(lvl) || !this.cumulator.levelBreak(this.ift, lvl) && !this.endOfFile) continue;
            this.addSubTotalRow(lvl);
        }
        if (this.endOfFile && this.selection.getGrandTotal()) {
            this.addSubTotalRow(0);
        }
    }

    protected void addSubTotalRow(int level) throws Exception {
        String id = (String)this.numericIdTransformer.transform(this.cumulator.getLevelValue(level)[0]);
        String descr = this.cumulator.getLevelValue(level)[1];
        if (level >= 1 && level <= 6) {
            descr = this.getFinDimDescription(id, level - 1);
        }
        BigDecimal[] total = this.getTotalsForLevel(level);
        this.clearCells();
        if (level == 0) {
            this.setCell(0, this.totalText, false, true);
            this.setCell(1, this.totalGenText, false, true);
        } else {
            this.setCell(0, this.totalText, false, true);
            this.setCell(1, this.cumulator.getLevelName(level, this.env) + " " + id + " (" + descr + ")", false, true);
        }
        this.setCell(2, IBSDecimal.format(total[2], true), false, true);
        this.setCell(3, IBSDecimal.format(total[3], true), false, true);
        this.addTableRow();
        this.addEmptyTableRow();
    }

    @Override
    protected void addTotalGenRow() throws Exception {
        this.printSubTotals();
    }

    @Override
    protected int[] getColumnsToCumulate() throws Exception {
        return new int[]{2, 3};
    }

    public static void main(String[] args) {
        Stopwatch sw = null;
        if (Log.debug()) {
            sw = new Stopwatch();
            sw.start();
        }
        try {
            IncomingFinancialTransactionToPDF.execute(args);
        }
        catch (Exception e) {
            Log.error((Exception)e);
            System.exit(-1);
        }
        if (sw != null) {
            Log.debug((String)("Elapsed time: " + sw.stop(1) + " seconds"));
        }
        System.exit(0);
    }

    public static void execute(String[] args) throws Exception {
        String bookYear;
        String companyId;
        String[][] selections;
        Map map;
        LoginHelper loginHelper;
        String message;
        if (Log.debug() && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                Log.debug((String)args[i]);
            }
        }
        if ((message = (loginHelper = BatchJobHelper.getLoginHelper(map = BatchJobHelper.getSelections(selections = BatchJobHelper.getSelections(args)))).login()) != null) {
            message = LanguageHelper.getString("nl.ibs.fac.language", message);
            Log.error((String)message);
            return;
        }
        String selectionAsString = (String)map.get(IncomingFinancialTransactionSelection.IFTSELECTION);
        IncomingFinancialTransactionSelection selection = new IncomingFinancialTransactionSelection(selectionAsString);
        boolean governmentActivated = Boolean.valueOf((String)map.get("governmentActivated"));
        Environment environment = (Environment)EnvironmentBO.get((String)map.get("facLib"))[0];
        message = loginHelper.login(environment, companyId = (String)map.get("Company"), bookYear = (String)map.get("BookYear"));
        if (message != null && message.trim().length() > 0) {
            message = LanguageHelper.getString("nl.ibs.fac.language", message);
            Log.error((String)message);
            return;
        }
        FMSHelper fmsHelper = null;
        FISHelper fisHelper = null;
        if (environment.getOperationArea().trim().length() > 0) {
            fmsHelper = new FMSHelper(loginHelper);
        } else {
            fisHelper = new FISHelper(loginHelper);
        }
        DBData dbData = BOAdapter.getDBData(map);
        Company company = (Company)CompanyBO.get(dbData, companyId)[0];
        IncomingFinancialTransactionToPDF incomingFinancialTransactionToPDF = new IncomingFinancialTransactionToPDF("IncomingFinancialTransactionReport", selections, selection, governmentActivated, environment, fmsHelper, fisHelper, company, bookYear);
        FileOutputStream fos = new FileOutputStream(ReportFileHelper.getFileName(args, "IncomingFinancialTransactionReport", "pdf"));
        fos.write(incomingFinancialTransactionToPDF.createPdf().toByteArray());
        fos.close();
        loginHelper.logout(environment, companyId, bookYear);
        loginHelper.logout();
    }
}

