/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.reports;

import com.itextpdf.text.Element;
import java.io.FileOutputStream;
import java.util.Collection;
import java.util.Map;
import nl.ibs.fac.BatchJobHelper;
import nl.ibs.fac.IBSDecimal;
import nl.ibs.fac.ReportFileHelper;
import nl.ibs.fac.boadapters.InterestTableBO;
import nl.ibs.fac.db.InterestBookYear;
import nl.ibs.fac.db.InterestPeriod;
import nl.ibs.fac.db.InterestTable;
import nl.ibs.fac.reports.PdfHelper;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.ExecutableQuery;
import nl.ibs.jsql.QueryFactory;
import nl.ibs.util.Stopwatch;

public class InterestTableToPDF
extends PdfHelper {
    public static final String CLASSNAME = InterestTableToPDF.class.getName();
    private static final String FILENAME = "InterestTable";
    private static final String REPORTTITLE = "InterestTables";
    private static final String[][] LABELSTABLE = new String[][]{{"Id", "Description", "NumberOfPeriods"}};
    private static final int[] SIZESTABLE = new int[]{100, 250, 100};
    private static final boolean[] RIGHTALIGNTABLE = new boolean[]{false, false, true};
    private static final String[][] LABELSPERIOD = new String[][]{{"", "BookYear", "RecalculationPercentage", "Period", "Percentage"}};
    private static final int[] SIZESPERIOD = new int[]{50, 100, 200, 75, 75};
    private static final boolean[] RIGHTALIGNPERIOD = new boolean[]{true, true, true, true, true};
    private InterestTable interestTable = null;
    private String previousId = null;
    private String interestTableId = null;

    protected InterestTableToPDF(String reportTitle, String[][] selections, Collection collection) throws Exception {
        super(reportTitle, selections, collection, null, null, "", "");
    }

    @Override
    protected void processObject(Object object) throws Exception {
        this.interestTable = (InterestTable)object;
        this.interestTableId = this.interestTable.getId();
        if (this.previousId != null) {
            this.document.add((Element)this.table);
            this.table = null;
            this.document.newPage();
        }
        this.previousId = this.interestTableId;
        this.value = new String[3];
        this.translate = new boolean[]{true, true, true};
        this.bold = new boolean[3];
        this.createTable(false, LABELSTABLE, SIZESTABLE, RIGHTALIGNTABLE, this.translate);
        this.addTableHeader();
        this.setCell(0, this.interestTable.getId(), false, false);
        this.setCell(1, this.interestTable.getDescription(), false, false);
        this.setCell(2, "" + this.interestTable.getNumberOfPeriods(), false, false);
        this.addTableRow();
        this.addEmptyTableRow();
        this.printInterestTableDetails();
    }

    private void printInterestTableDetails() throws Exception {
        this.value = new String[5];
        this.translate = new boolean[]{true, true, true, true, true};
        this.bold = new boolean[5];
        this.createTable(true, LABELSPERIOD, SIZESPERIOD, RIGHTALIGNPERIOD, this.translate);
        this.addTableHeader();
        ExecutableQuery queryP = QueryFactory.create(InterestPeriod.class);
        queryP.setOrdering("period");
        ExecutableQuery queryB = QueryFactory.create(InterestBookYear.class);
        queryB.setOrdering("bookYear");
        for (InterestBookYear interestBookYear : this.interestTable.getInterestBookYearsCollection(queryB)) {
            boolean first = true;
            for (InterestPeriod period : interestBookYear.getInterestPeriodsCollection(queryP)) {
                if (first) {
                    this.setCell(1, "" + interestBookYear.getBookYear(), false, false);
                    this.setCell(2, IBSDecimal.format(interestBookYear.getRecalculationPercentage(), 3), false, false);
                    this.setCell(3, "" + period.getPeriod(), false, false);
                    this.setCell(4, IBSDecimal.format(period.getPercentage(), 3), false, false);
                    first = false;
                } else {
                    this.setCell(1, "", false, false);
                    this.setCell(2, "", false, false);
                    this.setCell(3, "" + period.getPeriod(), false, false);
                    this.setCell(4, IBSDecimal.format(period.getPercentage(), 3), false, false);
                }
                this.addTableRow();
            }
        }
    }

    public static void main(String[] args) {
        Stopwatch sw = null;
        if (Log.debug()) {
            sw = new Stopwatch();
            sw.start();
        }
        try {
            InterestTableToPDF.execute(args);
        }
        catch (Exception e) {
            Log.error((Exception)e);
            System.exit(-1);
        }
        if (sw != null) {
            Log.debug((String)("Elapsed time: " + sw.stop(1) + " seconds"));
        }
        System.exit(0);
    }

    public static void execute(String[] args) throws Exception {
        if (Log.debug() && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                Log.debug((String)args[i]);
            }
        }
        String[][] selections = BatchJobHelper.getSelections(args);
        Map map = BatchJobHelper.getSelections(selections);
        InterestTableToPDF interestTableToPDF = new InterestTableToPDF(REPORTTITLE, selections, InterestTableBO.getInterestTables(map));
        FileOutputStream fos = new FileOutputStream(ReportFileHelper.getFileName(args, FILENAME, "pdf"));
        fos.write(interestTableToPDF.createPdf().toByteArray());
        fos.close();
    }

    @Override
    protected int[] getColumnsToCumulate() throws Exception {
        return null;
    }

    protected int[] getLevelsToCumulate() throws Exception {
        return null;
    }
}

