/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.reports;

import com.itextpdf.text.Document;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.Image;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPTableEvent;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfPageEventHelper;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import nl.ibs.fac.Cumulator;
import nl.ibs.fac.DateHelper;
import nl.ibs.fac.boadapters.EnvironmentBO;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.fis.FISHelper;
import nl.ibs.fac.fms.FMSHelper;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.ui.AssetSelection;
import nl.ibs.fac.ui.IncomingFinancialTransactionSelection;
import nl.ibs.jeelog.Log;
import nl.ibs.util.NameValuePair;

public abstract class PdfHelper
extends PdfPageEventHelper {
    protected static final Rectangle A4LANDSCAPE = new Rectangle(842.0f, 595.0f);
    protected static final String SKIP_FRONTPAGE = "SKIP_FRONTPAGE";
    protected Document document;
    protected String reportTitle;
    private Collection collection;
    protected static final String FILETYPE = "pdf";
    private boolean[] alignRight;
    private int[] cellBorder;
    protected String[][] selections;
    protected PdfPTable table = null;
    protected PdfPCell defaultCell;
    private boolean odd = true;
    private PdfTemplate tpl;
    private BaseFont baseFont;
    private Font boldFont;
    private String[][] labels;
    protected boolean[] translateLabel;
    private int antColumns;
    private int[] sizes;
    private Object[] values = null;
    protected String[] value;
    protected boolean[] translate;
    protected boolean[] bold;
    protected boolean endOfFile = false;
    protected Cumulator cumulator = null;
    protected int[] columnsToCumulate = null;
    protected String totalText = LanguageHelper.getString("nl.ibs.fac.language", "Total");
    protected String totalGenText = LanguageHelper.getString("nl.ibs.fac.language", "General");
    protected FISHelper fisHelper = null;
    protected FMSHelper fmsHelper = null;
    protected String companyId = null;
    protected String bookYear = null;
    protected boolean interest = false;

    protected PdfHelper() throws Exception {
        this.baseFont = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)false);
        this.boldFont = FontFactory.getFont((String)"Helvetica-Bold", (String)"Cp1252", (boolean)false);
    }

    protected PdfHelper(String reportTitle, String[][] selections, Collection collection, String[][] labels, int[] sizes, boolean[] alignRight, FMSHelper fmsHelper, FISHelper fisHelper, String companyId, String bookYear) throws Exception {
        this(reportTitle, selections, collection, fmsHelper, fisHelper, companyId, bookYear);
        this.labels = labels;
        this.sizes = sizes;
        this.alignRight = alignRight;
        this.cumulator = this.createCumulator();
        this.value = new String[labels[0].length];
        this.bold = new boolean[labels[0].length];
        this.translate = new boolean[labels[0].length];
        this.createTable(false);
        this.addTableHeader();
    }

    protected PdfHelper(String reportTitle, String[][] selections, Collection collection, FMSHelper fmsHelper, FISHelper fisHelper, String companyId, String bookYear) throws Exception {
        this.reportTitle = reportTitle;
        this.selections = selections;
        this.collection = collection;
        this.fmsHelper = fmsHelper;
        this.fisHelper = fisHelper;
        this.companyId = companyId;
        this.bookYear = bookYear;
        this.cumulator = this.createCumulator();
        this.document = new Document();
        this.document.setMargins(20.0f, 5.0f, 40.0f, 40.0f);
        this.document.addTitle(LanguageHelper.getString("nl.ibs.fac.language", reportTitle));
        this.baseFont = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)false);
        this.boldFont = FontFactory.getFont((String)"Helvetica-Bold", (String)"Cp1252", (boolean)false);
    }

    protected PdfHelper(String reportTitle, String[][] selections, Collection collection, FMSHelper fmsHelper, FISHelper fisHelper, String companyId, String bookYear, boolean interest) throws Exception {
        this.reportTitle = reportTitle;
        this.selections = selections;
        this.collection = collection;
        this.fmsHelper = fmsHelper;
        this.fisHelper = fisHelper;
        this.companyId = companyId;
        this.bookYear = bookYear;
        this.interest = interest;
        this.cumulator = this.createCumulator();
        this.document = new Document();
        this.document.setMargins(20.0f, 5.0f, 40.0f, 40.0f);
        this.document.addTitle(LanguageHelper.getString("nl.ibs.fac.language", reportTitle));
        this.baseFont = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)false);
        this.boldFont = FontFactory.getFont((String)"Helvetica-Bold", (String)"Cp1252", (boolean)false);
    }

    protected void createTable(boolean border, String[][] labels, int[] sizes, boolean[] alignRight, boolean[] translateLabel) throws Exception {
        this.labels = labels;
        this.sizes = sizes;
        this.alignRight = alignRight;
        this.translateLabel = translateLabel;
        this.createTable(true);
    }

    protected void createTable(boolean border) throws Exception {
        if (this.table != null) {
            this.document.add((Element)this.table);
        }
        this.odd = true;
        this.antColumns = this.labels[0].length;
        this.table = new PdfPTable(this.antColumns);
        this.table.setHeaderRows(2);
        this.table.setWidths(this.sizes);
        this.table.setWidthPercentage(100.0f);
        this.defaultCell = this.table.getDefaultCell();
        this.defaultCell.setBorder(0);
        this.defaultCell.setPaddingBottom(5.0f);
        if (border) {
            this.table.setTableEvent((PdfPTableEvent)new TableEvent());
        }
        this.cellBorder = new int[this.labels[0].length];
    }

    protected Cumulator createCumulator() throws Exception {
        this.columnsToCumulate = this.getColumnsToCumulate();
        Cumulator cumulator = new Cumulator();
        boolean[] levelsToCumulate = null;
        String selectionAsString = this.extractFromSelections(AssetSelection.ASSETSELECTION);
        if (selectionAsString != null) {
            levelsToCumulate = new AssetSelection(selectionAsString).getLevelBreakFields();
        } else {
            selectionAsString = this.extractFromSelections(IncomingFinancialTransactionSelection.IFTSELECTION);
            if (selectionAsString != null) {
                levelsToCumulate = new IncomingFinancialTransactionSelection(selectionAsString).getLevelBreakFields();
            }
        }
        if (levelsToCumulate != null) {
            for (int i = 0; i < levelsToCumulate.length; ++i) {
                cumulator.setSwitchCumulationLevel(i, levelsToCumulate[i]);
            }
        }
        return cumulator;
    }

    protected abstract int[] getColumnsToCumulate() throws Exception;

    protected void cumulate(Object object) throws Exception {
        this.values = new Object[this.columnsToCumulate.length];
        for (int i = 0; i < this.columnsToCumulate.length; ++i) {
            this.values[i] = this.value[this.columnsToCumulate[i]];
        }
        this.cumulator.add(object, this.values);
    }

    protected BigDecimal[] getTotalsForLevel(int level) throws Exception {
        BigDecimal[] total = this.cumulator.getTotalsForLevel(level);
        BigDecimal[] result = new BigDecimal[this.value.length];
        for (int i = 0; i < this.columnsToCumulate.length; ++i) {
            result[this.columnsToCumulate[i]] = total[i];
        }
        return result;
    }

    protected String extractFromSelections(String key) {
        String result = null;
        for (int i = 0; i < this.selections.length; ++i) {
            if (!key.equals(this.selections[i][0])) continue;
            result = this.selections[i][1];
        }
        return result;
    }

    public ByteArrayOutputStream createPdf() throws Exception {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        PdfWriter writer = PdfWriter.getInstance((Document)this.document, (OutputStream)stream);
        writer.setPageEvent((PdfPageEvent)this);
        this.document.open();
        this.document.newPage();
        if (Log.debug()) {
            Log.debug((String)("" + this.collection.size()));
        }
        this.endOfFile = false;
        Iterator iterator = this.collection.iterator();
        while (iterator.hasNext()) {
            this.processObject(iterator.next());
        }
        this.endOfFile = true;
        this.addTotalRow();
        this.addTotalGenRow();
        if (this.table != null) {
            this.document.add((Element)this.table);
        }
        this.document.close();
        if (Log.debug()) {
            Log.debug((String)("" + stream.size()));
        }
        return stream;
    }

    protected void processObject(Object object) throws Exception {
        this.addTableRow(this.getRowValues(object), null, null);
    }

    protected String[] getRowValues(Object object) throws Exception {
        return new String[0];
    }

    protected void addTableHeader() throws Exception {
        for (int i = 0; i < this.labels.length; ++i) {
            for (int j = 0; j < this.labels[0].length; ++j) {
                String value = this.labels[i][j];
                if (this.translateLabel == null || this.translateLabel[j]) {
                    value = LanguageHelper.getString("nl.ibs.fac.language", value);
                }
                this.setCell(j, value, false, true);
            }
            this.addTableRow();
        }
        this.table.setHeaderRows(this.labels.length);
    }

    protected void addTableHeader(int selfDefinedHeaderRows) throws Exception {
        this.addTableHeader();
        this.table.setHeaderRows(this.table.getHeaderRows() + selfDefinedHeaderRows);
    }

    protected void clearCells() throws Exception {
        for (int i = 0; i < this.value.length; ++i) {
            this.value[i] = "";
        }
    }

    protected void setCell(int i, String value, boolean translate, boolean bold) throws Exception {
        this.value[i] = value;
        this.translate[i] = translate;
        this.bold[i] = bold;
    }

    protected void setCellBorder(int i, int border) throws Exception {
        this.cellBorder[i] = border;
    }

    protected void resetCellBorders() throws Exception {
        for (int i = 0; i < this.cellBorder.length; ++i) {
            this.cellBorder[i] = 0;
        }
    }

    protected void addTableRow() throws Exception {
        this.addTableRow(this.value, this.translate, this.bold);
    }

    protected void addTableRow(String[] value) throws Exception {
        this.addTableRow(value, null, null);
    }

    protected void addTableRow(String[] value, boolean[] translate) throws Exception {
        this.addTableRow(value, translate, null);
    }

    protected void addTableRow(String[] value, boolean[] translate, boolean[] bold) throws Exception {
        this.defaultCell = this.table.getDefaultCell();
        if (this.odd) {
            this.defaultCell.setGrayFill(1.0f);
            this.odd = false;
        } else {
            this.defaultCell.setGrayFill(0.9f);
            this.odd = true;
        }
        for (int i = 0; i < value.length; ++i) {
            if (value[i] == null) {
                this.table.addCell(" ");
                continue;
            }
            this.defaultCell.setHorizontalAlignment(0);
            if (this.alignRight[i]) {
                this.defaultCell.setHorizontalAlignment(2);
            }
            this.defaultCell.setBorder(0);
            if (this.cellBorder[i] != 0) {
                this.defaultCell.setBorder(this.cellBorder[i]);
            }
            if (translate != null && translate[i]) {
                value[i] = LanguageHelper.getString("nl.ibs.fac.language", value[i]);
            }
            if (bold != null && bold[i]) {
                this.table.addCell(new Phrase(value[i], this.boldFont));
                continue;
            }
            this.table.addCell(value[i]);
        }
    }

    protected void addEmptyTableRow() throws Exception {
        String[] value = new String[this.antColumns];
        for (int i = 0; i < value.length; ++i) {
            value[i] = " ";
        }
        this.addTableRow(value);
    }

    protected void addTotalRow() throws Exception {
    }

    protected void addTotalGenRow() throws Exception {
    }

    protected static String formatAssetId(Asset asset, boolean numericId) throws Exception {
        String id;
        String string = id = numericId ? String.valueOf(Integer.parseInt(asset.getId())) : asset.getId();
        if (!asset.getParentAsset() && asset.getSubAsset()) {
            id = " > " + id;
        }
        return id;
    }

    public void onStartPage(PdfWriter writer, Document document) {
        PdfContentByte cb = writer.getDirectContent();
        cb.saveState();
        if (writer.getPageNumber() == 1) {
            this.tpl = writer.getDirectContent().createTemplate(100.0f, 100.0f);
            this.tpl.setBoundingBox(new Rectangle(-20.0f, -20.0f, 100.0f, 100.0f));
            this.addImage(cb);
            this.addReportTitle(cb);
            if (this.selections != null) {
                this.addSelections(cb);
            }
        } else {
            this.addReportTitle(cb);
        }
        String text = DateHelper.getDate() + "  " + DateHelper.getTime();
        int size = 12;
        float textSize = this.baseFont.getWidthPoint(text, (float)size);
        cb.beginText();
        cb.setFontAndSize(this.baseFont, (float)size);
        float textBase = document.top() + 20.0f;
        cb.setTextMatrix(document.right() - textSize, textBase);
        cb.showText(text);
        cb.endText();
        cb.restoreState();
    }

    protected void addImage(PdfContentByte cb) {
        try {
            ClassLoader cl = PdfHelper.class.getClassLoader();
            URL url = cl.getResource("PrintLogo.gif");
            Image image = Image.getInstance((URL)url);
            image.setAbsolutePosition(-60.0f + (this.document.left() + this.document.right()) / 2.0f, this.document.top() - 50.0f);
            cb.addImage(image);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void addReportTitle(PdfContentByte cb) {
        cb.beginText();
        int size = 18;
        cb.setFontAndSize(this.baseFont, (float)size);
        String text = LanguageHelper.getString("nl.ibs.fac.language", this.reportTitle);
        float textSize = this.baseFont.getWidthPoint(text, (float)size);
        float textBase = this.document.top() + 24.0f;
        float position = (this.document.left() + this.document.right() - textSize) / 2.0f;
        cb.setTextMatrix(position, textBase);
        cb.showText(text);
        cb.endText();
    }

    protected void addSelections(PdfContentByte cb) {
        String skip = this.extractFromSelections(SKIP_FRONTPAGE);
        if (skip != null && Boolean.valueOf(skip).booleanValue()) {
            return;
        }
        String ap1Description = "";
        String ap2Description = "";
        String ap3Description = "";
        cb.beginText();
        int size = 12;
        cb.setFontAndSize(this.baseFont, (float)size);
        float position = this.document.left() + 150.0f;
        float textBase = this.document.top() - 70.0f;
        for (int i = 0; i < this.selections.length; ++i) {
            int l;
            String[] lines2;
            if (this.selections[i][0] == null || this.selections[i][0].equals("Password") || this.selections[i][0].equals("System") || this.selections[i][0].equals("operationArea") || this.selections[i][0].equals("dataLib") || this.selections[i][0].equals("BookYear") || this.selections[i][0].equals("Environment") || this.selections[i][0].equals("governmentActivated") || (AssetSelection.ASSETSELECTION + "2").equals(this.selections[i][0])) continue;
            if (AssetSelection.ASSETSELECTION.equals(this.selections[i][0])) {
                cb.setTextMatrix(position, textBase -= 20.0f);
                cb.showText(LanguageHelper.getString("nl.ibs.fac.language", "SelectSort") + ":");
                try {
                    lines2 = new AssetSelection(this.selections[i][1]).toString(this.fisHelper, this.fmsHelper).split("\n");
                    for (l = 0; l < lines2.length; ++l) {
                        if (lines2[l].trim().length() <= 0 || lines2[l].startsWith("Hoofdact.:") || lines2[l].startsWith("Incl. gedesinv.:")) continue;
                        cb.setTextMatrix(position + 150.0f, textBase);
                        cb.showText(lines2[l]);
                        textBase -= 20.0f;
                    }
                    textBase += 20.0f;
                }
                catch (Exception lines2) {}
                continue;
            }
            if (IncomingFinancialTransactionSelection.IFTSELECTION.equals(this.selections[i][0])) {
                cb.setTextMatrix(position, textBase -= 20.0f);
                cb.showText(LanguageHelper.getString("nl.ibs.fac.language", "SelectSort") + ":");
                try {
                    lines2 = new IncomingFinancialTransactionSelection(this.selections[i][1]).toString(this.fisHelper, this.fmsHelper).split("\n");
                    for (l = 0; l < lines2.length; ++l) {
                        if (lines2[l].trim().length() <= 0) continue;
                        cb.setTextMatrix(position + 150.0f, textBase);
                        cb.showText(lines2[l]);
                        textBase -= 20.0f;
                    }
                    textBase += 20.0f;
                }
                catch (Exception lines3) {}
                continue;
            }
            if ("facLib".equals(this.selections[i][0])) {
                try {
                    Environment environment = (Environment)EnvironmentBO.get(this.selections[i][1])[0];
                    if (environment != null) {
                        ap1Description = environment.getAPName1();
                        ap2Description = environment.getAPName2();
                        ap3Description = environment.getAPName3();
                    }
                }
                catch (Exception environment) {
                    // empty catch block
                }
            }
            if ("AccountingPrinciple".equals(this.selections[i][0])) {
                String apDescription = "";
                if ("1".equals(this.selections[i][1])) {
                    apDescription = ap1Description;
                } else if ("2".equals(this.selections[i][1])) {
                    apDescription = ap2Description;
                } else if ("3".equals(this.selections[i][1])) {
                    apDescription = ap3Description;
                } else if ("9".equals(this.selections[i][1])) {
                    apDescription = ap1Description + " + " + ap3Description;
                }
                cb.setTextMatrix(position, textBase -= 20.0f);
                cb.showText(LanguageHelper.getString("nl.ibs.fac.language", this.selections[i][0]));
                cb.setTextMatrix(position + 150.0f, textBase);
                cb.showText(apDescription);
                continue;
            }
            if ("PeriodType".equals(this.selections[i][0])) {
                String periodType = "";
                if ("B".equals(this.selections[i][1])) {
                    periodType = LanguageHelper.getString("nl.ibs.fac.language", "BookYear");
                } else if ("P".equals(this.selections[i][1])) {
                    periodType = LanguageHelper.getString("nl.ibs.fac.language", "Period");
                }
                cb.setTextMatrix(position, textBase -= 20.0f);
                cb.showText(LanguageHelper.getString("nl.ibs.fac.language", this.selections[i][0]));
                cb.setTextMatrix(position + 150.0f, textBase);
                cb.showText(periodType);
                continue;
            }
            cb.setTextMatrix(position, textBase -= 20.0f);
            cb.showText(LanguageHelper.getString("nl.ibs.fac.language", this.selections[i][0]));
            cb.setTextMatrix(position + 150.0f, textBase);
            if (this.selections[i][1] == null) continue;
            if (Boolean.toString(true).equals(this.selections[i][1]) || Boolean.toString(false).equals(this.selections[i][1])) {
                cb.showText(LanguageHelper.getString("nl.ibs.fac.language", this.selections[i][1]));
                continue;
            }
            cb.showText(this.selections[i][1]);
        }
        cb.endText();
    }

    public void onEndPage(PdfWriter writer, Document document) {
        PdfContentByte cb = writer.getDirectContent();
        cb.saveState();
        String text = LanguageHelper.getString("nl.ibs.fac.language", "Page") + " " + writer.getPageNumber() + " " + LanguageHelper.getString("nl.ibs.fac.language", "of") + " ";
        int size = 12;
        float textSize = this.baseFont.getWidthPoint(text, (float)size);
        float textBase = document.bottom() - 20.0f;
        cb.beginText();
        cb.setFontAndSize(this.baseFont, (float)size);
        float position = (document.left() + document.right() - textSize) / 2.0f;
        cb.setTextMatrix(position, textBase);
        cb.showText(text);
        cb.endText();
        cb.addTemplate(this.tpl, position + textSize, textBase);
        cb.restoreState();
    }

    public void onCloseDocument(PdfWriter writer, Document document) {
        this.tpl.beginText();
        this.tpl.setFontAndSize(this.baseFont, 12.0f);
        this.tpl.setTextMatrix(0.0f, 0.0f);
        this.tpl.showText("" + (writer.getPageNumber() - 1));
        this.tpl.endText();
    }

    protected String getFinDimDescription(String id, int index) throws Exception {
        String description = "";
        if (this.fmsHelper != null) {
            NameValuePair pair = this.fmsHelper.getNameValuePair(id, index);
            if (pair != null) {
                description = pair.getValue();
            }
        } else if (this.fisHelper != null) {
            description = this.fisHelper.getDescription(id, this.companyId, this.bookYear, index);
        }
        return description;
    }

    private class TableEvent
    implements PdfPTableEvent {
        private TableEvent() {
        }

        public void tableLayout(PdfPTable table, float[][] width, float[] heights, int headerRows, int rowStart, PdfContentByte[] canvases) {
            float[] widths = width[0];
            PdfContentByte cb = canvases[3];
            cb.saveState();
            cb.rectangle(widths[0], heights[heights.length - 1], widths[widths.length - 1] - widths[0], heights[0] - heights[heights.length - 1]);
            cb.stroke();
            cb.restoreState();
        }
    }
}

