/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.reports;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import nl.ibs.fac.CalculationValue;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.bp.ProofDepreciationBP;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.Transaction;

public abstract class ProofDepreciationReportHelper {
    private static final BigDecimal ZERO = new BigDecimal(0.0);
    private static final String SEPARATOR = "/~/";

    public static HashMap addAmountsFromTransactions(HashMap amounts, Asset asset, int accountingPrinciple, int bookYearFrom, int numberOfYears, String periodType) throws Exception {
        Iterator transactions = TransactionBO.getBeforeOrEquals(asset, bookYearFrom + (numberOfYears - 1), 99, accountingPrinciple, true, true).iterator();
        Transaction transaction = null;
        int year = 0;
        int per = 0;
        while (transactions.hasNext()) {
            transaction = (Transaction)transactions.next();
            if (transaction.getState() != 1) continue;
            year = transaction.getBookYearForJournalization();
            per = transaction.getPeriodForJournalization();
            switch (transaction.getMainTransactionType()) {
                case 1: {
                    amounts = ProofDepreciationReportHelper.addAmount(amounts, asset, "INV", year, per, bookYearFrom, periodType, transaction.getAmount1());
                    amounts = ProofDepreciationReportHelper.addAmount(amounts, asset, "DEB", year, per, bookYearFrom, periodType, transaction.getAmount2());
                    break;
                }
                case 2: {
                    amounts = ProofDepreciationReportHelper.addAmount(amounts, asset, "INV", year, per, bookYearFrom, periodType, transaction.getAmount1());
                    amounts = ProofDepreciationReportHelper.addAmount(amounts, asset, "DEB", year, per, bookYearFrom, periodType, transaction.getAmount2());
                    break;
                }
                case 3: {
                    amounts = ProofDepreciationReportHelper.addAmount(amounts, asset, "DEP", year, per, bookYearFrom, periodType, transaction.getAmount2());
                    amounts = ProofDepreciationReportHelper.addAmount(amounts, asset, "INT", year, per, bookYearFrom, periodType, transaction.getAmount3());
                }
            }
        }
        return amounts;
    }

    public static HashMap addAmountsFromProofDepreciation(HashMap amounts, ProofDepreciationBP proofDepreciationBP, Asset asset, int accountingPrinciple, int bookYearFrom, int numberOfYears, int numberOfPeriods, String periodType) throws Exception {
        int yearTo = bookYearFrom + (numberOfYears - 1);
        int periodTo = numberOfPeriods;
        CalculationValue value2 = null;
        for (CalculationValue value2 : proofDepreciationBP.calculate(asset, accountingPrinciple, yearTo, periodTo)) {
            if (!value2.isDepreciationBeyondEconomicLife()) {
                amounts = ProofDepreciationReportHelper.addAmount(amounts, value2.getAsset(), "DEP", value2.getYear(), value2.getPeriod(), bookYearFrom, periodType, value2.getDepreciationAmount());
            }
            amounts = ProofDepreciationReportHelper.addAmount(amounts, value2.getAsset(), "INT", value2.getYear(), value2.getPeriod(), bookYearFrom, periodType, value2.getInterestAmount());
        }
        return amounts;
    }

    private static HashMap addAmount(HashMap amounts, Asset currentAsset, String key, int bookYear, int period, int bookYearFrom, String periodType, BigDecimal amount) throws Exception {
        BigDecimal value;
        if (amount == null || amount.doubleValue() == 0.0) {
            return amounts;
        }
        key = currentAsset.getId() + SEPARATOR + key;
        if (bookYear < bookYearFrom) {
            bookYear = bookYearFrom - 1;
            period = 0;
        }
        if ((value = (BigDecimal)amounts.get(key = periodType.equals("B") ? key + String.valueOf(bookYear) : key + PeriodHelper.toString(bookYear, period))) == null) {
            value = amount;
            amounts.put(key, value);
        } else {
            value = value.add(amount);
            amounts.put(key, value);
        }
        return amounts;
    }

    public static BigDecimal getAmount(HashMap amounts, Asset currentAsset, String key, int bookYear, int period, int bookYearFrom, String periodType) throws Exception {
        key = currentAsset.getId() + SEPARATOR + key;
        if (bookYear < bookYearFrom) {
            bookYear = bookYearFrom - 1;
            period = 0;
        }
        key = periodType.equals("B") ? key + String.valueOf(bookYear) : key + PeriodHelper.toString(bookYear, period);
        BigDecimal value = (BigDecimal)amounts.get(key);
        return value == null ? ZERO : value;
    }
}

