/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.reports;

import java.io.FileOutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import nl.ibs.fac.BatchJobHelper;
import nl.ibs.fac.IBSDecimal;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.ReportFileHelper;
import nl.ibs.fac.boadapters.AnalysisGroupBO;
import nl.ibs.fac.boadapters.AssetTypeBO;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.CompanyAccountingPrincipleDefaultBO;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.EnvironmentBO;
import nl.ibs.fac.boadapters.ValuationMainAccountBO;
import nl.ibs.fac.bp.ProofDepreciationBP;
import nl.ibs.fac.db.AnalysisGroup;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.AssetAnalysisCode;
import nl.ibs.fac.db.AssetType;
import nl.ibs.fac.db.AssetValue;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.CompanyAccountingPrincipleDefault;
import nl.ibs.fac.db.Credit;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.db.ValuationMainAccount;
import nl.ibs.fac.fis.FISHelper;
import nl.ibs.fac.fms.FMSHelper;
import nl.ibs.fac.gov.bp.CreditDepreciationBP;
import nl.ibs.fac.gov.reports.AdditionalJournalingDataHelper;
import nl.ibs.fac.gov.reports.CreditProofDepreciationReportHelper;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.reports.CSVHelper;
import nl.ibs.fac.reports.ProofDepreciationReportHelper;
import nl.ibs.fac.ui.AssetSelection;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;
import nl.ibs.util.Stopwatch;

public class ProofDepreciationToCSV
extends CSVHelper {
    public static final String CLASSNAME = ProofDepreciationToCSV.class.getName();
    private static final String FILENAME = "ProofDepreciationReport";
    private int theAccountingPrinciple;
    private int accountingPrinciple;
    private int bookYearFrom = 0;
    private int numberOfYears = 0;
    private int numberOfPeriods = 0;
    private int numberOfColumns;
    private String[] variablePeriodNames = null;
    private String periodType = null;
    private Asset asset = null;
    private Credit theCredit;
    private ProofDepreciationBP proofDepreciationBP = null;
    private CreditDepreciationBP creditDepreciationBP = null;
    private HashMap amounts = null;
    private BigDecimal[] creditAmounts;
    private boolean includeDisinvested;
    private boolean governmentActivated;
    private Company company;
    private AdditionalJournalingDataHelper ajdHelper;
    private ValuationMainAccount vma;
    private String[] idAndDescription;
    private boolean finDimd1Description = false;
    private boolean finDimd2Description = false;
    private boolean finDimd3Description = false;
    private boolean finDimd4Description = false;
    private boolean finDimd5Description = false;
    private boolean typeDescription = false;
    private boolean assetDescription = false;
    private static int maxSeqNbr;
    private boolean interest;

    public ProofDepreciationToCSV(String[][] selections, Collection collection, String[][] labels, FMSHelper fmsHelper, FISHelper fisHelper, Company company, String periodType, int bookYearFrom, int numberOfYears, boolean finDimd1Description, boolean finDimd2Description, boolean finDimd3Description, boolean finDimd4Description, boolean finDimd5Description, boolean typeDescription, boolean assetDescription, boolean interest) throws Exception {
        super(selections, collection, labels, fmsHelper, fisHelper);
        if (company.getNumberOfPeriods() != -1) {
            this.numberOfPeriods = company.getNumberOfPeriods();
        } else {
            Company dataSet = company.getDataSet();
            this.numberOfPeriods = dataSet.getNumberOfPeriods();
        }
        this.company = company;
        this.proofDepreciationBP = new ProofDepreciationBP(company, this.numberOfPeriods);
        this.creditDepreciationBP = new CreditDepreciationBP(company, this.numberOfPeriods);
        this.numberOfColumns = labels[0].length;
        this.theAccountingPrinciple = Integer.parseInt(this.extractFromSelections("AccountingPrinciple", selections));
        this.accountingPrinciple = Integer.parseInt(this.extractFromSelections("AccountingPrinciple", selections));
        this.periodType = periodType;
        this.bookYearFrom = bookYearFrom;
        this.numberOfYears = numberOfYears;
        this.variablePeriodNames = new String[periodType.equals("B") ? numberOfYears : numberOfYears * this.numberOfPeriods];
        int vpn = 0;
        for (int i = 0; i < numberOfYears; ++i) {
            if (periodType.equals("B")) {
                this.variablePeriodNames[vpn++] = String.valueOf(bookYearFrom + i);
                continue;
            }
            for (int p = 1; p <= this.numberOfPeriods; ++p) {
                this.variablePeriodNames[vpn++] = PeriodHelper.toString(bookYearFrom + i, p);
            }
        }
        this.finDimd1Description = finDimd1Description;
        this.finDimd2Description = finDimd2Description;
        this.finDimd3Description = finDimd3Description;
        this.finDimd4Description = finDimd4Description;
        this.finDimd5Description = finDimd5Description;
        this.typeDescription = typeDescription;
        this.assetDescription = assetDescription;
        this.interest = interest;
    }

    public void setIncludeDisinvested(boolean includeDisinvested) {
        this.includeDisinvested = includeDisinvested;
    }

    public void setGovernmentActivated(boolean governmentActivated) throws Exception {
        this.governmentActivated = governmentActivated;
        if (governmentActivated) {
            this.ajdHelper = new AdditionalJournalingDataHelper(this.company, this.bookYearFrom, this.fmsHelper);
        }
    }

    @Override
    protected String[] getRowValues(Object object) throws Exception {
        if (object instanceof Credit) {
            this.theCredit = (Credit)object;
            if (this.theAccountingPrinciple == 9) {
                this.accountingPrinciple = 3;
            }
            return this.getCreditPrintAttributes();
        }
        this.asset = (Asset)object;
        if (this.theAccountingPrinciple == 9) {
            this.accountingPrinciple = 1;
        }
        this.amounts = new HashMap();
        this.amounts = ProofDepreciationReportHelper.addAmountsFromTransactions(this.amounts, this.asset, this.accountingPrinciple, this.bookYearFrom, this.numberOfYears, this.periodType);
        this.amounts = ProofDepreciationReportHelper.addAmountsFromProofDepreciation(this.amounts, this.proofDepreciationBP, this.asset, this.accountingPrinciple, this.bookYearFrom, this.numberOfYears, this.numberOfPeriods, this.periodType);
        return this.getPrintAttributes(this.amounts);
    }

    private String[] getPrintAttributes(HashMap amounts) throws Exception {
        int i;
        if (this.asset.getDisinvestmentYear() > 0 && this.asset.getDisinvestmentYear() < this.bookYearFrom) {
            return null;
        }
        BigDecimal invBegin = ProofDepreciationReportHelper.getAmount(amounts, this.asset, "INV", this.bookYearFrom - 1, 0, this.bookYearFrom, this.periodType);
        BigDecimal depBegin = ProofDepreciationReportHelper.getAmount(amounts, this.asset, "DEP", this.bookYearFrom - 1, 0, this.bookYearFrom, this.periodType);
        depBegin = depBegin.add(ProofDepreciationReportHelper.getAmount(amounts, this.asset, "DEB", this.bookYearFrom - 1, 0, this.bookYearFrom, this.periodType));
        BigDecimal invCurr = null;
        BigDecimal depCurr = null;
        BigDecimal debCurr = null;
        BigDecimal intCurr = null;
        BigDecimal invEnd = invBegin;
        BigDecimal depEnd = depBegin;
        int v = 0;
        int year = 0;
        int period = 0;
        String[] attr = new String[this.numberOfColumns];
        if (this.fisHelper == null) {
            attr[v++] = this.asset.getCompanyId();
        } else {
            attr[v++] = FISHelper.getCompanyId(this.asset.getCompanyId());
            if (!FISHelper.getBrancheId(this.asset.getCompanyId()).equals("000")) {
                attr[v++] = FISHelper.getBrancheId(this.asset.getCompanyId());
            }
        }
        attr[v++] = this.asset.getParentId() == null ? this.asset.getId() : this.asset.getParentId();
        String string = attr[v++] = this.asset.getParentId() == null ? "" : this.asset.getId();
        if (this.assetDescription) {
            attr[v++] = this.asset.getDescription();
        }
        attr[v++] = this.asset.getTypeId();
        if (this.typeDescription) {
            attr[v++] = ((AssetType)AssetTypeBO.get(this.asset.getDBData(), this.asset.getCompanyId(), this.asset.getTypeId())[0]).getDescription();
        }
        attr[v++] = this.asset.getFinDimId1();
        if (this.finDimd1Description) {
            attr[v++] = this.asset.getFinDimId1().length() == 0 ? "" : (this.fisHelper != null ? this.fisHelper.getDescription(this.asset.getFinDimId1(), this.asset.getCompanyId(), "" + this.bookYearFrom, 1) : this.fmsHelper.getDescription(this.asset.getFinDimId1(), 1));
        }
        attr[v++] = this.asset.getFinDimId2();
        if (this.finDimd2Description) {
            attr[v++] = this.asset.getFinDimId2().length() == 0 ? "" : (this.fisHelper != null ? this.fisHelper.getDescription(this.asset.getFinDimId2(), this.asset.getCompanyId(), "" + this.bookYearFrom, 2) : this.fmsHelper.getDescription(this.asset.getFinDimId2(), 2));
        }
        attr[v++] = this.asset.getFinDimId3();
        if (this.finDimd3Description) {
            attr[v++] = this.asset.getFinDimId3().length() == 0 ? "" : (this.fisHelper != null ? this.fisHelper.getDescription(this.asset.getFinDimId3(), this.asset.getCompanyId(), "" + this.bookYearFrom, 3) : this.fmsHelper.getDescription(this.asset.getFinDimId3(), 3));
        }
        attr[v++] = this.asset.getFinDimId4();
        if (this.finDimd4Description) {
            attr[v++] = this.asset.getFinDimId4().length() == 0 ? "" : (this.fisHelper != null ? this.fisHelper.getDescription(this.asset.getFinDimId4(), this.asset.getCompanyId(), "" + this.bookYearFrom, 4) : this.fmsHelper.getDescription(this.asset.getFinDimId4(), 4));
        }
        attr[v++] = this.asset.getFinDimId5();
        if (this.finDimd5Description) {
            if (this.asset.getFinDimId5().length() == 0) {
                attr[v++] = "";
            } else if (this.fisHelper != null) {
                attr[v++] = this.fisHelper.getDescription(this.asset.getFinDimId5(), this.asset.getCompanyId(), "" + this.bookYearFrom, 5);
            }
        }
        for (i = v; i < v + maxSeqNbr; ++i) {
            attr[i] = "";
        }
        i = v - 1;
        Collection assetAnalysisCodes = this.asset.getAssetAnalysisCodeCollection(null);
        for (AssetAnalysisCode assetAnalysisCode : assetAnalysisCodes) {
            attr[i + assetAnalysisCode.getSeqNr()] = "" + assetAnalysisCode.getCode();
        }
        Collection assetValues = this.asset.getAssetValueCollection(null);
        for (AssetValue assetValue : assetValues) {
            attr[i + assetValue.getSeqNr()] = "" + assetValue.getValue();
        }
        v += maxSeqNbr;
        attr[v++] = IBSDecimal.format(invBegin, true);
        attr[v++] = IBSDecimal.format(depBegin, true);
        attr[v++] = IBSDecimal.format(invBegin.subtract(depBegin), true);
        for (i = 0; i < this.variablePeriodNames.length; ++i) {
            if (this.periodType.equals("B")) {
                year = Integer.parseInt(this.variablePeriodNames[i]);
                period = 0;
            } else {
                year = Integer.parseInt(this.variablePeriodNames[i].substring(0, 4));
                period = Integer.parseInt(this.variablePeriodNames[i].substring(5));
            }
            invCurr = ProofDepreciationReportHelper.getAmount(amounts, this.asset, "INV", year, period, this.bookYearFrom, this.periodType);
            depCurr = ProofDepreciationReportHelper.getAmount(amounts, this.asset, "DEP", year, period, this.bookYearFrom, this.periodType);
            debCurr = ProofDepreciationReportHelper.getAmount(amounts, this.asset, "DEB", year, period, this.bookYearFrom, this.periodType);
            intCurr = ProofDepreciationReportHelper.getAmount(amounts, this.asset, "INT", year, period, this.bookYearFrom, this.periodType);
            invEnd = invEnd.add(invCurr);
            depEnd = depEnd.add(depCurr);
            depEnd = depEnd.add(debCurr);
            attr[v++] = IBSDecimal.format(depCurr, true);
            if (!this.interest) continue;
            attr[v++] = IBSDecimal.format(intCurr, true);
        }
        attr[v++] = IBSDecimal.format(invEnd, true);
        attr[v++] = IBSDecimal.format(depEnd, true);
        attr[v++] = IBSDecimal.format(invEnd.subtract(depEnd), true);
        if (this.governmentActivated) {
            this.vma = ValuationMainAccountBO.getValuationMainAccountToUse(this.company.getDBData(), this.company.getId(), "A", this.asset.getId(), this.accountingPrinciple, this.bookYearFrom + this.numberOfYears, 1);
            if (this.vma != null) {
                this.idAndDescription = new String[2];
                this.idAndDescription[0] = this.vma.getMainAccountId3();
                this.idAndDescription[1] = this.fmsHelper.getDescription(this.idAndDescription[0], 0);
            } else {
                this.idAndDescription = this.ajdHelper.getIdAndDescription(this.asset.getTypeId(), this.accountingPrinciple, 30, 0);
            }
            attr[v++] = this.idAndDescription[0];
            attr[v++] = this.idAndDescription[1];
            this.idAndDescription = this.ajdHelper.getIdAndDescription(this.asset.getTypeId(), this.accountingPrinciple, 30, 1);
            attr[v++] = this.idAndDescription[0];
            attr[v++] = this.idAndDescription[1];
            if (this.vma != null) {
                this.idAndDescription = new String[2];
                this.idAndDescription[0] = this.vma.getMainAccountId8();
                this.idAndDescription[1] = this.fmsHelper.getDescription(this.idAndDescription[0], 0);
            } else {
                this.idAndDescription = this.ajdHelper.getIdAndDescription(this.asset.getTypeId(), this.accountingPrinciple, 80, 0);
            }
            attr[v++] = this.idAndDescription[0];
            attr[v++] = this.idAndDescription[1];
            this.idAndDescription = this.ajdHelper.getIdAndDescription(this.asset.getTypeId(), this.accountingPrinciple, 80, 1);
            attr[v++] = this.idAndDescription[0];
            attr[v++] = this.idAndDescription[1];
            attr[v++] = IBSDecimal.format(this.asset.getPayOffYearAmount(), true);
        }
        return attr;
    }

    private String[] getCreditPrintAttributes() throws Exception {
        int i;
        if (!this.includeDisinvested && this.theCredit.getState() < 2) {
            return null;
        }
        if (this.theCredit.getClosingYear() > 0 && this.theCredit.getClosingYear() < this.bookYearFrom) {
            return null;
        }
        int v = 0;
        String[] attr = new String[this.numberOfColumns];
        attr[v++] = this.theCredit.getCompanyId();
        attr[v++] = this.theCredit.getId();
        attr[v++] = "";
        if (this.assetDescription) {
            attr[v++] = this.theCredit.getDescription();
        }
        attr[v++] = this.theCredit.getProFormaTypeId();
        if (this.typeDescription) {
            attr[v++] = ((AssetType)AssetTypeBO.get(this.theCredit.getDBData(), this.theCredit.getCompanyId(), this.theCredit.getProFormaTypeId())[0]).getDescription();
        }
        attr[v++] = this.theCredit.getFinDimId1();
        if (this.finDimd1Description) {
            attr[v++] = this.theCredit.getFinDimId1().length() == 0 ? "" : (this.fisHelper != null ? this.fisHelper.getDescription(this.theCredit.getFinDimId1(), this.theCredit.getCompanyId(), "" + this.bookYearFrom, 1) : this.fmsHelper.getDescription(this.theCredit.getFinDimId1(), 1));
        }
        attr[v++] = this.theCredit.getFinDimId2();
        if (this.finDimd2Description) {
            attr[v++] = this.theCredit.getFinDimId2().length() == 0 ? "" : (this.fisHelper != null ? this.fisHelper.getDescription(this.theCredit.getFinDimId2(), this.theCredit.getCompanyId(), "" + this.bookYearFrom, 2) : this.fmsHelper.getDescription(this.theCredit.getFinDimId2(), 2));
        }
        attr[v++] = this.theCredit.getFinDimId3();
        if (this.finDimd3Description) {
            attr[v++] = this.theCredit.getFinDimId3().length() == 0 ? "" : (this.fisHelper != null ? this.fisHelper.getDescription(this.theCredit.getFinDimId3(), this.theCredit.getCompanyId(), "" + this.bookYearFrom, 3) : this.fmsHelper.getDescription(this.theCredit.getFinDimId3(), 3));
        }
        attr[v++] = this.theCredit.getFinDimId4();
        if (this.finDimd4Description) {
            attr[v++] = this.theCredit.getFinDimId4().length() == 0 ? "" : (this.fisHelper != null ? this.fisHelper.getDescription(this.theCredit.getFinDimId4(), this.theCredit.getCompanyId(), "" + this.bookYearFrom, 4) : this.fmsHelper.getDescription(this.theCredit.getFinDimId4(), 4));
        }
        attr[v++] = "";
        for (i = v; i < v + maxSeqNbr; ++i) {
            attr[i] = "";
        }
        i = v - 1;
        if (this.theCredit.getDimValue1().trim().length() > 0) {
            attr[i + this.company.getSeqNr1().intValue()] = this.theCredit.getDimValue1();
        }
        if (this.theCredit.getDimValue2().trim().length() > 0) {
            attr[i + this.company.getSeqNr2().intValue()] = this.theCredit.getDimValue2();
        }
        if (this.theCredit.getDimValue3().trim().length() > 0) {
            attr[i + this.company.getSeqNr3().intValue()] = this.theCredit.getDimValue3();
        }
        if (this.theCredit.getDimValue4().trim().length() > 0) {
            attr[i + this.company.getSeqNr4().intValue()] = this.theCredit.getDimValue4();
        }
        if (this.theCredit.getDimValue5().trim().length() > 0) {
            attr[i + this.company.getSeqNr5().intValue()] = this.theCredit.getDimValue5();
        }
        if (this.theCredit.getDimValue6().trim().length() > 0) {
            attr[i + this.company.getSeqNr6().intValue()] = this.theCredit.getDimValue6();
        }
        v += maxSeqNbr;
        this.creditAmounts = CreditProofDepreciationReportHelper.retrieveAmounts(this.creditDepreciationBP, this.theCredit, this.bookYearFrom, this.numberOfYears);
        attr[v++] = IBSDecimal.format(this.creditAmounts[0], true);
        attr[v++] = IBSDecimal.format(this.creditAmounts[1], true);
        attr[v++] = IBSDecimal.format(this.creditAmounts[0].subtract(this.creditAmounts[1]), true);
        for (i = 0; i < this.variablePeriodNames.length; ++i) {
            attr[v++] = IBSDecimal.format(this.creditAmounts[i * 2 + 2], true);
            if (!this.interest) continue;
            attr[v++] = IBSDecimal.format(this.creditAmounts[i * 2 + 3], true);
        }
        attr[v++] = IBSDecimal.format(this.creditAmounts[this.variablePeriodNames.length * 2 + 2], true);
        attr[v++] = IBSDecimal.format(this.creditAmounts[this.variablePeriodNames.length * 2 + 3], true);
        attr[v++] = IBSDecimal.format(this.creditAmounts[this.variablePeriodNames.length * 2 + 2].subtract(this.creditAmounts[this.variablePeriodNames.length * 2 + 3]), true);
        this.vma = ValuationMainAccountBO.getValuationMainAccountToUse(this.company.getDBData(), this.company.getId(), "C", this.theCredit.getId(), this.accountingPrinciple, this.bookYearFrom + this.numberOfYears, 1);
        if (this.vma != null) {
            attr[v++] = this.vma.getMainAccountId3();
            attr[v++] = this.fmsHelper.getDescription(this.vma.getMainAccountId3(), 0);
        } else {
            attr[v++] = "";
            attr[v++] = "";
        }
        if (this.theCredit.getProFormaTypeId().trim().length() > 0) {
            this.idAndDescription = this.ajdHelper.getIdAndDescription(this.theCredit.getProFormaTypeId(), 1, 30, 1);
            attr[v++] = this.idAndDescription[0];
            attr[v++] = this.idAndDescription[1];
        } else {
            attr[v++] = "";
            attr[v++] = "";
        }
        if (this.vma != null) {
            attr[v++] = this.vma.getMainAccountId8();
            attr[v++] = this.fmsHelper.getDescription(this.vma.getMainAccountId8(), 0);
        } else {
            attr[v++] = "";
            attr[v++] = "";
        }
        if (this.theCredit.getProFormaTypeId().trim().length() > 0) {
            this.idAndDescription = this.ajdHelper.getIdAndDescription(this.theCredit.getProFormaTypeId(), 1, 80, 1);
            attr[v++] = this.idAndDescription[0];
            attr[v++] = this.idAndDescription[1];
        } else {
            attr[v++] = "";
            attr[v++] = "";
        }
        while (v < attr.length) {
            attr[v] = "";
            ++v;
        }
        return attr;
    }

    private static String[][] createLabels(Map map, String periodType, int bookYearFrom, int numberOfYears, int numberOfPeriods, boolean governmentActivated, boolean finDimd1Description, boolean finDimd2Description, boolean finDimd3Description, boolean finDimd4Description, boolean finDimd5Description, boolean typeDescription, boolean assetDesciption, boolean interest, FISHelper fisHelper, String companyId) throws Exception {
        String[][] labels = new String[][]{new String[0]};
        String balanceBegin = LanguageHelper.getString("nl.ibs.fac.language", "BalanceBegin");
        String balanceEnd = LanguageHelper.getString("nl.ibs.fac.language", "BalanceEnd");
        String invest = LanguageHelper.getString("nl.ibs.fac.language", "Investment");
        String deprec = LanguageHelper.getString("nl.ibs.fac.language", "Depreciation");
        String intrst = LanguageHelper.getString("nl.ibs.fac.language", "Interest");
        String bookVal = LanguageHelper.getString("nl.ibs.fac.language", "BookValue");
        String name = null;
        ArrayList<String> _labels = new ArrayList<String>();
        _labels.add(LanguageHelper.getString("nl.ibs.fac.language", "Company"));
        if (fisHelper != null & !FISHelper.getBrancheId(companyId).equals("000")) {
            _labels.add(LanguageHelper.getString("nl.ibs.fac.language", "Branche"));
        }
        _labels.add(LanguageHelper.getString("nl.ibs.fac.language", "Id"));
        _labels.add(LanguageHelper.getString("nl.ibs.fac.language", "SubId"));
        if (assetDesciption) {
            _labels.add(LanguageHelper.getString("nl.ibs.fac.language", "Description"));
        }
        _labels.add("Type");
        if (typeDescription) {
            _labels.add(LanguageHelper.getString("nl.ibs.fac.language", "Description"));
        }
        Environment environment = (Environment)EnvironmentBO.get((String)map.get("facLib"))[0];
        _labels.add(environment.getShortName1());
        if (finDimd1Description) {
            _labels.add(LanguageHelper.getString("nl.ibs.fac.language", "Description"));
        }
        _labels.add(environment.getShortName2());
        if (finDimd2Description) {
            _labels.add(LanguageHelper.getString("nl.ibs.fac.language", "Description"));
        }
        _labels.add(environment.getShortName3());
        if (finDimd3Description) {
            _labels.add(LanguageHelper.getString("nl.ibs.fac.language", "Description"));
        }
        _labels.add(environment.getShortName4());
        if (finDimd4Description) {
            _labels.add(LanguageHelper.getString("nl.ibs.fac.language", "Description"));
        }
        _labels.add(environment.getShortName5());
        if (finDimd5Description) {
            _labels.add(LanguageHelper.getString("nl.ibs.fac.language", "Description"));
        }
        Collection analysisGroups = AnalysisGroupBO.getAnalysisGroups(map);
        Iterator agi1 = analysisGroups.iterator();
        maxSeqNbr = 0;
        while (agi1.hasNext()) {
            AnalysisGroup analysisGroup = (AnalysisGroup)agi1.next();
            if (analysisGroup.getSeqNr() <= maxSeqNbr) continue;
            maxSeqNbr = analysisGroup.getSeqNr();
        }
        if (maxSeqNbr > 0) {
            String[] facdim_labels = new String[maxSeqNbr];
            for (AnalysisGroup analysisGroup : analysisGroups) {
                facdim_labels[analysisGroup.getSeqNr() - 1] = analysisGroup.getShortName();
            }
            for (int i = 0; i < maxSeqNbr; ++i) {
                _labels.add(facdim_labels[i]);
            }
        }
        _labels.add(balanceBegin + " " + invest);
        _labels.add(balanceBegin + " " + deprec);
        _labels.add(balanceBegin + " " + bookVal);
        for (int i = 0; i < numberOfYears; ++i) {
            if (periodType.equals("B")) {
                name = String.valueOf(bookYearFrom + i);
                _labels.add(deprec + " " + name);
                if (!interest) continue;
                _labels.add(intrst + " " + name);
                continue;
            }
            for (int p = 1; p <= numberOfPeriods; ++p) {
                name = PeriodHelper.toString(bookYearFrom + i, p);
                _labels.add(deprec + " " + name);
                if (!interest) continue;
                _labels.add(intrst + " " + name);
            }
        }
        _labels.add(balanceEnd + " " + invest);
        _labels.add(balanceEnd + " " + deprec);
        _labels.add(balanceEnd + " " + bookVal);
        if (governmentActivated) {
            _labels.add("Id");
            _labels.add("Afschr.kosten");
            _labels.add("Id");
            _labels.add("Categorie");
            _labels.add("Id");
            _labels.add("Rentekosten");
            _labels.add("Id");
            _labels.add("Categorie");
            _labels.add("PayOffYearAmount");
        }
        int s = _labels.size();
        labels[0] = new String[s];
        for (int i = 0; i < s; ++i) {
            labels[0][i] = (String)_labels.get(i);
        }
        return labels;
    }

    public static void main(String[] args) {
        Stopwatch sw = null;
        if (Log.debug()) {
            sw = new Stopwatch();
            sw.start();
        }
        try {
            ProofDepreciationToCSV.execute(args);
        }
        catch (Exception e) {
            Log.error((Exception)e);
            System.exit(-1);
        }
        if (sw != null) {
            Log.debug((String)("Elapsed time: " + sw.stop(1) + " seconds"));
        }
        System.exit(0);
    }

    public static void execute(String[] args) throws Exception {
        String bookYear;
        String companyId;
        String[][] selections;
        Map map;
        LoginHelper loginHelper;
        String message;
        if (Log.debug() && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                Log.debug((String)args[i]);
            }
        }
        if ((message = (loginHelper = BatchJobHelper.getLoginHelper(map = BatchJobHelper.getSelections(selections = BatchJobHelper.getSelections(args)))).login()) != null) {
            message = LanguageHelper.getString("nl.ibs.fac.language", message);
            Log.error((String)message);
            return;
        }
        Environment environment = (Environment)EnvironmentBO.get((String)map.get("facLib"))[0];
        message = loginHelper.login(environment, companyId = (String)map.get("Company"), bookYear = (String)map.get("BookYear"));
        if (message != null && message.trim().length() > 0) {
            message = LanguageHelper.getString("nl.ibs.fac.language", message);
            Log.error((String)message);
            return;
        }
        FMSHelper fmsHelper = null;
        FISHelper fisHelper = null;
        if (environment.getOperationArea().trim().length() > 0) {
            fmsHelper = new FMSHelper(loginHelper);
        } else {
            fisHelper = new FISHelper(loginHelper);
        }
        DBData dbData = BOAdapter.getDBData(map);
        int accountingPrinciple = Integer.parseInt((String)map.get("AccountingPrinciple"));
        CompanyAccountingPrincipleDefault capd = (CompanyAccountingPrincipleDefault)CompanyAccountingPrincipleDefaultBO.get(dbData, companyId, accountingPrinciple)[0];
        boolean interest = capd == null ? true : capd.getCalculateInterest();
        Company company = (Company)CompanyBO.get(dbData, companyId)[0];
        boolean governmentActivated = Boolean.valueOf((String)map.get("governmentActivated"));
        String periodType = (String)map.get("PeriodType");
        int bookYearFrom = Integer.parseInt((String)map.get("BookYearFrom"));
        int numberOfYears = Integer.parseInt((String)map.get("NumberOfYears"));
        int numberOfPeriods = company.getNumberOfPeriods();
        String assetSelectionAsString = (String)map.get(AssetSelection.ASSETSELECTION);
        String assetSelectionAsString2 = (String)map.get(AssetSelection.ASSETSELECTION + "2");
        AssetSelection assetSelection = new AssetSelection(assetSelectionAsString + assetSelectionAsString2);
        assetSelection.governmentActivated = governmentActivated;
        assetSelection.ap = Integer.parseInt((String)map.get("AccountingPrinciple"));
        boolean finDimd1Description = false;
        boolean finDimd2Description = false;
        boolean finDimd3Description = false;
        boolean finDimd4Description = false;
        boolean finDimd5Description = false;
        boolean typeDescription = false;
        boolean assetDescription = false;
        int i = 0;
        StringTokenizer st = new StringTokenizer(assetSelection.getDescription(), ",");
        while (st.hasMoreTokens()) {
            boolean value = Boolean.parseBoolean(st.nextToken());
            if (value) {
                switch (i) {
                    case 0: {
                        finDimd1Description = value;
                        break;
                    }
                    case 1: {
                        finDimd2Description = value;
                        break;
                    }
                    case 2: {
                        finDimd3Description = value;
                        break;
                    }
                    case 3: {
                        finDimd4Description = value;
                        break;
                    }
                    case 4: {
                        if (environment.getOperationArea().trim().length() > 0) {
                            typeDescription = value;
                            break;
                        }
                        finDimd5Description = value;
                        break;
                    }
                    case 5: {
                        if (environment.getOperationArea().trim().length() > 0) {
                            assetDescription = value;
                            break;
                        }
                        typeDescription = value;
                        break;
                    }
                    case 6: {
                        assetDescription = value;
                    }
                }
            }
            ++i;
        }
        assetDescription = true;
        String[][] labels = ProofDepreciationToCSV.createLabels(map, periodType, bookYearFrom, numberOfYears, numberOfPeriods, governmentActivated, finDimd1Description, finDimd2Description, finDimd3Description, finDimd4Description, finDimd5Description, typeDescription, assetDescription, interest, fisHelper, companyId);
        ProofDepreciationToCSV proofDepreciationToCSV = new ProofDepreciationToCSV(selections, assetSelection.getCollection(), labels, fmsHelper, fisHelper, company, periodType, bookYearFrom, numberOfYears, finDimd1Description, finDimd2Description, finDimd3Description, finDimd4Description, finDimd5Description, typeDescription, assetDescription, interest);
        proofDepreciationToCSV.setIncludeDisinvested(assetSelection.getIncludeDisinvested());
        proofDepreciationToCSV.setGovernmentActivated(governmentActivated);
        FileOutputStream fos = new FileOutputStream(ReportFileHelper.getFileName(args, FILENAME, "csv"));
        fos.write(proofDepreciationToCSV.createCsv());
        fos.close();
        loginHelper.logout(environment, companyId, bookYear);
        loginHelper.logout();
    }
}

