/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.reports;

import java.io.FileOutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import nl.ibs.fac.BatchJobHelper;
import nl.ibs.fac.IBSDecimal;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.ReportFileHelper;
import nl.ibs.fac.boadapters.AnalysisGroupBO;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.CompanyAccountingPrincipleDefaultBO;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.EnvironmentBO;
import nl.ibs.fac.boadapters.ValuationMainAccountBO;
import nl.ibs.fac.bp.ProofDepreciationBP;
import nl.ibs.fac.db.AnalysisGroup;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.AssetAnalysisCode;
import nl.ibs.fac.db.AssetValue;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.CompanyAccountingPrincipleDefault;
import nl.ibs.fac.db.Credit;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.db.ValuationMainAccount;
import nl.ibs.fac.fis.FISHelper;
import nl.ibs.fac.fms.FMSHelper;
import nl.ibs.fac.gov.bp.CreditDepreciationBP;
import nl.ibs.fac.gov.reports.AdditionalJournalingDataHelper;
import nl.ibs.fac.gov.reports.CreditProofDepreciationReportHelper;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.reports.CSVHelper;
import nl.ibs.fac.reports.ProofDepreciationReportHelper;
import nl.ibs.fac.ui.AssetSelection;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;
import nl.ibs.util.Stopwatch;

public class ProofDepreciationToCSVForET
extends CSVHelper {
    public static final String CLASSNAME = ProofDepreciationToCSVForET.class.getName();
    private static final String FILENAME = "ProofDepreciationReport";
    private int theAccountingPrinciple;
    private int accountingPrinciple;
    private int bookYearFrom = 0;
    private int numberOfYears = 0;
    private int numberOfPeriods = 0;
    private int numberOfColumns;
    private String[] variablePeriodNames = null;
    private Asset asset = null;
    private Credit theCredit;
    private ProofDepreciationBP proofDepreciationBP = null;
    private CreditDepreciationBP creditDepreciationBP = null;
    private HashMap amounts = null;
    private BigDecimal[] creditAmounts;
    private boolean includeDisinvested;
    private boolean governmentActivated;
    private Company company;
    private AdditionalJournalingDataHelper ajdHelper;
    private ValuationMainAccount vma;
    private String[] idAndDescription;
    private String periodType = "B";
    private static int maxSeqNbr;
    private boolean interest;

    public ProofDepreciationToCSVForET(String[][] selections, Collection collection, String[][] labels, FMSHelper fmsHelper, FISHelper fisHelper, Company company, int bookYearFrom, int numberOfYears, boolean interest) throws Exception {
        super(null, collection, labels, fmsHelper, fisHelper);
        if (company.getNumberOfPeriods() != -1) {
            this.numberOfPeriods = company.getNumberOfPeriods();
        } else {
            Company dataSet = company.getDataSet();
            this.numberOfPeriods = dataSet.getNumberOfPeriods();
        }
        this.company = company;
        this.proofDepreciationBP = new ProofDepreciationBP(company, this.numberOfPeriods);
        this.creditDepreciationBP = new CreditDepreciationBP(company, this.numberOfPeriods);
        this.numberOfColumns = labels[0].length;
        this.theAccountingPrinciple = Integer.parseInt(this.extractFromSelections("AccountingPrinciple", selections));
        this.accountingPrinciple = Integer.parseInt(this.extractFromSelections("AccountingPrinciple", selections));
        this.bookYearFrom = bookYearFrom;
        this.numberOfYears = numberOfYears;
        this.variablePeriodNames = new String[numberOfYears];
        int vpn = 0;
        for (int i = 0; i < numberOfYears; ++i) {
            this.variablePeriodNames[vpn++] = String.valueOf(bookYearFrom + i);
        }
        this.interest = interest;
    }

    public void setIncludeDisinvested(boolean includeDisinvested) {
        this.includeDisinvested = includeDisinvested;
    }

    public void setGovernmentActivated(boolean governmentActivated) throws Exception {
        this.governmentActivated = governmentActivated;
        if (governmentActivated) {
            this.ajdHelper = new AdditionalJournalingDataHelper(this.company, this.bookYearFrom, this.fmsHelper);
        }
    }

    @Override
    protected String[] getRowValues(Object object) throws Exception {
        if (object instanceof Credit) {
            this.theCredit = (Credit)object;
            if (this.theAccountingPrinciple == 9) {
                this.accountingPrinciple = 3;
            }
            this.creditAmounts = CreditProofDepreciationReportHelper.retrieveAmounts(this.creditDepreciationBP, this.theCredit, this.bookYearFrom, this.numberOfYears);
            for (int i = 0; i < this.variablePeriodNames.length; ++i) {
                String[] values;
                int year = Integer.parseInt(this.variablePeriodNames[i]);
                BigDecimal depCurr = this.creditAmounts[i * 2 + 2];
                BigDecimal intCurr = this.creditAmounts[i * 2 + 3];
                if (depCurr.doubleValue() == 0.0 && intCurr.doubleValue() == 0.0 || (values = this.getCreditPrintAttributes(depCurr, intCurr, year)) == null) continue;
                this.addRow(values);
            }
            return null;
        }
        this.asset = (Asset)object;
        if (this.theAccountingPrinciple == 9) {
            this.accountingPrinciple = 1;
        }
        this.amounts = new HashMap();
        this.amounts = ProofDepreciationReportHelper.addAmountsFromTransactions(this.amounts, this.asset, this.accountingPrinciple, this.bookYearFrom, this.numberOfYears, this.periodType);
        this.amounts = ProofDepreciationReportHelper.addAmountsFromProofDepreciation(this.amounts, this.proofDepreciationBP, this.asset, this.accountingPrinciple, this.bookYearFrom, this.numberOfYears, this.numberOfPeriods, this.periodType);
        for (int i = 0; i < this.variablePeriodNames.length; ++i) {
            String[] values;
            int year = Integer.parseInt(this.variablePeriodNames[i]);
            int period = 0;
            BigDecimal depCurr = ProofDepreciationReportHelper.getAmount(this.amounts, this.asset, "DEP", year, period, this.bookYearFrom, this.periodType);
            BigDecimal intCurr = ProofDepreciationReportHelper.getAmount(this.amounts, this.asset, "INT", year, period, this.bookYearFrom, this.periodType);
            if (depCurr.doubleValue() == 0.0 && intCurr.doubleValue() == 0.0 || (values = this.getPrintAttributes(depCurr, intCurr, year)) == null) continue;
            this.addRow(values);
        }
        return null;
    }

    private String[] getPrintAttributes(BigDecimal depCurr, BigDecimal intCurr, int year) throws Exception {
        int i;
        if (this.asset.getDisinvestmentYear() > 0 && this.asset.getDisinvestmentYear() < this.bookYearFrom) {
            return null;
        }
        int v = 0;
        String[] attr = new String[this.numberOfColumns];
        if (this.fisHelper == null) {
            attr[v++] = this.asset.getCompanyId();
        } else {
            attr[v++] = FISHelper.getCompanyId(this.asset.getCompanyId());
            if (!FISHelper.getBrancheId(this.asset.getCompanyId()).equals("000")) {
                attr[v++] = FISHelper.getBrancheId(this.asset.getCompanyId());
            }
        }
        attr[v++] = this.asset.getParentId() == null ? this.asset.getId() : this.asset.getParentId();
        attr[v++] = this.asset.getParentId() == null ? "" : this.asset.getId();
        attr[v++] = this.asset.getTypeId();
        attr[v++] = this.asset.getFinDimId1();
        attr[v++] = this.asset.getFinDimId2();
        attr[v++] = this.asset.getFinDimId3();
        attr[v++] = this.asset.getFinDimId4();
        attr[v++] = this.asset.getFinDimId5();
        for (i = v; i < v + maxSeqNbr; ++i) {
            attr[i] = "";
        }
        i = v - 1;
        Collection assetAnalysisCodes = this.asset.getAssetAnalysisCodeCollection(null);
        for (AssetAnalysisCode assetAnalysisCode : assetAnalysisCodes) {
            attr[i + assetAnalysisCode.getSeqNr()] = "" + assetAnalysisCode.getCode();
        }
        Collection assetValues = this.asset.getAssetValueCollection(null);
        for (AssetValue assetValue : assetValues) {
            attr[i + assetValue.getSeqNr()] = "" + assetValue.getValue();
        }
        v += maxSeqNbr;
        attr[v++] = IBSDecimal.format(depCurr, true);
        if (this.interest) {
            attr[v++] = IBSDecimal.format(intCurr, true);
        }
        attr[v++] = "" + year;
        if (this.governmentActivated) {
            this.vma = ValuationMainAccountBO.getValuationMainAccountToUse(this.company.getDBData(), this.company.getId(), "A", this.asset.getId(), this.accountingPrinciple, this.bookYearFrom + this.numberOfYears, 1);
            if (this.vma != null) {
                this.idAndDescription = new String[2];
                this.idAndDescription[0] = this.vma.getMainAccountId3();
                this.idAndDescription[1] = this.fmsHelper.getDescription(this.idAndDescription[0], 0);
            } else {
                this.idAndDescription = this.ajdHelper.getIdAndDescription(this.asset.getTypeId(), this.accountingPrinciple, 30, 0);
            }
            attr[v++] = this.idAndDescription[0];
            attr[v++] = this.idAndDescription[1];
            this.idAndDescription = this.ajdHelper.getIdAndDescription(this.asset.getTypeId(), this.accountingPrinciple, 30, 1);
            attr[v++] = this.idAndDescription[0];
            attr[v++] = this.idAndDescription[1];
            if (this.vma != null) {
                this.idAndDescription = new String[2];
                this.idAndDescription[0] = this.vma.getMainAccountId8();
                this.idAndDescription[1] = this.fmsHelper.getDescription(this.idAndDescription[0], 0);
            } else {
                this.idAndDescription = this.ajdHelper.getIdAndDescription(this.asset.getTypeId(), this.accountingPrinciple, 80, 0);
            }
            attr[v++] = this.idAndDescription[0];
            attr[v++] = this.idAndDescription[1];
            this.idAndDescription = this.ajdHelper.getIdAndDescription(this.asset.getTypeId(), this.accountingPrinciple, 80, 1);
            attr[v++] = this.idAndDescription[0];
            attr[v++] = this.idAndDescription[1];
        }
        return attr;
    }

    private String[] getCreditPrintAttributes(BigDecimal depCurr, BigDecimal intCurr, int year) throws Exception {
        int i;
        if (!this.includeDisinvested && this.theCredit.getState() < 2) {
            return null;
        }
        if (this.theCredit.getClosingYear() > 0 && this.theCredit.getClosingYear() < this.bookYearFrom) {
            return null;
        }
        int v = 0;
        String[] attr = new String[this.numberOfColumns];
        attr[v++] = this.theCredit.getCompanyId();
        attr[v++] = this.theCredit.getId();
        attr[v++] = "";
        attr[v++] = this.theCredit.getProFormaTypeId();
        attr[v++] = this.theCredit.getFinDimId1();
        attr[v++] = this.theCredit.getFinDimId2();
        attr[v++] = this.theCredit.getFinDimId3();
        attr[v++] = this.theCredit.getFinDimId4();
        attr[v++] = "";
        for (i = v; i < v + maxSeqNbr; ++i) {
            attr[i] = "";
        }
        i = v - 1;
        if (this.theCredit.getDimValue1().trim().length() > 0) {
            attr[i + this.company.getSeqNr1().intValue()] = this.theCredit.getDimValue1();
        }
        if (this.theCredit.getDimValue2().trim().length() > 0) {
            attr[i + this.company.getSeqNr2().intValue()] = this.theCredit.getDimValue2();
        }
        if (this.theCredit.getDimValue3().trim().length() > 0) {
            attr[i + this.company.getSeqNr3().intValue()] = this.theCredit.getDimValue3();
        }
        if (this.theCredit.getDimValue4().trim().length() > 0) {
            attr[i + this.company.getSeqNr4().intValue()] = this.theCredit.getDimValue4();
        }
        if (this.theCredit.getDimValue5().trim().length() > 0) {
            attr[i + this.company.getSeqNr5().intValue()] = this.theCredit.getDimValue5();
        }
        if (this.theCredit.getDimValue6().trim().length() > 0) {
            attr[i + this.company.getSeqNr6().intValue()] = this.theCredit.getDimValue6();
        }
        v += maxSeqNbr;
        attr[v++] = IBSDecimal.format(depCurr, true);
        if (this.interest) {
            attr[v++] = IBSDecimal.format(intCurr, true);
        }
        attr[v++] = "" + year;
        this.vma = ValuationMainAccountBO.getValuationMainAccountToUse(this.company.getDBData(), this.company.getId(), "C", this.theCredit.getId(), this.accountingPrinciple, this.bookYearFrom + this.numberOfYears, 1);
        if (this.vma != null) {
            attr[v++] = this.vma.getMainAccountId3();
            attr[v++] = this.fmsHelper.getDescription(this.vma.getMainAccountId3(), 0);
        } else {
            attr[v++] = "";
            attr[v++] = "";
        }
        if (this.theCredit.getProFormaTypeId().trim().length() > 0) {
            this.idAndDescription = this.ajdHelper.getIdAndDescription(this.theCredit.getProFormaTypeId(), 1, 30, 1);
            attr[v++] = this.idAndDescription[0];
            attr[v++] = this.idAndDescription[1];
        } else {
            attr[v++] = "";
            attr[v++] = "";
        }
        if (this.vma != null) {
            attr[v++] = this.vma.getMainAccountId8();
            attr[v++] = this.fmsHelper.getDescription(this.vma.getMainAccountId8(), 0);
        } else {
            attr[v++] = "";
            attr[v++] = "";
        }
        if (this.theCredit.getProFormaTypeId().trim().length() > 0) {
            this.idAndDescription = this.ajdHelper.getIdAndDescription(this.theCredit.getProFormaTypeId(), 1, 80, 1);
            attr[v++] = this.idAndDescription[0];
            attr[v++] = this.idAndDescription[1];
        } else {
            attr[v++] = "";
            attr[v++] = "";
        }
        while (v < attr.length) {
            attr[v] = "";
            ++v;
        }
        return attr;
    }

    private static String[][] createLabels(Map map, String periodType, int bookYearFrom, int numberOfYears, int numberOfPeriods, boolean governmentActivated, boolean interest, FISHelper fisHelper, String companyId) throws Exception {
        String[][] labels = new String[][]{new String[0]};
        String deprec = LanguageHelper.getString("nl.ibs.fac.language", "Depreciation");
        String intrst = LanguageHelper.getString("nl.ibs.fac.language", "Interest");
        Object name = null;
        ArrayList<String> _labels = new ArrayList<String>();
        _labels.add(LanguageHelper.getString("nl.ibs.fac.language", "Company"));
        if (fisHelper != null & !FISHelper.getBrancheId(companyId).equals("000")) {
            _labels.add(LanguageHelper.getString("nl.ibs.fac.language", "Branche"));
        }
        _labels.add(LanguageHelper.getString("nl.ibs.fac.language", "Id"));
        _labels.add(LanguageHelper.getString("nl.ibs.fac.language", "SubId"));
        _labels.add("Type");
        Environment environment = (Environment)EnvironmentBO.get((String)map.get("facLib"))[0];
        _labels.add(environment.getShortName1());
        _labels.add(environment.getShortName2());
        _labels.add(environment.getShortName3());
        _labels.add(environment.getShortName4());
        _labels.add(environment.getShortName5());
        Collection analysisGroups = AnalysisGroupBO.getAnalysisGroups(map);
        Iterator agi1 = analysisGroups.iterator();
        maxSeqNbr = 0;
        while (agi1.hasNext()) {
            AnalysisGroup analysisGroup = (AnalysisGroup)agi1.next();
            if (analysisGroup.getSeqNr() <= maxSeqNbr) continue;
            maxSeqNbr = analysisGroup.getSeqNr();
        }
        if (maxSeqNbr > 0) {
            String[] facdim_labels = new String[maxSeqNbr];
            for (AnalysisGroup analysisGroup : analysisGroups) {
                facdim_labels[analysisGroup.getSeqNr() - 1] = analysisGroup.getShortName();
            }
            for (int i = 0; i < maxSeqNbr; ++i) {
                _labels.add(facdim_labels[i]);
            }
        }
        _labels.add(deprec);
        if (interest) {
            _labels.add(intrst);
        }
        _labels.add("Year");
        if (governmentActivated) {
            _labels.add("Id");
            _labels.add("Afschr.kosten");
            _labels.add("Id");
            _labels.add("Categorie");
            _labels.add("Id");
            _labels.add("Rentekosten");
            _labels.add("Id");
            _labels.add("Categorie");
        }
        int s = _labels.size();
        labels[0] = new String[s];
        for (int i = 0; i < s; ++i) {
            labels[0][i] = (String)_labels.get(i);
        }
        return labels;
    }

    public static void main(String[] args) {
        Stopwatch sw = null;
        if (Log.debug()) {
            sw = new Stopwatch();
            sw.start();
        }
        try {
            ProofDepreciationToCSVForET.execute(args);
        }
        catch (Exception e) {
            Log.error((Exception)e);
            System.exit(-1);
        }
        if (sw != null) {
            Log.debug((String)("Elapsed time: " + sw.stop(1) + " seconds"));
        }
        System.exit(0);
    }

    public static void execute(String[] args) throws Exception {
        String bookYear;
        String companyId;
        String[][] selections;
        Map map;
        LoginHelper loginHelper;
        String message;
        if (Log.debug() && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                Log.debug((String)args[i]);
            }
        }
        if ((message = (loginHelper = BatchJobHelper.getLoginHelper(map = BatchJobHelper.getSelections(selections = BatchJobHelper.getSelections(args)))).login()) != null) {
            message = LanguageHelper.getString("nl.ibs.fac.language", message);
            Log.error((String)message);
            return;
        }
        Environment environment = (Environment)EnvironmentBO.get((String)map.get("facLib"))[0];
        message = loginHelper.login(environment, companyId = (String)map.get("Company"), bookYear = (String)map.get("BookYear"));
        if (message != null && message.trim().length() > 0) {
            message = LanguageHelper.getString("nl.ibs.fac.language", message);
            Log.error((String)message);
            return;
        }
        FMSHelper fmsHelper = null;
        FISHelper fisHelper = null;
        if (environment.getOperationArea().trim().length() > 0) {
            fmsHelper = new FMSHelper(loginHelper);
        } else {
            fisHelper = new FISHelper(loginHelper);
        }
        DBData dbData = BOAdapter.getDBData(map);
        int accountingPrinciple = Integer.parseInt((String)map.get("AccountingPrinciple"));
        CompanyAccountingPrincipleDefault capd = (CompanyAccountingPrincipleDefault)CompanyAccountingPrincipleDefaultBO.get(dbData, companyId, accountingPrinciple)[0];
        boolean interest = capd == null ? true : capd.getCalculateInterest();
        Company company = (Company)CompanyBO.get(dbData, companyId)[0];
        boolean governmentActivated = Boolean.valueOf((String)map.get("governmentActivated"));
        String periodType = (String)map.get("PeriodType");
        int bookYearFrom = Integer.parseInt((String)map.get("BookYearFrom"));
        int numberOfYears = Integer.parseInt((String)map.get("NumberOfYears"));
        int numberOfPeriods = company.getNumberOfPeriods();
        String assetSelectionAsString = (String)map.get(AssetSelection.ASSETSELECTION);
        String assetSelectionAsString2 = (String)map.get(AssetSelection.ASSETSELECTION + "2");
        AssetSelection assetSelection = new AssetSelection(assetSelectionAsString + assetSelectionAsString2);
        assetSelection.governmentActivated = governmentActivated;
        assetSelection.ap = Integer.parseInt((String)map.get("AccountingPrinciple"));
        String[][] labels = ProofDepreciationToCSVForET.createLabels(map, periodType, bookYearFrom, numberOfYears, numberOfPeriods, governmentActivated, interest, fisHelper, companyId);
        ProofDepreciationToCSVForET proofDepreciationToCSV = new ProofDepreciationToCSVForET(selections, assetSelection.getCollection(), labels, fmsHelper, fisHelper, company, bookYearFrom, numberOfYears, interest);
        proofDepreciationToCSV.setIncludeDisinvested(assetSelection.getIncludeDisinvested());
        proofDepreciationToCSV.setGovernmentActivated(governmentActivated);
        FileOutputStream fos = new FileOutputStream(ReportFileHelper.getFileName(args, FILENAME, "csv"));
        fos.write(proofDepreciationToCSV.createCsv());
        fos.close();
        loginHelper.logout(environment, companyId, bookYear);
        loginHelper.logout();
    }
}

