/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.reports;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import nl.ibs.fac.ColumnDefinition;
import nl.ibs.fac.db.AnalysisGroup;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Environment;

public abstract class ReportDefinitionHelper {
    private static final String[][] DB_COLUMN_USAGE = new String[][]{{"ID", "1"}, {"DESCR", "1"}, {"STATE", "1"}, {"COMPANYID", "1"}, {"TYPEID", "1"}, {"PARENTID", "1"}, {"HISTYP", "1"}, {"ACQUIDATE", "1"}, {"STRUSEYP", "1"}, {"DISINVYP", "1"}, {"ACCPRIN", "1"}, {"PSTACQBAL", "0"}, {"DEPBALANCE", "0"}, {"STRDPRYP", "1"}, {"LSTDPRYP", "1"}, {"DEPLIFE", "1"}, {"NBRDEPPER", "1"}, {"RMNLIFE", "1"}, {"LOAN", "1"}, {"POFFYRAMT", "1"}, {"DEPRMETHOD", "1"}, {"STARTPERHM", "1"}, {"DEPPAUSED", "0"}, {"TRANSACTN.ASSETID", "2"}, {"ASSET.DESCR", "2"}, {"ASSET.STATE", "2"}, {"TRANSACTN.COMPANYID", "2"}, {"ASSET.TYPEID", "2"}, {"ASSET.PARENTID", "2"}, {"ASSET.ACQUIDATE", "2"}, {"ASSET.LOAN", "2"}, {"TRANSACTN.DOCUMENTNR", "2"}, {"TRANSACTN.AMOUNT1", "2"}, {"TRANSACTN.AMOUNT2", "2"}, {"TRANSACTN.AMOUNT3", "2"}, {"TRANSACTN.TRANSTYP", "2"}, {"TRANSACTN.DESCR", "2"}, {"TRANSACTN.PERIOD", "2"}, {"INCFINTRNS.INTINVOICE", "2"}, {"TRANSACTN.CREDITID", "3"}, {"CREDIT.DESC", "3"}, {"TRANSACTN.COMPANYID", "3"}, {"TRANSACTN.DOCUMENTNR", "3"}, {"TRANSACTN.AMOUNT1", "3"}, {"TRANSACTN.AMOUNT2", "3"}, {"TRANSACTN.AMOUNT3", "3"}, {"TRANSACTN.TRANSTYP", "3"}, {"TRANSACTN.BOOKINGIND", "3"}, {"TRANSACTN.DESCR", "3"}, {"TRANSACTN.BOOKYEAR", "3"}, {"TRANSACTN.PERIOD", "3"}, {"TRANSACTN.MAINACC1", "3"}, {"CRDBALANCE.DESCR", "3"}, {"ID", "4"}, {"DESCR", "4"}, {"COMPANYID", "4"}, {"PFTYPEID", "4"}};
    private static final String[][] DB_COLUMNS = new String[][]{{"ID", "Label.AssetId", "A1"}, {"DESCR", "Label.Description", "A1"}, {"STATE", "Label.State", "A1"}, {"COMPANYID", "Label.CompanyId", "A1"}, {"TYPEID", "Label.Type", "A1"}, {"PARENTID", "Label.ParentAsset", "A1"}, {"HISTYP", "Label.HistoricalPeriod", "A1"}, {"ACQUIDATE", "Label.AcquisitionDate", "A1"}, {"STRUSEYP", "Label.StartPeriod", "A1"}, {"DISINVYP", "Label.DisInvestmentPeriod", "A1"}, {"ACCPRIN", "Label.AccountingPrinciple", "A1"}, {"PSTACQBAL", "Label.AcquisitionValue", "A1"}, {"DEPBALANCE", "Label.Depreciations", "A1"}, {"STRDPRYP", "Label.PeriodFrom", "A1"}, {"LSTDPRYP", "Label.LastDepreciated", "A1"}, {"DEPLIFE", "Label.DepreciationLife", "A1"}, {"NBRDEPPER", "Label.DepreciatedPeriods", "A1"}, {"RMNLIFE", "Label.RemainingLife", "A1"}, {"LOAN", "Label.Loan", "A1"}, {"POFFYRAMT", "Label.PayOffYearAmount", "A1"}, {"DEPRMETHOD", "Label.DepreciationMethod", "A1"}, {"STARTPERHM", "Label.StartPeriodHandlingPolicy", "A1"}, {"DEPPAUSED", "Label.DepreciationPaused", "A1"}, {"TRANSACTN.ASSETID", "Label.AssetId", "T1"}, {"ASSET.DESCR", "Label.Description", "A1"}, {"ASSET.STATE", "Label.State", "A1"}, {"TRANSACTN.COMPANYID", "Label.CompanyId", "A1"}, {"ASSET.TYPEID", "Label.Type", "A1"}, {"ASSET.PARENTID", "Label.ParentAsset", "A1"}, {"ASSET.ACQUIDATE", "Label.AcquisitionDate", "A1"}, {"ASSET.LOAN", "Label.Loan", "A1"}, {"TRANSACTN.DOCUMENTNR", "Label.DocumentNr", "T1"}, {"TRANSACTN.AMOUNT1", "Label.InvestmentAmount", "T1"}, {"TRANSACTN.AMOUNT2", "Label.DepreciationAmount", "T1"}, {"TRANSACTN.AMOUNT3", "Label.InterestAmount", "T1"}, {"TRANSACTN.TRANSTYP", "Label.TransactionType", "T1"}, {"TRANSACTN.DESCR", "Label.TransactionDescription", "T1"}, {"TRANSACTN.PERIODE", "Label.Period", "T1"}, {"INCFINTRNS.INTINVOICE", "Label.InternalInvoiceId", "T1"}, {"TRANSACTN.CREDITID", "Label.CreditId", "T1"}, {"CREDIT.DESCR", "Label.Description", "T1"}, {"TRANSACTN.COMPANYID", "Label.CompanyId", "T1"}, {"TRANSACTN.DOCUMENTNR", "Label.DocumentNr", "T1"}, {"TRANSACTN.AMOUNT1", "Label.InvestmentAmount", "T1"}, {"TRANSACTN.AMOUNT2", "Label.DepreciationAmount", "T1"}, {"TRANSACTN.AMOUNT3", "Label.InterestAmount", "T1"}, {"TRANSACTN.TRANSTYP", "Label.TransactionType", "T1"}, {"TRANSACTN.BOOKINGIND", "Label.BookingIndicator", "T1"}, {"TRANSACTN.DESCR", "Label.TransactionDescription", "T1"}, {"TRANSACTN.PERIODE", "Label.Period", "T1"}, {"TRANSACTN.BOOKYEAR", "Label.BookYear", "T1"}, {"TRANSACTN.MAINACC1", "Label.CostAccount", "T1"}, {"CRDBALANCE.DESCR", "Label.CostDescription", "T1"}, {"ID", "Label.CreditId", "C1"}, {"DESCR", "Label.Description", "C1"}, {"COMPANYID", "Label.CompanyId", "C1"}, {"PFTYPEID", "Label.Type", "C1"}};
    public static final String US_FUNCTION = "FACReportDefinition";
    public static final String US_TYPE_COMMON_HEADER = "RT";
    public static final String US_TYPE_COLUMN_SELECT = "RS";
    public static final String YEARFROM = "yearFrom";
    public static final String PERIODRFROM = "periodFrom";
    public static final String YEARTO = "yearTo";
    public static final String PERIODTO = "periodTo";
    public static final String TRANSACTIONTYPE = "transactionType";
    public static final String ACCOUNTINGPRINCIPLE = "accountingPrinciple";
    public static final String REPORTDEFINITIONKEY = "reportDefinitionKey";
    public static final String REPORTNAME = "reportName";

    public static Vector retrieveAllColumnDefinitions(Environment env, boolean isFMS, Company company, int reportType, int usage) throws Exception {
        Vector vector = ReportDefinitionHelper.retrieveDBColumnDefinitions(reportType);
        vector = ReportDefinitionHelper.retrieveCalculationColumnDefinitions(reportType, vector);
        vector = ReportDefinitionHelper.retrieveFinancialDimensionColumnDefinitions(env, isFMS, company, vector, usage, reportType);
        if (reportType == 1 || reportType == 4) {
            vector = ReportDefinitionHelper.retrieveOtherDimensionColumnDefinitions(reportType, company, vector, usage);
        }
        if (reportType == 3) {
            vector = ReportDefinitionHelper.retrieveOtherDimensionColumnDefinitionsCreditTransactions(reportType, company, vector, usage);
        }
        return vector;
    }

    private static Vector retrieveDBColumnDefinitions(int reportType) throws Exception {
        Vector<ColumnDefinition> vector = new Vector<ColumnDefinition>();
        for (int index = 0; index < DB_COLUMN_USAGE.length; ++index) {
            if (!DB_COLUMN_USAGE[index][1].equals("" + reportType)) continue;
            vector.add(new ColumnDefinition(DB_COLUMNS[index][0], DB_COLUMNS[index][1], DB_COLUMNS[index][2]));
        }
        return vector;
    }

    private static Vector retrieveCalculationColumnDefinitions(int reportType, Vector incomingVector) throws Exception {
        Vector<ColumnDefinition> vector = incomingVector == null ? new Vector<ColumnDefinition>() : incomingVector;
        if (reportType == 1) {
            vector.add(new ColumnDefinition("T1", "Label.AcquisitionValue", "CC", "(1*)"));
            vector.add(new ColumnDefinition("T2", "Label.Depreciations", "CC", "(1*)"));
            vector.add(new ColumnDefinition("C1", "Label.BookValue", "CC", "(1*)"));
            vector.add(new ColumnDefinition("T3", "Label.AcquisitionValue", "CC", "(2*)"));
            vector.add(new ColumnDefinition("T5", "Label.AcquisitionValue", "CC", "(3*)"));
            vector.add(new ColumnDefinition("T6", "Label.Depreciations", "CC", "(3*)"));
            vector.add(new ColumnDefinition("T7", "Label.YieldValue", "CC", "(3*)"));
            vector.add(new ColumnDefinition("C2", "Label.Result", "CC", "(3*)"));
            vector.add(new ColumnDefinition("T8", "Label.DepreciationCosts", "CC"));
            vector.add(new ColumnDefinition("T9", "Label.InterestCosts", "CC"));
            vector.add(new ColumnDefinition("C3", "Label.AcquisitionValue", "CC", "(4*)"));
            vector.add(new ColumnDefinition("C4", "Label.Depreciations", "CC", "(4*)"));
            vector.add(new ColumnDefinition("C5", "Label.BookValue", "CC", "(4*)"));
        }
        if (reportType == 4) {
            vector.add(new ColumnDefinition("T1", "Label.AcquisitionValue", "CC", "(1*)"));
            vector.add(new ColumnDefinition("T2", "Label.Depreciations", "CC", "(1*)"));
            vector.add(new ColumnDefinition("C1", "Label.BookValue", "CC", "(1*)"));
            vector.add(new ColumnDefinition("T3", "Label.AcquisitionValue", "CC", "(2*)"));
            vector.add(new ColumnDefinition("T5", "Label.AcquisitionValue", "CC", "(3*)"));
            vector.add(new ColumnDefinition("T8", "Label.DepreciationCosts", "CC"));
            vector.add(new ColumnDefinition("T9", "Label.InterestCosts", "CC"));
            vector.add(new ColumnDefinition("C3", "Label.AcquisitionValue", "CC", "(4*)"));
            vector.add(new ColumnDefinition("C4", "Label.Depreciations", "CC", "(4*)"));
            vector.add(new ColumnDefinition("C5", "Label.BookValue", "CC", "(4*)"));
            vector.add(new ColumnDefinition("T10", "Label.CreditAmount", "CC"));
        }
        return vector;
    }

    private static Vector retrieveFinancialDimensionColumnDefinitions(Environment env, boolean isFMS, Company company, Vector incomingVector, int usage, int reportType) throws Exception {
        Company dataSet = company.getDataSet();
        if (dataSet == null) {
            dataSet = company;
        }
        Vector<ColumnDefinition> vector = incomingVector == null ? new Vector<ColumnDefinition>() : incomingVector;
        if (usage == 0) {
            if (dataSet.getFinancialDimension1Usage() != 0) {
                vector.add(new ColumnDefinition("FINDIMID1", env.getName1(), "FD"));
            }
            if (dataSet.getFinancialDimension2Usage() != 0) {
                vector.add(new ColumnDefinition("FINDIMID2", env.getName2(), "FD"));
            }
            if (dataSet.getFinancialDimension3Usage() != 0) {
                vector.add(new ColumnDefinition("FINDIMID3", env.getName3(), "FD"));
            }
            if (dataSet.getFinancialDimension4Usage() != 0) {
                vector.add(new ColumnDefinition("FINDIMID4", env.getName4(), "FD"));
            }
            if (!isFMS && dataSet.getFinancialDimension5Usage() != 0) {
                vector.add(new ColumnDefinition("FINDIMID5", env.getName5(), "FD"));
            }
            if (reportType == 3) {
                vector.add(new ColumnDefinition("VOUCHERID", "Boekstuknummer", "FD"));
            }
        } else {
            vector.add(new ColumnDefinition("FINDIMID1", env.getName1(), "FD"));
            vector.add(new ColumnDefinition("FINDIMID2", env.getName2(), "FD"));
            vector.add(new ColumnDefinition("FINDIMID3", env.getName3(), "FD"));
            vector.add(new ColumnDefinition("FINDIMID4", env.getName4(), "FD"));
            if (!isFMS) {
                vector.add(new ColumnDefinition("FINDIMID5", env.getName5(), "FD"));
            }
        }
        return vector;
    }

    private static Vector retrieveOtherDimensionColumnDefinitions(int reportType, Company company, Vector incomingVector, int usage) throws Exception {
        Company dataSet = company.getDataSet();
        if (dataSet == null) {
            dataSet = company;
        }
        Vector<ColumnDefinition> vector = incomingVector == null ? new Vector<ColumnDefinition>() : incomingVector;
        if (usage != 0) {
            return vector;
        }
        if (reportType == 1) {
            Collection analysisGroups = dataSet.getAnalysisGroupsCollection(null);
            for (AnalysisGroup analysisGroup : analysisGroups) {
                String type;
                if (analysisGroup.getUsage() == 1 || analysisGroup.getUsage() == 3) {
                    type = "AC";
                } else {
                    if (analysisGroup.getUsage() != 2 && analysisGroup.getUsage() != 3) continue;
                    type = "AV";
                }
                vector.add(new ColumnDefinition("DIM" + analysisGroup.getSeqNr(), analysisGroup.getName(), type, analysisGroup.getSeqNr()));
            }
            return vector;
        }
        Collection analysisGroups = dataSet.getAnalysisGroupsCollection(null);
        Iterator agi = analysisGroups.iterator();
        int i = 1;
        while (agi.hasNext() && i < 7) {
            AnalysisGroup analysisGroup = (AnalysisGroup)agi.next();
            vector.add(new ColumnDefinition("DIMVALUE" + i++, analysisGroup.getName(), "FAC"));
        }
        return vector;
    }

    private static Vector retrieveOtherDimensionColumnDefinitionsCreditTransactions(int reportType, Company company, Vector incomingVector, int usage) throws Exception {
        Company dataSet = company.getDataSet();
        if (dataSet == null) {
            dataSet = company;
        }
        Vector<ColumnDefinition> vector = incomingVector == null ? new Vector<ColumnDefinition>() : incomingVector;
        if (usage != 0) {
            return vector;
        }
        Collection analysisGroups = dataSet.getAnalysisGroupsCollection(null);
        Iterator agi = analysisGroups.iterator();
        int i = 1;
        while (agi.hasNext() && i < 7) {
            AnalysisGroup analysisGroup = (AnalysisGroup)agi.next();
            vector.add(new ColumnDefinition("CREDIT.DIMVALUE" + i++, analysisGroup.getName(), "FAC"));
        }
        return vector;
    }

    public static String retrieveSQLStatement(String dataLib, Company company, int year, int yearPeriodFrom, int yearPeriodTo, int ap, int reportType, int usage, String nonCalcColumns) throws Exception {
        String companyId = company.getId();
        String stmt = "";
        if (reportType == 1) {
            stmt = stmt + "WITH ";
            stmt = stmt + "OPENING_BALANCE AS (";
            stmt = stmt + "SELECT COMPANYID, CORA, ASSETID, SUM(AMOUNT1) AS TOTAL1, SUM(AMOUNT2) AS TOTAL2 ";
            stmt = stmt + "FROM " + dataLib + ".TRANSACTN ";
            stmt = stmt + "WHERE (COMPANYID = '" + companyId + "' AND CORA = 'A' AND ACCPRIN = " + ap + " AND ";
            stmt = stmt + "((JRNBOOKYR * 100) + JRNPERIOD) < " + yearPeriodFrom + " AND ";
            stmt = stmt + "(MNTRANSTYP = 1 OR MNTRANSTYP = 2 OR MNTRANSTYP = 3)) OR ";
            stmt = stmt + "(COMPANYID = '" + companyId + "' AND CORA = 'A' AND ACCPRIN = " + ap + " AND ";
            stmt = stmt + "MNTRANSTYP = 1 AND TRANSTYP = 20) ";
            stmt = stmt + "GROUP BY COMPANYID, CORA, ASSETID), ";
            stmt = stmt + "CURRENT_INVESTMENTS AS (";
            stmt = stmt + "SELECT COMPANYID, CORA, ASSETID, SUM(AMOUNT1) AS TOTAL3, SUM(AMOUNT2) AS TOTAL4 ";
            stmt = stmt + "FROM " + dataLib + ".TRANSACTN ";
            stmt = stmt + "WHERE COMPANYID = '" + companyId + "' AND CORA = 'A' AND ACCPRIN = " + ap + " AND ";
            stmt = stmt + "((JRNBOOKYR * 100) + JRNPERIOD) >= " + yearPeriodFrom + " AND ";
            stmt = stmt + "((JRNBOOKYR * 100) + JRNPERIOD) <= " + yearPeriodTo + " AND ";
            stmt = stmt + "MNTRANSTYP = 1 AND TRANSTYP <> 20 ";
            stmt = stmt + "GROUP BY COMPANYID, CORA, ASSETID), ";
            stmt = stmt + "CURRENT_DISINVESTMENTS AS (";
            stmt = stmt + "SELECT COMPANYID, CORA, ASSETID, SUM(AMOUNT1) AS TOTAL5, SUM(AMOUNT2) AS TOTAL6, SUM(AMOUNT3) AS TOTAL7 ";
            stmt = stmt + "FROM " + dataLib + ".TRANSACTN ";
            stmt = stmt + "WHERE COMPANYID = '" + companyId + "' AND CORA = 'A' AND ACCPRIN = " + ap + " AND ";
            stmt = stmt + "((JRNBOOKYR * 100) + JRNPERIOD) >= " + yearPeriodFrom + " AND ";
            stmt = stmt + "((JRNBOOKYR * 100) + JRNPERIOD) <= " + yearPeriodTo + " AND ";
            stmt = stmt + "MNTRANSTYP = 2 ";
            stmt = stmt + "GROUP BY COMPANYID, CORA, ASSETID), ";
            stmt = stmt + "DEPRECIATION_INTEREST_COSTS AS (";
            stmt = stmt + "SELECT COMPANYID, CORA, ASSETID, SUM(AMOUNT2) AS TOTAL8, SUM(AMOUNT3) AS TOTAL9 ";
            stmt = stmt + "FROM " + dataLib + ".TRANSACTN ";
            stmt = stmt + "WHERE COMPANYID = '" + companyId + "' AND CORA = 'A' AND ACCPRIN = " + ap + " AND ";
            stmt = stmt + "((JRNBOOKYR * 100) + JRNPERIOD) >= " + yearPeriodFrom + " AND ";
            stmt = stmt + "((JRNBOOKYR * 100) + JRNPERIOD) <= " + yearPeriodTo + " AND ";
            stmt = stmt + "MNTRANSTYP = 3 ";
            stmt = stmt + "GROUP BY COMPANYID, CORA, ASSETID), ";
            Vector analysisGroupVector = ReportDefinitionHelper.retrieveOtherDimensionColumnDefinitions(1, company, null, usage);
            String dimensions = "";
            if (!analysisGroupVector.isEmpty()) {
                stmt = stmt + "DIMENSIONS AS (";
                stmt = stmt + "SELECT DX.COMPANYID, DX.CORA, DX.ID";
                for (ColumnDefinition columnDefinition : analysisGroupVector) {
                    stmt = "AC".equals(columnDefinition.getType()) ? stmt + ", D" + columnDefinition.getAgSeqNr() + ".CODE AS DIM" + columnDefinition.getAgSeqNr() : stmt + ", D" + columnDefinition.getAgSeqNr() + ".VALUE AS DIM" + columnDefinition.getAgSeqNr();
                    dimensions = dimensions + "Z.DIM" + columnDefinition.getAgSeqNr() + ", ";
                }
                stmt = stmt + " FROM " + dataLib + ".Asset AS DX";
                for (ColumnDefinition columnDefinition : analysisGroupVector) {
                    stmt = "AC".equals(columnDefinition.getType()) ? stmt + " LEFT OUTER JOIN " + dataLib + ".AssetCode AS D" + columnDefinition.getAgSeqNr() + " ON " : stmt + " LEFT OUTER JOIN " + dataLib + ".AssetValue AS D" + columnDefinition.getAgSeqNr() + " ON ";
                    stmt = stmt + "D" + columnDefinition.getAgSeqNr() + ".COMPANYID = DX.COMPANYID AND ";
                    stmt = stmt + "D" + columnDefinition.getAgSeqNr() + ".CORA = DX.CORA AND ";
                    stmt = stmt + "D" + columnDefinition.getAgSeqNr() + ".ASSETID = DX.ID AND ";
                    stmt = stmt + "D" + columnDefinition.getAgSeqNr() + ".SEQNR = " + columnDefinition.getAgSeqNr();
                }
                stmt = stmt + "), ";
            }
            stmt = stmt + "MERGETABLE AS (";
            stmt = stmt + "SELECT X.ACCPRIN, X.STRDEPBKYR, X.STRDEPPER, X.LSTDEPBKYR, X.LSTDEPPER, X.DEPLIFE, X.NBRDEPPER, X.DEPRMETHOD, X.STARTPERHM, ";
            stmt = stmt + "Y.*, " + dimensions;
            stmt = stmt + "(CASE WHEN STRUSEPER > 9 THEN VARCHAR(STRUSEYEAR) CONCAT '-' CONCAT VARCHAR(STRUSEPER) ELSE VARCHAR(STRUSEYEAR) CONCAT '-0' CONCAT VARCHAR(STRUSEPER) END) AS STRUSEYP, ";
            stmt = stmt + "(CASE WHEN DISINVPER > 9 THEN VARCHAR(DISINVYEAR) CONCAT '-' CONCAT VARCHAR(DISINVPER) ELSE VARCHAR(DISINVYEAR) CONCAT '-0' CONCAT VARCHAR(DISINVPER) END) AS DISINVYP, ";
            stmt = stmt + "(CASE WHEN HISTPERIOD > 9 THEN VARCHAR(HISTYEAR) CONCAT '-' CONCAT VARCHAR(HISTPERIOD) ELSE VARCHAR(HISTYEAR) CONCAT '-0' CONCAT VARCHAR(HISTPERIOD) END) AS HISTYP, ";
            stmt = stmt + "(CASE WHEN STRDEPPER > 9 THEN VARCHAR(STRDEPBKYR) CONCAT '-' CONCAT VARCHAR(STRDEPPER) ELSE VARCHAR(STRDEPBKYR) CONCAT '-0' CONCAT VARCHAR(STRDEPPER) END) AS STRDPRYP, ";
            stmt = stmt + "(CASE WHEN LSTDEPPER > 9 THEN VARCHAR(LSTDEPBKYR) CONCAT '-' CONCAT VARCHAR(LSTDEPPER) ELSE VARCHAR(LSTDEPBKYR) CONCAT '-0' CONCAT VARCHAR(LSTDEPPER) END) AS LSTDPRYP, ";
            stmt = stmt + "(DEPLIFE - NBRDEPPER) AS RMNLIFE, ";
            stmt = stmt + "A.TOTAL1, A.TOTAL2, B.TOTAL3, C.TOTAL5, C.TOTAL6, C.TOTAL7, D.TOTAL8, D.TOTAL9 ";
            stmt = stmt + "FROM " + dataLib + ".VALUATION AS X ";
            stmt = stmt + "LEFT OUTER JOIN OPENING_BALANCE AS A ON ";
            stmt = stmt + "A.COMPANYID = X.COMPANYID AND ";
            stmt = stmt + "A.CORA = X.CORA AND ";
            stmt = stmt + "A.ASSETID = X.ASSETID ";
            stmt = stmt + "LEFT OUTER JOIN CURRENT_INVESTMENTS AS B ON ";
            stmt = stmt + "B.COMPANYID = X.COMPANYID AND ";
            stmt = stmt + "B.CORA = X.CORA AND ";
            stmt = stmt + "B.ASSETID = X.ASSETID ";
            stmt = stmt + "LEFT OUTER JOIN CURRENT_DISINVESTMENTS AS C ON ";
            stmt = stmt + "C.COMPANYID = X.COMPANYID AND ";
            stmt = stmt + "C.CORA = X.CORA AND ";
            stmt = stmt + "C.ASSETID = X.ASSETID ";
            stmt = stmt + "LEFT OUTER JOIN DEPRECIATION_INTEREST_COSTS AS D ON ";
            stmt = stmt + "D.COMPANYID = X.COMPANYID AND ";
            stmt = stmt + "D.CORA = X.CORA AND ";
            stmt = stmt + "D.ASSETID = X.ASSETID ";
            stmt = stmt + "LEFT OUTER JOIN " + dataLib + ".Asset AS Y ON ";
            stmt = stmt + "Y.COMPANYID = X.COMPANYID AND ";
            stmt = stmt + "Y.CORA = X.CORA AND ";
            stmt = stmt + "Y.ID = X.ASSETID ";
            if (!analysisGroupVector.isEmpty()) {
                stmt = stmt + "LEFT OUTER JOIN DIMENSIONS AS Z ON ";
                stmt = stmt + "Z.COMPANYID = X.COMPANYID AND ";
                stmt = stmt + "Z.CORA = X.CORA AND ";
                stmt = stmt + "Z.ID = X.ASSETID ";
            }
            stmt = stmt + "WHERE (X.COMPANYID = '" + companyId + "' AND X.ACCPRIN = " + ap + " AND Y.STATE = 2 AND ";
            stmt = stmt + "((Y.STRUSEYEAR * 100) + Y.STRUSEPER) <= " + yearPeriodTo + ") OR ";
            stmt = stmt + "(X.COMPANYID = '" + companyId + "' AND X.ACCPRIN = " + ap + " AND Y.STATE > 2 AND ";
            stmt = stmt + "((Y.STRUSEYEAR * 100) + Y.STRUSEPER) <= " + yearPeriodTo + " AND ";
            stmt = stmt + "((Y.FINDISYEAR * 100) + Y.FINDISPER) >= " + yearPeriodFrom + ")), ";
            stmt = stmt + "BASETABLE AS (";
            stmt = stmt + "SELECT " + nonCalcColumns + ", ";
            stmt = stmt + "COALESCE(TOTAL1, 0) AS T1, COALESCE(TOTAL2, 0) AS T2, COALESCE(TOTAL3, 0) AS T3, COALESCE(TOTAL5, 0) AS T5, ";
            stmt = stmt + "COALESCE(TOTAL6, 0) AS T6, COALESCE(TOTAL7, 0) AS T7, COALESCE(TOTAL8, 0) AS T8, COALESCE(TOTAL9, 0) AS T9, ";
            stmt = stmt + "(COALESCE(TOTAL1, 0) - COALESCE(TOTAL2, 0)) AS C1, (COALESCE(TOTAL5, 0) - COALESCE(TOTAL6, 0) + COALESCE(TOTAL7, 0)) AS C2, ";
            stmt = stmt + "(COALESCE(TOTAL1, 0) + COALESCE(TOTAL3, 0) + COALESCE(TOTAL5, 0)) AS C3, ";
            stmt = stmt + "(COALESCE(TOTAL2, 0) + COALESCE(TOTAL6, 0) + COALESCE(TOTAL8, 0)) AS C4, ";
            stmt = stmt + "(COALESCE(TOTAL1, 0) + COALESCE(TOTAL3, 0) + COALESCE(TOTAL5, 0) - COALESCE(TOTAL2, 0) - COALESCE(TOTAL6, 0) - COALESCE(TOTAL8, 0)) AS C5 ";
            stmt = stmt + "FROM MERGETABLE) ";
        }
        if (reportType == 4) {
            stmt = stmt + "WITH ";
            stmt = stmt + "OPENING_BALANCE AS (";
            stmt = stmt + "SELECT COMPANYID, CORA, CREDITID, SUM(AMOUNT1) AS TOTAL1, SUM(AMOUNT2) AS TOTAL2 ";
            stmt = stmt + "FROM " + dataLib + ".TRANSACTN ";
            stmt = stmt + "WHERE (COMPANYID = '" + companyId + "' AND CORA = 'C' AND ";
            stmt = stmt + "((JRNBOOKYR * 100) + JRNPERIOD) < " + yearPeriodFrom + " AND ";
            stmt = stmt + "(MNTRANSTYP = 1 OR MNTRANSTYP = 2 OR MNTRANSTYP = 3)) OR ";
            stmt = stmt + "(COMPANYID = '" + companyId + "' AND CORA = 'C' AND ";
            stmt = stmt + "MNTRANSTYP = 1 AND TRANSTYP = 20) ";
            stmt = stmt + "GROUP BY COMPANYID, CORA, CREDITID), ";
            stmt = stmt + "CURRENT_INVESTMENTS AS (";
            stmt = stmt + "SELECT COMPANYID, CORA, CREDITID, SUM(AMOUNT1) AS TOTAL3, SUM(AMOUNT2) AS TOTAL4 ";
            stmt = stmt + "FROM " + dataLib + ".TRANSACTN ";
            stmt = stmt + "WHERE COMPANYID = '" + companyId + "' AND CORA = 'C' AND ";
            stmt = stmt + "((JRNBOOKYR * 100) + JRNPERIOD) >= " + yearPeriodFrom + " AND ";
            stmt = stmt + "((JRNBOOKYR * 100) + JRNPERIOD) <= " + yearPeriodTo + " AND ";
            stmt = stmt + "MNTRANSTYP = 1 AND TRANSTYP <> 20 ";
            stmt = stmt + "GROUP BY COMPANYID, CORA, CREDITID), ";
            stmt = stmt + "CURRENT_DISINVESTMENTS AS (";
            stmt = stmt + "SELECT COMPANYID, CORA, CREDITID, SUM(AMOUNT1) AS TOTAL5, SUM(AMOUNT2) AS TOTAL6, SUM(AMOUNT3) AS TOTAL7 ";
            stmt = stmt + "FROM " + dataLib + ".TRANSACTN ";
            stmt = stmt + "WHERE COMPANYID = '" + companyId + "' AND CORA = 'C' AND ";
            stmt = stmt + "((JRNBOOKYR * 100) + JRNPERIOD) >= " + yearPeriodFrom + " AND ";
            stmt = stmt + "((JRNBOOKYR * 100) + JRNPERIOD) <= " + yearPeriodTo + " AND ";
            stmt = stmt + "MNTRANSTYP = 2 ";
            stmt = stmt + "GROUP BY COMPANYID, CORA, CREDITID), ";
            stmt = stmt + "DEPRECIATION_INTEREST_COSTS AS (";
            stmt = stmt + "SELECT COMPANYID, CORA, CREDITID, SUM(AMOUNT2) AS TOTAL8, SUM(AMOUNT3) AS TOTAL9 ";
            stmt = stmt + "FROM " + dataLib + ".TRANSACTN ";
            stmt = stmt + "WHERE COMPANYID = '" + companyId + "' AND CORA = 'C' AND ";
            stmt = stmt + "((JRNBOOKYR * 100) + JRNPERIOD) >= " + yearPeriodFrom + " AND ";
            stmt = stmt + "((JRNBOOKYR * 100) + JRNPERIOD) <= " + yearPeriodTo + " AND ";
            stmt = stmt + "MNTRANSTYP = 3 ";
            stmt = stmt + "GROUP BY COMPANYID, CORA, CREDITID), ";
            stmt = stmt + "CREDIT_AMOUNT AS (";
            stmt = stmt + "SELECT COMPANYID, CREDITID, SUM(DTLAMOUNT) AS TOTAL10 ";
            stmt = stmt + "FROM " + dataLib + ".DTLESTTRNS ";
            stmt = stmt + "WHERE COMPANYID = '" + companyId + "' AND ";
            stmt = stmt + "YEAR <= " + year;
            stmt = stmt + " GROUP BY COMPANYID, CREDITID), ";
            stmt = stmt + " MERGETABLE AS (";
            stmt = stmt + "SELECT X.*, ";
            stmt = stmt + "A.TOTAL1, A.TOTAL2, B.TOTAL3, C.TOTAL5, C.TOTAL6, C.TOTAL7, D.TOTAL8, D.TOTAL9, E.TOTAL10 ";
            stmt = stmt + "FROM " + dataLib + ".CREDIT AS X ";
            stmt = stmt + "LEFT OUTER JOIN OPENING_BALANCE AS A ON ";
            stmt = stmt + "A.COMPANYID = X.COMPANYID AND ";
            stmt = stmt + "A.CREDITID = X.ID ";
            stmt = stmt + "LEFT OUTER JOIN CURRENT_INVESTMENTS AS B ON ";
            stmt = stmt + "B.COMPANYID = X.COMPANYID AND ";
            stmt = stmt + "B.CREDITID= X.ID ";
            stmt = stmt + "LEFT OUTER JOIN CURRENT_DISINVESTMENTS AS C ON ";
            stmt = stmt + "C.COMPANYID = X.COMPANYID AND ";
            stmt = stmt + "C.CREDITID = X.ID ";
            stmt = stmt + "LEFT OUTER JOIN DEPRECIATION_INTEREST_COSTS AS D ON ";
            stmt = stmt + "D.COMPANYID = X.COMPANYID AND ";
            stmt = stmt + "D.CREDITID = X.ID ";
            stmt = stmt + "LEFT OUTER JOIN CREDIT_AMOUNT AS E ON ";
            stmt = stmt + "E.COMPANYID = X.COMPANYID AND ";
            stmt = stmt + "E.CREDITID = X.ID ), ";
            stmt = stmt + "BASETABLE AS (";
            stmt = stmt + "SELECT " + nonCalcColumns + ", ";
            stmt = stmt + "COALESCE(TOTAL1, 0) AS T1, COALESCE(TOTAL2, 0) AS T2, COALESCE(TOTAL3, 0) AS T3, COALESCE(TOTAL5, 0) AS T5, ";
            stmt = stmt + "COALESCE(TOTAL6, 0) AS T6, COALESCE(TOTAL7, 0) AS T7, COALESCE(TOTAL8, 0) AS T8, COALESCE(TOTAL9, 0) AS T9, ";
            stmt = stmt + "COALESCE(TOTAL10, 0) AS T10, ";
            stmt = stmt + "(COALESCE(TOTAL1, 0) - COALESCE(TOTAL2, 0)) AS C1, (COALESCE(TOTAL5, 0) - COALESCE(TOTAL6, 0) + COALESCE(TOTAL7, 0)) AS C2, ";
            stmt = stmt + "(COALESCE(TOTAL1, 0) + COALESCE(TOTAL3, 0) + COALESCE(TOTAL5, 0)) AS C3, ";
            stmt = stmt + "(COALESCE(TOTAL2, 0) + COALESCE(TOTAL6, 0) + COALESCE(TOTAL8, 0)) AS C4, ";
            stmt = stmt + "(COALESCE(TOTAL1, 0) + COALESCE(TOTAL3, 0) + COALESCE(TOTAL5, 0) - COALESCE(TOTAL2, 0) - COALESCE(TOTAL6, 0) - COALESCE(TOTAL8, 0)) AS C5 ";
            stmt = stmt + "FROM MERGETABLE) ";
        }
        return stmt;
    }
}

