/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.reports;

import java.io.FileOutputStream;
import java.util.Collection;
import java.util.Map;
import nl.ibs.fac.BatchJobHelper;
import nl.ibs.fac.IBSDecimal;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.ReportFileHelper;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.EnvironmentBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.boadapters.TransactionBatchBO;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.TransactionBatch;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.reports.CSVHelper;
import nl.ibs.fac.reports.DepreciationProposalToPDF;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;
import nl.ibs.util.Stopwatch;

public class TransactionBatchToCSV
extends CSVHelper {
    public static final String CLASSNAME = TransactionBatchToCSV.class.getName();
    private static final String FILENAME = "TransactionBatch";
    private static final String[] LABELS = new String[]{"Id", "Type", "Period", "Description", "AcquisitionValue", "DepreciationValue", "InterestValue"};
    private String[] finTexts;
    private int numberOfColumns;

    public TransactionBatchToCSV(String[][] selections, Collection collection, String[][] labels, String[] finTexts) throws Exception {
        super(selections, collection, labels, null, null);
        this.numberOfColumns = labels[0].length;
        this.finTexts = finTexts;
    }

    @Override
    protected String[] getRowValues(Object object) throws Exception {
        Transaction transaction = (Transaction)object;
        String[] value = new String[this.numberOfColumns];
        value[0] = "A".equals(transaction.getCora()) ? transaction.getAssetId() : transaction.getCreditId();
        value[1] = transaction.getProFormaTypeId();
        value[2] = PeriodHelper.toString(transaction.getBookYear(), transaction.getPeriod());
        value[3] = transaction.getDescription();
        value[4] = IBSDecimal.format(transaction.getAmount1());
        value[5] = IBSDecimal.format(transaction.getAmount2());
        value[6] = IBSDecimal.format(transaction.getAmount3());
        int i = 7;
        String finDimId1 = transaction.getFinDimId1();
        String finDimId2 = transaction.getFinDimId2();
        String finDimId3 = transaction.getFinDimId3();
        String finDimId4 = transaction.getFinDimId4();
        String finDimId5 = transaction.getFinDimId5();
        if (this.finTexts[0] != null) {
            value[i++] = finDimId1;
        }
        if (this.finTexts[1] != null) {
            value[i++] = finDimId2;
        }
        if (this.finTexts[2] != null) {
            value[i++] = finDimId3;
        }
        if (this.finTexts[3] != null) {
            value[i++] = finDimId4;
        }
        if (this.finTexts[4] != null) {
            value[i++] = finDimId5;
        }
        return value;
    }

    public static void main(String[] args) {
        Stopwatch sw = null;
        if (Log.debug()) {
            sw = new Stopwatch();
            sw.start();
        }
        try {
            TransactionBatchToCSV.execute(args);
        }
        catch (Exception e) {
            Log.error((Exception)e);
            System.exit(-1);
        }
        if (sw != null) {
            Log.debug((String)("Elapsed time: " + sw.stop(1) + " seconds"));
        }
        System.exit(0);
    }

    public static void execute(String[] args) throws Exception {
        TransactionBatch transactionBatch;
        if (Log.debug() && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                Log.debug((String)args[i]);
            }
        }
        String[][] selections = BatchJobHelper.getSelections(args);
        Map map = BatchJobHelper.getSelections(selections);
        String companyId = (String)map.get("Company");
        DBData dbData = BOAdapter.getDBData(map);
        Environment env = (Environment)EnvironmentBO.get((String)map.get("facLib"))[0];
        if (map.containsKey("batchId")) {
            int batchId = Integer.parseInt((String)map.get("batchId"));
            transactionBatch = (TransactionBatch)TransactionBatchBO.get(dbData, companyId, batchId)[0];
        } else {
            transactionBatch = (TransactionBatch)CompanyBO.getCurrentBatch(dbData, companyId)[0];
            if (transactionBatch != null) {
                map.put("batchId", "" + transactionBatch.getBatchId());
            }
        }
        if (transactionBatch == null) {
            String message = LanguageHelper.getString("nl.ibs.fac.language", "batch_not_found");
            Log.error((String)message);
            return;
        }
        map.put("governmentActivated", new Boolean(env.getGovernmentActivated()));
        String[][] modifiedSelections = DepreciationProposalToPDF.modifySelections(selections, env, transactionBatch);
        TransactionBatchToCSV.processAccountingPrinciple(args, map, modifiedSelections, env, transactionBatch, false);
        TransactionBatchToCSV.processAccountingPrinciple(args, map, modifiedSelections, env, transactionBatch, true);
    }

    private static void processAccountingPrinciple(String[] args, Map map, String[][] modifiedSelections, Environment environment, TransactionBatch transactionBatch, boolean ap2) throws Exception {
        int i;
        if (ap2) {
            map.remove("AccountingPrinciple2");
            modifiedSelections[5][1] = environment.getGovernmentActivated() ? ": " + environment.getAPName3() : ": " + environment.getAPName2();
        } else {
            modifiedSelections[5][1] = ": " + environment.getAPName1();
        }
        map.put("AccountingPrinciple2", new Boolean(ap2));
        Collection transactions = TransactionBO.getTransactions(map, transactionBatch);
        if (transactions.isEmpty()) {
            return;
        }
        DBData dbData = transactionBatch.getDBData();
        String companyId = (String)map.get("Company");
        Company company = (Company)CompanyBO.get(dbData, companyId)[0];
        String[] finTexts = new String[5];
        if (company.retrieveFinancialDimension1Usage() != 0) {
            finTexts[0] = environment.getName1();
        }
        if (company.retrieveFinancialDimension2Usage() != 0) {
            finTexts[1] = environment.getName2();
        }
        if (company.retrieveFinancialDimension3Usage() != 0) {
            finTexts[2] = environment.getName3();
        }
        if (company.retrieveFinancialDimension4Usage() != 0) {
            finTexts[3] = environment.getName4();
        }
        if (company.retrieveFinancialDimension5Usage() != 0) {
            finTexts[4] = environment.getName5();
        }
        int numberOfDims = 0;
        for (int i2 = 0; i2 < finTexts.length; ++i2) {
            if (finTexts[i2] == null) continue;
            ++numberOfDims;
        }
        String[][] labels = new String[1][LABELS.length + numberOfDims];
        int index = 0;
        for (i = 0; i < LABELS.length; ++i) {
            labels[0][index++] = LABELS[i];
        }
        for (i = 0; i < finTexts.length; ++i) {
            if (finTexts[i] == null) continue;
            labels[0][index++] = finTexts[i];
        }
        TransactionBatchToCSV transactionBatchToCSV = new TransactionBatchToCSV(modifiedSelections, transactions, labels, finTexts);
        FileOutputStream fos = new FileOutputStream(ReportFileHelper.getFileName(args, LanguageHelper.getString("nl.ibs.fac.language", FILENAME) + '-' + modifiedSelections[5][1].substring(2), "csv"));
        fos.write(transactionBatchToCSV.createCsv());
        fos.close();
    }
}

