/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.ui;

import java.util.Map;
import nl.ibs.esp.event.EventListener;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.InputComponent;
import nl.ibs.esp.uiobjects.Panel;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.fac.ui.ApplicationSettings;

public class ApplicationSettingsPanel
extends Panel {
    private static final long serialVersionUID = 1622398663740429185L;
    private ApplicationSettings applicationSettings;
    private Field report;
    private Field mailserver;
    private Field mailport;
    private Field defaultMail;

    public ApplicationSettingsPanel(final Map settings) throws Exception {
        this("Settings", new ApplicationSettings(){
            private static final long serialVersionUID = -7630892858850759557L;

            @Override
            public String getValue(String key) {
                Object value = settings.get(key);
                return value == null ? null : String.valueOf(value);
            }

            @Override
            public void setValue(String key, String value) {
                settings.put(key, value);
            }
        });
    }

    public ApplicationSettingsPanel(String headerLabel, ApplicationSettings applicationSettings) throws Exception {
        this.applicationSettings = applicationSettings;
        if (headerLabel != null && headerLabel.trim().length() == 0) {
            this.addUIObject((UIObject)new Header(headerLabel, "screen_name"));
        }
        this.addUIObject((UIObject)this.createMailfieldGroup());
    }

    private FieldGroup createMailfieldGroup() throws Exception {
        FieldGroup mailFieldGroup = new FieldGroup("mail");
        this.defaultMail = new Field("defaultMail");
        this.defaultMail.setName("defaultMail");
        this.defaultMail.setLength(50);
        this.defaultMail.setMaxLength(50);
        mailFieldGroup.add(this.defaultMail);
        this.initialize((InputComponent)this.defaultMail);
        this.mailserver = new Field("mailserver");
        this.mailserver.setName("mailserver");
        mailFieldGroup.add(this.mailserver);
        this.initialize((InputComponent)this.mailserver);
        this.mailport = new Field("mailport", "number");
        this.mailport.setName("mailport");
        this.mailport.setLength(5);
        this.mailport.setMaxLength(5);
        this.mailport.setValue("25");
        mailFieldGroup.add(this.mailport);
        this.initialize((InputComponent)this.mailport);
        return mailFieldGroup;
    }

    private void initialize(InputComponent inputComponent) {
        String value = this.applicationSettings.getValue(inputComponent.getName());
        if (value != null && value.trim().length() > 0) {
            inputComponent.setValueAsString(value);
        }
        inputComponent.addOnChangeListener(new EventListener(){
            private static final long serialVersionUID = 1L;

            public void event(UIObject object, String type) throws Exception {
                ApplicationSettingsPanel.this.applicationSettings.setValue(object.getName(), ((InputComponent)object).getValue());
            }
        });
    }
}

