/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.ui;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.layout.ESPGridLayout;
import nl.ibs.esp.uiobjects.CheckBox;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FilterTable;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Panel;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.adapters.FISReferenceField;
import nl.ibs.fac.adapters.FMSReferenceField;
import nl.ibs.fac.adapters.FinancialReferenceField;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.IncomingFinancialTransactionBO;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.fis.FISHelper;
import nl.ibs.fac.fms.FMSHelper;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.jsql.DBData;

public class IncomingFinancialTransactionSelection
implements Serializable {
    private static final long serialVersionUID = 7579546489571469531L;
    public static final String IFTSELECTION = IncomingFinancialTransactionSelection.class.getName();
    private Environment environment;
    private static final String[] FIELDNAMES = new String[]{"mainAccount", "finDimId1", "finDimId2", "finDimId3", "finDimId4", "finDimId5"};
    private static int _finApp = 0;
    private static int _library = 1;
    private static int _companyId = 2;
    private static int _bookYear = 3;
    private static int _dimText0 = 4;
    private static int _dimText1 = 5;
    private static int _dimText2 = 6;
    private static int _dimText3 = 7;
    private static int _dimText4 = 8;
    private static int _dimText5 = 9;
    private static int _dimFROM0 = 10;
    private static int _dimTO0 = 11;
    private static int _dimFROM1 = 12;
    private static int _dimTO1 = 13;
    private static int _dimFROM2 = 14;
    private static int _dimTO2 = 15;
    private static int _dimFROM3 = 16;
    private static int _dimTO3 = 17;
    private static int _dimFROM4 = 18;
    private static int _dimTO4 = 19;
    private static int _dimFROM5 = 20;
    private static int _dimTO5 = 21;
    private static int _justTotals = 22;
    private static int _grandTotal = 23;
    private static int _sortering = 24;
    private static int _levels = 25;
    private static int _bookYearFrom = 26;
    private static int _periodFrom = 27;
    private static int _bookYearTo = 28;
    private static int _periodTo = 29;
    private static int MAX = 30;
    private String finApp = null;
    private String library = null;
    private Company company = null;
    private String companyId = null;
    private String bookYear = null;
    private String bookYearFrom = null;
    private String bookYearTo = null;
    private String periodFrom = null;
    private String periodTo = null;
    private DBData dbData = null;
    private String SEPARATOR = ";";
    private String sortering = "";
    private String levels = "";
    private String[] levelName = new String[9];
    private String[] dimText = new String[]{"", "", "", "", "", ""};
    private String[] dimFROM = new String[]{"", "", "", "", "", ""};
    private String[] dimTO = new String[]{"", "", "", "", "", ""};
    private FinancialReferenceField[] fldDimFROM = new FinancialReferenceField[6];
    private FinancialReferenceField[] fldDimTO = new FinancialReferenceField[6];
    public CheckBox fldJustTotals = null;
    public CheckBox fldGrandTotal = null;
    private boolean justTotals = false;
    private boolean grandTotal = false;
    private boolean[] used = new boolean[]{true, true, true, true, true, true};
    private StringBuffer sb = new StringBuffer();
    private FilterTable table;
    private FieldGroup screen = null;
    private boolean dspatr_showDim;
    private boolean dspatr_showJustTotals;
    private boolean dspatr_showGrandTotal;
    private boolean dspatr_showSortable;
    private boolean dspatr_showTotalizable;
    public boolean hideFieldGroup;
    private Company dataSet;

    public void setBookYearFrom(String bookYearFrom) {
        this.bookYearFrom = bookYearFrom;
    }

    public void setBookYearTo(String bookYearTo) {
        this.bookYearTo = bookYearTo;
    }

    public void setPeriodFrom(String periodFrom) {
        this.periodFrom = periodFrom;
    }

    public void setPeriodTo(String periodTo) {
        this.periodTo = periodTo;
    }

    public IncomingFinancialTransactionSelection(DataObject object) throws Exception {
        this.environment = (Environment)object.getSessionAttribute("ActiveEnvironment");
        this.companyId = (String)object.getSessionAttribute("ActiveCompany");
        this.bookYear = (String)object.getSessionAttribute("ActiveBookYear");
        this.bookYearFrom = (String)object.getSessionAttribute("BookYearFrom");
        this.periodFrom = (String)object.getSessionAttribute("PeriodFrom");
        this.bookYearFrom = (String)object.getSessionAttribute("BookYearTo");
        this.periodTo = (String)object.getSessionAttribute("PeriodTo");
        this.finApp = this.environment.getOperationArea().length() == 0 ? "FIS" : "FMS";
        this.library = this.environment.getFacLib();
        this.dimText[0] = LanguageHelper.getString("nl.ibs.fac.language", "MainAccount");
        this.dimText[1] = this.environment.getName1();
        this.dimText[2] = this.environment.getName2();
        this.dimText[3] = this.environment.getName3();
        this.dimText[4] = this.environment.getName4();
        this.dimText[5] = this.environment.getName5();
        this.init();
    }

    public IncomingFinancialTransactionSelection(String stringRepresentation) throws Exception {
        this.split(stringRepresentation);
        this.init();
    }

    private void init() throws Exception {
        this.dbData = BOAdapter.getDBData(this.library);
        this.company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        this.used[0] = true;
        this.dataSet = this.company.getDataSet();
        if (this.dataSet == null) {
            this.dataSet = this.company;
        }
        this.used[1] = this.dataSet.getFinancialDimension1Usage() != 0;
        this.used[2] = this.dataSet.getFinancialDimension2Usage() != 0;
        this.used[3] = this.dataSet.getFinancialDimension3Usage() != 0;
        this.used[4] = this.dataSet.getFinancialDimension4Usage() != 0;
        this.used[5] = this.dataSet.getFinancialDimension5Usage() != 0;
        this.levelName[0] = LanguageHelper.getString("nl.ibs.fac.language", "General");
        this.levelName[1] = this.dimText[0];
        this.levelName[2] = this.dimText[1];
        this.levelName[3] = this.dimText[2];
        this.levelName[4] = this.dimText[3];
        this.levelName[5] = this.dimText[4];
        this.levelName[6] = this.dimText[5];
        this.levelName[7] = LanguageHelper.getString("nl.ibs.fac.language", "Type");
        this.levelName[8] = LanguageHelper.getString("nl.ibs.fac.language", "Asset");
    }

    private void getScreenValues() {
        for (int i = 0; i < 6; ++i) {
            if (!this.used[i]) continue;
            this.dimFROM[i] = this.fldDimFROM[i].getFormattedId();
            this.dimTO[i] = this.fldDimTO[i].getFormattedId();
        }
        this.justTotals = this.fldJustTotals.getBoolean();
        this.grandTotal = this.fldGrandTotal.getBoolean();
        this.sortering = this.table.getOrderBy();
        this.levels = this.table.getLevels();
    }

    public void setDisplayAttributes(boolean showDim, boolean showJustTotals, boolean showGrandTotal, boolean showSortable, boolean showTotalizable) throws Exception {
        this.dspatr_showDim = showDim;
        this.dspatr_showJustTotals = showJustTotals;
        this.dspatr_showGrandTotal = showGrandTotal;
        this.dspatr_showSortable = showSortable;
        this.dspatr_showTotalizable = showTotalizable;
    }

    public Panel getSelectionPanel(LoginHelper loginHelper) throws Exception {
        Panel screen = new Panel();
        FieldGroup fg = new FieldGroup(LanguageHelper.getString("nl.ibs.fac.language", "SelectSort"));
        ESPGridLayout grid = new ESPGridLayout();
        this.table = new FilterTable(FIELDNAMES, this.dspatr_showSortable, this.dspatr_showTotalizable, false, 100);
        this.table.setName("IncomingFinancialTransactionSelection");
        for (int index = 0; index < this.dimText.length; ++index) {
            if (this.dimText[index].length() == 0) continue;
            if (this.finApp.equals("FIS")) {
                this.fldDimFROM[index] = new FISReferenceField(loginHelper, this.dimText[index], index, this.dataSet);
                this.fldDimTO[index] = new FISReferenceField(loginHelper, this.dimText[index], index, this.dataSet);
            } else {
                this.fldDimFROM[index] = new FMSReferenceField(loginHelper, this.dimText[index], index, this.dataSet);
                this.fldDimTO[index] = new FMSReferenceField(loginHelper, this.dimText[index], index, this.dataSet);
            }
            this.fldDimFROM[index].setValue(this.dimFROM[index]);
            this.fldDimTO[index].setValue(this.dimTO[index]);
            if (!this.dspatr_showDim || !this.used[index]) continue;
            this.table.addRow(index, (Field)this.fldDimFROM[index], (Field)this.fldDimTO[index]);
        }
        this.table.reload();
        grid.add((UIObject)this.table, 0, 1);
        FloatBar fb = new FloatBar();
        fb.alignment(1);
        fb.addAction(this.table.getClearAction());
        grid.add((UIObject)fb, 1, 1);
        fg.add(grid);
        screen.addUIObject((UIObject)fg);
        fg = new FieldGroup(LanguageHelper.getString("nl.ibs.fac.language", "Miscellaneous"));
        this.fldJustTotals = new CheckBox(LanguageHelper.getString("nl.ibs.fac.language", "JustTotals"));
        this.fldJustTotals.setValue(this.justTotals);
        if (this.dspatr_showJustTotals) {
            fg.add(this.fldJustTotals);
        }
        this.fldGrandTotal = new CheckBox(LanguageHelper.getString("nl.ibs.fac.language", "PrintGrandTotal"));
        this.fldGrandTotal.setValue(this.grandTotal);
        if (this.dspatr_showGrandTotal) {
            fg.add(this.fldGrandTotal);
        }
        if (!this.hideFieldGroup) {
            screen.addUIObject((UIObject)fg);
        }
        return screen;
    }

    public boolean[] getLevelBreakFields() {
        boolean[] lvl = new boolean[9];
        lvl[0] = this.grandTotal;
        for (int i = 0; i < this.levels.length(); ++i) {
            if (this.levels.charAt(i) == '0') continue;
            lvl[i + 1] = true;
        }
        return lvl;
    }

    public String getLevelBreakFieldsAsString() {
        this.sb = new StringBuffer();
        boolean[] lvl = this.getLevelBreakFields();
        for (int i = 1; i < lvl.length; ++i) {
            if (!lvl[i]) continue;
            if (this.sb.length() > 0) {
                this.sb.append(", ");
            }
            this.sb.append(this.levelName[i]);
        }
        return this.sb.toString();
    }

    public int[] getOrderBy() {
        int[] result = new int[9];
        for (int i = 0; i < result.length; ++i) {
            result[i] = -1;
        }
        int nr = 0;
        String[] orderBy = this.sortering.split(",");
        String s = null;
        for (int i = 0; i < orderBy.length; ++i) {
            s = orderBy[i].trim().toLowerCase();
            if (s.equals("mainaccount")) {
                result[nr++] = 1;
                continue;
            }
            if (s.equals("findimid1")) {
                result[nr++] = 2;
                continue;
            }
            if (s.equals("findimid2")) {
                result[nr++] = 3;
                continue;
            }
            if (s.equals("findimid3")) {
                result[nr++] = 4;
                continue;
            }
            if (s.equals("findimid4")) {
                result[nr++] = 5;
                continue;
            }
            if (s.equals("findimid5")) {
                result[nr++] = 6;
                continue;
            }
            if (s.equals("typeid")) {
                result[nr++] = 7;
                continue;
            }
            if (!s.equals("id")) continue;
            result[nr++] = 8;
        }
        return result;
    }

    public String getOrderByAsString() {
        this.sb = new StringBuffer();
        int[] orderBy = this.getOrderBy();
        int x = 0;
        for (int i = 0; i < orderBy.length; ++i) {
            x = orderBy[i];
            if (x <= 0) continue;
            if (this.sb.length() > 0) {
                this.sb.append(", ");
            }
            this.sb.append(this.levelName[x]);
        }
        return this.sb.toString();
    }

    public boolean getJustTotals() {
        return this.justTotals;
    }

    public boolean getGrandTotal() {
        return this.grandTotal;
    }

    public Collection getCollection() throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("facLib", this.library);
        map.put("Company", this.companyId);
        map.put("BookYearFrom", this.bookYearFrom);
        map.put("PeriodFrom", this.periodFrom);
        map.put("BookYearTo", this.bookYearTo);
        map.put("PeriodTo", this.periodTo);
        map.put("MainAccountFrom", this.dimFROM[0]);
        map.put("MainAccountTo", this.dimTO[0]);
        map.put("FinDimId1From", this.dimFROM[1]);
        map.put("FinDimId1To", this.dimTO[1]);
        map.put("FinDimId2From", this.dimFROM[2]);
        map.put("FinDimId2To", this.dimTO[2]);
        map.put("FinDimId3From", this.dimFROM[3]);
        map.put("FinDimId3To", this.dimTO[3]);
        map.put("FinDimId4From", this.dimFROM[4]);
        map.put("FinDimId4To", this.dimTO[4]);
        map.put("FinDimId5From", this.dimFROM[5]);
        map.put("FinDimId5To", this.dimTO[5]);
        map.put("Confirmed", Boolean.FALSE);
        map.put("orderBy", this.sortering);
        return IncomingFinancialTransactionBO.getIncomingFinancialTransactions(map, true);
    }

    public void save() throws Exception {
        this.table.save();
    }

    public String getStringRepresentation() throws Exception {
        this.getScreenValues();
        this.sb = new StringBuffer();
        this.append(_finApp, this.finApp);
        this.append(_library, this.library);
        this.append(_companyId, this.companyId);
        this.append(_bookYear, this.bookYear);
        this.append(_dimText0, this.dimText[0]);
        this.append(_dimText1, this.dimText[1]);
        this.append(_dimText2, this.dimText[2]);
        this.append(_dimText3, this.dimText[3]);
        this.append(_dimText4, this.dimText[4]);
        this.append(_dimText5, this.dimText[5]);
        this.append(_dimFROM0, this.dimFROM[0]);
        this.append(_dimTO0, this.dimTO[0]);
        this.append(_dimFROM1, this.dimFROM[1]);
        this.append(_dimTO1, this.dimTO[1]);
        this.append(_dimFROM2, this.dimFROM[2]);
        this.append(_dimTO2, this.dimTO[2]);
        this.append(_dimFROM3, this.dimFROM[3]);
        this.append(_dimTO3, this.dimTO[3]);
        this.append(_dimFROM4, this.dimFROM[4]);
        this.append(_dimTO4, this.dimTO[4]);
        this.append(_dimFROM5, this.dimFROM[5]);
        this.append(_dimTO5, this.dimTO[5]);
        this.append(_justTotals, Boolean.toString(this.justTotals));
        this.append(_grandTotal, Boolean.toString(this.grandTotal));
        this.append(_sortering, this.sortering);
        this.append(_levels, this.levels);
        this.append(_bookYearFrom, this.bookYearFrom);
        this.append(_periodFrom, this.periodFrom);
        this.append(_bookYearTo, this.bookYearTo);
        this.append(_periodTo, this.periodTo);
        return this.sb.toString();
    }

    private void append(int i, String s) {
        if (s == null) {
            s = "";
        }
        if (s.length() > 0) {
            this.sb.append(i);
            this.sb.append("=");
            this.sb.append(s);
            this.sb.append(this.SEPARATOR);
        }
    }

    private void split(String stringRepresentation) throws Exception {
        String[] tokens = stringRepresentation.split(this.SEPARATOR);
        String[] val = new String[MAX];
        String[] nameValuePair = null;
        int fld = 0;
        for (int i = 0; i < tokens.length; ++i) {
            nameValuePair = tokens[i].split("=");
            fld = Integer.parseInt(nameValuePair[0]);
            val[fld] = nameValuePair[1];
        }
        this.finApp = val[_finApp] == null ? "" : val[_finApp];
        this.library = val[_library] == null ? "" : val[_library];
        this.companyId = val[_companyId] == null ? "" : val[_companyId];
        this.bookYear = val[_bookYear] == null ? "" : val[_bookYear];
        this.bookYearFrom = val[_bookYearFrom] == null ? "" : val[_bookYearFrom];
        this.periodFrom = val[_periodFrom] == null ? "" : val[_periodFrom];
        this.bookYearTo = val[_bookYearTo] == null ? "" : val[_bookYearTo];
        this.periodTo = val[_periodTo] == null ? "" : val[_periodTo];
        this.dimText[0] = val[_dimText0] == null ? "" : val[_dimText0];
        this.dimText[1] = val[_dimText1] == null ? "" : val[_dimText1];
        this.dimText[2] = val[_dimText2] == null ? "" : val[_dimText2];
        this.dimText[3] = val[_dimText3] == null ? "" : val[_dimText3];
        this.dimText[4] = val[_dimText4] == null ? "" : val[_dimText4];
        this.dimText[5] = val[_dimText5] == null ? "" : val[_dimText5];
        this.dimFROM[0] = val[_dimFROM0] == null ? "" : val[_dimFROM0];
        this.dimTO[0] = val[_dimTO0] == null ? "" : val[_dimTO0];
        this.dimFROM[1] = val[_dimFROM1] == null ? "" : val[_dimFROM1];
        this.dimTO[1] = val[_dimTO1] == null ? "" : val[_dimTO1];
        this.dimFROM[2] = val[_dimFROM2] == null ? "" : val[_dimFROM2];
        this.dimTO[2] = val[_dimTO2] == null ? "" : val[_dimTO2];
        this.dimFROM[3] = val[_dimFROM3] == null ? "" : val[_dimFROM3];
        this.dimTO[3] = val[_dimTO3] == null ? "" : val[_dimTO3];
        this.dimFROM[4] = val[_dimFROM4] == null ? "" : val[_dimFROM4];
        this.dimTO[4] = val[_dimTO4] == null ? "" : val[_dimTO4];
        this.dimFROM[5] = val[_dimFROM5] == null ? "" : val[_dimFROM5];
        this.dimTO[5] = val[_dimTO5] == null ? "" : val[_dimTO5];
        this.justTotals = Boolean.valueOf(val[_justTotals]);
        this.grandTotal = Boolean.valueOf(val[_grandTotal]);
        this.sortering = val[_sortering] == null ? "" : val[_sortering];
        this.levels = val[_levels] == null ? "0000000" : val[_levels];
    }

    public String toString(FISHelper fisHelper, FMSHelper fmsHelper) throws Exception {
        if (this.screen != null) {
            this.getScreenValues();
        }
        StringBuffer bf = new StringBuffer();
        boolean first = true;
        if (this.dimFROM[0].length() > 0 || this.dimTO[0].length() > 0) {
            first = false;
            bf.append("MainAccount: ");
            if (fisHelper != null) {
                bf.append(FISHelper.unFormatId(this.dimFROM[0]));
                bf.append("-");
                bf.append(FISHelper.unFormatId(this.dimTO[0]));
            }
            if (fmsHelper != null) {
                bf.append(fmsHelper.unFormatId(this.dimFROM[0], 0));
                bf.append("-");
                bf.append(fmsHelper.unFormatId(this.dimTO[0], 0));
            }
        }
        for (int i = 1; i <= 5; ++i) {
            if (this.dimFROM[i].length() <= 0 && this.dimTO[i].length() <= 0) continue;
            if (first) {
                first = false;
            } else {
                bf.append(", ");
            }
            bf.append(this.dimText[i] + ": ");
            if (fisHelper != null) {
                bf.append(FISHelper.unFormatId(this.dimFROM[i]));
                bf.append("-");
                bf.append(FISHelper.unFormatId(this.dimTO[i]));
            }
            if (fmsHelper == null) continue;
            bf.append(fmsHelper.unFormatId(this.dimFROM[i], i + 1));
            bf.append("-");
            bf.append(fmsHelper.unFormatId(this.dimTO[i], i + 1));
        }
        if (this.getOrderByAsString().trim().length() > 0) {
            bf.append("\nSorteren op: ");
            bf.append(this.getOrderByAsString());
        }
        if (this.getLevelBreakFieldsAsString().trim().length() > 0) {
            bf.append("\nTotaliseren op: ");
            bf.append(this.getLevelBreakFieldsAsString());
        }
        bf.append("\nAlleen totalen: ");
        bf.append(LanguageHelper.getString(this.justTotals));
        if (this.levels.trim().length() > 0) {
            bf.append("\nAfdrukken tot.generaal: ");
            bf.append(LanguageHelper.getString(this.grandTotal));
        }
        return bf.toString();
    }
}

