/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.usertool;

import java.math.BigDecimal;
import java.util.Collection;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.CreditBalance;
import nl.ibs.fac.db.CreditBalanceDetail;
import nl.ibs.fac.db.CreditBalanceDetailManagerFactory;
import nl.ibs.fac.db.CreditBalanceManagerFactory;
import nl.ibs.fac.db.IncomingFinancialTransaction;
import nl.ibs.fac.db.IncomingFinancialTransactionManagerFactory;
import nl.ibs.fac.gov.bp.CreditBalanceBP;
import nl.ibs.fac.usertool.FACUserTool;
import nl.ibs.fac.usertool.FACUserToolInvokeAdapter;
import nl.ibs.jsql.ExecutableQuery;
import nl.ibs.jsql.QueryFactory;

public class CreditBalanceUpdate
implements FACUserTool {
    FACUserToolInvokeAdapter invokeAdapter;
    private static final BigDecimal ZERO = new BigDecimal(0);

    @Override
    public void execute(String[] parameterValues) throws Exception {
        Company company = this.invokeAdapter.getCompany();
        if (company == null) {
            throw new IllegalArgumentException("Er is geen bedrijf actief !");
        }
        CreditBalanceBP bp = new CreditBalanceBP(company);
        ExecutableQuery query = QueryFactory.create(CreditBalance.class);
        query.setFilter("companyId = '" + company.getId() + "'");
        Collection balances = CreditBalanceManagerFactory.getInstance(company.getDBData()).getCollection(query);
        for (CreditBalance balance : balances) {
            bp.handleBalanceIsDirty(balance);
            balance.setTotalBalanceAmount(ZERO);
            String mainAccount = balance.getGLAccountId();
            ExecutableQuery query2 = QueryFactory.create(CreditBalanceDetail.class);
            query2.setFilter("companyId = '" + company.getId() + "' AND " + "gLAccountId" + " = '" + mainAccount + "'");
            Collection details = CreditBalanceDetailManagerFactory.getInstance(company.getDBData()).getCollection(query2);
            for (CreditBalanceDetail detail : details) {
                detail.setBalanceAmount1(ZERO);
                detail.setBalanceAmount2(ZERO);
                detail.setBalanceAmount3(ZERO);
            }
            ExecutableQuery query3 = QueryFactory.create(IncomingFinancialTransaction.class);
            query3.setFilter("companyId = '" + company.getId() + "' AND " + "mainAccount" + " = '" + mainAccount + "'");
            Collection transactions = IncomingFinancialTransactionManagerFactory.getInstance(company.getDBData()).getCollection(query3);
            for (IncomingFinancialTransaction ift : transactions) {
                ift.setIsNew(true);
                balance.setTotalBalanceAmount(balance.getTotalBalanceAmount().add(ift.getTransactionValue()));
            }
            if (balance == null) continue;
            balance.setIsDirty(true);
            bp.handleBalanceIsDirty(balance);
        }
    }

    @Override
    public FieldGroup getFieldGroup() throws Exception {
        return null;
    }

    @Override
    public String[] validate() throws Exception {
        return null;
    }

    @Override
    public String[] getParameterDescriptions() throws Exception {
        return null;
    }

    @Override
    public String getProgramDescription() throws Exception {
        return null;
    }

    @Override
    public String getCompletionMessage() throws Exception {
        return null;
    }

    @Override
    public boolean getAS400WriterNeeded() throws Exception {
        return false;
    }

    @Override
    public void setInvoker(FACUserToolInvokeAdapter invokeAdapter) throws Exception {
        this.invokeAdapter = invokeAdapter;
    }
}

