/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.usertool;

import java.util.Collection;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.UserMessageException;
import nl.ibs.fac.db.CreditBalance;
import nl.ibs.fac.db.CreditBalanceDetail;
import nl.ibs.fac.db.CreditBalanceManagerFactory;
import nl.ibs.fac.db.IncomingFinancialTransaction;
import nl.ibs.fac.db.IncomingFinancialTransactionManagerFactory;
import nl.ibs.fac.db.IncomingFinancialTransactionPK;
import nl.ibs.fac.gov.boadapters.CreditBalanceBO;
import nl.ibs.fac.gov.boadapters.CreditBalanceDetailBO;
import nl.ibs.fac.usertool.FACUserTool;
import nl.ibs.fac.usertool.FACUserToolInvokeAdapter;
import nl.ibs.jsql.exception.FinderException;

public class DeleteIFT
implements FACUserTool {
    FACUserToolInvokeAdapter invokeAdapter;

    @Override
    public void execute(String[] parameterValues) throws Exception {
        CreditBalance creditBalance;
        IncomingFinancialTransaction ift;
        String companyId = this.invokeAdapter.getCompanyId();
        if (companyId == null) {
            throw new IllegalArgumentException("Er is geen bedrijf actief !");
        }
        Collection balances = CreditBalanceManagerFactory.getInstance(this.invokeAdapter.getCompany().getDBData()).getCollection(null);
        for (CreditBalance balance : balances) {
            if (!balance.getIsDirty()) continue;
            throw new UserMessageException("first run UpdateBalances");
        }
        String id = parameterValues[0];
        IncomingFinancialTransactionPK key = new IncomingFinancialTransactionPK();
        key.setCompanyId(companyId);
        key.setId(id);
        try {
            ift = IncomingFinancialTransactionManagerFactory.getInstance(this.invokeAdapter.getCompany().getDBData()).findByPrimaryKey(key);
        }
        catch (FinderException ex) {
            throw new UserMessageException("id not found");
        }
        Object[] objects = CreditBalanceDetailBO.get(this.invokeAdapter.getCompany(), ift.getMainAccount(), ift.getBookYear(), 0);
        if (objects[0] != null) {
            CreditBalanceDetail detail = (CreditBalanceDetail)objects[0];
            switch (ift.getBBVCategory()) {
                case 0: {
                    detail.setBalanceAmount1(detail.getBalanceAmount1().subtract(ift.getTransactionValue()));
                    break;
                }
                case 1: {
                    detail.setBalanceAmount2(detail.getBalanceAmount2().subtract(ift.getTransactionValue()));
                    break;
                }
                case 2: {
                    detail.setBalanceAmount3(detail.getBalanceAmount3().subtract(ift.getTransactionValue()));
                }
            }
        }
        if ((creditBalance = (CreditBalance)CreditBalanceBO.get(this.invokeAdapter.getCompany(), ift.getMainAccount())[0]) != null) {
            creditBalance.setTotalBalanceAmount(creditBalance.getTotalBalanceAmount().subtract(ift.getTransactionValue()));
        }
        ift.delete();
    }

    @Override
    public FieldGroup getFieldGroup() throws Exception {
        return null;
    }

    @Override
    public String[] validate() throws Exception {
        return null;
    }

    @Override
    public String[] getParameterDescriptions() throws Exception {
        return new String[]{"Id"};
    }

    @Override
    public String getProgramDescription() throws Exception {
        return null;
    }

    @Override
    public String getCompletionMessage() throws Exception {
        return null;
    }

    @Override
    public boolean getAS400WriterNeeded() throws Exception {
        return false;
    }

    @Override
    public void setInvoker(FACUserToolInvokeAdapter invokeAdapter) throws Exception {
        this.invokeAdapter = invokeAdapter;
    }
}

