/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.usertool;

import com.ibm.as400.access.AS400;
import java.math.BigDecimal;
import nl.ibs.api.fms.AlabxfrAdapter;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.db.IncomingFinancialTransaction;
import nl.ibs.fac.db.IncomingFinancialTransactionManagerFactory;
import nl.ibs.fac.usertool.FACUserTool;
import nl.ibs.fac.usertool.FACUserToolInvokeAdapter;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.ExecutableQuery;
import nl.ibs.jsql.QueryFactory;

public class FACIFT
implements FACUserTool {
    private FACUserToolInvokeAdapter invokeAdapter;

    @Override
    public String[] getParameterDescriptions() throws Exception {
        return null;
    }

    @Override
    public void execute(String[] parameterValues) throws Exception {
        Environment env = this.invokeAdapter.getEnvironment();
        if (env.getOperationArea().length() == 0) {
            throw new IllegalArgumentException("Er is geen FMS omgeving actief !");
        }
        AlabxfrAdapter alabxfr = new AlabxfrAdapter((AS400)this.invokeAdapter.getLoginHelper().getAs400());
        ExecutableQuery query = QueryFactory.create(IncomingFinancialTransaction.class);
        query.setFilter("voucherId = ''");
        for (IncomingFinancialTransaction ift : IncomingFinancialTransactionManagerFactory.getInstance(this.invokeAdapter.getDBData()).getCollection(query)) {
            alabxfr.setP1PARMP1AACD(ift.getCompanyId());
            alabxfr.setP1PARMP1ABCD("" + ift.getBookYear());
            alabxfr.setP1PARMP1AQNB(new BigDecimal(ift.getSystemItemNumber()));
            boolean ok = alabxfr.execute();
            if (!ok) {
                Log.error((String)alabxfr.getFirstMessage());
                throw new IllegalArgumentException(alabxfr.getFirstMessage());
            }
            if (alabxfr.getP0RTN().trim().length() != 0) continue;
            ift.setVoucherId(alabxfr.getP1PARMP1HKTX());
            ift.setDocumentId(alabxfr.getP1PARMP1YHTK());
            ift.setInternalInvoiceId(alabxfr.getP1PARMP1LKNO().longValue());
        }
    }

    @Override
    public FieldGroup getFieldGroup() throws Exception {
        return null;
    }

    @Override
    public String[] validate() throws Exception {
        return null;
    }

    @Override
    public String getProgramDescription() throws Exception {
        return null;
    }

    @Override
    public String getCompletionMessage() throws Exception {
        return null;
    }

    @Override
    public boolean getAS400WriterNeeded() throws Exception {
        return true;
    }

    @Override
    public void setInvoker(FACUserToolInvokeAdapter invokeAdapter) throws Exception {
        this.invokeAdapter = invokeAdapter;
    }
}

