/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.usertool;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import nl.ibs.esp.adapter.Adapter;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FileSelectionField;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.fac.FacConstants;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.adapters.FACAdapter;
import nl.ibs.fac.usertool.FACUserToolUploadAdapter;
import nl.ibs.jeelog.Log;

public class FACPatchUploadAdapter
extends FACAdapter {
    private static final long serialVersionUID = 3062537039083027310L;
    public static String PAGE = FACUserToolUploadAdapter.class.getName();
    private Header header = new Header("Upload patch", "screen_name", null);
    private FieldGroup fieldGroup = new FieldGroup();
    private FileSelectionField uploadFile = new FileSelectionField("Patch file");
    private Field uploadedFile = new Field("Patch file");
    private FloatBar floatBar = new FloatBar();
    private static final String UPDATE_PATH = "Update-Path";
    private final String[] cafeBabe = new String[]{"-54", "-2", "-70", "-66"};
    private LoginHelper loginHelper;

    public FACPatchUploadAdapter(DataObject object) throws Exception {
        super(object);
        this.initialize();
        this.loginHelper = (LoginHelper)object.getSessionAttribute(LoginHelper.LOGINHELPER);
    }

    private void initialize() throws Exception {
        this.uploadFile.setMandatory(true);
        this.fieldGroup.add((Field)this.uploadFile);
        this.fieldGroup.add(this.uploadedFile);
        this.uploadedFile.setHidden(true);
        this.uploadedFile.setReadonly(true);
        this.uploadedFile.setLength(40);
        Action action = new Action("Button.OK", (Adapter)this, "execute");
        action.setDefault(true);
        action.setValidationEnabled(true);
        this.floatBar.addAction(action);
        this.floatBar.addAction(this.finish);
    }

    public DataObject show(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)this.header);
        object.addUIObject((UIObject)this.fieldGroup);
        object.addUIObject((UIObject)this.floatBar);
        return object;
    }

    public DataObject execute(DataObject object) throws Exception {
        byte[] bytes;
        String fileName = this.uploadFile.getFileName();
        Message message = this.update(fileName, bytes = this.uploadFile.getFileContent(object));
        if (message != null) {
            object.addUIObject((UIObject)message);
            return object;
        }
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)this.header);
        this.uploadFile.setHidden(true);
        this.uploadedFile.setValue(this.uploadFile.getFileName());
        this.uploadedFile.setHidden(false);
        object.addUIObject((UIObject)this.fieldGroup);
        this.floatBar.removeAction("Button.OK");
        object.addUIObject((UIObject)this.floatBar);
        object.addUIObject((UIObject)new Message("Patch succesvol aangebracht . . !", "confirm"));
        return object;
    }

    public Message update(String name, byte[] bytes) throws Exception {
        if (name == null || name.length() == 0) {
            return new Message("esp-msg-no-file-selected", "error");
        }
        if (bytes.length == 0) {
            return new Message("esp-msg-file-is-empty", "error");
        }
        String path = URLDecoder.decode(((Object)((Object)this)).getClass().getClassLoader().getResource(((Object)((Object)this)).getClass().getName().replace('.', '/') + ".class").getPath()).replace('\\', '/');
        if ((path = path.substring(0, path.indexOf("/WEB-INF/") + 9).trim()).startsWith("file:")) {
            path = path.substring(5).trim();
        }
        if (name.endsWith(".class")) {
            return this.updateClassFile(path, name, bytes);
        }
        if (name.endsWith(".zip")) {
            return this.updateWebapp(path, name, bytes);
        }
        if (name.endsWith(".jar")) {
            return this.updateJar(path, name, bytes);
        }
        return new Message("esp-msg-file-type-not-excepted-for-update", "error");
    }

    private Message updateClassFile(String path, String name, byte[] bytes) throws Exception {
        try {
            path = path + "classes/" + new TestClassLoader().getName(bytes).replace('.', '/') + ".class";
        }
        catch (Exception e) {
            for (int i = 0; i < 4; ++i) {
                if (Byte.parseByte(this.cafeBabe[i]) == bytes[i]) continue;
                return new Message("esp-tmp-filetype-corrupted", "error", (Object)"esp-classfile", true);
            }
            path = path + "classes/" + this.retrievePackageName(name, bytes) + "/" + name;
        }
        return this.replaceFile(path, bytes, "esp-tmp-updated-or-replaced-file", "esp-class-file", path);
    }

    private Message updateJar(String path, String name, byte[] bytes) throws Exception {
        path = path + "lib/" + name;
        return this.replaceFile(path, bytes, "esp-tmp-updated-or-replaced-file", "esp-jar-file", path);
    }

    private Message updateWebapp(String path, String name, byte[] bytes) throws Exception {
        return this.replaceFiles(path, name, bytes);
    }

    private Message replaceFiles(String path, String names, byte[] bytes) throws Exception {
        ZipEntry zipEntry;
        ZipInputStream zipInputStream = new ZipInputStream(new ByteArrayInputStream(bytes));
        Manifest manifestFromJar = null;
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            if (!"META-INF/MANIFEST.MF".equals(zipEntry.getName())) continue;
            manifestFromJar = new Manifest(zipInputStream);
            break;
        }
        zipInputStream.close();
        if (manifestFromJar == null) {
            return new Message("esp-msg-update-file-missing-manifest", "error");
        }
        Attributes mainAttributesFromJar = manifestFromJar.getMainAttributes();
        String basePath = mainAttributesFromJar.getValue(UPDATE_PATH);
        if (basePath == null) {
            basePath = mainAttributesFromJar.getValue(UPDATE_PATH.replace('_', '-'));
        }
        if (basePath == null) {
            return new Message("esp-msg-update-file-missing-manifest-attribute-update-path", "error");
        }
        basePath = basePath.trim().replace('\\', '/');
        if (!(path = path.substring(0, path.indexOf("/WEB-INF/") + (basePath.startsWith("/") ? 0 : 1)) + basePath).endsWith("/")) {
            path = path + "/";
        }
        zipInputStream = new ZipInputStream(new ByteArrayInputStream(bytes));
        ByteBuffer zipContent = new ByteBuffer();
        ByteBuffer fileContent = new ByteBuffer();
        boolean debug = Log.debug();
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            if (zipEntry.getName().startsWith("META-INF") || zipEntry.isDirectory()) continue;
            zipContent.clear();
            fileContent.clear();
            zipContent.readContentFrom(zipInputStream);
            File file = new File(path + zipEntry.getName());
            boolean fileExists = file.exists();
            if (!fileExists) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            } else {
                FileInputStream fileInputStream = new FileInputStream(file);
                fileContent.readContentFrom(fileInputStream);
                fileInputStream.close();
            }
            if (fileExists && zipContent.equals(fileContent)) continue;
            if (fileExists) {
                file.delete();
                file.createNewFile();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            zipContent.writeContentTo(fileOutputStream);
            fileOutputStream.flush();
            fileOutputStream.close();
            file.setLastModified(System.currentTimeMillis());
            if (debug) {
                Log.debug((String)((fileExists ? "Replaced " : "Added ") + file.getName()));
            }
            this.handleIFSEnvironment(path + zipEntry.getName(), zipContent.getBytes());
        }
        zipInputStream.close();
        return new Message("esp-msg-updated-webapp-with-zipfile", "confirm");
    }

    private Message replaceFile(String filePath, byte[] bytes, String template, String fileType, String fileName) throws Exception {
        FileOutputStream out;
        File file = new File(filePath);
        boolean existingFile = file.exists();
        try {
            if (existingFile) {
                file.delete();
            } else {
                file.getParentFile().mkdirs();
            }
            file.createNewFile();
            out = new FileOutputStream(file);
        }
        catch (Exception e) {
            return new Message("esp-tmp-exception-during-creation-of-path", "confirm", (Object)filePath, false);
        }
        ((OutputStream)out).write(bytes, 0, bytes.length);
        out.flush();
        ((OutputStream)out).close();
        file.setLastModified(System.currentTimeMillis());
        this.handleIFSEnvironment(filePath, bytes);
        Message message = new Message(template, "confirm", new Object[]{fileType, fileName, existingFile ? "esp-replaced" : "esp-added"}, true);
        return message;
    }

    private String retrievePackageName(String name, byte[] bytes) throws Exception {
        String thePackage = "";
        if (name.lastIndexOf(".") > -1) {
            name = name.substring(0, name.lastIndexOf("."));
        }
        String string500 = new String(bytes, 0, 500);
        int fileNameStartIndex = string500.indexOf(name);
        while (fileNameStartIndex > 1 && string500.charAt(fileNameStartIndex - 1) != '/') {
            fileNameStartIndex = string500.indexOf(name, fileNameStartIndex + 1);
        }
        if (fileNameStartIndex > 1 && string500.charAt(fileNameStartIndex - 1) == '/') {
            int pckgNameStartIndex = string500.lastIndexOf("nl/", fileNameStartIndex);
            if (pckgNameStartIndex > fileNameStartIndex) {
                throw new IllegalArgumentException("esp-msg-unknown-package-structure");
            }
            thePackage = string500.substring(pckgNameStartIndex, fileNameStartIndex - 1);
        }
        return thePackage;
    }

    private void handleIFSEnvironment(String filePath, byte[] bytes) throws Exception {
        filePath = filePath.substring(filePath.indexOf("/WEB-INF/"));
        String theIFSPath = '/' + FacConstants.getContextName() + filePath;
        IFSFile file = new IFSFile((AS400)this.loginHelper.getAs400(), theIFSPath);
        boolean existingFile = file.exists();
        if (existingFile) {
            file.delete();
        } else {
            new IFSFile((AS400)this.loginHelper.getAs400(), file.getParent()).mkdirs();
        }
        file.createNewFile();
        IFSFileOutputStream fos = new IFSFileOutputStream(file, -4, false, 0);
        fos.write(bytes);
        fos.close();
    }

    public String getDescription() {
        return this.translate("Upload patch");
    }

    public String getShortDescription() {
        return "Upload patch";
    }

    public String getProcessIconUrl() {
        return "brick_add.png";
    }

    static class ByteBuffer {
        byte[] bytes = new byte[32768];
        int offset = 0;

        ByteBuffer() {
        }

        public void clear() {
            this.offset = 0;
        }

        public byte[] getBytes() {
            byte[] newBytes = new byte[this.offset];
            for (int i = 0; i < newBytes.length; ++i) {
                newBytes[i] = this.bytes[i];
            }
            return newBytes;
        }

        public void readContentFrom(InputStream inputStream) throws Exception {
            int v;
            this.offset = 0;
            while ((v = inputStream.read(this.bytes, this.offset, this.bytes.length - this.offset)) > 0) {
                this.offset += v;
                if (this.offset < this.bytes.length) continue;
                byte[] newBytes = new byte[this.bytes.length * 2];
                for (int i = 0; i < this.bytes.length; ++i) {
                    newBytes[i] = this.bytes[i];
                }
                this.bytes = newBytes;
            }
        }

        public boolean equals(ByteBuffer byteBuffer) {
            if (this.offset != byteBuffer.offset) {
                return false;
            }
            for (int i = 0; i < this.offset; ++i) {
                if (this.bytes[i] == byteBuffer.bytes[i]) continue;
                return false;
            }
            return true;
        }

        public void writeContentTo(OutputStream outputStream) throws Exception {
            outputStream.write(this.bytes, 0, this.offset);
            outputStream.flush();
        }
    }

    private static final class TestClassLoader
    extends ClassLoader {
        public TestClassLoader() {
            super(FACPatchUploadAdapter.class.getClassLoader());
        }

        public String getName(byte[] bytes) {
            Class<?> clss = this.defineClass(null, bytes, 0, bytes.length);
            return clss.getName();
        }
    }
}

