/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.usertool;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import nl.ibs.esp.adapter.Adapter;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FileSelectionField;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.fac.adapters.FACAdapter;

public class FACUserToolUploadAdapter
extends FACAdapter {
    private static final long serialVersionUID = 940134076901012626L;
    public static String PAGE = FACUserToolUploadAdapter.class.getName();
    private Header header = new Header("Title.UploadUserTool", "screen_name", null);
    private FieldGroup fieldGroup = new FieldGroup();
    private FileSelectionField uploadFile = new FileSelectionField("Label.UserTool");
    private Field uploadedFile = new Field("Label.UserTool");
    private FloatBar floatBar = new FloatBar();

    public FACUserToolUploadAdapter(DataObject object) throws Exception {
        super(object);
        this.initialize();
    }

    private void initialize() throws Exception {
        this.uploadFile.setMandatory(true);
        this.fieldGroup.add((Field)this.uploadFile);
        this.fieldGroup.add(this.uploadedFile);
        this.uploadedFile.setHidden(true);
        this.uploadedFile.setReadonly(true);
        this.uploadedFile.setLength(40);
        Action action = new Action("Button.OK", (Adapter)this, "execute");
        action.setDefault(true);
        action.setValidationEnabled(true);
        this.floatBar.addAction(action);
        this.floatBar.addAction(this.finish);
    }

    public DataObject show(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)this.header);
        object.addUIObject((UIObject)this.fieldGroup);
        object.addUIObject((UIObject)this.floatBar);
        return object;
    }

    public DataObject execute(DataObject object) throws Exception {
        FileOutputStream out;
        byte[] bytes = this.uploadFile.getFileContent(object);
        if (bytes.length == 0) {
            throw new IllegalArgumentException("Bestand is leeg !");
        }
        String path = ((Object)((Object)this)).getClass().getClassLoader().getResource("jsql_config.properties").getPath();
        File newFile = new File(path);
        String newPath = newFile.getParent();
        String s = File.separator;
        try {
            out = new FileOutputStream(newPath + s + "nl" + s + "ibs" + s + "fac" + s + "usertool" + s + this.uploadFile.getFileName());
        }
        catch (Exception e) {
            boolean ok = new File(newPath + s + "nl" + s + "ibs" + s + "fac" + s + "usertool").mkdirs();
            if (!ok) {
                throw new IllegalArgumentException("Aanmaken pad" + newPath + s + "nl" + s + "ibs" + s + "fac" + s + "usertool is mislukt !");
            }
            out = new FileOutputStream(newPath + s + "nl" + s + "ibs" + s + "fac" + s + "usertool" + s + this.uploadFile.getFileName());
        }
        int len = bytes.length;
        ((OutputStream)out).write(bytes, 0, len);
        out.flush();
        ((OutputStream)out).close();
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)this.header);
        this.uploadFile.setHidden(true);
        this.uploadedFile.setValue(this.uploadFile.getFileName());
        this.uploadedFile.setHidden(false);
        object.addUIObject((UIObject)this.fieldGroup);
        this.floatBar.removeAction("Button.OK");
        object.addUIObject((UIObject)this.floatBar);
        object.addUIObject((UIObject)new Message("Hulpprogramma succesvol geladen . . !", "confirm"));
        return object;
    }

    public String getDescription() {
        return this.translate("Process.UploadUserTool");
    }

    public String getShortDescription() {
        return "Process.UploadUserTool.short";
    }

    public String getProcessIconUrl() {
        return "brick_add.png";
    }
}

