/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.usertool;

import java.math.BigDecimal;
import java.util.Iterator;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.conversion.FacDB0120;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.Valuation;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.usertool.FACUserTool;
import nl.ibs.fac.usertool.FACUserToolInvokeAdapter;

public class LeenBakker
implements FACUserTool {
    private FACUserToolInvokeAdapter invokeAdapter;

    @Override
    public String[] getParameterDescriptions() throws Exception {
        return null;
    }

    @Override
    public void execute(String[] parameterValues) throws Exception {
        FacDB0120.execute(this.invokeAdapter.getCompany().getDBData());
        this.processAsset("130006946");
        this.processAsset("130005346");
    }

    private void processAsset(String assetId) throws Exception {
        Company company = this.invokeAdapter.getCompany();
        Asset asset = (Asset)AssetBO.get(company, assetId, false)[0];
        Iterator iterator = asset.getValuationsCollection(null).iterator();
        Transaction transaction2 = null;
        int facYear = 0;
        int facPeriod = 0;
        while (iterator.hasNext()) {
            Valuation valuation = (Valuation)iterator.next();
            BigDecimal bookValue = new BigDecimal("0");
            for (Transaction transaction2 : TransactionBO.getTransactions(valuation, true)) {
                bookValue = bookValue.add(transaction2.getAmount1()).subtract(transaction2.getAmount2());
            }
            int[] yp = PeriodHelper.getNextPeriod(company.getNumberOfPeriods(), transaction2.getBookYear(), transaction2.getPeriod());
            facYear = yp[0];
            facPeriod = yp[1];
            int state = 0;
            if (valuation.getAccountingPrinciple() == 1) {
                state = 1;
            }
            Transaction disinvestment = (Transaction)TransactionBO.create(company.getDBData(), company.getId(), 0, 1, LanguageHelper.getString("nl.ibs.fac.language", "ContraBookingBalanceValues"), asset.getCora(), asset.getId(), valuation.getAccountingPrinciple(), 2, 30, facYear, facPeriod, facYear, facPeriod, bookValue.negate(), new BigDecimal("0"), new BigDecimal("0"), null, asset.getFinDimId1(), asset.getFinDimId2(), asset.getFinDimId3(), asset.getFinDimId4(), asset.getFinDimId5(), state, 0, -1, "SYSTEM", asset.getTypeId())[0];
            disinvestment.setState(1);
        }
        asset.setDisinvestmentYear(facYear);
        asset.setDisinvestmentPeriod(facPeriod);
    }

    @Override
    public FieldGroup getFieldGroup() throws Exception {
        return null;
    }

    @Override
    public String[] validate() throws Exception {
        return null;
    }

    @Override
    public String getProgramDescription() throws Exception {
        return null;
    }

    @Override
    public String getCompletionMessage() throws Exception {
        return null;
    }

    @Override
    public boolean getAS400WriterNeeded() throws Exception {
        return true;
    }

    @Override
    public void setInvoker(FACUserToolInvokeAdapter invokeAdapter) throws Exception {
        this.invokeAdapter = invokeAdapter;
    }
}

