/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.usertool;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.boadapters.MainAccountSchemeBO;
import nl.ibs.fac.boadapters.ValuationMainAccountBO;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.AssetType;
import nl.ibs.fac.db.MainAccountScheme;
import nl.ibs.fac.usertool.FACUserTool;
import nl.ibs.fac.usertool.FACUserToolInvokeAdapter;
import nl.ibs.jsql.DBData;

public class MIGR0010
implements FACUserTool {
    FACUserToolInvokeAdapter invokeAdapter;
    String mask;
    int accountingPrinciple = 1;
    int year;
    int period;

    @Override
    public String[] getParameterDescriptions() throws Exception {
        String[] descriptions = new String[]{"Mask (8 pos. 0/1)"};
        return descriptions;
    }

    @Override
    public void execute(String[] parameterValues) throws Exception {
        if (this.invokeAdapter.getCompanyId() == null) {
            throw new IllegalArgumentException("Er is geen bedrijf actief !");
        }
        this.mask = parameterValues[0].trim();
        if (this.mask.length() != 8) {
            throw new IllegalArgumentException("Invalid mask length !");
        }
        for (int index = 0; index < 8; ++index) {
            if (this.mask.charAt(index) == '0' || this.mask.charAt(index) == '1') continue;
            throw new IllegalArgumentException("Invalid character found(character is not (0 or 1)) !");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("facLib", this.invokeAdapter.getEnvironment().getFacLib());
        map.put("Company", this.invokeAdapter.getCompanyId());
        Collection<?> assets = AssetBO.getAssets(map, false);
        Iterator<?> ai = assets.iterator();
        DBData dbData = this.invokeAdapter.getDBData();
        String companyId = this.invokeAdapter.getCompanyId();
        String cora = "A";
        String[] maIds = new String[]{"", "", "", "", "", "", "", "", ""};
        while (ai.hasNext()) {
            Asset asset = (Asset)ai.next();
            String assetId = asset.getId();
            this.year = asset.getStartUseYear();
            this.period = asset.getStartUsePeriod();
            Object[] objects = ValuationMainAccountBO.get(dbData, companyId, cora, assetId, this.accountingPrinciple, this.year, this.period);
            if (objects[0] != null) continue;
            maIds = this.retrieveTypeDefaults(asset.getAssetType(), maIds);
            maIds = this.supplyCostAccount(asset.getFinDimId5(), maIds);
            ValuationMainAccountBO.create(dbData, companyId, cora, assetId, this.accountingPrinciple, this.year, this.period, maIds[0], maIds[1], maIds[2], maIds[3], maIds[4], maIds[5], maIds[6], maIds[7], maIds[8]);
        }
    }

    private String[] retrieveTypeDefaults(AssetType assetType, String[] maIds) throws Exception {
        MainAccountScheme mas = MainAccountSchemeBO.getMainAccountSchemeToUse(assetType, this.accountingPrinciple, this.year, this.period);
        if (mas == null) {
            maIds[0] = "";
            maIds[1] = "";
            maIds[2] = "";
            maIds[3] = "";
            maIds[4] = "";
            maIds[5] = "";
            maIds[6] = "";
            maIds[7] = "";
            maIds[8] = "";
        } else {
            maIds[0] = mas.getMainAccountId1();
            maIds[1] = mas.getMainAccountId2();
            maIds[2] = mas.getMainAccountId3();
            maIds[3] = mas.getMainAccountId4();
            maIds[4] = mas.getMainAccountId5();
            maIds[5] = mas.getMainAccountId6();
            maIds[6] = mas.getMainAccountId7();
            maIds[7] = mas.getMainAccountId8();
            maIds[8] = mas.getMainAccountId9();
        }
        return maIds;
    }

    private String[] supplyCostAccount(String costAccount, String[] maIds) throws Exception {
        if (costAccount.trim().length() == 0) {
            return maIds;
        }
        for (int index = 0; index < 8; ++index) {
            if (this.mask.charAt(index) != '1') continue;
            maIds[index] = costAccount;
        }
        return maIds;
    }

    @Override
    public FieldGroup getFieldGroup() throws Exception {
        return null;
    }

    @Override
    public String[] validate() throws Exception {
        return null;
    }

    @Override
    public String getProgramDescription() throws Exception {
        return null;
    }

    @Override
    public String getCompletionMessage() throws Exception {
        return null;
    }

    @Override
    public boolean getAS400WriterNeeded() throws Exception {
        return true;
    }

    @Override
    public void setInvoker(FACUserToolInvokeAdapter invokeAdapter) throws Exception {
        this.invokeAdapter = invokeAdapter;
    }
}

